/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.pricemodel.business.service.quote;

import java.util.List;
import kd.mpscmm.msbd.pricemodel.business.helper.quote.QuoteExtHelper;
import kd.mpscmm.msbd.pricemodel.business.pojo.quote.QuotePolicyParam;
import kd.mpscmm.msbd.pricemodel.business.pojo.quote.QuoteSchemeInfo;
import kd.mpscmm.msbd.pricemodel.business.service.quote.QuotePolicy;
import kd.mpscmm.msbd.pricemodel.business.service.quote.step.FilterStep;
import kd.mpscmm.msbd.pricemodel.business.service.quote.step.JoinStep;
import kd.mpscmm.msbd.pricemodel.business.service.quote.step.QuoteBillPreFilterStep;
import kd.mpscmm.msbd.pricemodel.business.service.quote.step.QuoteCollectStep;
import kd.mpscmm.msbd.pricemodel.business.service.quote.step.QuoteProcessExtStep;
import kd.mpscmm.msbd.pricemodel.business.service.quote.step.QuoteSourceFilterStep;
import kd.mpscmm.msbd.pricemodel.business.service.quote.step.QuoteSourceOrgFilterStep;

public class QuoteDataSetPolicy
extends QuotePolicy {
    public QuoteDataSetPolicy(QuotePolicyParam quotePolicyParam, QuoteSchemeInfo quoteSchemeInfo) {
        super(quotePolicyParam, quoteSchemeInfo);
        this.addStep(new QuoteBillPreFilterStep());
        boolean isReplace = false;
        List<Boolean> results = QuoteExtHelper.callIsReplaceQuote(quoteSchemeInfo);
        if (results != null && results.size() > 0) {
            for (Boolean result : results) {
                if (!result.booleanValue()) continue;
                isReplace = true;
                break;
            }
        }
        if (isReplace) {
            this.addStep(new QuoteProcessExtStep());
        } else {
            this.addStep(new QuoteSourceOrgFilterStep());
            this.addStep(new QuoteSourceFilterStep());
            this.addStep(new JoinStep());
            this.addStep(new FilterStep());
            this.addStep(new QuoteCollectStep());
        }
    }
}

