/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.pricemodel.business.service.quote;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Field;
import kd.bos.algo.JoinDataSet;
import kd.bos.algo.JoinHint;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.mpscmm.msbd.pricemodel.business.helper.DataSetHelper;
import kd.mpscmm.msbd.pricemodel.business.helper.PriceHelper;
import kd.mpscmm.msbd.pricemodel.business.pojo.PriceEntityKeyInfo;
import kd.mpscmm.msbd.pricemodel.business.pojo.quote.QuoteParam;
import kd.mpscmm.msbd.pricemodel.business.pojo.quote.QuotePolicyParam;
import kd.mpscmm.msbd.pricemodel.business.pojo.quote.QuoteProcessInfo;
import kd.mpscmm.msbd.pricemodel.business.pojo.quote.QuoteSchemeColl;
import kd.mpscmm.msbd.pricemodel.business.pojo.quote.QuoteSchemeInfo;
import kd.mpscmm.msbd.pricemodel.business.pojo.quote.QuoteStrategeColl;
import kd.mpscmm.msbd.pricemodel.business.pojo.quote.calc.QuoteCalcInfo;
import kd.mpscmm.msbd.pricemodel.business.service.quote.AbstractPolicy;
import kd.mpscmm.msbd.pricemodel.business.service.quote.QuoteConfigurePolicy;
import kd.mpscmm.msbd.pricemodel.business.service.quote.QuoteDataSetPolicy;
import kd.mpscmm.msbd.pricemodel.business.service.quote.QuotePolicy;
import kd.mpscmm.msbd.pricemodel.business.service.quote.log.QuoteLogProxy;
import kd.mpscmm.msbd.pricemodel.common.consts.PriceConst;

public class QuoteEngine
implements AutoCloseable {
    private static final Log log = LogFactory.getLog(QuoteEngine.class);
    protected QuoteLogProxy logProxy;

    public QuoteEngine(QuoteLogProxy logProxy) {
        this.logProxy = logProxy;
    }

    public Map<String, Object> startQuote(QuoteStrategeColl quoteStrategeColl, DynamicObject quoteStratege, QuoteParam quoteParam) {
        QuoteSchemeColl quoteSchemeColl = quoteStrategeColl.getQuoteSchemeColl(quoteStratege);
        List<QuoteSchemeInfo> quoteSchemeInfos = quoteSchemeColl.getQuoteSchemeInfos();
        ArrayList<AbstractPolicy> quotePolicys = new ArrayList<AbstractPolicy>(quoteSchemeInfos.size());
        for (int i = 0; i < quoteSchemeInfos.size(); ++i) {
            QuoteSchemeInfo qs = quoteSchemeInfos.get(i);
            if (!this.hasQuoteNext(quoteParam)) continue;
            QuotePolicyParam quotePolicyParam = new QuotePolicyParam(quoteParam.getQuoteOriginDataSet().copy(), (Long)quoteSchemeColl.getQuoteStratege().getDynamicObject("createorg").getPkValue(), quoteParam.getQccInfo(), quoteParam.getEntityType());
            quotePolicyParam.getOtherParam().putAll(quoteParam.getOtherParam());
            QuotePolicy policy = qs.isConfigure() ? new QuoteConfigurePolicy(quotePolicyParam, qs) : new QuoteDataSetPolicy(quotePolicyParam, qs);
            quotePolicys.add(policy);
            policy.query(this.logProxy);
            this.suplusDataSet(quoteParam, quotePolicyParam, qs);
        }
        Map<String, Object> result = this.buildResult(quotePolicys, quoteParam, quoteStrategeColl, quoteStratege);
        this.fillEmpty(quoteParam);
        this.logProxy.setEndTime(TimeServiceHelper.now());
        return result;
    }

    protected void suplusDataSet(QuoteParam quoteParam, QuotePolicyParam quotePolicyParam, QuoteProcessInfo quoteProcessInfo) {
        String terminationSign = PriceHelper.getLeftName(quoteProcessInfo.getTerminationSignX());
        if (StringUtils.isNotEmpty((CharSequence)terminationSign)) {
            String filterStr_r = new StringBuffer(terminationSign).append(" ").append("is not null").toString();
            DataSet policyResult = quotePolicyParam.getResultSet();
            policyResult = policyResult.where(filterStr_r);
            if (!DataSetHelper.isIncludeField(terminationSign, quotePolicyParam.getResultSet())) {
                quotePolicyParam.getResultSet().close();
                String message = quoteProcessInfo instanceof QuoteCalcInfo ? ResManager.loadKDString((String)"\u5f53\u524d\u53d6\u4ef7\u7b56\u7565\u4e2d\u7684\u8ba1\u7b97\u7b56\u7565\u5bf9\u5e94\u7684\u53d6\u4ef7\u7ec8\u6b62\u5b57\u6bb5\u5728\u8ba1\u7b97\u7b56\u7565\u4e2d\u5df2\u7ecf\u88ab\u5220\u9664\uff0c\u9519\u8bef\u7b56\u7565\u662f\u201c%s\u201d\u3002", (String)"QuoteEngine_0", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5f53\u524d\u53d6\u4ef7\u7b56\u7565\u4e2d\u7684\u53d6\u4ef7\u65b9\u6848\u5bf9\u5e94\u7684\u53d6\u4ef7\u7ec8\u6b62\u5b57\u6bb5\u5728\u65b9\u6848\u4e2d\u5df2\u7ecf\u88ab\u5220\u9664\uff0c\u9519\u8bef\u65b9\u6848\u662f\u201c%s\u201d\u3002", (String)"QuoteEngine_1", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]);
                message = String.format(message, quoteProcessInfo.getName());
                throw new KDBizException(message);
            }
            DataSet quoteOriginDataSet = quoteParam.getQuoteOriginDataSet();
            try (DataSet result = policyResult.copy();){
                String resultFieldAlias = new StringBuffer(PriceConst.RESULT).append(terminationSign).toString();
                String resultSelector = new StringBuffer(terminationSign).append(" ").append(resultFieldAlias).toString();
                String filterStr = new StringBuffer(resultFieldAlias).append(" ").append("is null").toString();
                JoinHint hint = new JoinHint();
                hint.setNullAsZero(true);
                JoinDataSet resultSet = quoteOriginDataSet.join(result, JoinType.LEFT).hint(hint);
                for (String key : quoteParam.getQccInfo().getLEFTIDFIELDS()) {
                    resultSet = resultSet.on(key, key);
                }
                Field[] quoteOriginFields = quoteOriginDataSet.getRowMeta().getFields();
                String[] fields = new String[quoteOriginFields.length];
                for (int i = 0; i < quoteOriginFields.length; ++i) {
                    fields[i] = quoteOriginFields[i].getName();
                }
                quoteOriginDataSet = resultSet.select(fields, new String[]{resultSelector}).finish().where(filterStr);
                quoteOriginDataSet = quoteOriginDataSet.select(fields);
                quoteParam.setQuoteOriginDataSet(quoteOriginDataSet);
            }
            catch (Throwable ex) {
                throw new KDBizException(ex.getMessage());
            }
            quotePolicyParam.setResultSet(policyResult);
        }
    }

    protected Map<String, Object> buildResult(List<AbstractPolicy> quotePolicys, QuoteParam quoteParam, QuoteStrategeColl quoteStrategeColl, DynamicObject quoteStratege) {
        HashMap<String, Object> priceMapping = new HashMap<String, Object>();
        if (quotePolicys.size() == 0) {
            return priceMapping;
        }
        List[] resultFieldsAliasArray = quoteStrategeColl.divideHeadAndEntryResultsAlias();
        List headAliasFields = resultFieldsAliasArray[0];
        List entryAliasFields = resultFieldsAliasArray[1];
        for (int i = 0; i < quotePolicys.size(); ++i) {
            AbstractPolicy p = quotePolicys.get(i);
            try (DataSet result = p.getQuotePolicyParam().getResultSet();){
                List<String> includeHeadAliasFields = DataSetHelper.getIncludeFields(headAliasFields, result);
                List<String> includeEntryAliasFields = DataSetHelper.getIncludeFields(entryAliasFields, result);
                for (Row row : result) {
                    Object priceResult;
                    String key;
                    String priceField;
                    String[] subFields;
                    if (includeHeadAliasFields.size() > 0) {
                        for (String headAliasField : includeHeadAliasFields) {
                            subFields = headAliasField.split("__");
                            priceField = subFields[subFields.length - 1];
                            key = this.generateHeadKey(row, priceField);
                            priceResult = row.get(headAliasField);
                            this.arrangeHeadPriceValue(priceMapping, key, priceResult);
                        }
                    }
                    if (includeEntryAliasFields.size() > 0) {
                        for (String entryAliasField : includeEntryAliasFields) {
                            subFields = entryAliasField.split("__");
                            priceField = subFields[subFields.length - 1];
                            key = this.generateKey(quoteParam.getQccInfo(), row, priceField);
                            priceResult = row.get(entryAliasField);
                            priceMapping.put(key, priceResult);
                        }
                    }
                    String key2 = this.generateKey(quoteParam.getQccInfo(), row, "iscover");
                    priceMapping.put(key2, quoteStratege.getString("pricecoverrule"));
                }
                continue;
            }
        }
        priceMapping.put("success", Boolean.TRUE);
        return priceMapping;
    }

    protected void fillEmpty(QuoteParam quoteParam) {
        log.info("\u586b\u5145\u7a7a\u503c\u5f00\u59cb\uff1a\u65b0\u8fd4\u56de\u63a5\u53e3\u5c06\u4e0d\u8fd4\u56de\u7a7a\u503c\uff0c\u53ea\u8bb0\u5f55\u65e5\u5fd7");
        try (DataSet quoteOriginDataSet = quoteParam.getQuoteOriginDataSet();){
            this.logProxy.setMissedRecDataSet(quoteOriginDataSet);
        }
        log.info("\u586b\u5145\u7a7a\u503c\u7ed3\u675f\uff1a\u65b0\u8fd4\u56de\u63a5\u53e3\u5c06\u4e0d\u8fd4\u56de\u7a7a\u503c\uff0c\u53ea\u8bb0\u5f55\u65e5\u5fd7");
    }

    protected void arrangeHeadPriceValue(Map<String, Object> priceMapping, String key, Object priceResult) {
        if (priceResult == null) {
            priceMapping.put(key, priceResult);
        } else if (!priceMapping.containsKey(key)) {
            priceMapping.put(key, priceResult);
        } else {
            Object oldValue = priceMapping.get(key);
            if (oldValue != null && !priceResult.equals(oldValue)) {
                priceMapping.put(key, null);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean hasQuoteNext(QuoteParam quoteParam) {
        try (DataSet quoteOriginDataSetCopy = quoteParam.getQuoteOriginDataSet().copy();){
            int i = 0;
            for (Row row : quoteOriginDataSetCopy) {
                if (++i <= 0) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            if (!(e instanceof NullPointerException)) throw new KDBizException(e.getMessage());
            StringBuilder message = new StringBuilder(ResManager.loadKDString((String)"\u8bca\u65ad\u4e3aAlgo\u8fd0\u7b97\u9047\u5230\u7a7a\u6307\u9488\u5f02\u5e38\u3002", (String)"QuoteEngine_2", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]));
            message.append("/").append(e.getMessage());
            throw new KDBizException(message.toString());
        }
    }

    protected String generateKey(PriceEntityKeyInfo quoteKeyInfo, Row row, String priceField) {
        return PriceHelper.generateKey(quoteKeyInfo, row, priceField);
    }

    protected String generateHeadKey(Row row, String priceField) {
        StringBuilder newKey = new StringBuilder();
        newKey.append(row.get(PriceEntityKeyInfo.LEFT_ID)).append("$$");
        newKey.append(priceField);
        return newKey.toString();
    }

    @Override
    public void close() {
    }
}

