/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.pricemodel.business.service.quote;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.mpscmm.msbd.pricemodel.business.helper.PriceHelper;
import kd.mpscmm.msbd.pricemodel.business.pojo.quote.QuoteParam;
import kd.mpscmm.msbd.pricemodel.business.pojo.quote.QuotePolicyParam;
import kd.mpscmm.msbd.pricemodel.business.pojo.quote.calc.FeatureValueInfo;
import kd.mpscmm.msbd.pricemodel.business.pojo.quote.calc.QuoteCalcInfo;
import kd.mpscmm.msbd.pricemodel.business.pojo.quote.calc.QuoteSchemeGroupInfo;
import kd.mpscmm.msbd.pricemodel.business.service.quote.CalcPolicy;
import kd.mpscmm.msbd.pricemodel.business.service.quote.CalcSimplePolicy;
import kd.mpscmm.msbd.pricemodel.business.service.quote.log.QuoteLogProxy;

public class QuoteSimpleCalcEngine {
    private QuoteLogProxy logProxy;
    private static final Log log = LogFactory.getLog(QuoteSimpleCalcEngine.class);

    public QuoteSimpleCalcEngine(QuoteLogProxy logProxy) {
        this.logProxy = logProxy;
    }

    public Map<String, Object> startQuote(QuoteCalcInfo qs, DynamicObject quoteStratege, QuoteParam quoteParam) {
        QuotePolicyParam quotePolicyParam = new QuotePolicyParam(quoteParam.getQuoteOriginDataSet(), (Long)quoteStratege.getDynamicObject("createorg").getPkValue(), quoteParam.getQccInfo(), quoteParam.getEntityType());
        quotePolicyParam.setOtherParam(quoteParam.getOtherParam());
        CalcSimplePolicy policy = new CalcSimplePolicy(quotePolicyParam, qs);
        policy.calc(this.logProxy);
        Map<String, Object> calcResult = this.buildResult(policy, quoteParam);
        this.logProxy.setEndTime(TimeServiceHelper.now());
        return calcResult;
    }

    protected Map<String, Object> buildResult(CalcPolicy quotePolicy, QuoteParam quoteParam) {
        HashMap<String, Object> priceMapping = new HashMap<String, Object>();
        try (DataSet result = quotePolicy.getQuotePolicyParam().getResultSet();){
            List<QuoteSchemeGroupInfo> schemeGroups = quotePolicy.getQuoteCalcInfo().getSchemeGroupInfos();
            List<String> fieldNames = this.getResultFields(result, quoteParam);
            for (Row row : result) {
                for (String aliasField : fieldNames) {
                    String[] subFields = aliasField.split("__");
                    String priceField = subFields[subFields.length - 1];
                    String key = PriceHelper.generateSimpleKey(quoteParam.getQccInfo(), row, priceField);
                    if (schemeGroups.size() > 0) {
                        HashMap<String, List<FeatureValueInfo>> featureValueTrasferKeyResult = new HashMap<String, List<FeatureValueInfo>>();
                        for (QuoteSchemeGroupInfo groupInfo : schemeGroups) {
                            String mainKey;
                            Map<String, List<FeatureValueInfo>> featureValueResult = groupInfo.getFeatureValueResult();
                            List<FeatureValueInfo> featureValueInfos = featureValueResult.get(mainKey = PriceHelper.generateRowKey(quoteParam.getQccInfo(), row));
                            if (featureValueInfos == null || featureValueInfos.size() <= 0) continue;
                            featureValueTrasferKeyResult.put(groupInfo.getNumber(), featureValueInfos);
                        }
                        String featureResultKey = PriceHelper.generateSimpleKey(quoteParam.getQccInfo(), row, "featurevalue");
                        priceMapping.put(featureResultKey, featureValueTrasferKeyResult);
                    }
                    Object priceResult = row.get(aliasField);
                    priceMapping.put(key, priceResult);
                }
            }
        }
        priceMapping.put("success", Boolean.TRUE);
        return priceMapping;
    }

    private List<String> getResultFields(DataSet result, QuoteParam quoteParam) {
        Field[] fields;
        ArrayList<String> fieldNames = new ArrayList<String>();
        for (Field field : fields = result.getRowMeta().getFields()) {
            if (quoteParam.getQccInfo().getLEFTIDFIELDS().contains(field.getName())) continue;
            fieldNames.add(field.getName());
        }
        return fieldNames;
    }
}

