/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.pricemodel.business.service.quote.extcase;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.temporal.TemporalAdjusters;
import java.util.Date;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.sdk.mpscmm.msbd.expoint.quote.IQuoteCasePlugin;
import kd.sdk.mpscmm.msbd.expoint.quote.QuoteDoParam;
import kd.sdk.mpscmm.msbd.expoint.quote.QuoteFilterParam;

public class QuoteProcessCase
implements IQuoteCasePlugin {
    public boolean preQuote(QuoteFilterParam e) {
        DynamicObject quoteObj;
        if (e.getQuoteScheme() != null && "aaa".equals((quoteObj = e.getQuoteScheme()).getString("number"))) {
            Date todayTime = TimeServiceHelper.today();
            Instant instant = todayTime.toInstant();
            ZoneId zone = ZoneId.systemDefault();
            LocalDateTime localDateTime = LocalDateTime.ofInstant(instant, zone);
            LocalDate today = localDateTime.toLocalDate();
            LocalDate todayPreYear = today.plusYears(-1L);
            LocalDate firstDayPreYear = todayPreYear.with(TemporalAdjusters.firstDayOfYear());
            java.sql.Date firstDatePreYear = java.sql.Date.valueOf(firstDayPreYear);
            e.getSourceFilter().and(new QFilter("priceentryentity.priceeffectdate", ">=", (Object)firstDatePreYear));
        }
        return true;
    }

    public boolean isReplaceQuote(DynamicObject quoteScheme) {
        String number = quoteScheme.getString("number");
        return number.contains("PurPriceFromCost");
    }

    public boolean doQuote(QuoteDoParam e) {
        DynamicObject quoteScheme = e.getQuoteScheme();
        String number = quoteScheme.getString("number");
        if (number.contains("PurPriceFromCost")) {
            String selecties = String.join((CharSequence)",", e.getRowKeyFields());
            StringBuilder allSelecties = new StringBuilder(selecties).append(",").append("Cast(200 as BigDecimal) as ").append(e.getTerminateField()).append(",").append("Cast(100 as BigDecimal) as ").append("AAAAA");
            StringBuilder allSelectiesX = new StringBuilder(selecties).append(",").append("null as ").append(e.getTerminateField()).append(",").append("Cast(100 as BigDecimal) as ").append("AAAAA");
            DataSet resultSet = e.getQuoteDataSet().copy().select(allSelecties.toString());
            DataSet resultSetX = e.getQuoteDataSet().copy().select(allSelectiesX.toString());
            resultSet = resultSetX.union(resultSet);
            e.setResultSet(resultSet);
            return true;
        }
        return false;
    }
}

