/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.pricemodel.business.service.quote.log;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.mpscmm.msbd.pricemodel.business.helper.PriceHelper;
import kd.mpscmm.msbd.pricemodel.business.helper.quote.QuoteLogHelper;
import kd.mpscmm.msbd.pricemodel.business.pojo.AdvancedPricingProInfo;
import kd.mpscmm.msbd.pricemodel.business.pojo.PriceEntityKeyInfo;
import kd.mpscmm.msbd.pricemodel.business.pojo.quote.QuoteRowInfo;
import kd.mpscmm.msbd.pricemodel.business.pojo.quote.QuoteSchemeInfo;
import kd.mpscmm.msbd.pricemodel.business.pojo.quote.QuoteStrategeColl;
import kd.mpscmm.msbd.pricemodel.business.service.quote.log.QuoteLogRunnable;
import kd.mpscmm.msbd.pricemodel.common.enums.quote.LogClassEnum;

public class QuoteLogProxy
implements AutoCloseable {
    private static final Log log = LogFactory.getLog(QuoteLogProxy.class);
    private boolean open;
    private Long quoteOrgID;
    private Date startTime;
    private Date endTime;
    private String quoteBill;
    private PriceEntityKeyInfo qccInfo;
    QuoteStrategeColl quoteStrategeColl;
    DynamicObject quoteStratege;
    private Map<String, List<String>> missSchemeCache = new HashMap<String, List<String>>();
    private Map<String, List<String>> missPriceCache = new HashMap<String, List<String>>();
    private Map<String, List<String>> shootPriceCache = new HashMap<String, List<String>>();
    private Map<String, List<String>> missCalcStrategeCache = new HashMap<String, List<String>>();
    private Map<String, List<String>> missCalPriceCache = new HashMap<String, List<String>>();
    private Map<String, List<String>> shootCalPriceCache = new HashMap<String, List<String>>();
    private Map<String, List<String>> multiPriceCache = new HashMap<String, List<String>>();
    private List<QuoteRowInfo> shootSourceCache = new ArrayList<QuoteRowInfo>();
    private Map<String, Map<String, List<String>>> matchAllPriceCache = new HashMap<String, Map<String, List<String>>>();
    private QuoteRowInfo missedRecDataSet;
    private boolean isCancle;
    private Map<String, AdvancedPricingProInfo> priceProcessMap = new HashMap<String, AdvancedPricingProInfo>();
    private boolean isAuto = false;

    public QuoteLogProxy(boolean open, Long quoteOrgID, String entityType, PriceEntityKeyInfo qccInfo, QuoteStrategeColl quoteStrategeColl, DynamicObject quoteStratege) {
        this.open = open;
        this.qccInfo = qccInfo;
        this.quoteStrategeColl = quoteStrategeColl;
        this.quoteStratege = quoteStratege;
        this.quoteOrgID = quoteOrgID;
        this.quoteBill = entityType;
        this.start();
    }

    public void addShootSourceCache(DataSet shootDataSet) {
        if (this.open) {
            this.getShootSourceCache().add(new QuoteRowInfo(shootDataSet));
        }
    }

    public void addMatchAllPriceCache(String schemeID, DataSet matchDataSet, boolean isRecordSource, LogClassEnum logClass) {
        if (this.open) {
            try (DataSet quoteDataSetCopy = matchDataSet.copy();){
                HashMap<String, List> row2Result = new HashMap<String, List>();
                TreeMap<String, String> nameMapping = new TreeMap();
                if (isRecordSource && LogClassEnum.QUOTESCHEME.getValue().equals(logClass.getValue())) {
                    QuoteSchemeInfo schemeInfo = this.quoteStrategeColl.getQuoteSchemeColl(this.quoteStratege).getQuoteSchemes(schemeID);
                    String sourceBillTypeName = QuoteLogHelper.getResultNameMapping(schemeInfo.getQuoteSrcType(), schemeInfo.getQuoteSourceResultAlias(), nameMapping);
                    for (Row row : quoteDataSetCopy) {
                        String key = PriceHelper.generateRowKey(this.qccInfo, row);
                        String multiResultDes = QuoteLogHelper.getMultiResultDes(nameMapping, row, sourceBillTypeName);
                        List results = row2Result.computeIfAbsent(key, k -> new ArrayList());
                        if (results.size() < 10) {
                            results.add(multiResultDes);
                            continue;
                        }
                        if (results.size() != 10) continue;
                        results.add("......");
                    }
                } else {
                    List<String> oneSchemeResultFields = Arrays.asList(quoteDataSetCopy.getRowMeta().getFieldNames());
                    nameMapping = QuoteLogHelper.getQuoteResultAliasName(this.quoteStrategeColl, this.getQuoteBill(), oneSchemeResultFields);
                    for (Row row : quoteDataSetCopy) {
                        String key = PriceHelper.generateRowKey(this.qccInfo, row);
                        String multiResultDes = QuoteLogHelper.getMultiResultDes(nameMapping, row, null);
                        List results = row2Result.computeIfAbsent(key, k -> new ArrayList());
                        results.add(multiResultDes);
                    }
                }
                this.getMatchAllPriceCache().put(schemeID, row2Result);
            }
        }
    }

    public void missSchemeCache(DataSet quoteDataSet, String schemeID, PriceEntityKeyInfo qccInfo, LogClassEnum logClass) {
        if (LogClassEnum.QUOTESCHEME.getValue().equals(logClass.getValue())) {
            this.handleSingleCache(quoteDataSet, schemeID, qccInfo, this.missSchemeCache);
        } else {
            this.handleSingleCache(quoteDataSet, schemeID, qccInfo, this.missCalcStrategeCache);
        }
    }

    public void multiPriceSchemeCache(DataSet quoteDataSet, String schemeID, PriceEntityKeyInfo qccInfo) {
        this.handleDoubleCache(quoteDataSet, schemeID, qccInfo, this.multiPriceCache, this.missPriceCache);
    }

    public void missPriceCache(DataSet quoteDataSet, String schemeID, PriceEntityKeyInfo qccInfo, LogClassEnum logClass) {
        if (LogClassEnum.QUOTESCHEME.getValue().equals(logClass.getValue())) {
            this.handleDoubleCache(quoteDataSet, schemeID, qccInfo, this.missPriceCache, this.missSchemeCache);
        } else {
            this.handleDoubleCache(quoteDataSet, schemeID, qccInfo, this.missCalPriceCache, this.missCalcStrategeCache);
        }
    }

    public void shootPriceCache(DataSet quoteDataSet, String schemeID, PriceEntityKeyInfo qccInfo, LogClassEnum logClass) {
        if (LogClassEnum.QUOTESCHEME.getValue().equals(logClass.getValue())) {
            this.handleDoubleCache(quoteDataSet, schemeID, qccInfo, this.shootPriceCache, this.missPriceCache);
        } else {
            this.handleDoubleCache(quoteDataSet, schemeID, qccInfo, this.shootCalPriceCache, this.missCalPriceCache);
        }
    }

    private void handleDoubleCache(DataSet quoteDataSet, String schemeID, PriceEntityKeyInfo qccInfo, Map<String, List<String>> shootPriceCache, Map<String, List<String>> missPriceCache) {
        if (this.open) {
            try (DataSet quoteDataSetCopy = quoteDataSet.copy();){
                for (Row row : quoteDataSetCopy) {
                    String key = PriceHelper.generateRowKey(qccInfo, row);
                    List schemeIDs = shootPriceCache.computeIfAbsent(key, k -> new ArrayList());
                    schemeIDs.add(schemeID);
                    List<String> missSchemeRecord = missPriceCache.get(key);
                    missSchemeRecord.remove(schemeID);
                }
            }
        }
    }

    private void handleSingleCache(DataSet quoteDataSet, String schemeID, PriceEntityKeyInfo qccInfo, Map<String, List<String>> missSchemeCache) {
        if (this.open) {
            try (DataSet quoteDataSetCopy = quoteDataSet.copy();){
                for (Row row : quoteDataSetCopy) {
                    String key = PriceHelper.generateRowKey(qccInfo, row);
                    List schemeIDs = missSchemeCache.computeIfAbsent(key, k -> new ArrayList());
                    schemeIDs.add(schemeID);
                }
            }
        }
    }

    private void output() {
        if (this.open && !this.isCancle) {
            QuoteLogRunnable logRunnable = new QuoteLogRunnable(this);
            ThreadPools.executeOnce((String)QuoteLogProxy.class.getName(), (Runnable)logRunnable);
            ArrayList<AdvancedPricingProInfo> processList = new ArrayList<AdvancedPricingProInfo>(this.priceProcessMap.size());
            Set<Map.Entry<String, AdvancedPricingProInfo>> process = this.priceProcessMap.entrySet();
            Iterator<Map.Entry<String, AdvancedPricingProInfo>> it = process.iterator();
            while (it.hasNext()) {
                processList.add(it.next().getValue());
            }
            AdvancedPricingProInfo.savePricingProcessInfoList(processList);
        }
    }

    public boolean isOpen() {
        return this.open;
    }

    @Override
    public void close() {
        this.end();
        this.output();
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    private final void start() {
        this.startTime = TimeServiceHelper.now();
        log.info("\u5f00\u59cb\u91c7\u96c6\u65e5\u5fd7\uff1a" + this.startTime);
    }

    private void end() {
        this.endTime = TimeServiceHelper.now();
        log.info("\u7ed3\u675f\u91c7\u96c6\u65e5\u5fd7\uff1a" + this.endTime);
    }

    public Long getQuoteOrgID() {
        return this.quoteOrgID;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public String getQuoteBill() {
        return this.quoteBill;
    }

    public List<QuoteRowInfo> getShootSourceCache() {
        return this.shootSourceCache;
    }

    public QuoteRowInfo getMissedRecDataSet() {
        return this.missedRecDataSet;
    }

    public void setMissedRecDataSet(DataSet missedRecDataSet) {
        if (this.open) {
            this.missedRecDataSet = new QuoteRowInfo(missedRecDataSet);
        }
    }

    public boolean isCancle() {
        return this.isCancle;
    }

    public void setCancle(boolean cancle) {
        this.isCancle = cancle;
    }

    public Map<String, Map<String, List<String>>> getMatchAllPriceCache() {
        return this.matchAllPriceCache;
    }

    public PriceEntityKeyInfo getQccInfo() {
        return this.qccInfo;
    }

    public QuoteStrategeColl getQuoteStrategeColl() {
        return this.quoteStrategeColl;
    }

    public DynamicObject getQuoteStratege() {
        return this.quoteStratege;
    }

    public Map<String, List<String>> getMissSchemeCache() {
        return this.missSchemeCache;
    }

    public Map<String, List<String>> getMissPriceCache() {
        return this.missPriceCache;
    }

    public Map<String, List<String>> getShootPriceCache() {
        return this.shootPriceCache;
    }

    public Map<String, List<String>> getMultiPriceCache() {
        return this.multiPriceCache;
    }

    public void setAuto(boolean auto) {
        this.isAuto = auto;
    }

    public boolean isAuto() {
        return this.isAuto;
    }

    public Map<String, AdvancedPricingProInfo> getPriceProcessMap() {
        return this.priceProcessMap;
    }

    public Map<String, List<String>> getMissCalcStrategeCache() {
        return this.missCalcStrategeCache;
    }

    public Map<String, List<String>> getMissCalPriceCache() {
        return this.missCalPriceCache;
    }

    public Map<String, List<String>> getShootCalPriceCache() {
        return this.shootCalPriceCache;
    }
}

