/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.pricemodel.business.service.quote.log;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.mpscmm.msbd.pricemodel.business.helper.PriceHelper;
import kd.mpscmm.msbd.pricemodel.business.helper.quote.QuoteLogHelper;
import kd.mpscmm.msbd.pricemodel.business.helper.quote.QuoteLogTreeNodeHelper;
import kd.mpscmm.msbd.pricemodel.business.pojo.quote.QuoteLogNode;
import kd.mpscmm.msbd.pricemodel.business.pojo.quote.QuoteRowInfo;
import kd.mpscmm.msbd.pricemodel.business.pojo.quote.calc.FeatureValueInfo;
import kd.mpscmm.msbd.pricemodel.business.service.quote.log.QuoteExpLogProxy;
import kd.mpscmm.msbd.pricemodel.business.service.quote.log.QuoteInnerLogProxy;
import kd.mpscmm.msbd.pricemodel.business.service.quote.log.QuoteLogProxy;
import kd.mpscmm.msbd.pricemodel.common.enums.quote.SceneTypeEnum;

public class QuoteLogRunnable
implements Runnable {
    private QuoteLogProxy proxy;
    private static final Log LOGGER = LogFactory.getLog(QuoteLogRunnable.class);

    public QuoteLogRunnable(QuoteLogProxy proxy) {
        this.proxy = proxy;
    }

    @Override
    public void run() {
        try {
            ArrayList<TreeNode> totalLogTreeNodes = new ArrayList<TreeNode>();
            Map taxRates = BusinessDataServiceHelper.loadFromCache((String)"bd_taxrate", (String)"id,number", (QFilter[])new QFilter[]{QFilter.of((String)"1=1", (Object[])new Object[0])});
            if (this.proxy.getShootSourceCache() != null) {
                for (int i = 0; i < this.proxy.getShootSourceCache().size(); ++i) {
                    QuoteRowInfo quoteRowInfo = this.proxy.getShootSourceCache().get(i);
                    List<String> oneSchemeResultFields = Arrays.asList(quoteRowInfo.getRowMeta().getFieldNames());
                    TreeMap<String, String> nameMapping = QuoteLogHelper.getQuoteResultAliasName(this.proxy.getQuoteStrategeColl(), this.proxy.getQuoteBill(), oneSchemeResultFields);
                    for (Row row : quoteRowInfo.getRows()) {
                        String resultDes = QuoteLogHelper.getResultDes(nameMapping, row, taxRates);
                        QuoteLogNode node = new QuoteLogNode(row.getString("quotesrcno"), row.getString("quotesrcbill"), row.getString("quotesrcseq"), row, resultDes);
                        TreeNode treeRoot = this.getStrategyNode(row, node);
                        totalLogTreeNodes.add(treeRoot);
                    }
                }
            }
            if (this.proxy.getMissedRecDataSet() != null) {
                QuoteRowInfo mssedRecDataSet = this.proxy.getMissedRecDataSet();
                for (Row row : mssedRecDataSet.getRows()) {
                    String quoteResultDescrip = ResManager.loadKDString((String)"\u672a\u627e\u5230\u5339\u914d\u7684\u4ef7\u683c\u3002", (String)"QuoteLogRunnable_0", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]);
                    QuoteLogNode node = new QuoteLogNode(null, null, null, null, quoteResultDescrip);
                    TreeNode treeRoot = this.getStrategyNode(row, node);
                    totalLogTreeNodes.add(treeRoot);
                }
            }
            if (this.proxy instanceof QuoteInnerLogProxy) {
                ArrayList featureValueLogTreeNodes = new ArrayList();
                QuoteInnerLogProxy proxyX = (QuoteInnerLogProxy)this.proxy;
                MainEntityType quoteType = EntityMetadataCache.getDataEntityType((String)proxyX.getQuoteCalcInfo().getQuoteType());
                for (TreeNode treeRoot : totalLogTreeNodes) {
                    String key = treeRoot.getType();
                    List<FeatureValueInfo> featureValueInfos = proxyX.getQuoteSchemeGroupInfo().getFeatureValueResult().get(key);
                    if (featureValueInfos == null || featureValueInfos.size() <= 0) continue;
                    featureValueInfos.forEach(e -> {
                        String returnField = e.getReturnField();
                        String displayName = QuoteLogHelper.getTerminateFieldDisplayName(quoteType, returnField);
                        String quoteResultDescrip = ResManager.loadKDString((String)"\u672a\u627e\u5230\u5339\u914d\u7684\u4ef7\u683c\u3002", (String)"QuoteLogRunnable_0", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]);
                        if (e.getValue() != null) {
                            quoteResultDescrip = displayName + ":" + e.getValue().stripTrailingZeros().toPlainString();
                        }
                        QuoteLogNode nodeF = new QuoteLogNode(e.getQuoteSrcNo(), e.getQuoteSrcbill(), e.getQuoteSrcSeq(), null, quoteResultDescrip);
                        nodeF.setFeatureValue(e.getFeatureValue());
                        TreeNode treeRootF = this.getFeatureValueNode(key, nodeF);
                        featureValueLogTreeNodes.add(treeRootF);
                    });
                }
                totalLogTreeNodes.addAll(featureValueLogTreeNodes);
                QuoteLogTreeNodeHelper.createInnerQuoteLog(totalLogTreeNodes, (QuoteInnerLogProxy)this.proxy);
            } else {
                QuoteLogTreeNodeHelper.createQuoteLog(totalLogTreeNodes, this.proxy);
            }
        }
        catch (KDBizException e2) {
            try (QuoteExpLogProxy expLogProxy = new QuoteExpLogProxy(true, this.proxy.getQuoteOrgID(), this.proxy.getQuoteBill());){
                String quoteLogExp = ResManager.loadKDString((String)"\u53d6\u4ef7\u65e5\u5fd7\u91c7\u96c6\u8fc7\u7a0b\u51fa\u73b0\u5f02\u5e381\uff1a", (String)"QuoteLogRunnable_1", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]);
                expLogProxy.setCancle(false);
                expLogProxy.setLogResult(quoteLogExp + e2.getMessage());
            }
        }
        catch (Exception e1) {
            LOGGER.info(e1.getMessage());
            try (QuoteExpLogProxy expLogProxy = new QuoteExpLogProxy(true, this.proxy.getQuoteOrgID(), this.proxy.getQuoteBill());){
                String quoteLogExp = ResManager.loadKDString((String)"\u53d6\u4ef7\u65e5\u5fd7\u91c7\u96c6\u8fc7\u7a0b\u51fa\u73b0\u5f02\u5e382\uff1a", (String)"QuoteLogRunnable_2", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]);
                expLogProxy.setCancle(false);
                expLogProxy.setLogResult(quoteLogExp + e1.getClass() + e1.getMessage());
            }
        }
    }

    private TreeNode getStrategyNode(Row row, QuoteLogNode node) {
        String key = PriceHelper.generateRowKey(this.proxy.getQccInfo(), row);
        ArrayList allNodes = new ArrayList();
        List<String> missStratege = this.proxy.getMissCalcStrategeCache().get(key);
        List<String> missCalPrice = this.proxy.getMissCalPriceCache().get(key);
        List<String> shootCalPrice = this.proxy.getShootCalPriceCache().get(key);
        ArrayList<TreeNode> strategeNodes = new ArrayList<TreeNode>();
        strategeNodes.addAll(QuoteLogTreeNodeHelper.buildStrategeNode(key, missStratege, this.proxy.getQuoteStrategeColl().getQuoteCalcColl(this.proxy.getQuoteStratege()), SceneTypeEnum.TYPE_MISSSTRATEGE, this.proxy.getMatchAllPriceCache()));
        strategeNodes.addAll(QuoteLogTreeNodeHelper.buildStrategeNode(key, missCalPrice, this.proxy.getQuoteStrategeColl().getQuoteCalcColl(this.proxy.getQuoteStratege()), SceneTypeEnum.TYPE_MISSCALPRICE, this.proxy.getMatchAllPriceCache()));
        strategeNodes.addAll(QuoteLogTreeNodeHelper.buildStrategeNode(key, shootCalPrice, this.proxy.getQuoteStrategeColl().getQuoteCalcColl(this.proxy.getQuoteStratege()), SceneTypeEnum.TYPE_SHOOTCALPRICE, this.proxy.getMatchAllPriceCache()));
        strategeNodes.sort((o1, o2) -> {
            if (Integer.parseInt(o1.getLongNumber()) > Integer.parseInt(o2.getLongNumber())) {
                return 1;
            }
            return -1;
        });
        List<String> missSchemes = this.proxy.getMissSchemeCache().get(key);
        List<String> missPrice = this.proxy.getMissPriceCache().get(key);
        List<String> shootPrice = this.proxy.getShootPriceCache().get(key);
        List<String> multiPrice = this.proxy.getMultiPriceCache().get(key);
        ArrayList<TreeNode> schemesNodes = new ArrayList<TreeNode>();
        schemesNodes.addAll(QuoteLogTreeNodeHelper.buildSchemeNode(key, missSchemes, this.proxy.getQuoteStrategeColl().getQuoteSchemeColl(this.proxy.getQuoteStratege()), SceneTypeEnum.TYPE_MISSSCHEMES, this.proxy.getMatchAllPriceCache()));
        schemesNodes.addAll(QuoteLogTreeNodeHelper.buildSchemeNode(key, missPrice, this.proxy.getQuoteStrategeColl().getQuoteSchemeColl(this.proxy.getQuoteStratege()), SceneTypeEnum.TYPE_MISSPRICE, this.proxy.getMatchAllPriceCache()));
        schemesNodes.addAll(QuoteLogTreeNodeHelper.buildSchemeNode(key, shootPrice, this.proxy.getQuoteStrategeColl().getQuoteSchemeColl(this.proxy.getQuoteStratege()), SceneTypeEnum.TYPE_SHOOTPRICE, this.proxy.getMatchAllPriceCache()));
        schemesNodes.addAll(QuoteLogTreeNodeHelper.buildSchemeNode(key, multiPrice, this.proxy.getQuoteStrategeColl().getQuoteSchemeColl(this.proxy.getQuoteStratege()), SceneTypeEnum.TYPE_MULTIPRICE, this.proxy.getMatchAllPriceCache()));
        schemesNodes.sort((o1, o2) -> {
            if (Integer.parseInt(o1.getLongNumber()) > Integer.parseInt(o2.getLongNumber())) {
                return 1;
            }
            return -1;
        });
        allNodes.addAll(strategeNodes);
        allNodes.addAll(schemesNodes);
        TreeNode treeRoot = new TreeNode();
        treeRoot.setId(String.valueOf(this.proxy.getQuoteStratege().getPkValue()));
        treeRoot.setType(key);
        treeRoot.setData((Object)node);
        treeRoot.addChildren(allNodes);
        return treeRoot;
    }

    private TreeNode getFeatureValueNode(String key, QuoteLogNode node) {
        TreeNode schemeGroupNode = new TreeNode();
        schemeGroupNode.setId(String.valueOf(this.proxy.getQuoteStratege().getPkValue()));
        schemeGroupNode.setType(key);
        schemeGroupNode.setData((Object)node);
        return schemeGroupNode;
    }
}

