/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.pricemodel.business.service.quote.log;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.mpscmm.msbd.pricemodel.business.pojo.quote.calc.QuoteCalcInfo;
import kd.mpscmm.msbd.pricemodel.business.pojo.quote.calc.QuoteSchemeGroupInfo;
import kd.mpscmm.msbd.pricemodel.business.service.quote.log.QuoteLogProxy;
import kd.mpscmm.msbd.pricemodel.business.service.quote.log.QuoteSchemeGrpLogRunnable;

public class QuoteSchemeGrpLogProxy
implements AutoCloseable {
    private static final Log log = LogFactory.getLog(QuoteSchemeGrpLogProxy.class);
    private boolean open;
    private Long quoteOrgID;
    private Date startTime;
    private Date endTime;
    private String quoteBill;
    private QuoteCalcInfo quoteCalcInfo;
    private boolean isAuto = false;
    private Map<String, Object> groupResult = new HashMap<String, Object>();
    private QuoteSchemeGroupInfo quoteSchemeGroupInfo;
    private boolean isCancle;

    public QuoteSchemeGrpLogProxy(boolean open, Long quoteOrgID, String entityType, QuoteCalcInfo quoteCalcInfo, QuoteSchemeGroupInfo quoteSchemeGroupInfo, boolean isAuto) {
        this.open = open;
        this.quoteOrgID = quoteOrgID;
        this.quoteBill = entityType;
        this.quoteCalcInfo = quoteCalcInfo;
        this.quoteSchemeGroupInfo = quoteSchemeGroupInfo;
        this.isAuto = isAuto;
        this.start();
    }

    @Override
    public void close() {
        this.end();
        this.output();
    }

    public QuoteCalcInfo getQuoteCalcInfo() {
        return this.quoteCalcInfo;
    }

    public QuoteSchemeGroupInfo getQuoteSchemeGroupInfo() {
        return this.quoteSchemeGroupInfo;
    }

    public Map<String, Object> getGroupResult() {
        return this.groupResult;
    }

    public boolean isCancle() {
        return this.isCancle;
    }

    public void setCancle(boolean cancle) {
        this.isCancle = cancle;
    }

    private final void start() {
        this.startTime = TimeServiceHelper.now();
        log.info("\u5f00\u59cb\u91c7\u96c6\u65e5\u5fd7\uff1a" + this.startTime);
    }

    public boolean isOpen() {
        return this.open;
    }

    public Long getQuoteOrgID() {
        return this.quoteOrgID;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public String getQuoteBill() {
        return this.quoteBill;
    }

    public boolean isAuto() {
        return this.isAuto;
    }

    private void end() {
        this.endTime = TimeServiceHelper.now();
        log.info("\u7ed3\u675f\u91c7\u96c6\u65e5\u5fd7\uff1a" + this.endTime);
    }

    private void output() {
        if (this.open && !this.isCancle) {
            QuoteSchemeGrpLogRunnable logRunnable = new QuoteSchemeGrpLogRunnable(this);
            ThreadPools.executeOnce((String)QuoteLogProxy.class.getName(), (Runnable)logRunnable);
        }
    }
}

