/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.pricemodel.business.service.quote.log;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.mpscmm.msbd.pricemodel.business.helper.PriceHelper;
import kd.mpscmm.msbd.pricemodel.business.pojo.PriceEntityKeyInfo;
import kd.mpscmm.msbd.pricemodel.business.service.quote.log.QuoteLogProxy;
import kd.mpscmm.msbd.pricemodel.business.service.quote.log.QuoteStrategeLogRunnable;

public class QuoteStrategeLogProxy
implements AutoCloseable {
    private static final Log log = LogFactory.getLog(QuoteStrategeLogProxy.class);
    private PriceEntityKeyInfo qccInfo;
    private boolean open;
    private Long quoteOrgID;
    private Date startTime;
    private Date endTime;
    private String quoteBill;
    private String logResult;
    private List<String> missedStrategeKeys = new ArrayList<String>();
    private List<String> multiStrategeKeys = new ArrayList<String>();

    public QuoteStrategeLogProxy(boolean open, Long quoteOrgID, String entityType, PriceEntityKeyInfo qccInfo) {
        this.open = open;
        this.quoteOrgID = quoteOrgID;
        this.quoteBill = entityType;
        this.qccInfo = qccInfo;
        this.start();
    }

    public void output() {
        if (this.open) {
            QuoteStrategeLogRunnable logRunnable = new QuoteStrategeLogRunnable(this);
            ThreadPools.executeOnce((String)QuoteLogProxy.class.getName(), (Runnable)logRunnable);
        }
    }

    @Override
    public void close() {
        this.end();
        this.output();
    }

    public Date getEndTime() {
        return this.endTime;
    }

    private final void start() {
        this.startTime = TimeServiceHelper.now();
        log.info("\u5f00\u59cb\u91c7\u96c6\u65e5\u5fd7\uff1a" + this.startTime);
    }

    public void end() {
        this.endTime = TimeServiceHelper.now();
        log.info("\u7ed3\u675f\u91c7\u96c6\u65e5\u5fd7\uff1a" + this.endTime);
    }

    public Long getQuoteOrgID() {
        return this.quoteOrgID;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public String getQuoteBill() {
        return this.quoteBill;
    }

    public void setMissedStrategeDataSet(DataSet missedStrategeDataSet) {
        this.readDataSetFirst(missedStrategeDataSet, this.missedStrategeKeys);
    }

    public void setMultiStrategeDataSet(DataSet multiStrategeDataSet) {
        this.readDataSetFirst(multiStrategeDataSet, this.multiStrategeKeys);
    }

    private void readDataSetFirst(DataSet strategeDataSet, List<String> strategeKeys) {
        if (strategeDataSet != null) {
            try (DataSet msDataSet = strategeDataSet;){
                for (Row row : msDataSet) {
                    String key = PriceHelper.generateRowKey(this.getQccInfo(), row);
                    strategeKeys.add(key);
                }
            }
        }
    }

    public PriceEntityKeyInfo getQccInfo() {
        return this.qccInfo;
    }

    public List<String> getMissedStrategeKeys() {
        return this.missedStrategeKeys;
    }

    public List<String> getMultiStrategeKeys() {
        return this.multiStrategeKeys;
    }
}

