/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.pricemodel.business.service.quote.log;

import java.util.ArrayList;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.mpscmm.msbd.pricemodel.business.helper.quote.QuoteLogTreeNodeHelper;
import kd.mpscmm.msbd.pricemodel.business.pojo.quote.QuoteLogNode;
import kd.mpscmm.msbd.pricemodel.business.service.quote.log.QuoteExpLogProxy;
import kd.mpscmm.msbd.pricemodel.business.service.quote.log.QuoteStrategeLogProxy;

public class QuoteStrategeLogRunnable
implements Runnable {
    private QuoteStrategeLogProxy proxy;
    private static final Log LOGGER = LogFactory.getLog(QuoteStrategeLogRunnable.class);

    public QuoteStrategeLogRunnable(QuoteStrategeLogProxy proxy) {
        this.proxy = proxy;
    }

    @Override
    public void run() {
        try {
            TreeNode treeRoot;
            QuoteLogNode node;
            String quoteResultDescrip;
            ArrayList<TreeNode> totalLogTreeNodes = new ArrayList<TreeNode>(16);
            for (String key : this.proxy.getMissedStrategeKeys()) {
                quoteResultDescrip = ResManager.loadKDString((String)"\u672a\u627e\u5230\u5339\u914d\u7684\u4ef7\u683c\u3002", (String)"QuoteStrategeLogRunnable_0", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]);
                node = new QuoteLogNode(null, null, null, null, quoteResultDescrip);
                treeRoot = this.getStrategyNode(key, node);
                totalLogTreeNodes.add(treeRoot);
            }
            QuoteLogTreeNodeHelper.createQuoteStrategeLog(totalLogTreeNodes, this.proxy, "NONE");
            totalLogTreeNodes.clear();
            for (String key : this.proxy.getMultiStrategeKeys()) {
                quoteResultDescrip = ResManager.loadKDString((String)"\u672a\u627e\u5230\u5339\u914d\u7684\u4ef7\u683c\u3002", (String)"QuoteStrategeLogRunnable_0", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]);
                node = new QuoteLogNode(null, null, null, null, quoteResultDescrip);
                treeRoot = this.getStrategyNode(key, node);
                totalLogTreeNodes.add(treeRoot);
            }
            QuoteLogTreeNodeHelper.createQuoteStrategeLog(totalLogTreeNodes, this.proxy, "MULTI");
        }
        catch (KDBizException e) {
            this.close();
            try (QuoteExpLogProxy expLogProxy = new QuoteExpLogProxy(true, this.proxy.getQuoteOrgID(), this.proxy.getQuoteBill());){
                String quoteLogExp = ResManager.loadKDString((String)"\u53d6\u4ef7\u65e5\u5fd7\u91c7\u96c6\u8fc7\u7a0b\u51fa\u73b0\u5f02\u5e383\uff1a", (String)"QuoteStrategeLogRunnable_1", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]);
                expLogProxy.setCancle(false);
                expLogProxy.setLogResult(quoteLogExp + e.getMessage());
            }
        }
        catch (Exception e1) {
            LOGGER.info(e1.getMessage());
            this.close();
            try (QuoteExpLogProxy expLogProxy = new QuoteExpLogProxy(true, this.proxy.getQuoteOrgID(), this.proxy.getQuoteBill());){
                String quoteLogExp = ResManager.loadKDString((String)"\u53d6\u4ef7\u65e5\u5fd7\u91c7\u96c6\u8fc7\u7a0b\u51fa\u73b0\u5f02\u5e384\uff1a", (String)"QuoteStrategeLogRunnable_2", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]);
                expLogProxy.setCancle(false);
                expLogProxy.setLogResult(quoteLogExp + e1.getClass() + e1.getMessage());
            }
        }
    }

    private void close() {
    }

    private TreeNode getStrategyNode(String key, QuoteLogNode node) {
        TreeNode treeRoot = new TreeNode();
        treeRoot.setId("0");
        treeRoot.setType(key);
        treeRoot.setData((Object)node);
        return treeRoot;
    }
}

