/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.pricemodel.business.service.quote.step;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.JoinDataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.mpscmm.msbd.pricemodel.business.pojo.quote.QuotePolicyParam;
import kd.mpscmm.msbd.pricemodel.business.pojo.quote.QuoteSchemeInfo;
import kd.mpscmm.msbd.pricemodel.business.service.quote.log.QuoteLogProxy;
import kd.mpscmm.msbd.pricemodel.business.service.quote.step.QuoteStep;

public class QuoteBillExpandStep
extends QuoteStep {
    private static final Log logger = LogFactory.getLog(QuoteBillExpandStep.class);

    @Override
    public void excute(QuotePolicyParam quotePolicyParam, QuoteSchemeInfo quoteSchemeInfo, QuoteLogProxy logProxy) {
        DataSet quoteDataSet = quotePolicyParam.getQuoteDataSet();
        ArrayList<Long> configCodeList = new ArrayList<Long>(16);
        try (DataSet quoteDataSetCopy = quoteDataSet.copy();){
            for (Row quoteRow : quoteDataSetCopy) {
                Long configCodeID = quoteRow.getLong(quoteSchemeInfo.getConfigureAlias().get(0));
                if (Long.valueOf("0").equals(configCodeID)) continue;
                configCodeList.add(configCodeID);
            }
        }
        if (configCodeList.size() == 0) {
            logger.info("\u4e0d\u5b58\u5728\u914d\u7f6e\u53f7");
            this.directReturn(quotePolicyParam);
            return;
        }
        Map configCodeListMap = (Map)DispatchServiceHelper.invokeBizService((String)"mmc", (String)"pdm", (String)"proConfigListQueryService", (String)"getJsonProdConfigFeatureList", (Object[])new Object[]{Boolean.TRUE, configCodeList});
        if (Boolean.TRUE.equals(configCodeListMap.get("status"))) {
            ArrayList configureList = new ArrayList();
            logger.info("\u914d\u7f6e\u53f7\u5c55\u5f00\u63a5\u53e3\u6267\u884c\u4e14\u8fd4\u56de\u6210\u529f");
            if (configCodeListMap.get("data") == null || "".equals(configCodeListMap.get("data"))) {
                logger.info("\u5236\u9020\u5c55\u7b97\u63a5\u53e3\u8fd4\u56deDATAL_KEY\u4e3a\u7a7a");
                this.directReturn(quotePolicyParam);
                return;
            }
            JSONArray jsonObjects = (JSONArray)configCodeListMap.get("data");
            logger.info("\u914d\u7f6e\u53f7\u5c55\u5f00\u4e2a\u6570 ===" + jsonObjects.size());
            if (jsonObjects.size() < 10) {
                logger.info("\u914d\u7f6e\u53f7\u8fd4\u56de\u5b8c\u6574json ===" + jsonObjects.toJSONString());
            }
            jsonObjects.forEach(e -> {
                Set configureResult = ((JSONObject)e).entrySet();
                for (Map.Entry configure : configureResult) {
                    String configureId = (String)configure.getKey();
                    JSONObject featureResult = (JSONObject)configure.getValue();
                    if (!Boolean.TRUE.equals(featureResult.get((Object)"status"))) continue;
                    JSONArray featureObjects = (JSONArray)featureResult.get((Object)"featurelist");
                    logger.info("\u914d\u7f6e\u53f7ID\u4e3a" + configureId + " \u5c55\u5f00\u7279\u5f81\u5bf9\u8c61\u4e2a\u6570 ===" + featureObjects.size());
                    featureObjects.forEach(s -> {
                        String featureID = ((JSONObject)s).getString("featureid");
                        List featureValues = (List)((JSONObject)s).get((Object)"featurevalue");
                        for (String featureValue : featureValues) {
                            Object[] configureRow = new Object[]{Long.valueOf(configureId), Long.valueOf(featureID), featureValue};
                            configureList.add(configureRow);
                        }
                    });
                }
            });
            DataType[] dataTypes = new DataType[]{DataType.LongType, DataType.LongType, DataType.StringType};
            String[] fieldNames = new String[]{"configureexpand", "featureexpand", "featurevalue"};
            RowMeta configureRowMeta = new RowMeta(fieldNames, dataTypes);
            DataSet configureResultSet = Algo.create((String)"QuoteBillExpandStep").createDataSet(configureList.iterator(), configureRowMeta);
            JoinDataSet quoteAndConfigureDataSet = quoteDataSet.join(configureResultSet, JoinType.LEFT).on(quoteSchemeInfo.getConfigureAlias().get(0), "configureexpand");
            Field[] quoteFields = quoteDataSet.getRowMeta().getFields();
            ArrayList<String> leftSelector = new ArrayList<String>(quoteFields.length);
            for (Field f : quoteFields) {
                leftSelector.add(f.getName());
            }
            ArrayList<String> rightSelector = new ArrayList<String>(2);
            rightSelector.add("featureexpand");
            rightSelector.add("featurevalue");
            quotePolicyParam.setQuoteDataSet(quoteAndConfigureDataSet.select(leftSelector.toArray(new String[0]), rightSelector.toArray(new String[0])).finish());
            return;
        }
        logger.info("\u5236\u9020\u5c55\u7b97\u63a5\u53e3\u4e0d\u6b63\u5e38\u8fd4\u56de");
        this.directReturn(quotePolicyParam);
    }

    private void directReturn(QuotePolicyParam quotePolicyParam) {
        DataSet quoteDataSet = quotePolicyParam.getQuoteDataSet();
        quoteDataSet = quoteDataSet.addNullField("featureexpand");
        quoteDataSet = quoteDataSet.addNullField("featurevalue");
        quotePolicyParam.setQuoteDataSet(quoteDataSet);
    }
}

