/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.pricemodel.business.service.quote.step;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.mpscmm.msbd.pricemodel.business.helper.DataSetHelper;
import kd.mpscmm.msbd.pricemodel.business.helper.PriceHelper;
import kd.mpscmm.msbd.pricemodel.business.helper.quote.QuoteExtHelper;
import kd.mpscmm.msbd.pricemodel.business.helper.quote.QuoteLogHelper;
import kd.mpscmm.msbd.pricemodel.business.pojo.quote.QuotePolicyParam;
import kd.mpscmm.msbd.pricemodel.business.pojo.quote.QuoteSchemeInfo;
import kd.mpscmm.msbd.pricemodel.business.service.quote.log.QuoteLogProxy;
import kd.mpscmm.msbd.pricemodel.business.service.quote.step.QuoteStep;
import kd.mpscmm.msbd.pricemodel.common.consts.log.QuoteLogConst;
import kd.mpscmm.msbd.pricemodel.common.enums.quote.LogClassEnum;
import kd.sdk.mpscmm.msbd.expoint.quote.QuoteDoParam;

public class QuoteProcessExtStep
extends QuoteStep {
    private static final Log logger = LogFactory.getLog(QuoteProcessExtStep.class);

    @Override
    public void excute(QuotePolicyParam quotePolicyParam, QuoteSchemeInfo quoteSchemeInfo, QuoteLogProxy logProxy) {
        QuoteDoParam extParam = new QuoteDoParam(quotePolicyParam.getQuoteDataSet(), quoteSchemeInfo.getQuoteScheme());
        ArrayList<String> resultMustFields = new ArrayList<String>(quotePolicyParam.getQccInfo().getLEFTIDFIELDS().size() + 1);
        resultMustFields.addAll(quotePolicyParam.getQccInfo().getLEFTIDFIELDS());
        String terminateField = PriceHelper.getLeftName(quoteSchemeInfo.getTerminationSignX());
        resultMustFields.add(terminateField);
        extParam.setRowKeyFields(quotePolicyParam.getQccInfo().getLEFTIDFIELDS());
        extParam.setTerminateField(terminateField);
        extParam.setPriceSourceFields(Arrays.asList(QuoteLogConst.getQuotelogSearchfields()));
        List<Boolean> results = QuoteExtHelper.callDoQuote(extParam);
        boolean isRequireClose = false;
        if (results.size() > 0) {
            if (extParam.getResultSet() == null) {
                String message = ResManager.loadKDString((String)"\u8c03\u7528\u53d6\u4ef7\u670d\u52a1\u62d3\u5c55\u573a\u666f\u8fd4\u56de\u7ed3\u679c\u6570\u636e\u96c6\u7ed3\u679c\u4e3a\u7a7a\uff0c\u4e0d\u7b26\u5408\u62d3\u5c55\u7ea6\u5b9a,\u62d3\u5c55\u573a\u666f\u4e3a\u201c%1$s\u201d,\u62d3\u5c55\u65b9\u6cd5\u4e3a\u201c%2$s\u201d,\u53d6\u4ef7\u65b9\u6848\u4e3a\u201c%3$s\u201d\u3002", (String)"QuoteProcessExtStep_0", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]);
                message = String.format(message, "MPSCMM_MSBD_QUOTE", "isReplaceQuoteProcess", quoteSchemeInfo.getName());
                throw new KDBizException(message);
            }
            resultMustFields.forEach(e -> {
                DataSet resultSet = extParam.getResultSet();
                if (!DataSetHelper.isIncludeField(e, resultSet)) {
                    String resultMustFieldStr = String.join((CharSequence)",", resultMustFields);
                    String message = ResManager.loadKDString((String)"\u8c03\u7528\u53d6\u4ef7\u670d\u52a1\u62d3\u5c55\u573a\u666f\u8fd4\u56de\u7ed3\u679c\u6570\u636e\u96c6\u5b57\u6bb5\u4e0d\u7b26\u5408\u62d3\u5c55\u7ea6\u5b9a,\u5e94\u8be5\u5305\u62ec\u5982\u4e0b\u5b57\u6bb5\uff1a\u201c%1$s\u201d,\u62d3\u5c55\u573a\u666f\u4e3a\u201c%2$s\u201d,\u62d3\u5c55\u65b9\u6cd5\u4e3a\u201c%3$s\u201d,\u573a\u666f\u53d6\u4ef7\u65b9\u6848\u4e3a\u201c%4$s\u201d\u3002", (String)"QuoteProcessExtStep_1", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]);
                    message = String.format(message, resultMustFieldStr, "MPSCMM_MSBD_QUOTE", "isReplaceQuoteProcess", quoteSchemeInfo.getName());
                    throw new KDBizException(message);
                }
            });
            Object resultSet = extParam.getResultSet();
            String priceSourceMessage = ResManager.loadKDString((String)"\u52a0\u5de5\u6570\u636e\u96c6", (String)"QuoteProcessExtStep_2", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]);
            resultSet = QuoteLogHelper.completePriceSourceField(quoteSchemeInfo.getQuoteSrcType(), (DataSet)resultSet, priceSourceMessage);
            String filterStr_r = new StringBuffer(terminateField).append(" ").append("is not null").toString();
            resultSet = resultSet.where(filterStr_r);
            try (DataSet logDataSet = resultSet.copy();){
                logProxy.addMatchAllPriceCache(quoteSchemeInfo.getId(), logDataSet, false, LogClassEnum.QUOTESCHEME);
                logProxy.addShootSourceCache(logDataSet);
                logProxy.shootPriceCache(logDataSet, quoteSchemeInfo.getId(), quotePolicyParam.getQccInfo(), LogClassEnum.QUOTESCHEME);
            }
            quotePolicyParam.setResultSet((DataSet)resultSet);
            resultSet = results.iterator();
            while (resultSet.hasNext()) {
                boolean flag = (Boolean)resultSet.next();
                if (!flag) continue;
                isRequireClose = true;
                break;
            }
            if (isRequireClose) {
                try {
                    if (quotePolicyParam.getQuoteDataSet() != null) {
                        quotePolicyParam.getQuoteDataSet().close();
                    }
                    if (quotePolicyParam.getQuoteSourceDataSet() != null) {
                        quotePolicyParam.getQuoteSourceDataSet().close();
                    }
                }
                catch (Throwable ex) {
                    logger.info("QuoteDataSet close occur exception");
                }
            }
        }
    }
}

