/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.pricemodel.business.service.quote.step;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mpscmm.msbd.pricemodel.business.pojo.PriceSourceKeyInfo;
import kd.mpscmm.msbd.pricemodel.business.pojo.quote.QuotePolicyParam;
import kd.mpscmm.msbd.pricemodel.business.pojo.quote.QuoteSchemeInfo;
import kd.mpscmm.msbd.pricemodel.business.service.quote.log.QuoteLogProxy;
import kd.mpscmm.msbd.pricemodel.business.service.quote.step.QuoteStep;
import kd.mpscmm.msbd.pricemodel.common.enums.OperatorEnum;

public class QuoteSourceFilterStep
extends QuoteStep {
    private static final Log logger = LogFactory.getLog(QuoteSourceFilterStep.class);

    @Override
    public void excute(QuotePolicyParam quotePolicyParam, QuoteSchemeInfo quoteSchemeInfo, QuoteLogProxy logProxy) {
        logger.info("quote into this QuoteSourceFilterStep  path:");
        List<String> allSourceSelecties = quoteSchemeInfo.mergeQuoteSourceFields();
        List<String> allAliasSelecties = quoteSchemeInfo.mergeQuoteSourceAlias();
        for (int i = 0; i < allSourceSelecties.size(); ++i) {
            allSourceSelecties.set(i, new StringBuffer(allSourceSelecties.get(i)).append(new StringBuffer(" ")).append(new StringBuffer(allAliasSelecties.get(i))).toString());
        }
        PriceSourceKeyInfo quoteSrcKeyInfo = quoteSchemeInfo.getPriceSourceKeyInfo();
        ArrayList<String> allSrcSelecties = new ArrayList<String>();
        if (StringUtils.isNotEmpty((CharSequence)quoteSrcKeyInfo.getBILLNO())) {
            allSrcSelecties.add(quoteSrcKeyInfo.getBILLNO() + " " + "quotesrcno");
        }
        if (StringUtils.isNotEmpty((CharSequence)quoteSrcKeyInfo.getBILLENTRY_SEQ())) {
            allSrcSelecties.add(quoteSrcKeyInfo.getBILLENTRY_SEQ() + " " + "quotesrcseq");
        }
        allSourceSelecties.addAll(allSrcSelecties);
        DataSet quoteSrcDataSet = null;
        try {
            if (quoteSchemeInfo.getQuoteSrcFilter() != null && logger.isInfoEnabled()) {
                logger.info("quotesrcfilter=======" + quoteSchemeInfo.getQuoteSrcFilter());
            }
            QFilter qConditionFilter = this.getLimitFilter(quotePolicyParam, quoteSchemeInfo);
            try (TXHandle h = TX.requiresNew((String)this.getClass().getName());){
                try (DataSet offlineDataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)quoteSchemeInfo.getQuoteSrcType(), (String)String.join((CharSequence)",", allSourceSelecties), (QFilter[])new QFilter[]{qConditionFilter, quoteSchemeInfo.getQuoteSrcFilter()}, null);){
                    logger.info("quote into this qConditionFilter=" + qConditionFilter);
                    quoteSrcDataSet = offlineDataSet.copy();
                }
                catch (Exception ex) {
                    logger.info("quote into this QuoteSourceFilterStep  exception");
                    h.markRollback();
                    throw ex;
                }
                finally {
                    h.commit();
                }
            }
            quoteSrcDataSet = quoteSrcDataSet.addField("'" + quoteSchemeInfo.getQuoteSrcType() + "'", "quotesrcbill");
            if (StringUtils.isEmpty((CharSequence)quoteSrcKeyInfo.getBILLNO())) {
                quoteSrcDataSet = quoteSrcDataSet.addNullField("quotesrcno");
            }
            if (StringUtils.isEmpty((CharSequence)quoteSrcKeyInfo.getBILLENTRY_SEQ())) {
                quoteSrcDataSet = quoteSrcDataSet.addNullField("quotesrcseq");
            }
        }
        catch (Throwable e) {
            if (quoteSrcDataSet == null) {
                logger.info("quote into this QuoteSourceFilterStep  exception x");
                String message = ResManager.loadKDString((String)"\u67e5\u8be2\u53d6\u4ef7\u6765\u6e90\u5355\u636e\u65f6\u51fa\u73b0\u5f02\u5e38\uff0c\u53d6\u4ef7\u65b9\u6848\u201c%1$s\u201d\u7684\u5b57\u6bb5\u6620\u5c04\u5206\u5f55\u7684\u4ef7\u683c\u6765\u6e90\u5b57\u6bb5\u548c\u53d6\u4ef7\u5355\u636e\u5b57\u6bb5\u53ef\u80fd\u5b58\u5728\u5b57\u6bb5\u7c7b\u578b\u4e0d\u5339\u914d\u6216\u4ef7\u683c\u6765\u6e90\u5355\u636e\u7684\u5143\u6570\u636e\u5b57\u6bb5\u53ef\u80fd\u53d1\u751f\u4e86\u53d8\u66f4\u3002", (String)"QuoteSourceFilterStep_0", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]);
                message = String.format(message, quoteSchemeInfo.getName());
                throw new KDBizException(message);
            }
            try {
                quoteSrcDataSet.close();
            }
            catch (Throwable var15) {
                logger.info("quote into this QuoteSourceFilterStep  exception y");
                e.addSuppressed(var15);
                String message = ResManager.loadKDString((String)"\u67e5\u8be2\u53d6\u4ef7\u6765\u6e90\u5355\u636e\u65f6\u51fa\u73b0\u5f02\u5e38\u3002", (String)"QuoteSourceFilterStep_1", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]);
                throw new KDBizException(message);
            }
        }
        logger.info("quote output this QuoteSourceFilterStep  path:");
        quotePolicyParam.setQuoteSourceDataSet(quoteSrcDataSet);
    }

    protected List<String> getLimitFields() {
        return Arrays.asList("org", "billno", "material", "customer", "supplier", "cpnn");
    }

    private QFilter getLimitFilter(QuotePolicyParam quotePolicyParam, QuoteSchemeInfo quoteSchemeInfo) {
        int i2;
        List<String> limitFields = this.getLimitFields();
        ArrayList<String> valueFields = new ArrayList<String>(quoteSchemeInfo.getOperators().size());
        ArrayList<String> conditonFields = new ArrayList<String>(quoteSchemeInfo.getOperators().size());
        for (int i3 = 0; i3 < quoteSchemeInfo.getOperators().size(); ++i3) {
            String operator = quoteSchemeInfo.getOperators().get(i3);
            if (!OperatorEnum.EQUALS.getValue().equals(operator)) continue;
            for (String limitField : limitFields) {
                if (!quoteSchemeInfo.getQuoteAlias().get(i3).contains(limitField) || !StringUtils.isNotEmpty((CharSequence)quoteSchemeInfo.getQuoteSourceDimensions().get(i3))) continue;
                valueFields.add(quoteSchemeInfo.getQuoteAlias().get(i3));
                conditonFields.add(quoteSchemeInfo.getQuoteSourceDimensions().get(i3));
            }
        }
        ArrayList<String> lessConditonFields = new ArrayList<String>(quoteSchemeInfo.getOperators().size());
        ArrayList<String> valueMaxFields = new ArrayList<String>(quoteSchemeInfo.getOperators().size());
        ArrayList<String> largeConditonFields = new ArrayList<String>(quoteSchemeInfo.getOperators().size());
        ArrayList<String> valueMinFields = new ArrayList<String>(quoteSchemeInfo.getOperators().size());
        if ("sm_salepricelist".equals(quoteSchemeInfo.getQuoteSrcType()) || "pm_purpricelist".equals(quoteSchemeInfo.getQuoteSrcType())) {
            for (int i4 = 0; i4 < quoteSchemeInfo.getOperators().size(); ++i4) {
                String operator = quoteSchemeInfo.getOperators().get(i4);
                if ((OperatorEnum.LESS_EQUALS.getValue().equals(operator) || OperatorEnum.LESS_THAN.getValue().equals(operator)) && StringUtils.isNotEmpty((CharSequence)quoteSchemeInfo.getQuoteSourceDimensions().get(i4)) && (quoteSchemeInfo.getQuoteSourceDimensions().get(i4).contains("effectdate") || quoteSchemeInfo.getQuoteSourceDimensions().get(i4).contains("expirydate") || quoteSchemeInfo.getQuoteSourceDimensions().get(i4).contains("priceeffectdate") || quoteSchemeInfo.getQuoteSourceDimensions().get(i4).contains("priceexpirydate"))) {
                    valueMaxFields.add(quoteSchemeInfo.getQuoteAlias().get(i4));
                    lessConditonFields.add(quoteSchemeInfo.getQuoteSourceDimensions().get(i4));
                }
                if (!OperatorEnum.LARGE_EQUALS.getValue().equals(operator) && !OperatorEnum.LARGE_THAN.getValue().equals(operator) || !StringUtils.isNotEmpty((CharSequence)quoteSchemeInfo.getQuoteSourceDimensions().get(i4)) || !quoteSchemeInfo.getQuoteSourceDimensions().get(i4).contains("effectdate") && !quoteSchemeInfo.getQuoteSourceDimensions().get(i4).contains("expirydate") && !quoteSchemeInfo.getQuoteSourceDimensions().get(i4).contains("priceeffectdate") && !quoteSchemeInfo.getQuoteSourceDimensions().get(i4).contains("priceexpirydate")) continue;
                valueMinFields.add(quoteSchemeInfo.getQuoteAlias().get(i4));
                largeConditonFields.add(quoteSchemeInfo.getQuoteSourceDimensions().get(i4));
            }
        }
        ArrayList valuesSet = new ArrayList(valueFields.size());
        valueFields.forEach(e -> valuesSet.add(new HashSet()));
        ArrayList maxValues = IntStream.range(0, valueMaxFields.size()).mapToObj(i -> null).collect(Collectors.toCollection(ArrayList::new));
        ArrayList minValues = IntStream.range(0, valueMinFields.size()).mapToObj(i -> null).collect(Collectors.toCollection(ArrayList::new));
        try (DataSet conditionSet = quotePolicyParam.getQuoteDataSet().copy();){
            int i5;
            RowMeta rowMeta = conditionSet.getRowMeta();
            for (i5 = valueMaxFields.size() - 1; i5 >= 0; --i5) {
                if (DataType.DateType.equals((Object)rowMeta.getField((String)valueMaxFields.get(i5)).getDataType()) || DataType.TimestampType.equals((Object)rowMeta.getField((String)valueMaxFields.get(i5)).getDataType())) continue;
                valueMaxFields.remove(i5);
                maxValues.remove(i5);
                lessConditonFields.remove(i5);
            }
            for (i5 = valueMinFields.size() - 1; i5 >= 0; --i5) {
                if (DataType.DateType.equals((Object)rowMeta.getField((String)valueMinFields.get(i5)).getDataType()) || DataType.TimestampType.equals((Object)rowMeta.getField((String)valueMinFields.get(i5)).getDataType())) continue;
                valueMinFields.remove(i5);
                minValues.remove(i5);
                largeConditonFields.remove(i5);
            }
            for (Row conditonRow : conditionSet) {
                Object value;
                int i6;
                for (i6 = 0; i6 < valueFields.size(); ++i6) {
                    value = conditonRow.get((String)valueFields.get(i6));
                    ((Set)valuesSet.get(i6)).add(value);
                }
                for (i6 = 0; i6 < valueMaxFields.size(); ++i6) {
                    value = conditonRow.get((String)valueMaxFields.get(i6));
                    if (maxValues.get(i6) == null) {
                        if (value == null) continue;
                        maxValues.set(i6, value);
                        continue;
                    }
                    if (value == null || !((Date)value).after((Date)maxValues.get(i6))) continue;
                    maxValues.set(i6, value);
                }
                for (i6 = 0; i6 < valueMinFields.size(); ++i6) {
                    value = conditonRow.get((String)valueMinFields.get(i6));
                    if (minValues.get(i6) == null) {
                        if (value == null) continue;
                        minValues.set(i6, value);
                        continue;
                    }
                    if (value == null || !((Date)value).before((Date)minValues.get(i6))) continue;
                    minValues.set(i6, value);
                }
            }
        }
        QFilter qConditionFilter = QFilter.of((String)"1=1", (Object[])new Object[0]);
        for (i2 = 0; i2 < conditonFields.size(); ++i2) {
            if (((Set)valuesSet.get(i2)).size() > 20000) continue;
            qConditionFilter.and(new QFilter((String)conditonFields.get(i2), "in", valuesSet.get(i2)));
        }
        for (i2 = 0; i2 < lessConditonFields.size(); ++i2) {
            if (maxValues.get(i2) == null) continue;
            qConditionFilter.and(new QFilter((String)lessConditonFields.get(i2), "<=", maxValues.get(i2)));
        }
        for (i2 = 0; i2 < largeConditonFields.size(); ++i2) {
            if (minValues.get(i2) == null) continue;
            qConditionFilter.and(new QFilter((String)largeConditonFields.get(i2), ">=", minValues.get(i2)));
        }
        return qConditionFilter;
    }
}

