/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.pricemodel.business.service.quote.step.calc;

import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.mpscmm.msbd.pricemodel.business.helper.PriceHelper;
import kd.mpscmm.msbd.pricemodel.business.pojo.quote.QuotePolicyParam;
import kd.mpscmm.msbd.pricemodel.business.pojo.quote.calc.QuoteCalcInfo;
import kd.mpscmm.msbd.pricemodel.business.service.quote.log.QuoteLogProxy;
import kd.mpscmm.msbd.pricemodel.business.service.quote.step.calc.CalcStep;
import kd.mpscmm.msbd.pricemodel.common.enums.quote.LogClassEnum;

public class CalcBillPreFilterStep
extends CalcStep {
    private static final Log logger = LogFactory.getLog(CalcBillPreFilterStep.class);

    @Override
    public void excute(QuotePolicyParam quotePolicyParam, QuoteCalcInfo quoteCalcInfo, QuoteLogProxy logProxy) {
        logProxy.missSchemeCache(quotePolicyParam.getQuoteDataSet(), quoteCalcInfo.getId(), quotePolicyParam.getQccInfo(), LogClassEnum.CALSTRATEGE);
        MainEntityType headType = EntityMetadataCache.getDataEntityType((String)quoteCalcInfo.getQuoteType());
        QFilter totalFilter = quoteCalcInfo.getQuotePreFilter();
        List<QFilter> conditionFilters = quoteCalcInfo.getQuotePreFilters();
        if (conditionFilters.size() > 0) {
            String conditionStr = PriceHelper.dataTypeAdapte(totalFilter, headType);
            DataSet quoteDataSet = quotePolicyParam.getQuoteDataSet();
            quoteDataSet = quoteDataSet.filter(conditionStr);
            quotePolicyParam.setQuoteDataSet(quoteDataSet);
        }
        logProxy.missPriceCache(quotePolicyParam.getQuoteDataSet(), quoteCalcInfo.getId(), quotePolicyParam.getQccInfo(), LogClassEnum.CALSTRATEGE);
    }
}

