/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.pricemodel.business.service.quote.step.calc;

import java.math.BigDecimal;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.mpscmm.msbd.pricemodel.business.helper.PriceHelper;
import kd.mpscmm.msbd.pricemodel.business.pojo.quote.QuotePolicyParam;
import kd.mpscmm.msbd.pricemodel.business.pojo.quote.calc.QuoteCalcInfo;
import kd.mpscmm.msbd.pricemodel.business.pojo.quote.calc.QuoteSchemeGroupInfo;
import kd.mpscmm.msbd.pricemodel.business.service.quote.log.QuoteLogProxy;
import kd.mpscmm.msbd.pricemodel.business.service.quote.log.QuoteSchemeGrpLogProxy;
import kd.mpscmm.msbd.pricemodel.business.service.quote.step.calc.CalcStep;
import kd.mpscmm.msbd.pricemodel.common.enums.quote.PriceSourceEnum;

public class CalcGetBillFieldStep
extends CalcStep {
    private static final Log logger = LogFactory.getLog(CalcGetBillFieldStep.class);

    @Override
    public void excute(QuotePolicyParam quotePolicyParam, QuoteCalcInfo quoteCalcInfo, QuoteLogProxy logProxy) {
        quoteCalcInfo.getSchemeGroupInfos().forEach(quoteSchemeGroupInfo -> {
            if (PriceSourceEnum.BILLFIELD.getValue().equals(quoteSchemeGroupInfo.getPriceSource())) {
                try (QuoteSchemeGrpLogProxy schemeGroupLogProxy = new QuoteSchemeGrpLogProxy(logProxy.isOpen(), quotePolicyParam.getQuoteOrgID(), quotePolicyParam.getEntityType(), quoteCalcInfo, (QuoteSchemeGroupInfo)quoteSchemeGroupInfo, logProxy.isAuto());){
                    try (DataSet quoteDataSet = quotePolicyParam.getQuoteDataSet().copy();){
                        for (Row row : quoteDataSet) {
                            String mainKey = PriceHelper.generateRowKey(quotePolicyParam.getQccInfo(), row);
                            Object value = row.get(quoteSchemeGroupInfo.getQuoteFieldSignAlias());
                            if (!quoteSchemeGroupInfo.isRequire() && value == null) {
                                value = BigDecimal.ZERO;
                            }
                            quoteSchemeGroupInfo.getGroupResult().put(mainKey, value);
                        }
                        schemeGroupLogProxy.getGroupResult().putAll(quoteSchemeGroupInfo.getGroupResult());
                    }
                    catch (KDBizException e) {
                        schemeGroupLogProxy.setCancle(true);
                        throw e;
                    }
                    catch (Exception e1) {
                        schemeGroupLogProxy.setCancle(true);
                        throw e1;
                    }
                }
            }
        });
    }
}

