/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.pricemodel.business.service.quote.step.calc;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;
import kd.mpscmm.msbd.pricemodel.business.helper.DataSetHelper;
import kd.mpscmm.msbd.pricemodel.business.helper.PriceHelper;
import kd.mpscmm.msbd.pricemodel.business.helper.quote.QuoteLogHelper;
import kd.mpscmm.msbd.pricemodel.business.pojo.AdvancedPricingProInfo;
import kd.mpscmm.msbd.pricemodel.business.pojo.quote.QuotePolicyParam;
import kd.mpscmm.msbd.pricemodel.business.pojo.quote.calc.FeatureValueInfo;
import kd.mpscmm.msbd.pricemodel.business.pojo.quote.calc.QuoteCalcFormulaInfo;
import kd.mpscmm.msbd.pricemodel.business.pojo.quote.calc.QuoteCalcInfo;
import kd.mpscmm.msbd.pricemodel.business.pojo.quote.calc.QuoteSchemeGroupInfo;
import kd.mpscmm.msbd.pricemodel.business.service.formulaexecutor.IPriceFormulaCalculate;
import kd.mpscmm.msbd.pricemodel.business.service.formulaexecutor.PriceFormulaCalculateExpr;
import kd.mpscmm.msbd.pricemodel.business.service.formulaexecutor.PriceFormulaExecutor;
import kd.mpscmm.msbd.pricemodel.business.service.quote.log.QuoteLogProxy;
import kd.mpscmm.msbd.pricemodel.business.service.quote.step.calc.CalcStep;
import kd.mpscmm.msbd.pricemodel.common.enums.quote.LogClassEnum;

public class CalcProcessStep
extends CalcStep {
    private static final Log logger = LogFactory.getLog(CalcProcessStep.class);

    @Override
    public void excute(QuotePolicyParam quotePolicyParam, QuoteCalcInfo quoteCalcInfo, QuoteLogProxy logProxy) {
        logger.info("\u9ad8\u7ea7\u5b9a\u4ef7\u8ba1\u7b97\u5f00\u59cb\u3002");
        try (DataSet quoteResultColl = quotePolicyParam.getResultSet();){
            int i;
            List<QuoteCalcFormulaInfo> formulaInfoList = quoteCalcInfo.getFormulaInfos();
            ArrayList<String> quoteSignList = new ArrayList<String>(8);
            quotePolicyParam.getQccInfo().getLEFTIDFIELDS().forEach(e -> quoteSignList.add((String)e));
            for (QuoteCalcFormulaInfo quoteCalcFormulaInfo : formulaInfoList) {
                String quoteSign = quoteCalcFormulaInfo.getQuotesign();
                if (StringUtils.isBlank((String)quoteSign)) continue;
                quoteSignList.add(PriceHelper.getLeftName(quoteSign));
            }
            DataType[] dataType = new DataType[quoteSignList.size()];
            RowMeta origialMeta = quoteResultColl.getRowMeta();
            for (i = 0; i < quotePolicyParam.getQccInfo().getLEFTIDFIELDS().size(); ++i) {
                String key = quotePolicyParam.getQccInfo().getLEFTIDFIELDS().get(i);
                int index = origialMeta.getFieldIndex(key);
                dataType[i] = origialMeta.getDataType(index);
            }
            for (i = quotePolicyParam.getQccInfo().getLEFTIDFIELDS().size(); i < dataType.length; ++i) {
                dataType[i] = DataType.BigDecimalType;
            }
            RowMeta rowMeta = new RowMeta(quoteSignList.toArray(new String[0]), dataType);
            List<QuoteSchemeGroupInfo> schemeGroupInfoList = quoteCalcInfo.getSchemeGroupInfos();
            ArrayList<Object[]> calResultList = new ArrayList<Object[]>();
            Long calStrategyID = Long.valueOf(quoteCalcInfo.getId().split("__")[0]);
            for (Row row : quoteResultColl) {
                String mainKey = PriceHelper.generateRowKey(quotePolicyParam.getQccInfo(), row);
                AdvancedPricingProInfo pricingProInfo = AdvancedPricingProInfo.createInstance();
                pricingProInfo.setQuoteStrategy(quoteCalcInfo.getQuoteStratege().getLong("id"));
                pricingProInfo.setCalStrategy(calStrategyID);
                if (quotePolicyParam.getQccInfo().getLEFTIDFIELDS().size() == 1) {
                    pricingProInfo.setBillId((Long)row.get(quotePolicyParam.getQccInfo().getLEFTIDFIELDS().get(0)));
                } else {
                    pricingProInfo.setBillId((Long)row.get(quotePolicyParam.getQccInfo().getLEFTIDFIELDS().get(0)));
                    pricingProInfo.setEntryId((Long)row.get(quotePolicyParam.getQccInfo().getLEFTIDFIELDS().get(1)));
                }
                pricingProInfo.setQuoteEntity(quotePolicyParam.getEntityType());
                pricingProInfo.setOrg(quotePolicyParam.getQuoteOrgID());
                pricingProInfo.setKey(QuoteLogHelper.generateUniqueKey(pricingProInfo.getBillId(), pricingProInfo.getEntryId()));
                HashMap<String, Object> valueMap = new HashMap<String, Object>(16);
                for (QuoteSchemeGroupInfo quoteSchemeGroupInfo : schemeGroupInfoList) {
                    String string = quoteSchemeGroupInfo.getNumber();
                    BigDecimal price = row.getBigDecimal(string);
                    valueMap.put(string, price);
                }
                Object[] obj = new Object[quoteSignList.size()];
                for (int i2 = 0; i2 < quotePolicyParam.getQccInfo().getLEFTIDFIELDS().size(); ++i2) {
                    obj[i2] = row.get(quotePolicyParam.getQccInfo().getLEFTIDFIELDS().get(i2));
                }
                for (QuoteCalcFormulaInfo quoteCalcFormulaInfo : formulaInfoList) {
                    String formula = quoteCalcFormulaInfo.getFormula();
                    DynamicObject processFactor = quoteCalcFormulaInfo.getProcessfactor();
                    if (processFactor == null) continue;
                    String number = processFactor.getString("number");
                    PriceFormulaExecutor priceFormulaExecutor = PriceFormulaExecutor.create(PriceFormulaCalculateExpr.create(number, formula));
                    Map<String, Object> result = priceFormulaExecutor.calculate(valueMap);
                    valueMap.put(number, result.get(number));
                }
                ArrayList<IPriceFormulaCalculate> calExpr = new ArrayList<IPriceFormulaCalculate>(16);
                for (QuoteCalcFormulaInfo quoteCalcFormulaInfo3 : formulaInfoList) {
                    String formula = quoteCalcFormulaInfo3.getFormula();
                    String quoteSign = quoteCalcFormulaInfo3.getQuotesign();
                    if (StringUtils.isBlank((String)quoteSign)) continue;
                    calExpr.add(PriceFormulaCalculateExpr.create(quoteSign, formula));
                }
                PriceFormulaExecutor priceFormulaExecutor = PriceFormulaExecutor.create(calExpr);
                Map<String, Object> quoteSignValueMap = priceFormulaExecutor.calculate(valueMap);
                int seq = quotePolicyParam.getQccInfo().getLEFTIDFIELDS().size();
                for (QuoteCalcFormulaInfo quoteCalcFormulaInfo4 : formulaInfoList) {
                    String quoteSign = quoteCalcFormulaInfo4.getQuotesign();
                    if (StringUtils.isBlank((String)quoteSign)) continue;
                    Object result = quoteSignValueMap.get(quoteSign);
                    String formula = quoteCalcFormulaInfo4.getFormula();
                    Object factorResult = valueMap.get(formula);
                    if (factorResult != null) {
                        result = factorResult;
                    }
                    obj[seq] = result;
                    ++seq;
                }
                calResultList.add(obj);
                DecimalFormat df10 = new DecimalFormat("0.0000000000");
                for (QuoteSchemeGroupInfo quoteSchemeGroupInfo : schemeGroupInfoList) {
                    String number = quoteSchemeGroupInfo.getNumber();
                    AdvancedPricingProInfo.CalFactor factorEntry = AdvancedPricingProInfo.createCalFactor();
                    factorEntry.setQuoteSchemeGroup(quoteSchemeGroupInfo.getId());
                    factorEntry.setQuoteSuccess("1");
                    factorEntry.setRequired(quoteSchemeGroupInfo.isRequire());
                    Optional<Object> configureOp = Optional.ofNullable(quoteSchemeGroupInfo.getFeatureResult().get(mainKey));
                    if (valueMap.get(number) != null) {
                        factorEntry.setPrice((BigDecimal)valueMap.get(number));
                        factorEntry.setResult(df10.format(valueMap.get(number)));
                    }
                    if (configureOp.isPresent()) {
                        factorEntry.setConfiguredValue(configureOp.get().toString());
                        List<FeatureValueInfo> featureValueInfos = quoteSchemeGroupInfo.getFeatureValueResult().get(mainKey);
                        if (featureValueInfos == null || featureValueInfos.size() <= 0) continue;
                        logger.info(new StringBuffer("\u65b9\u6848\u7ec4").append(quoteSchemeGroupInfo.getNumber()).append("\u7279\u5f81\u503c\u4e2a\u6570=").append(featureValueInfos.size()).toString());
                        int featureValueSeq = 0;
                        for (FeatureValueInfo featureValueInfo : featureValueInfos) {
                            AdvancedPricingProInfo.CalFactor factorEntry_sub = factorEntry.copy();
                            factorEntry_sub.setConfiguredValue(featureValueInfo.getFeatureValue());
                            logger.info("\u7b2c" + ++featureValueSeq + "\u4e2a\u7279\u5f81\u503c" + featureValueInfo.getFeatureValue() + featureValueInfo.getFeatureValue());
                            factorEntry_sub.setPrice(featureValueInfo.getValue());
                            if (featureValueInfo.getValue() != null) {
                                factorEntry_sub.setResult(df10.format(featureValueInfo.getValue()));
                            }
                            pricingProInfo.getCalFactorList().add(factorEntry_sub);
                        }
                        continue;
                    }
                    logger.info(new StringBuffer("\u65b9\u6848\u7ec4").append(quoteSchemeGroupInfo.getNumber()).append("\u8be5\u884c\u4e0d\u5177\u5907\u7279\u5f81\u503c").toString());
                    pricingProInfo.getCalFactorList().add(factorEntry);
                }
                for (QuoteCalcFormulaInfo quoteCalcFormulaInfo5 : formulaInfoList) {
                    String formula = quoteCalcFormulaInfo5.getFormula();
                    String quoteSign = quoteCalcFormulaInfo5.getQuotesign();
                    DynamicObject processFactor = quoteCalcFormulaInfo5.getProcessfactor();
                    AdvancedPricingProInfo.CalFormula formulaEntry = AdvancedPricingProInfo.createCalFormula();
                    formulaEntry.setFormula(formula);
                    formulaEntry.setFormulaDes(quoteCalcFormulaInfo5.getFormulaEntry().getString("formulades"));
                    formulaEntry.setProcessFactor(processFactor != null ? Long.valueOf(processFactor.getLong("id")) : null);
                    formulaEntry.setQuoteSign(quoteSign);
                    formulaEntry.setQuoteSignName(quoteCalcFormulaInfo5.getFormulaEntry().getString("quotesignname"));
                    formulaEntry.setFormulaDescription(quoteCalcFormulaInfo5.getFormulaEntry().getString("formuladescription"));
                    if (StringUtils.isNotEmpty((String)quoteSign) && quoteSignValueMap.get(quoteSign) != null) {
                        Object priceResult = quoteSignValueMap.get(quoteSign);
                        Object factorResult = valueMap.get(formula);
                        if (factorResult != null) {
                            priceResult = factorResult;
                        }
                        formulaEntry.setPriceResult((BigDecimal)priceResult);
                        if (priceResult != null) {
                            formulaEntry.setCalResult(df10.format(priceResult));
                        }
                    } else if (processFactor != null && valueMap.get(processFactor.getString("number")) != null) {
                        formulaEntry.setPriceResult((BigDecimal)valueMap.get(processFactor.getString("number")));
                        if (valueMap.get(processFactor.getString("number")) != null) {
                            formulaEntry.setCalResult(df10.format(valueMap.get(processFactor.getString("number"))));
                        }
                    }
                    pricingProInfo.getCalFormulaList().add(formulaEntry);
                }
                logProxy.getPriceProcessMap().put(mainKey, pricingProInfo);
            }
            logger.info("\u9ad8\u7ea7\u5b9a\u4ef7\u8ba1\u7b97\u6210\u529f\u3002");
            DataSet resultSet = Algo.create((String)this.getClass().getName()).createDataSet(calResultList.iterator(), rowMeta);
            if (!DataSetHelper.isIncludeField("quotesrcbill", resultSet)) {
                resultSet = resultSet.addNullField("quotesrcbill");
            }
            if (!DataSetHelper.isIncludeField("quotesrcno", resultSet)) {
                String priceSourceMessage = ResManager.loadKDString((String)"\u5b9a\u4ef7\u8fc7\u7a0b", (String)"CalcProcessStep_0", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]);
                resultSet = resultSet.addField(DataSetHelper.getDataSetValue(priceSourceMessage), "quotesrcno");
            }
            if (!DataSetHelper.isIncludeField("quotesrcseq", resultSet)) {
                resultSet = resultSet.addNullField("quotesrcseq");
            }
            quotePolicyParam.setResultSet(resultSet);
            String terminateField = PriceHelper.getLeftName(quoteCalcInfo.getTerminationSignX());
            Field terminateFieldF = resultSet.getRowMeta().getField(terminateField, false);
            if (terminateFieldF == null) {
                String errorMsg = ResManager.loadKDString((String)"\u8ba1\u7b97\u7b56\u7565\u201c%1$s\u201d\u5bf9\u5e94\u7684\u53d6\u5230\u4ef7\u683c\u7ec8\u6b62\u5b57\u6bb5\u672a\u8fd4\u56de\u3002", (String)"CalcProcessStep_1", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]);
                throw new KDBizException(String.format(errorMsg, quoteCalcInfo.getName()));
            }
            String filterStr_r = new StringBuffer(terminateField).append(" is not null").toString();
            DataSet logDataSet = resultSet.copy().where(filterStr_r);
            Object object = null;
            try {
                logProxy.addMatchAllPriceCache(quoteCalcInfo.getId(), logDataSet, false, LogClassEnum.CALSTRATEGE);
                logProxy.addShootSourceCache(logDataSet);
                logProxy.shootPriceCache(logDataSet, quoteCalcInfo.getId(), quotePolicyParam.getQccInfo(), LogClassEnum.CALSTRATEGE);
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (logDataSet != null) {
                    if (object != null) {
                        try {
                            logDataSet.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        logDataSet.close();
                    }
                }
            }
        }
    }
}

