/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.pricemodel.business.service.quote.step.calc;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.mpscmm.msbd.pricemodel.business.helper.quote.QuoteHelper;
import kd.mpscmm.msbd.pricemodel.business.pojo.PriceEntityKeyInfo;
import kd.mpscmm.msbd.pricemodel.business.pojo.quote.QuoteParam;
import kd.mpscmm.msbd.pricemodel.business.pojo.quote.QuotePolicyParam;
import kd.mpscmm.msbd.pricemodel.business.pojo.quote.QuoteSchemeColl;
import kd.mpscmm.msbd.pricemodel.business.pojo.quote.QuoteStrategeColl;
import kd.mpscmm.msbd.pricemodel.business.pojo.quote.calc.QuoteCalcInfo;
import kd.mpscmm.msbd.pricemodel.business.pojo.quote.calc.QuoteSchemeGroupInfo;
import kd.mpscmm.msbd.pricemodel.business.service.quote.QuoteSchemeGroupEngine;
import kd.mpscmm.msbd.pricemodel.business.service.quote.log.QuoteInnerLogProxy;
import kd.mpscmm.msbd.pricemodel.business.service.quote.log.QuoteLogProxy;
import kd.mpscmm.msbd.pricemodel.business.service.quote.step.calc.CalcStep;
import kd.mpscmm.msbd.pricemodel.common.enums.quote.PriceSourceEnum;

public class CalcScheGrpStep
extends CalcStep {
    private static final Log logger = LogFactory.getLog(CalcScheGrpStep.class);

    @Override
    public void excute(QuotePolicyParam quotePolicyParam, QuoteCalcInfo quoteCalcInfo, QuoteLogProxy logProxy) {
        HashMap priceAllMap = new HashMap();
        HashMap keyRelatition = new HashMap();
        quoteCalcInfo.getSchemeGroupInfos().forEach(quoteSchemeGroupInfo -> {
            if (PriceSourceEnum.SCHEME.getValue().equals(quoteSchemeGroupInfo.getPriceSource()) && quoteSchemeGroupInfo.getQuoteSchemeInfos().size() != 0) {
                DynamicObject quoteStratege = quoteSchemeGroupInfo.getQuoteStratege();
                QuoteStrategeColl quoteStrategeColl = new QuoteStrategeColl(quoteCalcInfo.getQuoteType());
                quoteStrategeColl.getSchemeCollMapping().put(quoteStratege.getPkValue(), (QuoteSchemeColl)quoteSchemeGroupInfo);
                quoteStrategeColl.getQuoteStrateges().add(quoteStratege);
                PriceEntityKeyInfo qccInfo = QuoteHelper.getQuoteCommonConst(quoteCalcInfo.getQuoteType(), quoteStrategeColl);
                QuoteParam param = new QuoteParam(quotePolicyParam.getQuoteDataSet().copy(), quotePolicyParam.getQuoteOrgID(), qccInfo, quoteCalcInfo.getQuoteType());
                param.getOtherParam().putAll(quotePolicyParam.getOtherParam());
                param.getOtherParam().put("SCHEMEGROUP", quoteSchemeGroupInfo);
                try (QuoteInnerLogProxy innerLogProxy = new QuoteInnerLogProxy(logProxy.isOpen(), quotePolicyParam.getQuoteOrgID(), quotePolicyParam.getEntityType(), qccInfo, quoteStrategeColl, quoteStratege);){
                    innerLogProxy.initLogInfo(quoteCalcInfo, (QuoteSchemeGroupInfo)quoteSchemeGroupInfo, logProxy.isAuto());
                    try {
                        QuoteSchemeGroupEngine engine = new QuoteSchemeGroupEngine(innerLogProxy);
                        Map<String, Object> priceMap = engine.startQuote(quoteStrategeColl, quoteStratege, param);
                        priceAllMap.putAll(priceMap);
                    }
                    catch (KDBizException e) {
                        logProxy.setCancle(true);
                        throw e;
                    }
                    catch (Exception e1) {
                        logProxy.setCancle(true);
                        throw e1;
                    }
                }
                if (param.getOtherParam().get("KEYRELATIONGROUP") != null) {
                    Map keyRelatition4Group = (Map)param.getOtherParam().get("KEYRELATIONGROUP");
                    keyRelatition4Group.forEach((k, v) -> {
                        List keyRelatitionList = keyRelatition.computeIfAbsent(k, s -> new ArrayList());
                        keyRelatitionList.addAll(v);
                    });
                }
            }
        });
        quotePolicyParam.getOtherParam().put("KEYRELATION", keyRelatition);
        quoteCalcInfo.getAddResult().putAll(priceAllMap);
    }
}

