/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.pricemodel.formplugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.base.BaseShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.botp.BillTreeBuildParameter;
import kd.bos.designer.botp.EntityParseHelper;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.BigIntProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.property.MasterBasedataProp;
import kd.bos.entity.property.MaterielProp;
import kd.bos.entity.property.PriceProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.treebuilder.FormTreeBuilder;
import kd.bos.metadata.treebuilder.PropTreeBuildOption;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.mpscmm.msbd.pricemodel.business.helper.DataSetHelper;
import kd.mpscmm.msbd.pricemodel.business.helper.LicenseHelper;
import kd.mpscmm.msbd.pricemodel.business.helper.quote.QuoteOtherHelper;

public class PriceControlSchemePlugin
extends AbstractBasePlugIn {
    private static final Log log = LogFactory.getLog(PriceControlSchemePlugin.class);
    private static final String FORMID_SELECTFIELD = "botp_selectfield";
    private static final String SOURCETREENODES = "treenodes";
    private static final String[] MATCHFIELDS = new String[]{"controlsource", "controlentity", "controlsource", "controlentity", "controlsource", "controlentity"};
    private static final List<String> SELECTFIELDS = Arrays.asList("sourcesign", "controlsign", "sourcecomp", "controlcomp", "sortsign");
    public static Map<String, String> pairFieldMap = new HashMap<String, String>();
    private static final String CHANGESOURCEBILL = "changesourcebill";
    private static final String CHANGEQUOTEBILL = "changequotebill";

    public void preOpenForm(PreOpenFormEventArgs e) {
        String formId;
        String appId;
        Map<String, Object> result;
        super.preOpenForm(e);
        if (e.getFormShowParameter() != null && Boolean.TRUE.equals((result = LicenseHelper.checkLicense(appId = e.getFormShowParameter().getServiceAppId(), formId = ((BaseShowParameter)e.getSource()).getFormId())).get("isCancel"))) {
            e.setCancelMessage((String)result.get("cancelMessage"));
            e.setCancel(true);
            return;
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"sourcesignname"});
        this.addClickListeners(new String[]{"controlsignname"});
        this.addClickListeners(new String[]{"sourcecompname"});
        this.addClickListeners(new String[]{"controlcompname"});
        this.addClickListeners(new String[]{"sortsignname"});
        this.addItemClickListeners(new String[]{"advcontoolbarap", "advcontoolbarapc"});
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        boolean a = true;
        boolean b = false;
        this.getModel().beginInit();
        this.getModel().setValue("enablematch", (Object)a);
        this.getModel().setValue("enablematchc", (Object)a);
        this.getModel().endInit();
        this.getModel().setDataChanged(b);
        ComboEdit orderEdit = (ComboEdit)this.getControl("order");
        orderEdit.setMustInput(a);
        this.getView().setEnable(Boolean.valueOf(b), new String[]{"use"});
        if (Boolean.TRUE.equals(this.getModel().getValue("ispreset"))) {
            this.getView().setEnable(Boolean.valueOf(b), new String[]{"bar_unaudit"});
        }
        AtomicBoolean change = new AtomicBoolean(false);
        QuoteOtherHelper.loadCaption(this.getModel(), "controlentity", "mappingentry", "controlsign", "controlsignname", change);
        QuoteOtherHelper.loadCaption(this.getModel(), "controlsource", "mappingentry", "sourcesign", "sourcesignname", change);
        QuoteOtherHelper.loadCaption(this.getModel(), "controlentity", "compareentry", "controlcomp", "controlcompname", change);
        QuoteOtherHelper.loadCaption(this.getModel(), "controlsource", "compareentry", "sourcecomp", "sourcecompname", change);
        if (change.get()) {
            this.getModel().setDataChanged(false);
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getModel().setValue("org", (Object)RequestContext.get().getOrgId());
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control c = (Control)evt.getSource();
        if ("sourcesignname".equalsIgnoreCase(c.getKey())) {
            this.showBillTree(0, "sourcesign");
        }
        if ("controlsignname".equalsIgnoreCase(c.getKey())) {
            this.showBillTree(1, "controlsign");
        }
        if ("sourcecompname".equalsIgnoreCase(c.getKey())) {
            this.showSimpleBillTree(0, "sourcecomp");
        }
        if ("controlcompname".equalsIgnoreCase(c.getKey())) {
            this.showSimpleBillTree(1, "controlcomp");
        }
        if ("sortsignname".equalsIgnoreCase(c.getKey())) {
            this.showSimpleBillTree(4, "sortsign");
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String barItemKey = evt.getItemKey();
        if (barItemKey.equalsIgnoreCase("btnautomatch")) {
            this.autoMatchFields("mappingentry", "sourcesign", "controlsign", "controlsignname");
        } else if (barItemKey.equalsIgnoreCase("btnautomatchc")) {
            this.autoMatchFields("compareentry", "sourcecomp", "controlcomp", "controlcompname");
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        Object oldValue = e.getChangeSet()[0].getOldValue();
        int row = e.getChangeSet()[0].getRowIndex();
        switch (key) {
            case "controlsource": {
                DynamicObject sourceEntity = (DynamicObject)oldValue;
                if (oldValue == null) break;
                this.getPageCache().put("pricesourceentityOldValue", sourceEntity.get("number").toString());
                this.confirmSourceChange();
                break;
            }
            case "controlentity": {
                DynamicObject controlEntity = (DynamicObject)oldValue;
                if (oldValue == null) break;
                this.getPageCache().put("priceQuoteOldValue", controlEntity.get("number").toString());
                this.confirmControlChange();
                break;
            }
            case "sourcesignname": {
                if (newValue == null || !StringUtils.isEmpty((CharSequence)newValue.toString())) break;
                this.getModel().setValue("sourcesign", null, row);
                break;
            }
            case "controlsignname": {
                if (newValue == null || !StringUtils.isEmpty((CharSequence)newValue.toString())) break;
                this.getModel().setValue("controlsign", null, row);
                break;
            }
            case "sourcecompname": {
                if (newValue == null || !StringUtils.isEmpty((CharSequence)newValue.toString())) break;
                this.getModel().setValue("sourcecomp", null, row);
                break;
            }
            case "controlcompname": {
                if (newValue == null || !StringUtils.isEmpty((CharSequence)newValue.toString())) break;
                this.getModel().setValue("controlcomp", null, row);
                break;
            }
            case "sortsignname": {
                if (newValue == null || !StringUtils.isBlank((CharSequence)newValue.toString())) break;
                this.getModel().setValue("sortsign", null, row);
                this.getModel().setValue("sortsignname", null, row);
                break;
            }
            case "enablematch": 
            case "enablematchc": {
                this.getModel().setDataChanged(false);
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        String key;
        super.confirmCallBack(evt);
        switch (key = evt.getCallBackId()) {
            case "changesourcebill": {
                if ("Yes".equals(evt.getResultValue())) {
                    DynamicObjectCollection mappingEntrys = this.getModel().getEntryEntity("mappingentry");
                    for (int i = 0; i < mappingEntrys.size(); ++i) {
                        ((DynamicObject)mappingEntrys.get(i)).set("sourcesign", null);
                        ((DynamicObject)mappingEntrys.get(i)).set("sourcesignname", null);
                    }
                    DynamicObjectCollection compareEntrys = this.getModel().getEntryEntity("compareentry");
                    for (int i = 0; i < compareEntrys.size(); ++i) {
                        ((DynamicObject)compareEntrys.get(i)).set("sourcecomp", null);
                        ((DynamicObject)compareEntrys.get(i)).set("sourcecompname", null);
                    }
                    this.getView().updateView("mappingentry");
                    this.getView().updateView("compareentry");
                    this.getModel().deleteEntryData("controlsortentry");
                    this.getModel().createNewEntryRow("controlsortentry");
                    break;
                }
                String pricesourceentityOldValue = this.getPageCache().get("pricesourceentityOldValue");
                this.getModel().beginInit();
                this.getModel().setValue("controlsource", (Object)pricesourceentityOldValue);
                this.getModel().endInit();
                this.getView().updateView("controlsource");
                break;
            }
            case "changequotebill": {
                if ("Yes".equals(evt.getResultValue())) {
                    DynamicObjectCollection mappingEntrys = this.getModel().getEntryEntity("mappingentry");
                    for (int i = 0; i < mappingEntrys.size(); ++i) {
                        ((DynamicObject)mappingEntrys.get(i)).set("controlsign", null);
                        ((DynamicObject)mappingEntrys.get(i)).set("controlsignname", null);
                    }
                    DynamicObjectCollection compareEntrys = this.getModel().getEntryEntity("compareentry");
                    for (int i = 0; i < compareEntrys.size(); ++i) {
                        ((DynamicObject)compareEntrys.get(i)).set("controlcomp", null);
                        ((DynamicObject)compareEntrys.get(i)).set("controlcompname", null);
                    }
                    this.getView().updateView("mappingentry");
                    this.getView().updateView("compareentry");
                    break;
                }
                String pricequoteOldValue = this.getPageCache().get("priceQuoteOldValue");
                this.getModel().beginInit();
                this.getModel().setValue("controlentity", (Object)pricequoteOldValue);
                this.getModel().endInit();
                this.getView().updateView("controlentity");
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        String actionId = e.getActionId();
        Object returnData = e.getReturnData();
        if (StringUtils.isEmpty((CharSequence)actionId) || returnData == null) {
            return;
        }
        if (returnData instanceof String) {
            String returnDataStr = (String)returnData;
            String[] returnDataArray = returnDataStr.split("\\.");
            DynamicObject controlSourceType = (DynamicObject)this.getModel().getValue("controlsource");
            DynamicObject controlType = (DynamicObject)this.getModel().getValue("controlentity");
            if (returnDataArray != null && returnDataArray.length > 0) {
                if (controlSourceType != null && controlSourceType.get("id").equals(returnDataArray[returnDataArray.length - 1])) {
                    returnData = "id";
                } else if ("billhead".equals(returnDataArray[returnDataArray.length - 1])) {
                    returnData = "id";
                } else if (controlType != null && controlType.get("id").equals(returnDataArray[returnDataArray.length - 1])) {
                    returnData = "id";
                }
            }
        }
        if (SELECTFIELDS.indexOf(actionId) >= 0) {
            this.setCallBackResult(returnData, actionId);
        }
    }

    private void showSimpleBillTree(int index, String clickSign) {
        DynamicObject bill = (DynamicObject)this.getModel().getValue(MATCHFIELDS[index]);
        if ("controlsource".equals(MATCHFIELDS[index])) {
            if (bill == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u9650\u4ef7\u6765\u6e90\u5355\u636e\u3002", (String)"PriceControlSchemePlugin_0", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]));
                return;
            }
        } else if (bill == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u9650\u4ef7\u5355\u636e\u3002", (String)"PriceControlSchemePlugin_1", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]));
            return;
        }
        String number = bill.getString("number");
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)number);
        Map allFields = dataEntityType.getAllFields();
        ArrayList sortFieldsList = new ArrayList();
        ArrayList sortEntryFieldsList = new ArrayList();
        allFields.forEach((k, v) -> {
            if (this.isShowField((IDataEntityProperty)v, index)) {
                String parentName = v.getParent().getName();
                if (!number.equals(parentName) && !parentName.contains("lk")) {
                    String[] entryFields = new String[2];
                    String sourceSign = parentName.concat(".").concat(v.getName());
                    String sourceSignName = v.getParent().getDisplayName().getLocaleValue().concat(".").concat(v.getDisplayName().getLocaleValue());
                    log.info("\u5b57\u6bb5\u5168\u8def\u5f84===" + sourceSignName);
                    String sourceSignName_origin = EntityParseHelper.buildPropFullCaption((EntityType)dataEntityType, (String)sourceSign);
                    log.info("\u5b57\u6bb5\u539f\u59cb\u5168\u8def\u5f84===" + sourceSignName_origin);
                    entryFields[0] = sourceSign;
                    entryFields[1] = sourceSignName;
                    sortEntryFieldsList.add(entryFields);
                } else {
                    String[] fields = new String[2];
                    String sourceSign = v.getName();
                    String sourceSignName = v.getDisplayName().getLocaleValue();
                    log.info("\u5b57\u6bb5\u5168\u8def\u5f84===" + sourceSignName);
                    String sourceSignName_origin = EntityParseHelper.buildPropFullCaption((EntityType)dataEntityType, (String)sourceSign);
                    log.info("\u5b57\u6bb5\u539f\u59cb\u5168\u8def\u5f84===" + sourceSignName_origin);
                    fields[0] = sourceSign;
                    fields[1] = sourceSignName;
                    sortFieldsList.add(fields);
                }
            }
        });
        ArrayList<String[]> allSortFieldsList = new ArrayList<String[]>(sortFieldsList.size() + sortEntryFieldsList.size());
        allSortFieldsList.addAll(sortFieldsList);
        allSortFieldsList.addAll(sortEntryFieldsList);
        if (allSortFieldsList.size() != 0) {
            this.buildSimpleFieldsTree(allSortFieldsList, index, clickSign);
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u53ef\u9009\u62e9\u7684\u5b57\u6bb5\uff1a\u5b57\u6bb5\u5fc5\u987b\u662f\u6570\u503c\u578b\u6216\u65e5\u671f\u578b\u3002", (String)"PriceControlSchemePlugin_2", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]));
        }
    }

    private void buildSimpleFieldsTree(List<String[]> allSortFieldsList, int index, String clickSign) {
        DynamicObject priceSource = (DynamicObject)this.getModel().getValue(MATCHFIELDS[index]);
        String rootName = priceSource.getString("name");
        String rootNumber = priceSource.getString("number");
        TreeNode root = new TreeNode();
        root.setId(rootNumber);
        root.setText(rootName);
        ArrayList<String> entryNumbers = new ArrayList<String>();
        for (String[] sortFields : allSortFieldsList) {
            TreeNode grandSon;
            TreeNode child;
            String nodeNumber = sortFields[0];
            String nodeName = sortFields[1];
            String[] splitNumber = nodeNumber.split("\\.");
            if (splitNumber.length == 1) {
                TreeNode child2 = new TreeNode();
                child2.setText(nodeName);
                child2.setId(nodeNumber);
                root.addChild(child2);
                continue;
            }
            if (splitNumber.length <= 1) continue;
            String[] splitName = nodeName.split("\\.");
            if (entryNumbers.contains(splitNumber[0])) {
                child = root.getTreeNodeByText(splitName[0], 1);
                grandSon = new TreeNode();
                grandSon.setId(splitNumber[1]);
                grandSon.setText(splitName[1]);
                child.addChild(grandSon);
                continue;
            }
            child = new TreeNode();
            child.setText(splitName[0]);
            child.setId(splitNumber[0]);
            root.addChild(child);
            grandSon = new TreeNode();
            grandSon.setId(splitNumber[1]);
            grandSon.setText(splitName[1]);
            child.addChild(grandSon);
            entryNumbers.add(splitNumber[0]);
        }
        root.setIsOpened(true);
        if (root.getChildren() == null) {
            return;
        }
        this.showSrcFieldForm(root, clickSign);
    }

    public void showBillTree(int index, String clickSign) {
        TreeNode treeNode;
        Boolean enablematch = (Boolean)this.getModel().getValue("enablematch");
        String entryName = "mappingentry";
        DynamicObject bill = (DynamicObject)this.getModel().getValue(MATCHFIELDS[index]);
        if ("controlsource".equals(MATCHFIELDS[index])) {
            if (bill == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u9650\u4ef7\u6765\u6e90\u5355\u636e\u3002", (String)"PriceControlSchemePlugin_0", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]));
                return;
            }
        } else if (bill == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u9650\u4ef7\u5355\u636e\u3002", (String)"PriceControlSchemePlugin_1", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]));
            return;
        }
        DynamicObject sourceBillInfo = (DynamicObject)this.getModel().getValue(MATCHFIELDS[index]);
        String sourceNumber = sourceBillInfo.getString("number");
        MainEntityType sourceEntityType = MetadataServiceHelper.getDataEntityType((String)sourceNumber);
        DynamicObject targetBillInfo = (DynamicObject)this.getModel().getValue(MATCHFIELDS[index + 1]);
        String targetFieldValue = null;
        MainEntityType targetEntityType = null;
        if (targetBillInfo != null) {
            String targetNumber = targetBillInfo.getString("number");
            targetEntityType = MetadataServiceHelper.getDataEntityType((String)targetNumber);
            int row = this.getModel().getEntryCurrentRowIndex(entryName);
            targetFieldValue = (String)this.getModel().getValue(pairFieldMap.get(clickSign), row);
        }
        boolean includePKField = true;
        if (StringUtils.isEmpty((CharSequence)sourceEntityType.getAlias())) {
            includePKField = false;
        }
        if (targetFieldValue == null || "".equals(targetFieldValue)) {
            PropTreeBuildOption option = new PropTreeBuildOption();
            option.setIncludePKField(includePKField);
            option.setOnlyPhysicsField(false);
            treeNode = FormTreeBuilder.buildDynamicPropertyTree((MainEntityType)sourceEntityType, (PropTreeBuildOption)option);
        } else {
            IDataEntityProperty targetProperty = DataSetHelper.findPropertys((EntityType)targetEntityType, targetFieldValue = this.subEntryField(targetFieldValue, targetEntityType));
            if (targetProperty == null) {
                PropTreeBuildOption option = new PropTreeBuildOption();
                option.setIncludePKField(includePKField);
                option.setOnlyPhysicsField(false);
                treeNode = FormTreeBuilder.buildDynamicPropertyTree((MainEntityType)sourceEntityType, (PropTreeBuildOption)option);
            } else if (enablematch.booleanValue()) {
                BillTreeBuildParameter parameter = new BillTreeBuildParameter(sourceEntityType, null, targetProperty);
                parameter.setIncludePKField(includePKField);
                parameter.setOnlyPhysicsField(false);
                if (targetProperty instanceof LongProp) {
                    PropTreeBuildOption option = new PropTreeBuildOption(null, LongProp.class);
                    option.addMatchedClassTypes(BigIntProp.class);
                    option.setOnlyPhysicsField(false);
                    option.setIncludePKField(includePKField);
                    treeNode = FormTreeBuilder.buildDynamicPropertyTree((MainEntityType)sourceEntityType, (PropTreeBuildOption)option);
                } else {
                    treeNode = EntityParseHelper.buildBillTreeNodes((BillTreeBuildParameter)parameter);
                }
            } else {
                PropTreeBuildOption option = new PropTreeBuildOption();
                option.setIncludePKField(includePKField);
                option.setOnlyPhysicsField(false);
                treeNode = FormTreeBuilder.buildDynamicPropertyTree((MainEntityType)sourceEntityType, (PropTreeBuildOption)option);
            }
        }
        this.removeIDNodeFromTree(treeNode, sourceEntityType);
        this.showSrcFieldForm(treeNode, clickSign);
    }

    private void showSrcFieldForm(TreeNode billNode, String clickSign) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(FORMID_SELECTFIELD);
        String nodesJson = SerializationUtils.toJsonString((Object)billNode);
        showParameter.getCustomParams().put(SOURCETREENODES, nodesJson);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, clickSign));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    private void setCallBackResult(Object returnData, String actionID) {
        int index = SELECTFIELDS.indexOf(actionID);
        String fieldId = returnData.toString();
        Object srcBill = this.getModel().getValue(MATCHFIELDS[index]);
        String srcBillId = (String)((DynamicObject)srcBill).getPkValue();
        MainEntityType srcBillMainType = MetadataServiceHelper.getDataEntityType((String)srcBillId);
        String fieldCaption = EntityParseHelper.buildPropFullCaption((EntityType)srcBillMainType, (String)fieldId);
        String[] split = fieldId.split("\\.");
        String tempFieldId = split[0];
        IDataEntityProperty findProperty = srcBillMainType.findProperty(tempFieldId);
        if (findProperty != null) {
            String parentName = findProperty.getParent().getName();
            fieldId = this.getEntryFullField(srcBillMainType, fieldId, srcBillId, parentName);
        }
        String[] fieldIds = fieldId.split("\\.");
        String entryName = ((IDataEntityProperty)this.getModel().getDataEntityType().getAllFields().get(actionID)).getParent().getName();
        int row = this.getModel().getEntryCurrentRowIndex(entryName);
        if ((index == 0 || index == 1) && fieldIds != null && fieldIds.length > 4) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5c0f\u4e8e\u56db\u7ea7\u7684\u5b57\u6bb5\u3002", (String)"PriceControlSchemePlugin_3", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]));
        }
        this.getModel().setValue(actionID, (Object)fieldId, row);
        this.getModel().setValue(actionID + "name", (Object)fieldCaption, row);
    }

    public void autoMatchFields(String entry, String sourceSign, String controlSign, String controlSignName) {
        DynamicObject source = (DynamicObject)this.getModel().getValue("controlsource");
        DynamicObject target = (DynamicObject)this.getModel().getValue("controlentity");
        if (source == null || target == null) {
            return;
        }
        String sourceNumber = source.getString("number");
        String targetNumber = target.getString("number");
        MainEntityType srcMainType = EntityMetadataCache.getDataEntityType((String)sourceNumber);
        MainEntityType tgtMainType = EntityMetadataCache.getDataEntityType((String)targetNumber);
        int rowCount = this.getModel().getEntryRowCount(entry);
        for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
            String targetFieldKey;
            String sourceFieldKey = (String)this.getModel().getValue(sourceSign, rowIndex);
            if (StringUtils.isBlank((CharSequence)sourceFieldKey) || StringUtils.isNotBlank((CharSequence)(targetFieldKey = (String)this.getModel().getValue(controlSign, rowIndex)))) continue;
            String[] split = sourceFieldKey.split("\\.");
            String tempSourceFieldKey = sourceFieldKey;
            if (split.length > 1) {
                tempSourceFieldKey = split[1];
            }
            DynamicProperty sourceField = (DynamicProperty)srcMainType.findProperty(tempSourceFieldKey);
            DynamicProperty targetField = (DynamicProperty)tgtMainType.findProperty(tempSourceFieldKey);
            if (tempSourceFieldKey.endsWith("id") && targetField == null) {
                tempSourceFieldKey = tempSourceFieldKey.substring(0, tempSourceFieldKey.length() - 2);
                targetField = (DynamicProperty)tgtMainType.findProperty(tempSourceFieldKey);
            }
            if (targetField == null || !targetField.getClass().isInstance(sourceField) || !StringUtils.isNotBlank((CharSequence)sourceField.getAlias())) continue;
            String fieldId = targetField.getName();
            IDataEntityProperty findProperty = tgtMainType.findProperty(fieldId);
            if (findProperty != null) {
                String parentName = findProperty.getParent().getName();
                fieldId = this.getEntryFullField(tgtMainType, fieldId, targetNumber, parentName);
            }
            String targetFieldName = EntityParseHelper.buildPropFullCaption((IDataEntityProperty)targetField);
            this.getModel().setValue(controlSign, (Object)fieldId, rowIndex);
            this.getModel().setValue(controlSignName, (Object)targetFieldName, rowIndex);
        }
    }

    private String subEntryField(String fieldKey, MainEntityType mainType) {
        IDataEntityProperty tempProperty;
        if (mainType == null) {
            return fieldKey;
        }
        String[] split = fieldKey.split("\\.");
        if (split.length > 1 && (tempProperty = mainType.findProperty(split[0])) instanceof EntryProp) {
            ArrayList<String> list = new ArrayList<String>(split.length);
            for (int i = 0; i < split.length; ++i) {
                list.add(split[i]);
            }
            list.remove(0);
            fieldKey = StringUtils.join((Object[])list.toArray(), (String)".");
        }
        return fieldKey;
    }

    private void removeIDNodeFromTree(TreeNode treeNode, MainEntityType entityType) {
        if (treeNode.getChildren() != null && treeNode.getChildren().size() > 0) {
            int size = treeNode.getChildren().size();
            for (int i = size - 1; i >= 0; --i) {
                IDataEntityProperty parentProperty;
                TreeNode childNode = (TreeNode)treeNode.getChildren().get(i);
                if (childNode.getId().endsWith(".id") && !((parentProperty = DataSetHelper.findPropertys((EntityType)entityType, childNode.getParentid())) instanceof EntryProp)) {
                    treeNode.getChildren().remove(i);
                    continue;
                }
                IDataEntityProperty property = DataSetHelper.findPropertys((EntityType)entityType, childNode.getId());
                if (property instanceof MaterielProp) {
                    String materialExtraName;
                    String baseEntityId = ((MaterielProp)property).getBaseEntityId();
                    if ("bd_materialinventoryinfo".equals(baseEntityId) || "bd_materialpurchaseinfo".equals(baseEntityId) || "bd_materialsalinfo".equals(baseEntityId)) {
                        MainEntityType materialEntity = MetadataServiceHelper.getDataEntityType((String)baseEntityId);
                        materialExtraName = "(" + materialEntity.getDisplayName().toString() + ")";
                        childNode.setText(childNode.getText() + materialExtraName);
                        int subSize = childNode.getChildren().size();
                        String parentID = childNode.getId();
                        for (int j = subSize - 1; j >= 0; --j) {
                            String subBaseEntityId;
                            TreeNode subChildNode = (TreeNode)childNode.getChildren().get(j);
                            if ((parentID + ".number").equals(subChildNode.getId())) {
                                childNode.getChildren().remove(j);
                            } else if ((parentID + ".name").equals(subChildNode.getId())) {
                                childNode.getChildren().remove(j);
                            } else if ((parentID + ".id").equals(subChildNode.getId())) {
                                childNode.getChildren().remove(j);
                            }
                            IDataEntityProperty subProperty = DataSetHelper.findPropertys((EntityType)entityType, subChildNode.getId());
                            if (!(subProperty instanceof MasterBasedataProp) || !"bd_material".equals(subBaseEntityId = ((MasterBasedataProp)subProperty).getBaseEntityId())) continue;
                            String subMaterialExtraName = ResManager.loadKDString((String)"\u7269\u6599\u4e3b\u6570\u636e", (String)"PriceControlSchemePlugin_4", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]);
                            subChildNode.setText(subChildNode.getText() + "(" + subMaterialExtraName + ")");
                        }
                        this.removeIDNodeFromTree(childNode, entityType);
                        continue;
                    }
                    if (!"bd_material".equals(baseEntityId)) continue;
                    String subMaterialExtraName = ResManager.loadKDString((String)"\u7269\u6599\u4e3b\u6570\u636e", (String)"PriceControlSchemePlugin_4", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]);
                    materialExtraName = "(" + subMaterialExtraName + ")";
                    childNode.setText(childNode.getText() + materialExtraName);
                    this.removeIDNodeFromTree(childNode, entityType);
                    continue;
                }
                this.removeIDNodeFromTree(childNode, entityType);
            }
        }
    }

    private String getEntryFullField(MainEntityType tgtMainType, String fieldId, String srcBillId, String parentName) {
        while (!srcBillId.equals(parentName)) {
            fieldId = parentName.concat(".").concat(fieldId);
            IDataEntityProperty parentProp = tgtMainType.findProperty(parentName);
            if (parentProp.getParent() == null) break;
            parentName = parentProp.getParent().getName();
        }
        return fieldId;
    }

    private void confirmSourceChange() {
        DynamicObjectCollection mappingEntry = this.getModel().getEntryEntity("mappingentry");
        DynamicObjectCollection compareEntry = this.getModel().getEntryEntity("compareentry");
        if (mappingEntry.size() > 0 && this.confirmMappingField("mappingentry", "sourcesign", "controlsign") != false || compareEntry.size() > 0 && this.confirmMappingField("compareentry", "sourcecomp", "controlcomp") != false || this.getModel().getEntryRowCount("controlsortentry") > 0) {
            ConfirmCallBackListener confirmCallBack = new ConfirmCallBackListener(CHANGESOURCEBILL, (IFormPlugin)this);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5207\u6362\u6216\u6e05\u9664\u201c\u9650\u4ef7\u6765\u6e90\u5355\u636e\u201d\u5c06\u4f1a\u6e05\u7a7a\u201c\u5b57\u6bb5\u6620\u5c04.\u9650\u4ef7\u6765\u6e90\u5b57\u6bb5\u201d\u3001\u201c\u5b57\u6bb5\u6bd4\u8f83.\u9650\u4ef7\u6765\u6e90\u5b57\u6bb5\u201d\u548c\u201c\u9650\u4ef7\u6392\u5e8f\u201d\uff0c\u662f\u5426\u7ee7\u7eed\u4fee\u6539\uff1f", (String)"PriceControlSchemePlugin_5", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]), MessageBoxOptions.YesNo, confirmCallBack);
        }
    }

    private void confirmControlChange() {
        DynamicObjectCollection mappingEntry = this.getModel().getEntryEntity("mappingentry");
        DynamicObjectCollection compareEntry = this.getModel().getEntryEntity("compareentry");
        if (mappingEntry.size() > 0 && this.confirmMappingField("mappingentry", "sourcesign", "controlsign").booleanValue() || compareEntry.size() > 0 && this.confirmMappingField("compareentry", "sourcecomp", "controlcomp").booleanValue()) {
            ConfirmCallBackListener confirmCallBack = new ConfirmCallBackListener(CHANGEQUOTEBILL, (IFormPlugin)this);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5207\u6362\u6216\u6e05\u9664\u201c\u9650\u4ef7\u5355\u636e\u201d\u5c06\u4f1a\u6e05\u7a7a\u201c\u5b57\u6bb5\u6620\u5c04.\u9650\u4ef7\u5355\u636e\u5b57\u6bb5\u201d\u53ca\u201c\u5b57\u6bb5\u6bd4\u8f83.\u9650\u4ef7\u5355\u636e\u5b57\u6bb5\u201d\uff0c\u662f\u5426\u7ee7\u7eed\u4fee\u6539\uff1f", (String)"PriceControlSchemePlugin_6", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]), MessageBoxOptions.YesNo, confirmCallBack);
        }
    }

    private Boolean confirmMappingField(String entryName, String sourceSign, String controlSign) {
        DynamicObjectCollection mappingEntry = this.getModel().getEntryEntity(entryName);
        for (DynamicObject entry : mappingEntry) {
            String source = entry.getString(sourceSign);
            String control = entry.getString(controlSign);
            if (!StringUtils.isNotBlank((CharSequence)source) && !StringUtils.isNotBlank((CharSequence)control)) continue;
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private boolean isShowField(IDataEntityProperty property, int index) {
        Class propertyType = property.getPropertyType();
        if (4 == index) {
            return Integer.class.isAssignableFrom(propertyType) || BigDecimal.class.isAssignableFrom(propertyType) || Date.class.isAssignableFrom(propertyType);
        }
        return property instanceof PriceProp;
    }

    static {
        pairFieldMap.put("sourcesign", "controlsign");
        pairFieldMap.put("controlsign", "sourcesign");
        pairFieldMap.put("sourcecomp", "controlcomp");
        pairFieldMap.put("controlcomp", "sourcecomp");
    }
}

