/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.pricemodel.formplugin;

import java.util.EventObject;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.designer.botp.EntityParseHelper;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.OperationTypeCache;
import kd.bos.entity.property.OrgProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.metadata.treebuilder.FormTreeBuilder;
import kd.bos.metadata.treebuilder.PropTreeBuildOption;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.util.StringUtils;
import kd.mpscmm.msbd.common.utils.CommonUtils;

public class PriceServiceRegisterPlugin
extends AbstractBasePlugIn {
    private static final String SPLIT_DONT = "\\.";
    private static final String FORMID_SELECTFIELD = "botp_selectfield";
    private static final String TREENODES = "treenodes";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        if (this.getView().getControl("orgsignname") != null) {
            this.addClickListeners(new String[]{"orgsignname"});
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control c = (Control)evt.getSource();
        if (c.getKey().equalsIgnoreCase("orgsignname")) {
            this.showBillTree();
        }
    }

    public void afterBindData(EventObject e) {
        boolean isModify;
        super.afterBindData(e);
        DynamicObject bizEntity = (DynamicObject)this.getModel().getValue("bizentity");
        if (bizEntity != null) {
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)bizEntity.getString("number"));
            String orgSign = (String)this.getModel().getValue("orgsign");
            if (StringUtils.isNotEmpty((String)orgSign) && dataEntityType.getAllFields().get(orgSign) != null) {
                this.getModel().setValue("orgsignname", (Object)((IDataEntityProperty)dataEntityType.getAllFields().get(orgSign)).getDisplayName());
                this.getModel().setDataChanged(false);
            }
        }
        this.setOpItems();
        if (this.getView().getFormShowParameter().getCustomParam("mofify") != null && (isModify = ((Boolean)this.getView().getFormShowParameter().getCustomParam("mofify")).booleanValue())) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"bizentity", "service"});
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        Object newValue = changeSet[0].getNewValue();
        if (CommonUtils.isRealChanged((ChangeData)changeSet[0])) {
            switch (key) {
                case "bizentity": {
                    this.getModel().setValue("controlpoint", null);
                    this.getModel().setValue("orgsign", null);
                    this.getModel().setValue("orgsignname", null);
                    if (newValue != null) {
                        DynamicObject bizEntity = (DynamicObject)newValue;
                        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)bizEntity.getString("number"));
                        String orgProperty = dataEntityType.getMainOrg();
                        if ("im".equals(dataEntityType.getAppId()) && dataEntityType.getAllFields().containsKey("bizorg")) {
                            orgProperty = "bizorg";
                        }
                        String fieldCaption = EntityParseHelper.buildPropFullCaption((EntityType)dataEntityType, (String)orgProperty);
                        this.getModel().setValue("orgsignname", (Object)this.getRealFieldCaption(fieldCaption));
                        this.getModel().setValue("orgsign", (Object)orgProperty);
                        this.setOpItems();
                    }
                    this.getModel().getDataEntity().getDataEntityState().setBizChanged(5, false);
                    this.getModel().getDataEntity().getDataEntityState().setBizChanged(6, false);
                    break;
                }
                case "isallpoint": {
                    this.getModel().setDataChanged(false);
                    this.setOpItems();
                    break;
                }
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        if (e.getReturnData() != null) {
            String actionId;
            switch (actionId = e.getActionId()) {
                case "orgsignname": {
                    Object returnData = e.getReturnData();
                    this.fillOrgInfo(returnData);
                }
            }
        }
    }

    private void showBillTree() {
        DynamicObject bizEntity = (DynamicObject)this.getModel().getValue("bizentity");
        if (bizEntity == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e1a\u52a1\u5355\u636e\u3002", (String)"PriceServiceRegisterPlugin_0", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]));
            return;
        }
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)bizEntity.getString("number"));
        PropTreeBuildOption option = new PropTreeBuildOption(null, OrgProp.class);
        TreeNode treeNode = FormTreeBuilder.buildDynamicPropertyTree((MainEntityType)dataEntityType, (PropTreeBuildOption)option);
        List children = treeNode.getChildren();
        for (int i = children.size() - 1; i > 0; --i) {
            children.remove(children.get(i));
        }
        List subChildren = ((TreeNode)children.get(0)).getChildren();
        for (int i = subChildren.size() - 1; i >= 0; --i) {
            if (((TreeNode)subChildren.get(i)).getChildren() != null && ((TreeNode)subChildren.get(i)).getChildren().size() > 0) {
                subChildren.remove(subChildren.get(i));
                continue;
            }
            if (!"settleorg".equals(((TreeNode)subChildren.get(i)).getId()) || !"pm_purorderbill".equals(dataEntityType.getName())) continue;
            subChildren.remove(subChildren.get(i));
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(FORMID_SELECTFIELD);
        String nodesJson = SerializationUtils.toJsonString((Object)treeNode);
        showParameter.getCustomParams().put(TREENODES, nodesJson);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "orgsignname"));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    private void fillOrgInfo(Object returnData) {
        String fieldId = returnData.toString();
        DynamicObject bizEntity = (DynamicObject)this.getModel().getValue("bizentity");
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)bizEntity.getString("number"));
        String fieldCaption = EntityParseHelper.buildPropFullCaption((EntityType)dataEntityType, (String)fieldId);
        fieldCaption = this.getRealFieldCaption(fieldCaption);
        this.getModel().setValue("orgsignname", (Object)fieldCaption);
        this.getModel().setValue("orgsign", (Object)fieldId);
    }

    private void setOpItems() {
        List<ComboItem> operationItems = this.getOpItems();
        if (this.getOpItems() != null && this.getOpItems().size() != 0) {
            ComboEdit checkOpsEdit = (ComboEdit)this.getControl("controlpoint");
            checkOpsEdit.setComboItems(operationItems);
        }
    }

    private List<ComboItem> getOpItems() {
        LinkedList<ComboItem> operationItems = new LinkedList<ComboItem>();
        DynamicObject entity = (DynamicObject)this.getModel().getValue("bizentity");
        if (entity == null) {
            return operationItems;
        }
        String entityKey = (String)entity.getPkValue();
        List entityOperates = EntityMetadataCache.getDataEntityOperate((String)entityKey);
        Iterator ops = entityOperates.iterator();
        boolean isAllPoint = (Boolean)this.getModel().getValue("isallpoint");
        if (isAllPoint) {
            while (ops.hasNext()) {
                Map op = (Map)ops.next();
                String opType = (String)op.get("type");
                if (!OperationTypeCache.isEntityOperation((String)opType)) continue;
                ComboItem comboItem = new ComboItem(LocaleString.fromMap((Map)((Map)op.get("name"))), (String)op.get("key"));
                operationItems.add(comboItem);
            }
        } else {
            while (ops.hasNext()) {
                Map op = (Map)ops.next();
                String opType = (String)op.get("type");
                if (!OperationTypeCache.isEntityOperation((String)opType) || !"audit".equals(opType) && !"submit".equals(opType)) continue;
                ComboItem comboItem = new ComboItem(LocaleString.fromMap((Map)((Map)op.get("name"))), (String)op.get("key"));
                operationItems.add(comboItem);
            }
        }
        return operationItems;
    }

    private String getRealFieldCaption(String fieldCaption) {
        String[] fieldCaptions = fieldCaption.split(SPLIT_DONT);
        if (fieldCaptions.length > 1) {
            fieldCaption = fieldCaptions[fieldCaptions.length - 1];
        }
        return fieldCaption;
    }
}

