/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.pricemodel.formplugin;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.MaterielProp;
import kd.bos.entity.property.QtyProp;
import kd.bos.entity.property.UnitProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mpscmm.msbd.business.helper.FetchPriceHelper;
import kd.mpscmm.msbd.pricemodel.business.helper.advanceprice.PriceProcessHelper;
import kd.mpscmm.msbd.pricemodel.common.consts.advanceprice.PriceProcessConst;

public class PricingProcessViewPlugin
extends AbstractFormPlugin {
    private static final String QUOTEOP = "quoteop";
    private static final String WHETHERQUOTEOP = "_whether_quoteop_";
    private static final String YES = "yes";
    private static final String BILLENTRY = "billentry";
    private static final String DELETEPRICINGPROCESS = "_delete_pricing_process_";
    private static final String PRICINGPROCESSIDLIST = "_pricing_process_id_list_";
    private static final String VIEWPRICING = "viewpricing";
    private static final String SHOWPRICINGPROCESS = "_show_pricing_process_";

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        String operateKey = ((FormOperate)e.getSource()).getOperateKey();
        IDataModel model = this.getModel();
        if ("kd.bos.ext.scmc.operation.quote.QuoteOp".equals(e.getSource().getClass().getName())) {
            String whetherQuote = this.getPageCache().get(WHETHERQUOTEOP);
            this.getPageCache().put(QUOTEOP, operateKey);
            if (YES.equals(whetherQuote)) {
                this.getPageCache().remove(WHETHERQUOTEOP);
                return;
            }
            DynamicObject[] pricingProcessList = this.getPricingProcessList();
            if (pricingProcessList != null && pricingProcessList.length > 0) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u83b7\u53d6\u4ef7\u683c\u5c06\u5220\u9664\u73b0\u6709\u5b9a\u4ef7\u8fc7\u7a0b\uff0c\u662f\u5426\u786e\u8ba4\uff1f", (String)"PricingProcessViewPlugin_0", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]), MessageBoxOptions.OKCancel, ConfirmTypes.Wait, new ConfirmCallBackListener(DELETEPRICINGPROCESS, (IFormPlugin)this));
                this.getPageCache().put(PRICINGPROCESSIDLIST, String.valueOf(Arrays.stream(pricingProcessList).map(row -> (Long)row.getPkValue()).collect(Collectors.toList())));
                e.setCancel(true);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        String operateKey = ((FormOperate)e.getSource()).getOperateKey();
        if (VIEWPRICING.equals(operateKey)) {
            DynamicObject bill = this.getModel().getDataEntity(true);
            boolean billFromDatabase = bill.getDataEntityState().getFromDatabase();
            if (!billFromDatabase) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u4fdd\u5b58\u5355\u636e\uff0c\u518d\u67e5\u770b\u5b9a\u4ef7\u8fc7\u7a0b\u3002", (String)"PricingProcessViewPlugin_2", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]));
                return;
            }
            Long id = (Long)bill.getPkValue();
            if (id == null || id == 0L) {
                return;
            }
            AbstractGrid factor = (AbstractGrid)this.getControl(BILLENTRY);
            int[] selectedRows = factor.getEntryState().getSelectedRows();
            if (selectedRows.length > 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u4ec5\u9009\u62e9\u4e00\u884c\u6570\u636e\u3002", (String)"PricingProcessViewPlugin_3", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]));
                return;
            }
            if (selectedRows.length <= 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7269\u6599\u660e\u7ec6\u5206\u5f55\u884c\u3002", (String)"PricingProcessViewPlugin_4", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]));
                return;
            }
            DynamicObject entryRow = (DynamicObject)bill.getDynamicObjectCollection(BILLENTRY).get(selectedRows[0]);
            boolean entryFromDatabase = entryRow.getDataEntityState().getFromDatabase();
            if (!entryFromDatabase) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u4fdd\u5b58\u5355\u636e\uff0c\u518d\u67e5\u770b\u5b9a\u4ef7\u8fc7\u7a0b\u3002", (String)"PricingProcessViewPlugin_2", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]));
                return;
            }
            Long entryId = (Long)entryRow.getPkValue();
            if (entryId == null || entryId == 0L) {
                return;
            }
            QFilter qFilter = new QFilter("billid", "=", (Object)id);
            qFilter.and("entryid", "=", (Object)entryId);
            ArrayList<String> allSel = new ArrayList<String>();
            allSel.addAll(PriceProcessConst.getSelectorList());
            allSel.addAll(PriceProcessConst.getPriceSelectorList());
            String selectFieldList = String.join((CharSequence)",", allSel);
            DynamicObject pricingProcess = BusinessDataServiceHelper.loadSingle((String)"msbd_pricingprocess", (String)selectFieldList, (QFilter[])qFilter.toArray());
            if (pricingProcess == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5206\u5f55\u884c\u65e0\u5b9a\u4ef7\u8fc7\u7a0b\u3002", (String)"PricingProcessViewPlugin_5", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]));
                return;
            }
            String billNo = pricingProcess.getString("billno");
            if (StringUtils.isEmpty((CharSequence)billNo)) {
                DynamicObject quoteEntity = pricingProcess.getDynamicObject("quoteentity");
                DynamicObject org = pricingProcess.getDynamicObject("org");
                Long entryID = pricingProcess.getLong("entryid");
                if (quoteEntity != null && org != null) {
                    Map keyResult;
                    Long orgID = org.getLong("id");
                    HashSet<Long> orgIDS = new HashSet<Long>(1);
                    orgIDS.add(org.getLong("id"));
                    String billtype = quoteEntity.getString("id");
                    MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)billtype);
                    Map keyMap = FetchPriceHelper.fetchPriceConditonKey(orgIDS, (String)billtype);
                    String entryName = BILLENTRY;
                    if (keyMap.get(orgID) != null && (keyResult = (Map)keyMap.get(orgID)).get("success") != null && Boolean.TRUE.equals(keyResult.get("success"))) {
                        List entryFields = (List)keyResult.get("entry");
                        entryName = ((String)entryFields.get(0)).split("\\.")[0];
                    }
                    QFilter qBillFilter = new QFilter("id", "=", (Object)id);
                    DynamicObject quoteBill = BusinessDataServiceHelper.loadSingle((String)billtype, (String)this.getFillFields(mainEntityType), (QFilter[])new QFilter[]{qBillFilter});
                    if (quoteBill != null) {
                        pricingProcess.set("billno", quoteBill.get(this.getBillNoField(mainEntityType)));
                        DynamicObject currency = quoteBill.getDynamicObject(this.getCurrencyField(mainEntityType));
                        pricingProcess.set("currency", (Object)currency);
                        DecimalFormat df4 = PriceProcessHelper.getPriceFormat(currency);
                        if (StringUtils.isNotEmpty((CharSequence)entryName)) {
                            DynamicObjectCollection entrys = quoteBill.getDynamicObjectCollection(entryName);
                            for (DynamicObject entry : entrys) {
                                if (!entryID.equals(entry.getLong("id"))) continue;
                                pricingProcess.set("material", this.getMaterialValue(mainEntityType, entry));
                                pricingProcess.set("unit", entry.get(this.getUnitField(mainEntityType)));
                                pricingProcess.set("qty", entry.get(this.getQtyField(mainEntityType)));
                            }
                        }
                        DynamicObjectCollection calFactorColl = pricingProcess.getDynamicObjectCollection("factor");
                        for (int i = 0; i < calFactorColl.size(); ++i) {
                            DynamicObject calFactor = (DynamicObject)calFactorColl.get(i);
                            BigDecimal price = calFactor.getBigDecimal("price");
                            String result = calFactor.getString("result");
                            if (!StringUtils.isNotEmpty((CharSequence)result)) continue;
                            calFactor.set("result", (Object)df4.format(price));
                        }
                        DynamicObjectCollection calFormulaColl = pricingProcess.getDynamicObjectCollection("calformula");
                        for (int i = 0; i < calFormulaColl.size(); ++i) {
                            DynamicObject calFormulaRow = (DynamicObject)calFormulaColl.get(i);
                            BigDecimal priceResult = calFormulaRow.getBigDecimal("priceresult");
                            String calRresult = calFormulaRow.getString("calresult");
                            if (!StringUtils.isNotEmpty((CharSequence)calRresult)) continue;
                            calFormulaRow.set("calresult", (Object)df4.format(priceResult));
                        }
                    }
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{pricingProcess});
                }
            }
            this.showPricingProcess((Long)pricingProcess.getPkValue());
        }
    }

    private void showPricingProcess(Long pricingProcessId) {
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.setFormId("msbd_pricingprocess");
        showParameter.setStatus(OperationStatus.EDIT);
        showParameter.setPkId((Object)pricingProcessId);
        if (pricingProcessId != null) {
            showParameter.setPageId(String.valueOf(pricingProcessId));
        }
        showParameter.setCustomParam("billStatus", (Object)this.getBillStatus());
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, SHOWPRICINGPROCESS));
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private String getBillStatus() {
        DynamicObject bill = this.getModel().getDataEntity(true);
        return bill.getString("billstatus");
    }

    private DynamicObject[] getPricingProcessList() {
        DynamicObject bill = this.getModel().getDataEntity(true);
        Long id = (Long)bill.getPkValue();
        AbstractGrid entryGrid = (AbstractGrid)this.getControl(BILLENTRY);
        DynamicObjectCollection billEntry = bill.getDynamicObjectCollection(BILLENTRY);
        int[] selectedRows = entryGrid.getEntryState().getSelectedRows();
        QFilter qFilter = new QFilter("billid", "=", (Object)id);
        ArrayList<Long> entryList = new ArrayList<Long>(16);
        if (selectedRows.length <= 0) {
            for (DynamicObject entry : billEntry) {
                Long entryId = (Long)entry.getPkValue();
                if (entryId == null || entryId == 0L) continue;
                entryList.add(entryId);
            }
            qFilter.and("entryid", "in", entryList);
        } else {
            for (int i = 0; i < selectedRows.length; ++i) {
                DynamicObject entry = (DynamicObject)billEntry.get(selectedRows[i]);
                Long entryId = (Long)entry.getPkValue();
                if (entryId == null || entryId == 0L) continue;
                entryList.add(entryId);
            }
            qFilter.and("entryid", "in", entryList);
        }
        return BusinessDataServiceHelper.load((String)"msbd_pricingprocess", (String)"id", (QFilter[])qFilter.toArray());
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String callBackId = messageBoxClosedEvent.getCallBackId();
        IPageCache pageCache = this.getPageCache();
        if (StringUtils.equals((CharSequence)DELETEPRICINGPROCESS, (CharSequence)callBackId) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            String pricingProcessIdListStr = pageCache.get(PRICINGPROCESSIDLIST);
            List pricingProcessIdList = SerializationUtils.fromJsonStringToList((String)pricingProcessIdListStr, Long.class);
            QFilter qFilter = new QFilter("id", "in", (Object)pricingProcessIdList);
            DeleteServiceHelper.delete((String)"msbd_pricingprocess", (QFilter[])qFilter.toArray());
            this.getPageCache().put(WHETHERQUOTEOP, YES);
            try {
                String op = this.getPageCache().get(QUOTEOP);
                if (StringUtils.isEmpty((CharSequence)op)) {
                    op = this.getQuoteOPKey();
                }
                this.getView().invokeOperation(op);
            }
            catch (Exception e) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8c03\u7528\u53d6\u4ef7\u64cd\u4f5c\u5931\u8d25\u3002", (String)"PricingProcessViewPlugin_7", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]));
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        block4: {
            String key;
            Map returnData;
            IDataModel model;
            block5: {
                String actionId = closedCallBackEvent.getActionId();
                Map returnDataX = (Map)closedCallBackEvent.getReturnData();
                model = this.getModel();
                if (returnDataX == null || !SHOWPRICINGPROCESS.equals(actionId)) break block4;
                String billEntryName = "";
                returnData = (Map)returnDataX.get("priceresult");
                Long entryID = (Long)returnDataX.get("entryid");
                for (Map.Entry entry : returnData.entrySet()) {
                    key = (String)entry.getKey();
                    IDataEntityProperty prop = (IDataEntityProperty)this.getModel().getDataEntityType().getAllFields().get(key);
                    if (!(prop.getParent() instanceof EntryType)) continue;
                    billEntryName = prop.getParent().getName();
                    break;
                }
                if (!StringUtils.isNotEmpty((CharSequence)billEntryName)) break block5;
                int rowIndex = -1;
                DynamicObjectCollection colls = model.getEntryEntity(billEntryName);
                for (int i = 0; i < colls.size(); ++i) {
                    if (!entryID.equals(((DynamicObject)colls.get(i)).get("id"))) continue;
                    rowIndex = i;
                    break;
                }
                if (rowIndex < 0) break block4;
                for (Map.Entry entry : returnData.entrySet()) {
                    String key2 = (String)entry.getKey();
                    BigDecimal value = (BigDecimal)entry.getValue();
                    model.setValue(key2, (Object)value, rowIndex);
                }
                break block4;
            }
            for (Map.Entry entry : returnData.entrySet()) {
                key = (String)entry.getKey();
                BigDecimal value = (BigDecimal)entry.getValue();
                model.setValue(key, (Object)value);
            }
        }
    }

    protected String getCurrencyField(MainEntityType tgtMainType) {
        if (tgtMainType.getAllFields().containsKey("settlecurrency")) {
            return "settlecurrency";
        }
        if (tgtMainType.getAllFields().containsKey("currency")) {
            return "currency";
        }
        return "currency";
    }

    protected String getQtyField(MainEntityType tgtMainType) {
        if (tgtMainType.getAllFields().containsKey("qty")) {
            return "qty";
        }
        if (tgtMainType.getAllFields().containsKey("e_quantity")) {
            return "e_quantity";
        }
        if (tgtMainType.getAllFields().containsKey("reqqty")) {
            return "reqqty";
        }
        if (tgtMainType.getAllFields().containsKey("quantity")) {
            return "quantity";
        }
        Set fields = tgtMainType.getAllFields().entrySet();
        Iterator fieldIter = fields.iterator();
        while (fieldIter.hasNext()) {
            IDataEntityProperty pros = (IDataEntityProperty)fieldIter.next().getValue();
            if (!(pros instanceof QtyProp)) continue;
            return pros.getName();
        }
        return "qty";
    }

    protected String getUnitField(MainEntityType tgtMainType) {
        if (tgtMainType.getAllFields().containsKey("unit")) {
            return "unit";
        }
        if (tgtMainType.getAllFields().containsKey("e_measureunit")) {
            return "e_measureunit";
        }
        if (tgtMainType.getAllFields().containsKey("measureunit")) {
            return "measureunit";
        }
        Set fields = tgtMainType.getAllFields().entrySet();
        Iterator fieldIter = fields.iterator();
        while (fieldIter.hasNext()) {
            IDataEntityProperty pros = (IDataEntityProperty)fieldIter.next().getValue();
            if (!(pros instanceof UnitProp)) continue;
            return pros.getName();
        }
        return "unit";
    }

    protected String getBillNoField(MainEntityType tgtMainType) {
        if (tgtMainType.getAllFields().containsKey("billno")) {
            return "billno";
        }
        if (tgtMainType.getAllFields().containsKey("number")) {
            return "number";
        }
        return "billno";
    }

    private String getMaterialField(MainEntityType tgtMainType) {
        String materialField = "material";
        if (tgtMainType.getAllFields().containsKey("material")) {
            materialField = "material";
        } else if (tgtMainType.getAllFields().containsKey("e_material")) {
            materialField = "e_material";
        } else if (tgtMainType.getAllFields().containsKey("materialid")) {
            materialField = "materialid";
        } else if (tgtMainType.getAllFields().containsKey("materialmasterid")) {
            materialField = "materialmasterid";
        } else {
            Set fields = tgtMainType.getAllFields().entrySet();
            Iterator fieldIter = fields.iterator();
            while (fieldIter.hasNext()) {
                IDataEntityProperty pros = (IDataEntityProperty)fieldIter.next().getValue();
                if (!(pros instanceof MaterielProp)) continue;
                materialField = pros.getName();
                break;
            }
        }
        MaterielProp materielProp = (MaterielProp)tgtMainType.getAllFields().get(materialField);
        String baseEntityId = materielProp.getBaseEntityId();
        if ("bd_material".equals(baseEntityId)) {
            return materialField;
        }
        return materialField + '.' + "masterid";
    }

    private String getFillFields(MainEntityType tgtMainType) {
        ArrayList<String> fields = new ArrayList<String>(4);
        fields.add(this.getBillNoField(tgtMainType));
        fields.add(this.getMaterialField(tgtMainType));
        fields.add(this.getQtyField(tgtMainType));
        fields.add(this.getUnitField(tgtMainType));
        fields.add(this.getCurrencyField(tgtMainType));
        return String.join((CharSequence)",", fields);
    }

    private Object getMaterialValue(MainEntityType mainEntityType, DynamicObject entry) {
        String materialField = this.getMaterialField(mainEntityType);
        String[] materialFields = materialField.split("\\.");
        DynamicObject materialOb = entry;
        for (String field : materialFields) {
            if (materialOb == null) {
                return null;
            }
            materialOb = materialOb.getDynamicObject(field);
        }
        return materialOb;
    }

    protected String getQuoteOPKey() {
        MainEntityType type = this.getModel().getDataEntityType();
        if (type != null && "pm_purorderbill".equals(type.getName())) {
            return "gainprice";
        }
        return QUOTEOP;
    }
}

