/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.pricemodel.formplugin.advanceprice;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.control.Control;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeCheckEvent;
import kd.bos.form.control.events.TreeNodeCheckListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.metadata.treebuilder.FormTreeBuilder;
import kd.bos.metadata.treebuilder.PropTreeBuildOption;
import kd.bos.util.CollectionUtils;

public class FieldSelectTreePlugin
extends AbstractFormPlugin
implements TreeNodeClickListener,
TreeNodeCheckListener,
SearchEnterListener {
    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{"btnok", "btncancel"});
        TreeView tv = (TreeView)this.getView().getControl("tv_fields");
        tv.addTreeNodeClickListener((TreeNodeClickListener)this);
        tv.addTreeNodeCheckListener((TreeNodeCheckListener)this);
        Search search = (Search)this.getView().getControl("searchfield");
        if (search != null) {
            search.addEnterListener((SearchEnterListener)this);
        }
    }

    public void afterCreateNewData(EventObject e) {
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String json = (String)this.getView().getFormShowParameter().getCustomParam("treenodes");
        this.fillTreeNodes(json);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control ctlSource = (Control)evt.getSource();
        if ("btnok".equalsIgnoreCase(ctlSource.getKey())) {
            String currNodeId = this.getPageCache().get("nodeids");
            if (StringUtils.isNotBlank((CharSequence)currNodeId)) {
                this.getView().returnDataToParent((Object)currNodeId);
            } else {
                this.getView().returnDataToParent((Object)"");
            }
            this.getView().close();
        } else if ("btncancel".equalsIgnoreCase(ctlSource.getKey())) {
            this.getView().close();
        }
    }

    public void treeNodeClick(TreeNodeEvent e) {
        if (!this.isMultiSelected()) {
            String currNodeId = (String)e.getNodeId();
            if ("0".equals(currNodeId)) {
                currNodeId = "";
            }
            this.getPageCache().put("nodeids", currNodeId);
        }
    }

    public void treeNodeDoubleClick(TreeNodeEvent e) {
        if (!this.isMultiSelected()) {
            String currNodeId = (String)e.getNodeId();
            if ("0".equals(currNodeId)) {
                currNodeId = "";
            }
            if (!StringUtils.isBlank((CharSequence)currNodeId)) {
                this.getView().returnDataToParent((Object)currNodeId);
                this.getView().close();
            }
        }
    }

    public void treeNodeCheck(TreeNodeCheckEvent e) {
        String cacheNodeIds = "";
        TreeView treeView = (TreeView)e.getSource();
        List checkedNodeIds = treeView.getTreeState().getCheckedNodeIds();
        if (checkedNodeIds != null) {
            checkedNodeIds.remove("0");
            cacheNodeIds = StringUtils.join((Object[])checkedNodeIds.toArray(), (String)",");
        }
        this.getPageCache().put("nodeids", cacheNodeIds);
    }

    private void fillTreeNodes(String strJson) {
        String entitynumber = (String)this.getView().getFormShowParameter().getCustomParam("entitynumber");
        TreeNode rootNode = new TreeNode();
        if (StringUtils.isBlank((CharSequence)strJson)) {
            if (StringUtils.isNotBlank((CharSequence)entitynumber)) {
                PropTreeBuildOption option = new PropTreeBuildOption();
                option.setIncludePKField(true);
                MainEntityType type = EntityMetadataCache.getDataEntityType((String)entitynumber);
                rootNode = FormTreeBuilder.buildDynamicPropertyTree((MainEntityType)type, (PropTreeBuildOption)option);
            } else {
                this.addTreeRootNode();
            }
        } else {
            rootNode = (TreeNode)SerializationUtils.fromJsonString((String)strJson, TreeNode.class);
        }
        TreeView tree = (TreeView)this.getView().getControl("tv_fields");
        tree.addNode(rootNode);
        if (this.isMultiSelected()) {
            this.multiSelect(tree, rootNode);
        }
    }

    private void multiSelect(TreeView tree, TreeNode rootNode) {
        tree.setMulti(true);
        String cacheNodeIds = (String)this.getView().getFormShowParameter().getCustomParam("nodeids");
        if (StringUtils.isNotBlank((CharSequence)cacheNodeIds)) {
            this.getPageCache().put("nodeids", cacheNodeIds);
            String[] arr = StringUtils.split((String)cacheNodeIds, (String)",");
            ArrayList<TreeNode> selectedNodes = new ArrayList<TreeNode>();
            String[] var6 = arr;
            int var7 = arr.length;
            for (int var8 = 0; var8 < var7; ++var8) {
                String nodeId = var6[var8];
                TreeNode node = rootNode.getTreeNode(nodeId, 5);
                if (node == null) continue;
                selectedNodes.add(node);
            }
            if (selectedNodes.size() > 0) {
                tree.checkNodes(selectedNodes);
            }
        }
    }

    private void addTreeRootNode() {
        TreeNode root = new TreeNode("", "0", ResManager.loadKDString((String)"\u5b57\u6bb5\u5217\u8868", (String)"FieldSelectTreePlugin_0", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]));
        TreeView tree = (TreeView)this.getView().getControl("tv_fields");
        tree.addNode(root);
    }

    private boolean isMultiSelected() {
        String isMulti = (String)this.getView().getFormShowParameter().getCustomParam("ismulti");
        if (StringUtils.isBlank((CharSequence)isMulti)) {
            return false;
        }
        return isMulti.equalsIgnoreCase("true") || isMulti.equalsIgnoreCase("1");
    }

    public void search(SearchEnterEvent evt) {
        Search search = (Search)evt.getSource();
        if (StringUtils.equals((CharSequence)"searchfield", (CharSequence)search.getKey())) {
            String searchText = evt.getText();
            this.doSearch(searchText);
        }
    }

    private void doSearch(String searchText) {
        String entitynumber = (String)this.getView().getFormShowParameter().getCustomParam("entitynumber");
        String json = (String)this.getView().getFormShowParameter().getCustomParam("treenodes");
        TreeNode rootNode = new TreeNode();
        if (StringUtils.isNotBlank((CharSequence)json)) {
            rootNode = (TreeNode)SerializationUtils.fromJsonString((String)json, TreeNode.class);
        } else if (StringUtils.isNotBlank((CharSequence)entitynumber)) {
            PropTreeBuildOption option = new PropTreeBuildOption();
            option.setIncludePKField(true);
            MainEntityType type = EntityMetadataCache.getDataEntityType((String)entitynumber);
            rootNode = FormTreeBuilder.buildDynamicPropertyTree((MainEntityType)type, (PropTreeBuildOption)option);
        }
        TreeView tree = (TreeView)this.getView().getControl("tv_fields");
        if (StringUtils.isNotBlank((CharSequence)searchText) && CollectionUtils.isNotEmpty((Collection)rootNode.getChildren())) {
            rootNode.setChildren(this.getContains(rootNode.getChildren(), searchText));
        }
        tree.updateNode(rootNode);
        if (this.isMultiSelected()) {
            this.multiSelect(tree, rootNode);
        }
    }

    private List<TreeNode> getContains(List<TreeNode> childrens, String searchText) {
        Iterator<TreeNode> iterator = childrens.iterator();
        while (iterator.hasNext()) {
            TreeNode treeNode = iterator.next();
            if (CollectionUtils.isNotEmpty((Collection)treeNode.getChildren())) {
                treeNode.setChildren(this.getContains(treeNode.getChildren(), searchText));
            }
            if (!CollectionUtils.isEmpty((Collection)treeNode.getChildren()) || treeNode.getText().contains(searchText)) continue;
            iterator.remove();
        }
        return childrens;
    }
}

