/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.pricemodel.formplugin.quote;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.basedataref.BaseDataCheckRefrence;
import kd.bos.basedataref.BaseDataRefenceKey;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.botp.BillTreeBuildParameter;
import kd.bos.designer.botp.EntityParseHelper;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BigIntProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.property.MasterBasedataProp;
import kd.bos.entity.property.MaterielProp;
import kd.bos.entity.property.TextProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.treebuilder.FormTreeBuilder;
import kd.bos.metadata.treebuilder.PropTreeBuildOption;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.mpscmm.msbd.common.utils.CommonUtils;
import kd.mpscmm.msbd.pricemodel.business.helper.DataSetHelper;
import kd.mpscmm.msbd.pricemodel.business.helper.PriceHelper;
import kd.mpscmm.msbd.pricemodel.business.helper.PropertyChangeHelper;
import kd.mpscmm.msbd.pricemodel.business.helper.advanceprice.AdvancedPricingHelper;
import kd.mpscmm.msbd.pricemodel.business.helper.quote.QuoteExtHelper;
import kd.mpscmm.msbd.pricemodel.business.helper.quote.QuoteOtherHelper;
import kd.mpscmm.msbd.pricemodel.business.pojo.quote.QuoteSchemeInfo;
import kd.mpscmm.msbd.pricemodel.common.enums.OperatorEnum;

public class QuoteSchemePlugin
extends AbstractBasePlugIn
implements BeforeF7SelectListener {
    private static final Log log = LogFactory.getLog(QuoteSchemePlugin.class);
    private static final String FORMID_SELECTFIELD = "botp_selectfield";
    private static final String SOURCETREENODES = "treenodes";
    private static final String CALLBACK_SORTFIELD = "sortfieldcallback";
    private static final String CHANGESOURCEBILL = "changesourcebill";
    private static final String CHANGEQUOTEBILL = "changequotebill";
    private static final String PRICEDIMENSIONOLDVALUE = "pricedimensionOldValue";

    public void registerListener(EventObject e) {
        BasedataEdit quoteEntityEdit;
        super.registerListener(e);
        this.addClickListeners(new String[]{"sourcesignname"});
        this.addClickListeners(new String[]{"quotesignname"});
        this.addClickListeners(new String[]{"sourcesignnamer"});
        this.addClickListeners(new String[]{"quotesignnamer"});
        this.addClickListeners(new String[]{"sortsignname"});
        this.addClickListeners(new String[]{"sourcesetting"});
        this.addItemClickListeners(new String[]{"advcontoolbarap"});
        this.addItemClickListeners(new String[]{"advcontoolbarap1"});
        BasedataEdit dimensionEdit = (BasedataEdit)this.getView().getControl("pricedimension");
        if (dimensionEdit != null) {
            dimensionEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((quoteEntityEdit = (BasedataEdit)this.getView().getControl("quoteentity")) != null) {
            quoteEntityEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.sourceBillChanged("pricesourceentity", "filtergridap");
        this.bindUnParseCols("quotesourceconditon", "filtergridap");
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        boolean a = true;
        boolean b = false;
        this.getModel().setValue("enablematch", (Object)a);
        this.getModel().setDataChanged(b);
        ComboEdit orderEdit = (ComboEdit)this.getControl("order");
        orderEdit.setMustInput(a);
        this.setPriceSourceMust();
        this.getView().setEnable(Boolean.valueOf(b), new String[]{"use"});
        if (Boolean.TRUE.equals(this.getModel().getValue("ispreset"))) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"bar_unaudit"});
        }
        TextEdit targetEditr = (TextEdit)this.getView().getControl("quotesignnamer");
        TextEdit sourceEditr = (TextEdit)this.getView().getControl("sourcesignnamer");
        TextEdit targetEdit = (TextEdit)this.getView().getControl("quotesignname");
        if (this.isDimensionMode()) {
            String sourceText = ResManager.loadKDString((String)"\u6765\u6e90\u5b9e\u4f53\u5b57\u6bb5", (String)"QuoteSchemePlugin_10", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]);
            LocaleString sourceTextLocale = new LocaleString(sourceText);
            TextEdit sourceEdit = (TextEdit)this.getView().getControl("sourcesignname");
            sourceEdit.setCaption(sourceTextLocale);
            sourceEditr.setCaption(sourceTextLocale);
            String targetText = ResManager.loadKDString((String)"\u76ee\u6807\u5b9e\u4f53\u5b57\u6bb5", (String)"QuoteSchemePlugin_18", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]);
            LocaleString targetTextLocale = new LocaleString(targetText);
            targetEdit.setCaption(targetTextLocale);
            targetEditr.setCaption(targetTextLocale);
        }
        sourceEditr.setMustInput(true);
        targetEditr.setMustInput(true);
        targetEdit.setMustInput(true);
        for (int row = 0; row < this.getModel().getEntryRowCount("entryresult"); ++row) {
            if (!this.checkSchemeGroupPrice(row)) {
                this.getView().setEnable(Boolean.FALSE, row, new String[]{"schemegroupprice"});
                continue;
            }
            this.getView().setEnable(Boolean.TRUE, row, new String[]{"schemegroupprice"});
        }
        AtomicBoolean change = new AtomicBoolean(false);
        QuoteOtherHelper.loadCaption(this.getModel(), "quoteentity", "entryentity", "quotesign", "quotesignname", change);
        QuoteOtherHelper.loadCaption(this.getModel(), "quoteentity", "entryresult", "quotesignr", "quotesignnamer", change);
        if (this.isDimensionMode()) {
            QuoteOtherHelper.loadCaption(this.getModel(), "quoteentity", "entryentity", "sourcesign", "sourcesignname", change);
            QuoteOtherHelper.loadCaption(this.getModel(), "quoteentity", "entryresult", "sourcesignr", "sourcesignnamer", change);
        } else {
            QuoteOtherHelper.loadCaption(this.getModel(), "pricesourceentity", "entryentity", "sourcesign", "sourcesignname", change);
            QuoteOtherHelper.loadCaption(this.getModel(), "pricesourceentity", "entryresult", "sourcesignr", "sourcesignnamer", change);
        }
        QuoteOtherHelper.loadCaption(this.getModel(), "pricesourceentity", "pricesortentity", "sortsign", "sortsignname", change);
        if (change.get()) {
            this.getModel().setDataChanged(false);
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getModel().setValue("org", (Object)RequestContext.get().getOrgId());
        this.getModel().setValue("quoteentity", (Object)"msbd_pricetax_expenses");
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        String entryName = e.getEntryProp().getName();
        if ("entryresult".equals(entryName)) {
            RowDataEntity[] addRows;
            for (RowDataEntity addRow : addRows = e.getRowDataEntities()) {
                int rowIndex = addRow.getRowIndex();
                if (!this.checkSchemeGroupPrice(rowIndex)) {
                    this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"schemegroupprice"});
                    continue;
                }
                this.getView().setEnable(Boolean.TRUE, rowIndex, new String[]{"schemegroupprice"});
            }
        }
    }

    public void click(EventObject evt) {
        String msg;
        super.click(evt);
        Control c = (Control)evt.getSource();
        if ("sourcesignname".equalsIgnoreCase(c.getKey())) {
            msg = ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4ef7\u683c\u6765\u6e90\u5355\u636e\u3002", (String)"QuoteSchemePlugin_5", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]);
            if (this.checkIsEmpty("pricesourceentity", msg)) {
                return;
            }
            msg = ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4ef7\u683c\u7ef4\u5ea6\u3002", (String)"QuoteSchemePlugin_16", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]);
            if (this.checkIsEmpty("pricedimension", msg)) {
                return;
            }
            this.showBillTree("pricesourceentity", "sourcesignname");
        }
        if ("quotesignname".equalsIgnoreCase(c.getKey())) {
            msg = ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u53d6\u4ef7\u5355\u636e\u3002", (String)"QuoteSchemePlugin_6", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]);
            if (this.checkIsEmpty("quoteentity", msg)) {
                return;
            }
            msg = ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4ef7\u683c\u7ef4\u5ea6\u3002", (String)"QuoteSchemePlugin_16", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]);
            if (this.checkIsEmpty("pricedimension", msg)) {
                return;
            }
            this.showBillTree("quoteentity", "quotesignname");
        }
        if ("sourcesignnamer".equalsIgnoreCase(c.getKey())) {
            msg = ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4ef7\u683c\u6765\u6e90\u5355\u636e\u3002", (String)"QuoteSchemePlugin_5", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]);
            if (this.checkIsEmpty("pricesourceentity", msg)) {
                return;
            }
            this.showBillTree("pricesourceentity", "sourcesignnamer");
        }
        if ("quotesignnamer".equalsIgnoreCase(c.getKey())) {
            msg = ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u53d6\u4ef7\u5355\u636e\u3002", (String)"QuoteSchemePlugin_6", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]);
            if (this.checkIsEmpty("quoteentity", msg)) {
                return;
            }
            this.showBillTree("quoteentity", "quotesignnamer");
        }
        if ("sortsignname".equalsIgnoreCase(c.getKey())) {
            this.showSortBillTree();
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        if ("btnautomatchfield".equals(itemKey)) {
            this.autoMatchFields("entryentity", "sourcesign", "quotesign", "quotesignname");
        }
        if ("automatch".equals(itemKey)) {
            this.autoMatchFields("entryresult", "sourcesignr", "quotesignr", "quotesignnamer");
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String fieldKey;
        switch (fieldKey = e.getProperty().getName()) {
            case "pricedimension": {
                DynamicObject priceSource = (DynamicObject)this.getModel().getValue("pricesourceentity");
                if (priceSource != null) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4ef7\u683c\u6765\u6e90\u5355\u636e\u3002", (String)"QuoteSchemePlugin_5", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]));
                e.setCancel(true);
                break;
            }
            case "quoteentity": {
                ListShowParameter formShowParameter = (ListShowParameter)e.getFormShowParameter();
                formShowParameter.getListFilterParameter().getQFilters().add(new QFilter("number", "!=", (Object)"msbd_pricetax_expenses"));
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if (PropertyChangeHelper.isStopChange(this.getPageCache())) {
            return;
        }
        String key = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        Object oldValue = e.getChangeSet()[0].getOldValue();
        int row = e.getChangeSet()[0].getRowIndex();
        switch (key) {
            case "pricesourceentity": {
                DynamicObject dy = (DynamicObject)oldValue;
                if (this.checkRef(key, dy)) break;
                if (oldValue != null) {
                    this.getPageCache().put("pricesourceentityOldValue", dy.get("number").toString());
                    this.confirmSourceChange();
                    break;
                }
                if (this.isDimensionMode()) break;
                this.sourceBillChanged("pricesourceentity", "filtergridap");
                this.bindUnParseCols("quotesourceconditon", "filtergridap");
                break;
            }
            case "quoteentity": {
                DynamicObject dys = (DynamicObject)oldValue;
                if (oldValue == null || this.checkRef(key, dys)) break;
                this.getPageCache().put("priceQuoteOldValue", dys.get("number").toString());
                this.confirmQuoteChange();
                break;
            }
            case "sourcesignname": {
                if (newValue == null || !StringUtils.isEmpty((CharSequence)newValue.toString())) break;
                this.getModel().setValue("sourcesign", null, row);
                break;
            }
            case "quotesignnamer": {
                if (newValue == null || !StringUtils.isEmpty((CharSequence)newValue.toString())) break;
                this.getModel().setValue("quotesignr", null, row);
                break;
            }
            case "sourcesignnamer": {
                if (newValue != null && StringUtils.isEmpty((CharSequence)newValue.toString())) {
                    this.getModel().setValue("sourcesignr", null, row);
                }
                this.getModel().setValue("schemegroupprice", (Object)Boolean.FALSE, row);
                break;
            }
            case "matchflag": {
                if (newValue == null || !OperatorEnum.CONFIGURED.getValue().equals(newValue)) break;
                DynamicObject entryInfo = (DynamicObject)this.getModel().getEntryEntity("entryentity").get(row);
                String quoteSign = entryInfo.getString("quotesign");
                DynamicObject bill = (DynamicObject)this.getModel().getValue("quoteentity");
                if (bill != null) {
                    String number = bill.getString("number");
                    MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)number);
                    if (StringUtils.isNotEmpty((CharSequence)quoteSign)) {
                        IDataEntityProperty currentProp = DataSetHelper.findPropertys((EntityType)dataEntityType, quoteSign);
                        if (currentProp instanceof BasedataProp) {
                            if (!"bd_configuredcode".equals(((BasedataProp)currentProp).getBaseEntityId())) {
                                this.getModel().setValue("quotesign", null, row);
                                this.getModel().setValue("quotesignname", null, row);
                            }
                        } else {
                            this.getModel().setValue("quotesign", null, row);
                            this.getModel().setValue("quotesignname", null, row);
                        }
                    }
                }
                String sourceSign = entryInfo.getString("sourcesign");
                DynamicObject sourcebill = (DynamicObject)this.getModel().getValue("pricesourceentity");
                if (sourcebill == null) break;
                String number = sourcebill.getString("number");
                if (this.isDimensionMode()) {
                    number = "msbd_pricetax_expenses";
                }
                MainEntityType sourceEntityType = MetadataServiceHelper.getDataEntityType((String)number);
                if (!StringUtils.isNotEmpty((CharSequence)sourceSign)) break;
                IDataEntityProperty currentProp = DataSetHelper.findPropertys((EntityType)sourceEntityType, sourceSign);
                if (this.isDimensionMode()) {
                    if ("featurevalue".equals(currentProp.getParent().getName()) || "kitnumber".equals(currentProp.getName())) break;
                    this.getModel().setValue("sourcesign", null, row);
                    this.getModel().setValue("sourcesignname", null, row);
                    break;
                }
                if (currentProp instanceof BasedataProp) {
                    if ("pdm_featuredefinition".equals(((BasedataProp)currentProp).getBaseEntityId())) break;
                    this.getModel().setValue("sourcesign", null, row);
                    this.getModel().setValue("sourcesignname", null, row);
                    break;
                }
                if (currentProp instanceof TextProp && !"pdm_featuredefinition".equals(currentProp.getParent().getName())) break;
                this.getModel().setValue("sourcesign", null, row);
                this.getModel().setValue("sourcesignname", null, row);
                break;
            }
            case "quotesignname": {
                if (newValue == null || !StringUtils.isEmpty((CharSequence)newValue.toString())) break;
                this.getModel().setValue("quotesign", null, row);
                break;
            }
            case "sortsignname": {
                if (newValue == null || !StringUtils.isBlank((CharSequence)newValue.toString())) break;
                this.getModel().setValue("sortsign", null, row);
                break;
            }
            case "schemegroupprice": {
                Boolean schemeGroupPrice = (Boolean)newValue;
                if (!schemeGroupPrice.booleanValue()) break;
                String sourceSign = (String)this.getModel().getValue("sourcesignr", row);
                if (StringUtils.isEmpty((CharSequence)sourceSign)) {
                    if (this.isDimensionMode()) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u6765\u6e90\u5b9e\u4f53\u5b57\u6bb5\u201d\u3002", (String)"QuoteSchemePlugin_19", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]));
                    } else {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u4ef7\u683c\u6765\u6e90\u5b57\u6bb5\u201d\u3002", (String)"QuoteSchemePlugin_12", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]));
                    }
                    this.getModel().setValue("schemegroupprice", (Object)Boolean.FALSE);
                    break;
                }
                IDataEntityProperty iDataEntityProperty = this.getPriceSourceFieldProperty(row);
                if (iDataEntityProperty == null) {
                    if (this.isDimensionMode()) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6570\u503c\u7c7b\u578b\u7684\u201c\u6765\u6e90\u5b9e\u4f53\u5b57\u6bb5\u201d\u914d\u7f6e\u4e3a\u201c\u4f5c\u4e3a\u65b9\u6848\u7ec4\u4ef7\u683c\u201d\u3002", (String)"QuoteSchemePlugin_20", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]));
                    } else {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6570\u503c\u7c7b\u578b\u7684\u201c\u4ef7\u683c\u6765\u6e90\u5b57\u6bb5\u201d\u914d\u7f6e\u4e3a\u201c\u4f5c\u4e3a\u65b9\u6848\u7ec4\u4ef7\u683c\u201d\u3002", (String)"QuoteSchemePlugin_11", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]));
                    }
                    this.getModel().setValue("schemegroupprice", (Object)Boolean.FALSE);
                    break;
                }
                Class type = iDataEntityProperty.getPropertyType();
                if (type == null || !BigDecimal.class.isAssignableFrom(type)) {
                    if (this.isDimensionMode()) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6570\u503c\u7c7b\u578b\u7684\u201c\u6765\u6e90\u5b9e\u4f53\u5b57\u6bb5\u201d\u914d\u7f6e\u4e3a\u201c\u4f5c\u4e3a\u65b9\u6848\u7ec4\u4ef7\u683c\u201d\u3002", (String)"QuoteSchemePlugin_20", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]));
                    } else {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6570\u503c\u7c7b\u578b\u7684\u201c\u4ef7\u683c\u6765\u6e90\u5b57\u6bb5\u201d\u914d\u7f6e\u4e3a\u201c\u4f5c\u4e3a\u65b9\u6848\u7ec4\u4ef7\u683c\u201d\u3002", (String)"QuoteSchemePlugin_11", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]));
                    }
                    this.getModel().setValue("schemegroupprice", (Object)Boolean.FALSE);
                    break;
                }
                for (int i = 0; i < this.getModel().getEntryRowCount("entryresult"); ++i) {
                    if (row == i) continue;
                    this.getModel().setValue("schemegroupprice", (Object)Boolean.FALSE, i);
                }
                break;
            }
            case "enablematch": {
                this.getModel().setDataChanged(false);
                break;
            }
            case "expandparam": {
                if (!CommonUtils.isRealChanged((Object)oldValue, (Object)newValue)) break;
                this.setPriceSourceMust();
                break;
            }
            case "pricedimension": {
                if (newValue == null) {
                    PropertyChangeHelper.stopChange(this.getPageCache());
                    this.getModel().setValue("pricedimension", oldValue);
                    PropertyChangeHelper.release(this.getPageCache());
                    break;
                }
                if (!CommonUtils.isRealChanged((Object)oldValue, (Object)newValue)) break;
                if (oldValue != null) {
                    DynamicObject dyOld = (DynamicObject)oldValue;
                    this.getPageCache().put(PRICEDIMENSIONOLDVALUE, dyOld.getPkValue().toString());
                    this.confirmDimensionChange();
                    break;
                }
                this.initConditionEntryByDimension();
                break;
            }
        }
    }

    private IDataEntityProperty getPriceSourceFieldProperty(int row) {
        MainEntityType dataEntityType;
        String sourceSign = (String)this.getModel().getValue("sourcesignr", row);
        DynamicObject priceSourceEntity = (DynamicObject)this.getModel().getValue("pricesourceentity");
        if (priceSourceEntity == null || StringUtils.isEmpty((CharSequence)sourceSign)) {
            return null;
        }
        String number = priceSourceEntity.getString("number");
        if (this.isDimensionMode()) {
            number = "msbd_pricetax_expenses";
        }
        if (StringUtils.isNotEmpty((CharSequence)(sourceSign = AdvancedPricingHelper.subEntryField(sourceSign, dataEntityType = MetadataServiceHelper.getDataEntityType((String)number))))) {
            Map allFields = dataEntityType.getAllFields();
            IDataEntityProperty iDataEntityProperty = (IDataEntityProperty)allFields.get(sourceSign);
            return iDataEntityProperty;
        }
        return null;
    }

    private void confirmSourceChange() {
        DynamicObjectCollection mappingEntry = this.getModel().getEntryEntity("entryentity");
        if (mappingEntry.size() > 0 && this.confirmMappingField().booleanValue() || StringUtils.isNotEmpty((CharSequence)this.getFilterGridCondition("filtergridap")) || this.getModel().getEntryRowCount("pricesortentity") > 0) {
            ConfirmCallBackListener confirmCallBack = new ConfirmCallBackListener(CHANGESOURCEBILL, (IFormPlugin)this);
            if (this.isDimensionMode()) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u5207\u6362\u6216\u6e05\u9664\u201c\u4ef7\u683c\u6765\u6e90\u5355\u636e\u201d\u5c06\u4f1a\u6e05\u7a7a\u4ef7\u683c\u7ef4\u5ea6\u3001\u53d6\u4ef7\u6761\u4ef6\u6620\u5c04\u3001\u53d6\u4ef7\u7ed3\u679c\u6620\u5c04\u548c\u4ef7\u683c\u6392\u5e8f\uff0c\u662f\u5426\u7ee7\u7eed\u4fee\u6539\uff1f", (String)"QuoteSchemePlugin_15", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]), MessageBoxOptions.YesNo, confirmCallBack);
            } else {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u5207\u6362\u6216\u6e05\u9664\u201c\u4ef7\u683c\u6765\u6e90\u5355\u636e\u201d\u5c06\u4f1a\u6e05\u7a7a\u201c\u53d6\u4ef7\u6761\u4ef6\u6620\u5c04.\u4ef7\u683c\u6765\u6e90\u5b57\u6bb5\u201d\u3001\u201c\u53d6\u4ef7\u7ed3\u679c\u6620\u5c04.\u4ef7\u683c\u6765\u6e90\u5b57\u6bb5\u201d\u548c\u201c\u4ef7\u683c\u6392\u5e8f\u201d\uff0c\u662f\u5426\u7ee7\u7eed\u4fee\u6539\uff1f", (String)"QuoteSchemePlugin_0", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]), MessageBoxOptions.YesNo, confirmCallBack);
            }
        }
    }

    private void confirmDimensionChange() {
        ConfirmCallBackListener confirmCallBack = new ConfirmCallBackListener(PRICEDIMENSIONOLDVALUE, (IFormPlugin)this);
        this.getView().showConfirm(ResManager.loadKDString((String)"\u5207\u6362\u201c\u4ef7\u683c\u7ef4\u5ea6\u201d\uff0c\u53d6\u4ef7\u6761\u4ef6\u6620\u5c04\u5206\u5f55\u4fe1\u606f\u5c06\u6309\u5207\u6362\u540e\u7684\u201c\u4ef7\u683c\u7ef4\u5ea6\u201d\u91cd\u65b0\u8d4b\u503c\uff0c\u662f\u5426\u7ee7\u7eed\u4fee\u6539\uff1f", (String)"QuoteSchemePlugin_14", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]), MessageBoxOptions.YesNo, confirmCallBack);
    }

    private void confirmQuoteChange() {
        DynamicObjectCollection mappingEntry = this.getModel().getEntryEntity("entryentity");
        if (mappingEntry.size() > 0 && this.confirmMappingField().booleanValue()) {
            ConfirmCallBackListener confirmCallBack = new ConfirmCallBackListener(CHANGEQUOTEBILL, (IFormPlugin)this);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5207\u6362\u6216\u6e05\u9664\u201c\u53d6\u4ef7\u5355\u636e\u201d\u5c06\u4f1a\u6e05\u7a7a\u201c\u53d6\u4ef7\u6761\u4ef6\u6620\u5c04.\u53d6\u4ef7\u5355\u636e\u5b57\u6bb5\u201d\u548c\u201c\u53d6\u4ef7\u7ed3\u679c\u6620\u5c04. \u53d6\u4ef7\u5355\u636e\u5b57\u6bb5\u201d\uff0c\u662f\u5426\u7ee7\u7eed\u4fee\u6539\uff1f", (String)"QuoteSchemePlugin_1", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]), MessageBoxOptions.YesNo, confirmCallBack);
        }
    }

    private Boolean confirmMappingField() {
        DynamicObjectCollection mappingEntry = this.getModel().getEntryEntity("entryentity");
        for (DynamicObject entry : mappingEntry) {
            String source = entry.getString("sourcesign");
            String quote = entry.getString("quotesign");
            if (!StringUtils.isNotBlank((CharSequence)source) && !StringUtils.isNotBlank((CharSequence)quote)) continue;
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String key = ((AbstractOperate)args.getSource()).getOperateKey();
        if ("save".equals(key) || "submit".equals(key)) {
            IDataModel model = this.getModel();
            String sourceFs = this.getFilterGridCondition("filtergridap");
            model.setValue("quotesourceconditon", (Object)sourceFs);
        }
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs e) {
        super.beforeDeleteRow(e);
        int[] deleteRows = e.getRowIndexs();
        if ("entryentity".equals(e.getEntryProp().getName())) {
            for (int index : deleteRows) {
                boolean isDimension = (Boolean)this.getModel().getValue("issumdimension", index);
                if (!isDimension) continue;
                String msg = ResManager.loadKDString((String)"\u4ef7\u683c\u7ef4\u5ea6\u6761\u4ef6\u884c\u4e0d\u80fd\u88ab\u5220\u9664\u3002", (String)"QuoteSchemePlugin_17", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]);
                this.getView().showTipNotification(msg);
                e.setCancel(true);
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        String key;
        super.confirmCallBack(evt);
        switch (key = evt.getCallBackId()) {
            case "changesourcebill": {
                if ("Yes".equals(evt.getResultValue())) {
                    if (!this.isDimensionMode()) {
                        DynamicObjectCollection entitys = this.getModel().getEntryEntity("entryentity");
                        for (int i = 0; i < entitys.size(); ++i) {
                            ((DynamicObject)entitys.get(i)).set("sourcesignname", null);
                            ((DynamicObject)entitys.get(i)).set("sourcesign", null);
                        }
                        DynamicObjectCollection rEntitys = this.getModel().getEntryEntity("entryresult");
                        for (int i = 0; i < rEntitys.size(); ++i) {
                            ((DynamicObject)rEntitys.get(i)).set("sourcesignnamer", null);
                            ((DynamicObject)rEntitys.get(i)).set("sourcesignr", null);
                        }
                        this.getView().updateView("entryentity");
                        this.getView().updateView("entryresult");
                        this.getModel().deleteEntryData("pricesortentity");
                        this.getModel().createNewEntryRow("pricesortentity");
                        this.getModel().setValue("quotesourceconditon", null);
                        this.sourceBillChanged("pricesourceentity", "filtergridap");
                        this.bindUnParseCols("quotesourceconditon", "filtergridap");
                        break;
                    }
                    PropertyChangeHelper.stopChange(this.getPageCache());
                    this.getModel().setValue("pricedimension", null);
                    this.getModel().deleteEntryData("entryentity");
                    this.getModel().deleteEntryData("entryresult");
                    this.getModel().deleteEntryData("pricesortentity");
                    this.getModel().createNewEntryRow("entryentity");
                    this.getModel().createNewEntryRow("entryresult");
                    this.getModel().createNewEntryRow("pricesortentity");
                    PropertyChangeHelper.release(this.getPageCache());
                    break;
                }
                String pricesourceentityOldValue = this.getPageCache().get("pricesourceentityOldValue");
                PropertyChangeHelper.stopChange(this.getPageCache());
                this.getModel().setValue("pricesourceentity", (Object)pricesourceentityOldValue);
                PropertyChangeHelper.release(this.getPageCache());
                break;
            }
            case "changequotebill": {
                if ("Yes".equals(evt.getResultValue())) {
                    DynamicObjectCollection entitys = this.getModel().getEntryEntity("entryentity");
                    int size = entitys.size();
                    for (int i = 0; i < size; ++i) {
                        ((DynamicObject)entitys.get(i)).set("quotesignname", null);
                        ((DynamicObject)entitys.get(i)).set("quotesign", null);
                    }
                    DynamicObjectCollection rEntitys = this.getModel().getEntryEntity("entryresult");
                    for (int i = 0; i < rEntitys.size(); ++i) {
                        ((DynamicObject)rEntitys.get(i)).set("quotesignnamer", null);
                        ((DynamicObject)rEntitys.get(i)).set("quotesignr", null);
                    }
                    this.getView().updateView("entryentity");
                    this.getView().updateView("entryresult");
                    break;
                }
                String pricequoteOldValue = this.getPageCache().get("priceQuoteOldValue");
                this.getModel().beginInit();
                this.getModel().setValue("quoteentity", (Object)pricequoteOldValue);
                this.getModel().endInit();
                this.getView().updateView("quoteentity");
                break;
            }
            case "pricedimensionOldValue": {
                if ("Yes".equals(evt.getResultValue())) {
                    this.initConditionEntryByDimension();
                    break;
                }
                String priceDimension = this.getPageCache().get(PRICEDIMENSIONOLDVALUE);
                PropertyChangeHelper.stopChange(this.getPageCache());
                this.getModel().setValue("pricedimension", (Object)priceDimension);
                PropertyChangeHelper.release(this.getPageCache());
            }
        }
    }

    private String getFilterGridCondition(String gridName) {
        FilterGrid grid = (FilterGrid)this.getControl(gridName);
        if (grid == null) {
            return "";
        }
        FilterCondition condition = grid.getFilterGridState().getFilterCondition();
        String jsonStr = SerializationUtils.toJsonString((Object)condition);
        return jsonStr;
    }

    private void sourceBillChanged(String billName, String filterGridap) {
        DynamicObject bill = (DynamicObject)this.getModel().getValue(billName);
        MainEntityType dataEntityType = null;
        if (bill != null) {
            String number = bill.getString("number");
            dataEntityType = MetadataServiceHelper.getDataEntityType((String)number);
        }
        this.setCols4FilterGrid(dataEntityType, filterGridap);
    }

    private void setCols4FilterGrid(MainEntityType entityType, String controlName) {
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl(controlName);
        EntityTypeUtil helper = new EntityTypeUtil();
        if (entityType == null) {
            filterGrid.setFilterColumns(Collections.EMPTY_LIST);
        } else {
            List cols = helper.getFilterColumns((IDataEntityType)entityType);
            filterGrid.setEntityNumber(entityType.getName());
            filterGrid.setFilterColumns(cols);
        }
        this.getView().updateView(controlName);
    }

    private void bindUnParseCols(String priceConditionField, String gridap) {
        String priceSourceFsStr = this.getModel().getDataEntity().getString(priceConditionField);
        FilterCondition condition = PriceHelper.convertStringToCondition(priceSourceFsStr);
        if (condition == null) {
            condition = new FilterCondition();
        }
        FilterGrid reserveFilter = (FilterGrid)this.getControl(gridap);
        reserveFilter.SetValue(condition);
    }

    private void showSortBillTree() {
        DynamicObjectCollection entries = this.getModel().getEntryEntity("entryentity");
        if (null == entries) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5b57\u6bb5\u6620\u5c04\u5206\u5f55\u3002", (String)"QuoteSchemePlugin_2", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]));
            return;
        }
        String msg = ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4ef7\u683c\u6765\u6e90\u5355\u636e\u3002", (String)"QuoteSchemePlugin_3", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]);
        if (this.checkIsEmpty("pricesourceentity", msg)) {
            return;
        }
        DynamicObject quoteSrcType = (DynamicObject)this.getModel().getValue("pricesourceentity");
        if (quoteSrcType == null) {
            return;
        }
        String number = quoteSrcType.getString("number");
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)number);
        Map allFields = dataEntityType.getAllFields();
        ArrayList sortFieldsList = new ArrayList();
        ArrayList sortEntryFieldsList = new ArrayList();
        allFields.forEach((k, v) -> {
            Class propertyType = v.getPropertyType();
            if (Integer.class.isAssignableFrom(propertyType) || BigDecimal.class.isAssignableFrom(propertyType) || Date.class.isAssignableFrom(propertyType)) {
                String parentName = v.getParent().getName();
                if (!number.equals(parentName) && !parentName.contains("lk")) {
                    String[] entryFields = new String[2];
                    String sourceSign = parentName.concat(".").concat(v.getName());
                    String sourceSignName = v.getParent().getDisplayName().getLocaleValue().concat(".").concat(v.getDisplayName().getLocaleValue());
                    String sourceSignName_origin = EntityParseHelper.buildPropFullCaption((EntityType)dataEntityType, (String)sourceSign);
                    entryFields[0] = sourceSign;
                    entryFields[1] = sourceSignName;
                    sortEntryFieldsList.add(entryFields);
                } else {
                    String[] fields = new String[2];
                    String sourceSign = v.getName();
                    String sourceSignName = v.getDisplayName().getLocaleValue();
                    String sourceSignName_origin = EntityParseHelper.buildPropFullCaption((EntityType)dataEntityType, (String)sourceSign);
                    fields[0] = sourceSign;
                    fields[1] = sourceSignName;
                    sortFieldsList.add(fields);
                }
            }
        });
        ArrayList<String[]> allSortFieldsList = new ArrayList<String[]>(sortFieldsList.size() + sortEntryFieldsList.size());
        allSortFieldsList.addAll(sortFieldsList);
        allSortFieldsList.addAll(sortEntryFieldsList);
        if (allSortFieldsList.size() != 0) {
            this.buildSortFieldsTree(allSortFieldsList);
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ef7\u683c\u6765\u6e90\u5355\u636e\u4e2d\u6ca1\u6709\u53ef\u53c2\u4e0e\u6392\u5e8f\u7684\u5b57\u6bb5\uff1a\u53c2\u4e0e\u6392\u5e8f\u7684\u5b57\u6bb5\u5fc5\u987b\u662f\u6570\u503c\u578b\u6216\u65e5\u671f\u578b\u3002", (String)"QuoteSchemePlugin_4", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]));
        }
    }

    private void buildSortFieldsTree(List<String[]> allSortFieldsList) {
        DynamicObject priceSource = (DynamicObject)this.getModel().getValue("pricesourceentity");
        String rootName = priceSource.getString("name");
        String rootNumber = priceSource.getString("number");
        TreeNode root = new TreeNode();
        root.setId(rootNumber);
        root.setText(rootName);
        ArrayList<String> entryNumbers = new ArrayList<String>();
        for (String[] sortFields : allSortFieldsList) {
            TreeNode grandSon;
            TreeNode child;
            String nodeNumber = sortFields[0];
            String nodeName = sortFields[1];
            String[] splitNumber = nodeNumber.split("\\.");
            if (splitNumber.length == 1) {
                TreeNode child2 = new TreeNode();
                child2.setIsOpened(true);
                child2.setText(nodeName);
                child2.setId(nodeNumber);
                root.addChild(child2);
                continue;
            }
            if (splitNumber.length <= 1) continue;
            String[] splitName = nodeName.split("\\.");
            if (entryNumbers.contains(splitNumber[0])) {
                child = root.getTreeNodeByText(splitName[0], 1);
                grandSon = new TreeNode();
                grandSon.setIsOpened(true);
                grandSon.setId(splitNumber[1]);
                grandSon.setText(splitName[1]);
                child.addChild(grandSon);
                continue;
            }
            child = new TreeNode();
            child.setIsOpened(true);
            child.setText(splitName[0]);
            child.setId(splitNumber[0]);
            root.addChild(child);
            grandSon = new TreeNode();
            grandSon.setIsOpened(true);
            grandSon.setId(splitNumber[1]);
            grandSon.setText(splitName[1]);
            child.addChild(grandSon);
            entryNumbers.add(splitNumber[0]);
        }
        root.setIsOpened(true);
        if (root.getChildren() == null) {
            return;
        }
        this.showSrcFieldForm(root, "sortsignname");
    }

    public void showBillTree(String selectBill, String fieldKey) {
        TreeNode treeNode;
        int row;
        String anotherBill;
        String currentBill;
        if ("pricesourceentity".equals(selectBill)) {
            currentBill = "pricesourceentity";
            anotherBill = "quoteentity";
        } else {
            currentBill = "quoteentity";
            anotherBill = "pricesourceentity";
        }
        DynamicObject sourceBill = (DynamicObject)this.getModel().getValue(currentBill);
        String sourceNumber = sourceBill.getString("number");
        if (this.isDimensionMode()) {
            sourceNumber = "msbd_pricetax_expenses";
        }
        MainEntityType sourceEntityType = MetadataServiceHelper.getDataEntityType((String)sourceNumber);
        DynamicObject targetBill = (DynamicObject)this.getModel().getValue(anotherBill);
        String targetFieldValue = "";
        MainEntityType targetEntityType = null;
        if (targetBill != null) {
            String matchField;
            int row2;
            String targetNumber = targetBill.getString("number");
            if (this.isDimensionMode()) {
                targetNumber = "msbd_pricetax_expenses";
            }
            targetEntityType = MetadataServiceHelper.getDataEntityType((String)targetNumber);
            if ("quotesignnamer".equals(fieldKey) || "sourcesignnamer".equals(fieldKey)) {
                row2 = this.getModel().getEntryCurrentRowIndex("entryresult");
                matchField = "pricesourceentity".equals(currentBill) ? "quotesignr" : "sourcesignr";
                targetFieldValue = ((DynamicObject)this.getModel().getEntryEntity("entryresult").get(row2)).getString(matchField);
            } else {
                row2 = this.getModel().getEntryCurrentRowIndex("entryentity");
                matchField = "pricesourceentity".equals(currentBill) ? "quotesign" : "sourcesign";
                targetFieldValue = ((DynamicObject)this.getModel().getEntryEntity("entryentity").get(row2)).getString(matchField);
            }
        }
        boolean includePKField = true;
        if (StringUtils.isEmpty((CharSequence)sourceEntityType.getAlias())) {
            includePKField = false;
        }
        boolean isFilterConfigCode = false;
        if (("quotesignname".equals(fieldKey) || "sourcesignname".equals(fieldKey)) && (row = this.getModel().getEntryCurrentRowIndex("entryentity")) >= 0) {
            DynamicObject entryInfo = (DynamicObject)this.getModel().getEntryEntity("entryentity").get(row);
            String matchFlag = entryInfo.getString("matchflag");
            if (OperatorEnum.CONFIGURED.getValue().equals(matchFlag)) {
                isFilterConfigCode = true;
            }
        }
        if (targetFieldValue == null || targetEntityType == null || isFilterConfigCode || "".equals(targetFieldValue)) {
            BillTreeBuildParameter parameter = new BillTreeBuildParameter(sourceEntityType, null, (IDataEntityProperty)null);
            parameter.setIncludePKField(includePKField);
            parameter.setOnlyPhysicsField(false);
            treeNode = EntityParseHelper.buildBillTreeNodes((BillTreeBuildParameter)parameter);
        } else {
            IDataEntityProperty targetProperty = DataSetHelper.findPropertys((EntityType)targetEntityType, targetFieldValue = this.subEntryField(targetFieldValue, targetEntityType));
            if (targetProperty == null) {
                BillTreeBuildParameter parameter = new BillTreeBuildParameter(sourceEntityType, null, (IDataEntityProperty)null);
                parameter.setIncludePKField(includePKField);
                parameter.setOnlyPhysicsField(false);
                treeNode = EntityParseHelper.buildBillTreeNodes((BillTreeBuildParameter)parameter);
            } else {
                BillTreeBuildParameter parameter;
                Boolean enablematch = (Boolean)this.getModel().getValue("enablematch");
                if ("sourcesignnamer".equals(fieldKey) && this.isDimensionMode()) {
                    enablematch = Boolean.FALSE;
                }
                if (enablematch.booleanValue()) {
                    if (targetProperty instanceof LongProp) {
                        PropTreeBuildOption option = new PropTreeBuildOption(null, LongProp.class);
                        option.addMatchedClassTypes(BigIntProp.class);
                        option.setOnlyPhysicsField(false);
                        option.setIncludePKField(includePKField);
                        treeNode = FormTreeBuilder.buildDynamicPropertyTree((MainEntityType)sourceEntityType, (PropTreeBuildOption)option);
                    } else {
                        parameter = new BillTreeBuildParameter(sourceEntityType, null, targetProperty);
                        parameter.setIncludePKField(includePKField);
                        parameter.setOnlyPhysicsField(false);
                        treeNode = EntityParseHelper.buildBillTreeNodes((BillTreeBuildParameter)parameter);
                    }
                } else {
                    parameter = new BillTreeBuildParameter(sourceEntityType, null, (IDataEntityProperty)null);
                    parameter.setIncludePKField(includePKField);
                    parameter.setOnlyPhysicsField(false);
                    treeNode = EntityParseHelper.buildBillTreeNodes((BillTreeBuildParameter)parameter);
                }
            }
        }
        if ("quotesignname".equals(fieldKey)) {
            this.removeNodeFromTree(treeNode, sourceEntityType, isFilterConfigCode, true);
            this.removeNoChildNode(treeNode, sourceEntityType, isFilterConfigCode);
        } else if ("sourcesignname".equals(fieldKey)) {
            this.removeNodeFromTree(treeNode, sourceEntityType, isFilterConfigCode, false);
            this.removeNoChildNode(treeNode, sourceEntityType, isFilterConfigCode);
        }
        if (this.isDimensionMode() && treeNode.getChildren() != null && treeNode.getChildren().size() == 1) {
            TreeNode childNode = (TreeNode)treeNode.getChildren().get(0);
            List grandsons = childNode.getChildren();
            ArrayList<String> existFields = new ArrayList<String>();
            if (grandsons != null && "sourcesignnamer".equals(fieldKey)) {
                for (int i = 0; i < this.getModel().getEntryRowCount("entryresult"); ++i) {
                    if (this.getModel().getValue("sourcesignr", i) == null) continue;
                    existFields.add((String)this.getModel().getValue("sourcesignr", i));
                }
            }
            if (grandsons != null && ("sourcesignnamer".equals(fieldKey) || "quotesignname".equals(fieldKey) || "sourcesignname".equals(fieldKey))) {
                for (int s = grandsons.size() - 1; s >= 0; --s) {
                    if (existFields.contains(((TreeNode)grandsons.get(s)).getId())) {
                        grandsons.remove(s);
                        continue;
                    }
                    ((TreeNode)grandsons.get(s)).setChildren(null);
                }
            }
            treeNode.getChildren().clear();
            treeNode.addChildren(grandsons);
        }
        this.showSrcFieldForm(treeNode, fieldKey);
    }

    private void showSrcFieldForm(TreeNode billNode, String fieldKey) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(FORMID_SELECTFIELD);
        String nodesJson = SerializationUtils.toJsonString((Object)billNode);
        showParameter.getCustomParams().put(SOURCETREENODES, nodesJson);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, fieldKey));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        String actionId = e.getActionId();
        Object returnData = e.getReturnData();
        if (StringUtils.isEmpty((CharSequence)actionId) || returnData == null) {
            return;
        }
        if (returnData instanceof String) {
            String returnDataStr = (String)returnData;
            String[] returnDataArray = returnDataStr.split("\\.");
            DynamicObject quoteSrcType = (DynamicObject)this.getModel().getValue("pricesourceentity");
            DynamicObject quoteQuoteType = (DynamicObject)this.getModel().getValue("quoteentity");
            if (returnDataArray != null && returnDataArray.length > 0) {
                if (quoteSrcType != null && quoteSrcType.get("id").equals(returnDataArray[returnDataArray.length - 1])) {
                    returnData = "id";
                } else if ("billhead".equals(returnDataArray[returnDataArray.length - 1])) {
                    returnData = "id";
                } else if (quoteQuoteType != null && quoteQuoteType.get("id").equals(returnDataArray[returnDataArray.length - 1])) {
                    returnData = "id";
                }
            }
        }
        switch (actionId) {
            case "sourcesignname": {
                this.setCallBackResult(returnData, "sourcesignname", "pricesourceentity");
                break;
            }
            case "quotesignname": {
                this.setCallBackResult(returnData, "quotesignname", "quoteentity");
                break;
            }
            case "sourcesignnamer": {
                this.setCallBackResult(returnData, "sourcesignnamer", "pricesourceentity");
                if (!this.isDimensionMode()) break;
                int row = this.getModel().getEntryCurrentRowIndex("entryresult");
                this.getModel().setValue("quotesignr", this.getModel().getValue("sourcesignr", row), row);
                this.getModel().setValue("quotesignnamer", this.getModel().getValue("sourcesignnamer", row), row);
                break;
            }
            case "quotesignnamer": {
                this.setCallBackResult(returnData, "quotesignnamer", "quoteentity");
                break;
            }
            case "sortsignname": {
                this.setCallBackResult(returnData, "sortsignname", "pricesourceentity");
                break;
            }
            case "sourcesetting": {
                FilterCondition condition = PriceHelper.convertFullStringToCondition((String)returnData);
                if (condition == null) {
                    condition = new FilterCondition();
                }
                this.getModel().setValue("quotesourceconditon", (Object)SerializationUtils.toJsonString((Object)condition));
                this.getModel().setValue("quoteconditon", returnData);
                this.bindUnParseCols("quotesourceconditon", "filtergridap");
                break;
            }
        }
    }

    private void setCallBackResult(Object returnData, String selectField, String billModel) {
        String fieldId = returnData.toString();
        Object srcBill = this.getModel().getValue(billModel);
        String srcBillId = (String)((DynamicObject)srcBill).getPkValue();
        if (this.isDimensionMode() && !"sortsignname".equals(selectField) && "id".equals(fieldId)) {
            return;
        }
        if (this.isDimensionMode() && "pricesourceentity".equals(billModel) && !"sortsignname".equals(selectField)) {
            srcBillId = "msbd_pricetax_expenses";
        }
        MainEntityType srcBillMainType = MetadataServiceHelper.getDataEntityType((String)srcBillId);
        String fieldCaption = EntityParseHelper.buildPropFullCaption((EntityType)srcBillMainType, (String)fieldId);
        fieldCaption = this.reduceFieldName(fieldCaption);
        String[] split = fieldId.split("\\.");
        String tempFieldId = split[0];
        IDataEntityProperty findProperty = srcBillMainType.findProperty(tempFieldId);
        boolean isEntryField = false;
        if (findProperty != null) {
            String parentName = findProperty.getParent().getName();
            fieldId = this.getEntryFullField(srcBillMainType, fieldId, srcBillId, parentName);
            if (!srcBillId.equals(parentName)) {
                isEntryField = true;
            }
        }
        String[] fieldIds = fieldId.split("\\.");
        if ("sourcesignname".equals(selectField) || "quotesignname".equals(selectField) || "sourcesignnamer".equals(selectField)) {
            if (fieldIds != null && fieldIds.length > 4) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5c0f\u4e8e\u56db\u7ea7\u7684\u5b57\u6bb5\u3002", (String)"QuoteSchemePlugin_7", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]));
            }
        } else if ("quotesignnamer".equals(selectField) && (fieldIds != null && isEntryField && fieldIds.length > 2 || fieldIds != null && !isEntryField && fieldIds.length > 1)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4f5c\u4e3a\u53d6\u4ef7\u7ed3\u679c\u8bf7\u9009\u62e9\u53d6\u4ef7\u5355\u636e\u672c\u8eab\u7684\u5b57\u6bb5\u3002", (String)"QuoteSchemePlugin_8", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]));
        }
        if ("sourcesignname".equals(selectField)) {
            int row = this.getModel().getEntryCurrentRowIndex("entryentity");
            this.getModel().setValue("sourcesignname", (Object)fieldCaption, row);
            this.getModel().setValue("sourcesign", (Object)fieldId, row);
        } else if ("quotesignname".equals(selectField)) {
            int row = this.getModel().getEntryCurrentRowIndex("entryentity");
            this.getModel().setValue("quotesignname", (Object)fieldCaption, row);
            this.getModel().setValue("quotesign", (Object)fieldId, row);
        } else if ("quotesignnamer".equals(selectField)) {
            int row = this.getModel().getEntryCurrentRowIndex("entryresult");
            this.getModel().setValue("quotesignnamer", (Object)fieldCaption, row);
            this.getModel().setValue("quotesignr", (Object)fieldId, row);
        } else if ("sourcesignnamer".equals(selectField)) {
            int row = this.getModel().getEntryCurrentRowIndex("entryresult");
            this.getModel().setValue("sourcesignnamer", (Object)fieldCaption, row);
            this.getModel().setValue("sourcesignr", (Object)fieldId, row);
            if (!this.checkSchemeGroupPrice(row)) {
                this.getView().setEnable(Boolean.FALSE, row, new String[]{"schemegroupprice"});
            } else {
                this.getView().setEnable(Boolean.TRUE, row, new String[]{"schemegroupprice"});
            }
        } else if ("sortsignname".equals(selectField)) {
            int row = this.getModel().getEntryCurrentRowIndex("pricesortentity");
            this.getModel().setValue("sortsignname", (Object)fieldCaption, row);
            this.getModel().setValue("sortsign", (Object)fieldId, row);
        }
    }

    public void autoMatchFields(String entrySymbol, String sourceSign, String quoteSign, String quoteSignName) {
        DynamicObject source = (DynamicObject)this.getModel().getValue("pricesourceentity");
        DynamicObject target = (DynamicObject)this.getModel().getValue("quoteentity");
        if (source == null || target == null) {
            return;
        }
        String sourceNumber = source.getString("number");
        String targetNumber = target.getString("number");
        if (this.isDimensionMode()) {
            sourceNumber = "msbd_pricetax_expenses";
        }
        MainEntityType srcMainType = EntityMetadataCache.getDataEntityType((String)sourceNumber);
        MainEntityType tgtMainType = EntityMetadataCache.getDataEntityType((String)targetNumber);
        int rowCount = this.getModel().getEntryRowCount(entrySymbol);
        for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
            String targetFieldKey;
            String sourceFieldKey = (String)this.getModel().getValue(sourceSign, rowIndex);
            if (StringUtils.isBlank((CharSequence)sourceFieldKey) || StringUtils.isNotBlank((CharSequence)(targetFieldKey = (String)this.getModel().getValue(quoteSign, rowIndex)))) continue;
            IDataEntityProperty targetField = null;
            boolean isMatch = false;
            if ("entryentity".equals(entrySymbol) && OperatorEnum.CONFIGURED.getValue().equals(this.getModel().getValue("matchflag", rowIndex))) {
                Set fields = tgtMainType.getAllFields().entrySet();
                for (Map.Entry field : fields) {
                    IDataEntityProperty currentField = (IDataEntityProperty)field.getValue();
                    if (!(currentField instanceof BasedataProp) || !"bd_configuredcode".equals(((BasedataProp)currentField).getBaseEntityId())) continue;
                    targetField = currentField;
                    isMatch = true;
                    break;
                }
            } else {
                String[] split = sourceFieldKey.split("\\.");
                String tempSourceFieldKey = sourceFieldKey;
                if (split.length > 1) {
                    tempSourceFieldKey = split[1];
                }
                DynamicProperty sourceField = (DynamicProperty)srcMainType.findProperty(tempSourceFieldKey);
                targetField = tgtMainType.findProperty(tempSourceFieldKey);
                if (targetField != null && targetField.getClass().isInstance(sourceField) && (this.isDimensionMode() || !this.isDimensionMode() && StringUtils.isNotBlank((CharSequence)sourceField.getAlias()))) {
                    isMatch = true;
                }
            }
            if (!isMatch || targetField == null) continue;
            String fieldId = targetField.getName();
            IDataEntityProperty findProperty = tgtMainType.findProperty(fieldId);
            if (findProperty != null) {
                String parentName = findProperty.getParent().getName();
                fieldId = this.getEntryFullField(tgtMainType, fieldId, targetNumber, parentName);
            }
            String targetFieldName = EntityParseHelper.buildPropFullCaption((IDataEntityProperty)targetField);
            this.getModel().setValue(quoteSign, (Object)fieldId, rowIndex);
            this.getModel().setValue(quoteSignName, (Object)this.reduceFieldName(targetFieldName), rowIndex);
        }
    }

    private String subEntryField(String fieldKey, MainEntityType mainType) {
        IDataEntityProperty tempProperty;
        if (mainType == null) {
            return fieldKey;
        }
        String[] split = fieldKey.split("\\.");
        if (split.length > 1 && (tempProperty = mainType.findProperty(split[0])) instanceof EntryProp) {
            ArrayList<String> list = new ArrayList<String>(split.length);
            for (int i = 0; i < split.length; ++i) {
                list.add(split[i]);
            }
            list.remove(0);
            fieldKey = StringUtils.join((Object[])list.toArray(), (String)".");
        }
        return fieldKey;
    }

    private void showConditionForm(String conditionJson, String entityNumber, String fieldNodes, String sourceCtrlKey) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("botp_condition");
        showParameter.getCustomParams().put("formula", conditionJson);
        showParameter.getCustomParams().put("entitynumber", entityNumber);
        showParameter.getCustomParams().put(SOURCETREENODES, fieldNodes);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, sourceCtrlKey));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    private String buildFullFormula() {
        String conditionJson;
        String fullFormula = (String)this.getModel().getValue("quoteconditon");
        String filterFormula = this.getFilterGridCondition("filtergridap");
        if (StringUtils.isNotEmpty((CharSequence)fullFormula)) {
            CRCondition crCondition = (CRCondition)SerializationUtils.fromJsonString((String)fullFormula, CRCondition.class);
            FilterCondition fc = PriceHelper.convertStringToCondition(filterFormula);
            crCondition.setFilterCondition(fc);
            conditionJson = SerializationUtils.toJsonString((Object)crCondition);
        } else {
            CRCondition crCondition = new CRCondition();
            FilterCondition fc = PriceHelper.convertStringToCondition(filterFormula);
            crCondition.setFilterCondition(fc);
            conditionJson = SerializationUtils.toJsonString((Object)crCondition);
        }
        return conditionJson;
    }

    private void removeNodeFromTree(TreeNode treeNode, MainEntityType entityType, boolean isFilterConfigCode, boolean isQuotebill) {
        if (treeNode.getChildren() != null && treeNode.getChildren().size() > 0) {
            int size = treeNode.getChildren().size();
            for (int i = size - 1; i >= 0; --i) {
                IDataEntityProperty parentProperty;
                TreeNode childNode = (TreeNode)treeNode.getChildren().get(i);
                if (isFilterConfigCode) {
                    boolean isRemove = true;
                    IDataEntityProperty currentProp = DataSetHelper.findPropertys((EntityType)entityType, childNode.getId());
                    if (currentProp == null || currentProp instanceof EntryProp) {
                        isRemove = false;
                    } else if (isQuotebill) {
                        if (currentProp instanceof BasedataProp && "bd_configuredcode".equals(((BasedataProp)currentProp).getBaseEntityId())) {
                            childNode.setChildren(null);
                            isRemove = false;
                        }
                    } else if (currentProp instanceof BasedataProp) {
                        if ("pdm_featuredefinition".equals(((BasedataProp)currentProp).getBaseEntityId())) {
                            childNode.setChildren(null);
                            isRemove = false;
                        }
                        if ("kitnumber".equals(currentProp.getName())) {
                            childNode.setChildren(null);
                            isRemove = false;
                        }
                    } else if (currentProp instanceof TextProp) {
                        isRemove = this.isDimensionMode() ? !"featurevalue".equals(currentProp.getName()) : false;
                    }
                    if (isRemove) {
                        treeNode.getChildren().remove(i);
                        continue;
                    }
                }
                if (childNode.getId().endsWith(".id") && !((parentProperty = DataSetHelper.findPropertys((EntityType)entityType, childNode.getParentid())) instanceof EntryProp)) {
                    treeNode.getChildren().remove(i);
                    continue;
                }
                IDataEntityProperty property = DataSetHelper.findPropertys((EntityType)entityType, childNode.getId());
                if (property instanceof MaterielProp) {
                    String materialExtraName;
                    String baseEntityId = ((MaterielProp)property).getBaseEntityId();
                    if ("bd_materialinventoryinfo".equals(baseEntityId) || "bd_materialpurchaseinfo".equals(baseEntityId) || "bd_materialsalinfo".equals(baseEntityId)) {
                        MainEntityType materialEntity = MetadataServiceHelper.getDataEntityType((String)baseEntityId);
                        materialExtraName = "(" + materialEntity.getDisplayName().toString() + ")";
                        childNode.setText(childNode.getText() + materialExtraName);
                        int subSize = childNode.getChildren().size();
                        String parentID = childNode.getId();
                        for (int j = subSize - 1; j >= 0; --j) {
                            String subBaseEntityId;
                            TreeNode subChildNode = (TreeNode)childNode.getChildren().get(j);
                            if ((parentID + ".number").equals(subChildNode.getId())) {
                                childNode.getChildren().remove(j);
                            } else if ((parentID + ".name").equals(subChildNode.getId())) {
                                childNode.getChildren().remove(j);
                            } else if ((parentID + ".id").equals(subChildNode.getId())) {
                                childNode.getChildren().remove(j);
                            }
                            IDataEntityProperty subProperty = DataSetHelper.findPropertys((EntityType)entityType, subChildNode.getId());
                            if (!(subProperty instanceof MasterBasedataProp) || !"bd_material".equals(subBaseEntityId = ((MasterBasedataProp)subProperty).getBaseEntityId())) continue;
                            String subMaterialExtraName = ResManager.loadKDString((String)"\u7269\u6599\u4e3b\u6570\u636e", (String)"QuoteSchemePlugin_9", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]);
                            subChildNode.setText(subChildNode.getText() + "(" + subMaterialExtraName + ")");
                        }
                        this.removeNodeFromTree(childNode, entityType, isFilterConfigCode, isQuotebill);
                        continue;
                    }
                    if (!"bd_material".equals(baseEntityId)) continue;
                    String subMaterialExtraName = ResManager.loadKDString((String)"\u7269\u6599\u4e3b\u6570\u636e", (String)"QuoteSchemePlugin_9", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]);
                    materialExtraName = "(" + subMaterialExtraName + ")";
                    childNode.setText(childNode.getText() + materialExtraName);
                    this.removeNodeFromTree(childNode, entityType, isFilterConfigCode, isQuotebill);
                    continue;
                }
                this.removeNodeFromTree(childNode, entityType, isFilterConfigCode, isQuotebill);
            }
        }
    }

    private void removeNoChildNode(TreeNode treeNode, MainEntityType entityType, boolean isFilterConfigCode) {
        if (isFilterConfigCode && treeNode.getChildren() != null && treeNode.getChildren().size() > 0) {
            int size = treeNode.getChildren().size();
            for (int i = size - 1; i >= 0; --i) {
                TreeNode childNode = (TreeNode)treeNode.getChildren().get(i);
                IDataEntityProperty currentProp = DataSetHelper.findPropertys((EntityType)entityType, childNode.getId());
                if (!(currentProp instanceof EntryProp) || childNode.getChildren() != null && childNode.getChildren().size() != 0) continue;
                treeNode.getChildren().remove(i);
            }
        }
    }

    private String getEntryFullField(MainEntityType tgtMainType, String fieldId, String srcBillId, String parentName) {
        while (!srcBillId.equals(parentName)) {
            fieldId = parentName.concat(".").concat(fieldId);
            IDataEntityProperty parentProp = tgtMainType.findProperty(parentName);
            if (parentProp.getParent() == null) break;
            parentName = parentProp.getParent().getName();
        }
        return fieldId;
    }

    private void setPriceSourceMust() {
        QuoteSchemeInfo quoteSchemeInfo = new QuoteSchemeInfo();
        boolean isReplace = QuoteExtHelper.isReplaceQuote(quoteSchemeInfo);
        if (!isReplace) {
            TextEdit sourceSignEdit = (TextEdit)this.getControl("sourcesignname");
            sourceSignEdit.setMustInput(true);
        } else {
            TextEdit sourceSignEdit = (TextEdit)this.getControl("sourcesignname");
            sourceSignEdit.setMustInput(false);
        }
    }

    private boolean checkRef(String property, DynamicObject dy) {
        BaseDataCheckRefrence checker;
        List allRefList;
        if (dy != null && this.getModel().getValue("id") != null && !Long.valueOf("0").equals(this.getModel().getValue("id")) && (allRefList = (checker = new BaseDataCheckRefrence()).getAllRefs((BasedataEntityType)this.getModel().getDataEntityType(), this.getModel().getValue("id"))).size() > 0) {
            BaseDataRefenceKey baseData = (BaseDataRefenceKey)allRefList.get(0);
            String refEntityKey = baseData.getRefEntityKey();
            MainEntityType refMainType = EntityMetadataCache.getDataEntityType((String)refEntityKey);
            String billName = refMainType.getDisplayName().toString();
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8be5\u53d6\u4ef7\u65b9\u6848\u5df2\u88ab\u201c%s\u201d\u5f15\u7528\uff0c\u4e0d\u80fd\u5207\u6362\u4ef7\u683c\u6765\u6e90\u5355\u636e\u548c\u53d6\u4ef7\u5355\u636e\u3002", (String)"QuoteSchemePlugin_13", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]), billName));
            PropertyChangeHelper.stopChange(this.getPageCache());
            this.getModel().setValue(property, (Object)dy);
            PropertyChangeHelper.release(this.getPageCache());
            this.getView().updateView(property);
            return true;
        }
        return false;
    }

    private void initConditionEntryByDimension() {
        DynamicObjectCollection dimensionEntrys;
        this.getModel().deleteEntryData("entryentity");
        DynamicObject dimension = (DynamicObject)this.getModel().getValue("pricedimension");
        if (dimension != null && (dimensionEntrys = dimension.getDynamicObjectCollection("entryentity")) != null && dimensionEntrys.size() > 0) {
            this.getModel().batchCreateNewEntryRow("entryentity", dimensionEntrys.size());
            for (int i = 0; i < this.getModel().getEntryRowCount("entryentity"); ++i) {
                DynamicObject dimensionMember = ((DynamicObject)dimensionEntrys.get(i)).getDynamicObject("pricedimmem");
                if (dimensionMember == null) continue;
                String sign = dimensionMember.getString("sign");
                String signName = dimensionMember.getString("signname");
                this.getModel().setValue("sourcesign", (Object)sign, i);
                this.getModel().setValue("sourcesignname", (Object)signName, i);
                if ("kitnumber".equals(sign) || "featurevalue".equals(sign)) {
                    this.getModel().setValue("quotesign", (Object)"configuredcode", i);
                    MainEntityType priceModeType = EntityMetadataCache.getDataEntityType((String)"msbd_pricetax_expenses");
                    IDataEntityProperty configuredField = (IDataEntityProperty)priceModeType.getFields().get("configuredcode");
                    if (configuredField != null) {
                        this.getModel().setValue("quotesignname", (Object)configuredField.getDisplayName(), i);
                    }
                } else {
                    this.getModel().setValue("quotesign", (Object)sign, i);
                    this.getModel().setValue("quotesignname", (Object)signName, i);
                }
                this.getModel().setValue("issumdimension", (Object)Boolean.TRUE, i);
            }
        }
    }

    private boolean isDimensionMode() {
        return this.getModel().getValue("quoteentity") != null && "msbd_pricetax_expenses".equals(((DynamicObject)this.getModel().getValue("quoteentity")).getString("number"));
    }

    private boolean checkIsEmpty(String field, String msg) {
        DynamicObject bill = (DynamicObject)this.getModel().getValue(field);
        if (bill == null) {
            this.getView().showTipNotification(msg);
            return true;
        }
        return false;
    }

    private String reduceFieldName(String fieldCaption) {
        String[] fieldCaption_sub;
        if (this.isDimensionMode() && (fieldCaption_sub = fieldCaption.split("\\.")).length >= 2) {
            int index = fieldCaption.indexOf(46, 0);
            fieldCaption = fieldCaption.substring(index + 1);
        }
        return fieldCaption;
    }

    private boolean checkSchemeGroupPrice(int row) {
        IDataEntityProperty iDataEntityProperty = this.getPriceSourceFieldProperty(row);
        if (iDataEntityProperty == null) {
            return false;
        }
        Class type = iDataEntityProperty.getPropertyType();
        return type != null && BigDecimal.class.isAssignableFrom(type);
    }
}

