/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.pricemodel.formplugin.quote;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.botp.BillTreeBuildParameter;
import kd.bos.designer.botp.EntityParseHelper;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.property.AmountProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.PriceProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.mpscmm.msbd.common.enums.StatusEnum;
import kd.mpscmm.msbd.common.utils.CommonUtils;
import kd.mpscmm.msbd.pricemodel.business.helper.PriceHelper;
import kd.mpscmm.msbd.pricemodel.business.helper.advanceprice.AdvancedPricingHelper;
import kd.mpscmm.msbd.pricemodel.business.helper.quote.QuoteHelper;

public class QuoteStrategyPlugin
extends AbstractBasePlugIn
implements BeforeF7SelectListener {
    private static final String ACTIONID = "mulcombofield";
    private static final Log logger = LogFactory.getLog(QuoteStrategyPlugin.class);
    private static final String SM_SALEPRICELIST = "sm_salepricelist";
    private static final String PM_PURPRICELIST = "pm_purpricelist";
    private static final String CONM_PURCONTRACT = "conm_purcontract";
    private static final String CONM_SALCONTRACT = "conm_salcontract";

    public void registerListener(EventObject e) {
        BasedataEdit calcStrategyF7;
        BasedataEdit quoteSchemeF7;
        BasedataEdit quoteEntity;
        super.registerListener(e);
        if (this.getView().getControl("qu_preconditiondesc") != null) {
            this.addClickListeners(new String[]{"qu_preconditiondesc"});
        }
        if (this.getView().getControl("pricesourceprecondesc") != null) {
            this.addClickListeners(new String[]{"pricesourceprecondesc"});
        }
        if (this.getView().getControl("terminationsigndesc") != null) {
            this.addClickListeners(new String[]{"terminationsigndesc"});
        }
        if (this.getView().getControl("qs_preconditiondesc") != null) {
            this.addClickListeners(new String[]{"qs_preconditiondesc"});
        }
        if ((quoteEntity = (BasedataEdit)this.getView().getControl("quotebill")) != null) {
            quoteEntity.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((quoteSchemeF7 = (BasedataEdit)this.getView().getControl("quotescheme")) != null) {
            quoteSchemeF7.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((calcStrategyF7 = (BasedataEdit)this.getView().getControl("calstrategy")) != null) {
            calcStrategyF7.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control c = (Control)evt.getSource();
        if (c.getKey().equalsIgnoreCase("qu_preconditiondesc")) {
            this.showCondition();
        }
        if (c.getKey().equalsIgnoreCase("pricesourceprecondesc")) {
            this.showSourceCondition();
        }
        if (c.getKey().equalsIgnoreCase("terminationsigndesc")) {
            this.showResultField();
        }
        if (c.getKey().equalsIgnoreCase("qs_preconditiondesc")) {
            this.showQsCondition();
        }
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs e) {
        String entryName = e.getEntryProp().getName();
        if ("conditionentryentity".equals(entryName)) {
            int[] selectRows;
            for (int rowIndex : selectRows = e.getRowIndexs()) {
                DynamicObject quoteBill = (DynamicObject)this.getModel().getValue("quotebill", rowIndex);
                if (!this.checkRef(quoteBill, true)) continue;
                e.setCancel(true);
                return;
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key = e.getProperty().getName();
        DynamicObject createorg = (DynamicObject)this.getModel().getValue("createorg");
        if (createorg == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u521b\u5efa\u7ec4\u7ec7\u3002", (String)"QuoteStrategyPlugin_0", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
        switch (key) {
            case "quotebill": {
                DynamicObject quoteBill = (DynamicObject)this.getModel().getValue("quotebill", e.getRow());
                if (this.checkRef(quoteBill, false)) {
                    e.setCancel(true);
                    return;
                }
                String appID = this.getModel().getDataEntityType() != null ? this.getModel().getDataEntityType().getAppId() : "";
                QuoteHelper.registerQuoteBill(e, appID, true);
                break;
            }
            case "quotescheme": 
            case "calstrategy": {
                ListShowParameter listParameter = (ListShowParameter)e.getFormShowParameter();
                listParameter.getCustomParams().put("schemeList_isFrom_strategyF7", "1");
                if (this.isDimensionMode()) {
                    List filters = listParameter.getListFilterParameter().getQFilters();
                    if (filters.size() > 0) {
                        listParameter.getListFilterParameter().setFilter(((QFilter)listParameter.getListFilterParameter().getQFilters().get(0)).and(this.getQuoteF7()));
                        break;
                    }
                    listParameter.getListFilterParameter().setFilter(this.getQuoteF7());
                    break;
                }
                List filters = listParameter.getListFilterParameter().getQFilters();
                QFilter oldModeFilter = new QFilter("quoteentity", "!=", (Object)"msbd_pricetax_expenses");
                if (filters.size() > 0) {
                    listParameter.getListFilterParameter().setFilter(((QFilter)listParameter.getListFilterParameter().getQFilters().get(0)).and(oldModeFilter));
                    break;
                }
                listParameter.getListFilterParameter().setFilter(oldModeFilter);
                break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        FormOperate source = (FormOperate)args.getSource();
        String itemKey = source.getOperateKey();
        if ("save".equals(itemKey) || "submit".equals(itemKey)) {
            DynamicObject bill = this.getModel().getDataEntity(true);
            DynamicObjectCollection conditionList = bill.getDynamicObjectCollection("conditionentryentity");
            int entrySize = conditionList.size();
            for (int i = entrySize - 1; i >= 0; --i) {
                DynamicObject row = (DynamicObject)conditionList.get(i);
                DynamicObject quoteBill = row.getDynamicObject("quotebill");
                if (quoteBill != null) continue;
                conditionList.remove(i);
            }
            DynamicObjectCollection quoteSchemeList = bill.getDynamicObjectCollection("entryentity");
            entrySize = quoteSchemeList.size();
            for (int i = entrySize - 1; i >= 0; --i) {
                DynamicObject row = (DynamicObject)quoteSchemeList.get(i);
                DynamicObject quoteScheme = row.getDynamicObject("quotescheme");
                if (quoteScheme != null) continue;
                quoteSchemeList.remove(i);
            }
            DynamicObjectCollection calcStrategyList = bill.getDynamicObjectCollection("calentry");
            entrySize = calcStrategyList.size();
            for (int i = entrySize - 1; i >= 0; --i) {
                DynamicObject row = (DynamicObject)calcStrategyList.get(i);
                DynamicObject calStrategy = row.getDynamicObject("calstrategy");
                if (calStrategy != null) continue;
                calcStrategyList.remove(i);
            }
            this.getView().updateView("conditionentryentity");
            this.getView().updateView("entryentity");
            this.getView().updateView("calentry");
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        if (Boolean.TRUE.equals(this.getModel().getValue("ispreset"))) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"bar_unaudit"});
        }
        if (StatusEnum.SAVE.getValue().equals(this.getModel().getValue("status")) && Boolean.FALSE.equals(this.getModel().getValue("ispreset"))) {
            this.getView().setEnable(Boolean.TRUE, new String[]{"number"});
        }
        if (this.isDimensionMode()) {
            ((BasedataEdit)this.getView().getControl("quotebill")).setMustInput(true);
        } else {
            ((BasedataEdit)this.getView().getControl("quotebill")).setMustInput(false);
        }
        AtomicBoolean change = new AtomicBoolean(false);
        this.loadConditonEntryCaption(change);
        this.loadSchemeEntryCaption(change);
        if (change.get()) {
            this.getModel().setDataChanged(false);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        Object newValue = changeSet[0].getNewValue();
        if (CommonUtils.isRealChanged((ChangeData)changeSet[0])) {
            switch (key) {
                case "quotescheme": {
                    int index = 0;
                    int index_c = 1;
                    for (int j = 0; j < changeSet.length; ++j) {
                        String number;
                        List<String[]> list;
                        int row = changeSet[j].getRowIndex();
                        DynamicObject quotescheme = (DynamicObject)this.getModel().getValue("quotescheme", row);
                        this.getModel().setValue("terminationsigndesc", null, row);
                        this.getModel().setValue("terminationsign", null, row);
                        this.getModel().setValue("qu_preconditiondesc", null, row);
                        this.getModel().setValue("qu_precondition", null, row);
                        this.getModel().setValue("preconditionjson_tag", null, row);
                        this.getModel().setValue("pricesourceprecondesc", null, row);
                        this.getModel().setValue("pricesourceprecon_tag", null, row);
                        if (quotescheme == null) continue;
                        DynamicObject priceSourceEntity = quotescheme.getDynamicObject("pricesourceentity");
                        if (priceSourceEntity != null) {
                            try {
                                FilterBuilder filterBuilder;
                                String entityId = (String)priceSourceEntity.getPkValue();
                                IDataModel model = this.getModel();
                                if (SM_SALEPRICELIST.equals(entityId) || PM_PURPRICELIST.equals(entityId)) {
                                    String priceListFilterJson = AdvancedPricingHelper.getPriceListFilterJson();
                                    model.setValue("pricesourceprecondesc", (Object)AdvancedPricingHelper.getConditionExprDesc(priceListFilterJson), row);
                                    model.setValue("pricesourceprecon_tag", (Object)priceListFilterJson, row);
                                    filterBuilder = PriceHelper.convertFullStringToQFilter(priceListFilterJson, entityId);
                                    filterBuilder.buildFilter();
                                    model.setValue("pricesourceprecondesc", (Object)filterBuilder.getFilterStringDesc(), row);
                                } else if (CONM_PURCONTRACT.equals(entityId) || CONM_SALCONTRACT.equals(entityId)) {
                                    String contractFilterJson = AdvancedPricingHelper.getContractFilterJson();
                                    model.setValue("pricesourceprecondesc", (Object)AdvancedPricingHelper.getConditionExprDesc(contractFilterJson), row);
                                    model.setValue("pricesourceprecon_tag", (Object)contractFilterJson, row);
                                    filterBuilder = PriceHelper.convertFullStringToQFilter(contractFilterJson, entityId);
                                    filterBuilder.buildFilter();
                                    model.setValue("pricesourceprecondesc", (Object)filterBuilder.getFilterStringDesc(), row);
                                } else {
                                    IDataEntityProperty billStatus;
                                    FilterBuilder filterBuilder2;
                                    MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)entityId);
                                    if (dataEntityType instanceof BasedataEntityType) {
                                        IDataEntityProperty enable = dataEntityType.findProperty("enable");
                                        if (enable != null) {
                                            String baseDataFilterJson = AdvancedPricingHelper.getBaseDataFilterJson();
                                            model.setValue("pricesourceprecondesc", (Object)AdvancedPricingHelper.getConditionExprDesc(baseDataFilterJson), row);
                                            model.setValue("pricesourceprecon_tag", (Object)baseDataFilterJson, row);
                                            filterBuilder2 = PriceHelper.convertFullStringToQFilter(baseDataFilterJson, entityId);
                                            filterBuilder2.buildFilter();
                                            model.setValue("pricesourceprecondesc", (Object)filterBuilder2.getFilterStringDesc(), row);
                                        }
                                    } else if (dataEntityType instanceof BillEntityType && (billStatus = dataEntityType.findProperty("billstatus")) != null) {
                                        String billFilterJson = AdvancedPricingHelper.getBillFilterJson();
                                        model.setValue("pricesourceprecondesc", (Object)AdvancedPricingHelper.getConditionExprDesc(billFilterJson), row);
                                        model.setValue("pricesourceprecon_tag", (Object)billFilterJson, row);
                                        filterBuilder2 = PriceHelper.convertFullStringToQFilter(billFilterJson, entityId);
                                        filterBuilder2.buildFilter();
                                        model.setValue("pricesourceprecondesc", (Object)filterBuilder2.getFilterStringDesc(), row);
                                    }
                                }
                            }
                            catch (Exception ea) {
                                logger.info("scheme sourcefilter tansfer fail");
                            }
                        }
                        if ((list = this.queryField(number = quotescheme.getString("number"))).size() == 0) {
                            this.getModel().setValue("terminationsigndesc", null, row);
                            this.getModel().setValue("terminationsign", null, row);
                            continue;
                        }
                        String value = list.get(index)[index];
                        String sign = list.get(index)[index_c];
                        this.getModel().setValue("terminationsigndesc", (Object)value, row);
                        this.getModel().setValue("terminationsign", (Object)sign, row);
                    }
                    break;
                }
                case "quotebill": {
                    for (int j = 0; j < changeSet.length; ++j) {
                        int row = changeSet[j].getRowIndex();
                        this.getModel().setValue("qs_preconditiondesc", null, row);
                        this.getModel().setValue("qs_precondition", null, row);
                        this.getModel().setValue("qs_precondition_tag", null, row);
                    }
                    break;
                }
                case "qu_preconditiondesc": {
                    int row = this.getModel().getEntryCurrentRowIndex("entryentity");
                    if (newValue != null && !"".equals(newValue)) break;
                    this.getModel().setValue("preconditionjson_tag", null, row);
                    this.getModel().setValue("qu_precondition", null, row);
                    break;
                }
                case "pricesourceprecondesc": {
                    int rowx = this.getModel().getEntryCurrentRowIndex("entryentity");
                    if (newValue != null && !"".equals(newValue)) break;
                    this.getModel().setValue("pricesourceprecon_tag", null, rowx);
                    break;
                }
                case "qs_preconditiondesc": {
                    int rowC = this.getModel().getEntryCurrentRowIndex("conditionentryentity");
                    if (newValue != null && !"".equals(newValue)) break;
                    this.getModel().setValue("qs_precondition_tag", null, rowC);
                    this.getModel().setValue("qs_precondition", null, rowC);
                    break;
                }
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        if (e.getActionId().equalsIgnoreCase("qu_preconditiondesc")) {
            this.receiveCondition((String)e.getReturnData(), "entryentity", "preconditionjson_tag", "qu_preconditiondesc");
        }
        if (e.getActionId().equalsIgnoreCase("pricesourceprecondesc")) {
            this.receiveCondition((String)e.getReturnData(), "entryentity", "pricesourceprecon_tag", "pricesourceprecondesc");
        }
        if (e.getActionId().equalsIgnoreCase("qs_preconditiondesc")) {
            this.receiveCondition((String)e.getReturnData(), "conditionentryentity", "qs_precondition_tag", "qs_preconditiondesc");
        }
        if (e.getActionId().equalsIgnoreCase(ACTIONID)) {
            Object returnData = e.getReturnData();
            if (returnData == null) {
                return;
            }
            Map map = (Map)returnData;
            this.getModel().setValue("terminationsigndesc", map.get("terminationsigndesc"));
            this.getModel().setValue("terminationsign", map.get("terminationsign"));
        }
    }

    private void showResultField() {
        int row = this.getModel().getEntryCurrentRowIndex("entryentity");
        DynamicObject quotescheme = (DynamicObject)this.getModel().getValue("quotescheme", row);
        String sign = (String)this.getModel().getValue("terminationsign", row);
        if (quotescheme == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u53d6\u4ef7\u65b9\u6848\u3002", (String)"QuoteStrategyPlugin_1", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]));
            return;
        }
        String number = quotescheme.getString("number");
        List<String[]> list = this.queryField(number);
        this.showDynForm(list, sign);
    }

    private List<String[]> queryField(String number) {
        ArrayList<String[]> list;
        block8: {
            String sourcesign;
            String quoteSignnamer;
            DynamicObjectCollection entryentity;
            QFilter filter = new QFilter("number", "=", (Object)number);
            filter.and(new QFilter("status", "=", (Object)"C"));
            filter.and(new QFilter("enable", "=", (Object)"1"));
            DynamicObject[] plat_quoteschemes = BusinessDataServiceHelper.load((String)"plat_quotescheme", (String)"name,quoteentity,pricesourceentity,sourcesignr,sourcesignnamer,quotesignnamer,isnewmode", (QFilter[])new QFilter[]{filter});
            list = new ArrayList<String[]>();
            HashSet<String> sourcesignSet = new HashSet<String>();
            if (plat_quoteschemes.length <= 0) break block8;
            DynamicObject plat_quotescheme = plat_quoteschemes[0];
            String priceSourceEntity_number = plat_quotescheme.getDynamicObject("pricesourceentity").getString("number");
            Map<Object, Object> fieldMapping = new HashMap();
            if (QuoteHelper.isDimensionMode(plat_quotescheme)) {
                HashSet<String> priceSourceBillSet = new HashSet<String>();
                priceSourceBillSet.add(priceSourceEntity_number);
                Map<String, Map<String, String>> billMap = QuoteHelper.buildBillMapping(priceSourceBillSet);
                fieldMapping = billMap.get(priceSourceEntity_number);
            }
            MainEntityType sourceDataEntityType = EntityMetadataCache.getDataEntityType((String)priceSourceEntity_number);
            Map quoteEntity = sourceDataEntityType.getAllFields();
            Iterator iterator = quoteEntity.entrySet().iterator();
            ArrayList<String> filed = new ArrayList<String>();
            ArrayList<String> filedNames = new ArrayList<String>();
            while (iterator.hasNext()) {
                Map.Entry next = iterator.next();
                String key = (String)next.getKey();
                IDataEntityProperty property = sourceDataEntityType.findProperty(key);
                IDataEntityProperty value = (IDataEntityProperty)next.getValue();
                if (!(value instanceof PriceProp) && !(value instanceof AmountProp) || property == null) continue;
                filedNames.add(EntityParseHelper.buildPropFullCaption((EntityType)sourceDataEntityType, (String)key));
                String parentName = property.getParent().getName();
                key = this.getEntryFullField(sourceDataEntityType, property.getName(), priceSourceEntity_number, parentName);
                filed.add(key);
            }
            if (QuoteHelper.isDimensionMode(plat_quotescheme)) {
                entryentity = plat_quotescheme.getDynamicObjectCollection("entryresult");
                for (DynamicObject entity : entryentity) {
                    quoteSignnamer = entity.getString("quotesignnamer");
                    if (!StringUtils.isNotEmpty((CharSequence)quoteSignnamer)) continue;
                    sourcesign = entity.getString("sourcesignr");
                    if (fieldMapping != null) {
                        sourcesign = (String)fieldMapping.get(sourcesign);
                    }
                    if (StringUtils.isEmpty((CharSequence)sourcesign)) {
                        String sourceSignname = this.getCaption(entity.getString("sourcesignr"), EntityMetadataCache.getDataEntityType((String)"msbd_pricetax_expenses"));
                        String message = String.format(ResManager.loadKDString((String)"\u53d6\u4ef7\u65b9\u6848\u201c%1$s\u201d\u7684\u201c\u53d6\u4ef7\u7ed3\u679c\u6620\u5c04\u5206\u5f55\u201d\u6765\u6e90\u5b9e\u4f53\u5b57\u6bb5\u89e3\u6790\u5931\u8d25\uff0c\u672a\u7ef4\u62a4\u4ef7\u683c\u6765\u6e90\u201c%2$s\u201d\u4e0e\u4ef7\u683c\u6a21\u578b\u5b57\u6bb5\u201c%3$s\u201d\u7684\u901a\u7528\u6620\u5c04\u914d\u7f6e\u6216\u914d\u7f6e\u6709\u8bef\u3002", (String)"QuoteSchemeInfo_5", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]), plat_quotescheme.getString("name"), sourceDataEntityType.getDisplayName(), sourceSignname);
                        throw new KDBizException(message);
                    }
                    if (!filed.contains(sourcesign) || !sourcesignSet.add(sourcesign)) continue;
                    String[] string = new String[]{(String)filedNames.get(filed.indexOf(sourcesign)), sourcesign};
                    list.add(string);
                }
            } else {
                entryentity = plat_quotescheme.getDynamicObjectCollection("entryresult");
                for (DynamicObject entity : entryentity) {
                    quoteSignnamer = entity.getString("quotesignnamer");
                    if (!StringUtils.isNotEmpty((CharSequence)quoteSignnamer)) continue;
                    sourcesign = entity.getString("sourcesignr");
                    String sourceSignname = this.getCaption(sourcesign, sourceDataEntityType);
                    if (!filed.contains(sourcesign) || !sourcesignSet.add(sourcesign)) continue;
                    String[] string = new String[]{sourceSignname, sourcesign};
                    list.add(string);
                }
            }
        }
        return list;
    }

    private void showDynForm(List<String[]> list, String sign) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("plat_quotesignsetting");
        String jsonString = SerializationUtils.toJsonString(list);
        parameter.setCustomParam("priceresultfieldlist", (Object)jsonString);
        if (StringUtils.isNotEmpty((CharSequence)sign)) {
            parameter.setCustomParam("sign", (Object)sign);
        }
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, ACTIONID));
        this.getView().showForm(parameter);
    }

    private void showCondition() {
        int row = this.getModel().getEntryCurrentRowIndex("entryentity");
        DynamicObject quotescheme = (DynamicObject)this.getModel().getValue("quotescheme", row);
        if (quotescheme == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u53d6\u4ef7\u65b9\u6848\u3002", (String)"QuoteStrategyPlugin_1", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]));
            return;
        }
        DynamicObject quoteentity1 = quotescheme.getDynamicObject("quoteentity");
        String number = quoteentity1.getString("number");
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)number);
        String conditionJson = (String)this.getModel().getValue("preconditionjson_tag", row);
        String conditionJsonOld = (String)this.getModel().getValue("qu_precondition", row);
        if (StringUtils.isBlank((CharSequence)conditionJson) && StringUtils.isNotBlank((CharSequence)conditionJsonOld)) {
            conditionJson = conditionJsonOld;
        }
        BillTreeBuildParameter parameter = new BillTreeBuildParameter(dataEntityType);
        TreeNode treeNode = EntityParseHelper.buildBillTreeNodes((BillTreeBuildParameter)parameter);
        String flsNodes = SerializationUtils.toJsonString((Object)treeNode);
        this.showConditionForm(conditionJson, dataEntityType.getName(), flsNodes, "qu_preconditiondesc");
    }

    private void showSourceCondition() {
        int row = this.getModel().getEntryCurrentRowIndex("entryentity");
        DynamicObject quotescheme = (DynamicObject)this.getModel().getValue("quotescheme", row);
        if (quotescheme == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u53d6\u4ef7\u65b9\u6848\u3002", (String)"QuoteStrategyPlugin_1", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]));
            return;
        }
        DynamicObject souceentity = quotescheme.getDynamicObject("pricesourceentity");
        String number = souceentity.getString("number");
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)number);
        String conditionJson = (String)this.getModel().getValue("pricesourceprecon_tag", row);
        BillTreeBuildParameter parameter = new BillTreeBuildParameter(dataEntityType);
        TreeNode treeNode = EntityParseHelper.buildBillTreeNodes((BillTreeBuildParameter)parameter);
        String flsNodes = SerializationUtils.toJsonString((Object)treeNode);
        this.showConditionForm(conditionJson, dataEntityType.getName(), flsNodes, "pricesourceprecondesc");
    }

    private void showQsCondition() {
        int row = this.getModel().getEntryCurrentRowIndex("conditionentryentity");
        DynamicObject quoteBill = (DynamicObject)this.getModel().getValue("quotebill", row);
        if (quoteBill == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u53d6\u4ef7\u5355\u636e\u3002", (String)"QuoteStrategyPlugin_2", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]));
            return;
        }
        String number = quoteBill.getString("number");
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)number);
        String conditionJson = (String)this.getModel().getValue("qs_precondition_tag", row);
        BillTreeBuildParameter parameter = new BillTreeBuildParameter(dataEntityType);
        TreeNode treeNode = EntityParseHelper.buildBillTreeNodes((BillTreeBuildParameter)parameter);
        String flsNodes = SerializationUtils.toJsonString((Object)treeNode);
        this.showConditionForm(conditionJson, dataEntityType.getName(), flsNodes, "qs_preconditiondesc");
    }

    private void showConditionForm(String conditionJson, String entityNumber, String fieldNodes, String sourceCtrlKey) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("msbd_pricecondition");
        showParameter.getCustomParams().put("formula", conditionJson);
        showParameter.getCustomParams().put("entitynumber", entityNumber);
        showParameter.getCustomParams().put("treenodes", fieldNodes);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, sourceCtrlKey));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    private void receiveCondition(String conditionJson, String entryEntityKey, String conditionFldKey, String descFldKey) {
        if (StringUtils.isNotBlank((CharSequence)conditionJson)) {
            CRCondition condition = (CRCondition)SerializationUtils.fromJsonString((String)conditionJson, CRCondition.class);
            String exprTran = condition.getExprDesc();
            if (StringUtils.isBlank((CharSequence)entryEntityKey)) {
                this.getModel().setValue(conditionFldKey, (Object)conditionJson);
                this.getModel().setValue(descFldKey, (Object)exprTran);
            } else {
                DynamicObject quoteBill;
                DynamicObject sourcebill;
                FilterBuilder fb;
                DynamicObject quotebill;
                DynamicObject scheme;
                int row = this.getModel().getEntryCurrentRowIndex(entryEntityKey);
                this.getModel().setValue(conditionFldKey, (Object)conditionJson, row);
                this.getModel().setValue(descFldKey, (Object)exprTran, row);
                if (descFldKey.equals("qu_preconditiondesc") && (scheme = (DynamicObject)this.getModel().getValue("quotescheme", row)) != null && (quotebill = scheme.getDynamicObject("quoteentity")) != null) {
                    fb = new FilterBuilder(EntityMetadataCache.getDataEntityType((String)((String)quotebill.getPkValue())), condition.getFilterCondition());
                    fb.buildFilter();
                    this.getModel().setValue(descFldKey, (Object)fb.getFilterStringDesc(), row);
                }
                if (descFldKey.equals("pricesourceprecondesc") && (scheme = (DynamicObject)this.getModel().getValue("quotescheme", row)) != null && (sourcebill = scheme.getDynamicObject("pricesourceentity")) != null) {
                    fb = new FilterBuilder(EntityMetadataCache.getDataEntityType((String)((String)sourcebill.getPkValue())), condition.getFilterCondition());
                    fb.buildFilter();
                    this.getModel().setValue(descFldKey, (Object)fb.getFilterStringDesc(), row);
                }
                if (descFldKey.equals("qs_preconditiondesc") && (quoteBill = (DynamicObject)this.getModel().getValue("quotebill", row)) != null) {
                    FilterBuilder fb2 = new FilterBuilder(EntityMetadataCache.getDataEntityType((String)((String)quoteBill.getPkValue())), condition.getFilterCondition());
                    fb2.buildFilter();
                    this.getModel().setValue(descFldKey, (Object)fb2.getFilterStringDesc(), row);
                }
            }
        }
    }

    private String getEntryFullField(MainEntityType tgtMainType, String fieldId, String srcBillId, String parentName) {
        while (!srcBillId.equals(parentName)) {
            fieldId = parentName.concat(".").concat(fieldId);
            IDataEntityProperty parentProp = tgtMainType.findProperty(parentName);
            if (parentProp.getParent() == null) break;
            parentName = parentProp.getParent().getName();
        }
        return fieldId;
    }

    private boolean isDimensionMode() {
        return Boolean.TRUE.equals(this.getModel().getValue("isnewmode"));
    }

    private QFilter getQuoteF7() {
        QFilter newModeFilter = new QFilter("quoteentity", "=", (Object)"msbd_pricetax_expenses");
        DynamicObjectCollection conditonEntry = this.getModel().getEntryEntity("conditionentryentity");
        HashSet<Object> quoteBills = new HashSet<Object>();
        if (conditonEntry != null) {
            for (DynamicObject conditon : conditonEntry) {
                if (conditon.getDynamicObject("quotebill") == null) continue;
                DynamicObject quoteBill = conditon.getDynamicObject("quotebill");
                quoteBills.add(quoteBill.getPkValue());
            }
        }
        if (quoteBills.size() > 0) {
            return newModeFilter.or(new QFilter("quoteentity", "in", quoteBills));
        }
        return newModeFilter;
    }

    private boolean checkRef(DynamicObject quoteBill, boolean isDeleteRow) {
        if (quoteBill != null && this.isDimensionMode()) {
            DynamicObject quotebillx;
            int i;
            int count = this.getModel().getEntryRowCount("entryentity");
            for (i = 0; i < count; ++i) {
                DynamicObject quoteScheme = (DynamicObject)this.getModel().getValue("quotescheme", i);
                if (quoteScheme == null || (quotebillx = quoteScheme.getDynamicObject("quoteentity")) == null || !quotebillx.getString("id").equals(quoteBill.getString("id"))) continue;
                if (isDeleteRow) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u9009\u4e2d\u7684\u524d\u7f6e\u6761\u4ef6\u884c\u5728\u65b9\u6848\u6392\u5e8f\u5206\u5f55\u4e2d\u5b58\u5728\u5bf9\u5e94\u7684\u53d6\u4ef7\u65b9\u6848\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"QuoteStrategyPlugin_3", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]));
                } else {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u9009\u4e2d\u7684\u524d\u7f6e\u6761\u4ef6\u884c\u5728\u65b9\u6848\u6392\u5e8f\u5206\u5f55\u4e2d\u5b58\u5728\u5bf9\u5e94\u7684\u53d6\u4ef7\u65b9\u6848\uff0c\u4e0d\u5141\u8bb8\u5207\u6362\u3002", (String)"QuoteStrategyPlugin_4", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]));
                }
                return true;
            }
            count = this.getModel().getEntryRowCount("calentry");
            for (i = 0; i < count; ++i) {
                DynamicObject calStrategy = (DynamicObject)this.getModel().getValue("calstrategy", i);
                if (calStrategy == null || (quotebillx = calStrategy.getDynamicObject("quoteentity")) == null || !quotebillx.getString("id").equals(quoteBill.getString("id"))) continue;
                if (isDeleteRow) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u9009\u4e2d\u7684\u524d\u7f6e\u6761\u4ef6\u884c\u5728\u8ba1\u7b97\u6392\u5e8f\u5206\u5f55\u4e2d\u5b58\u5728\u5bf9\u5e94\u7684\u8ba1\u7b97\u7b56\u7565\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"QuoteStrategyPlugin_5", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]));
                } else {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u9009\u4e2d\u7684\u524d\u7f6e\u6761\u4ef6\u884c\u5728\u8ba1\u7b97\u6392\u5e8f\u5206\u5f55\u4e2d\u5b58\u5728\u5bf9\u5e94\u7684\u8ba1\u7b97\u7b56\u7565\uff0c\u4e0d\u5141\u8bb8\u5207\u6362\u3002", (String)"QuoteStrategyPlugin_6", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]));
                }
                return true;
            }
        }
        return false;
    }

    private void loadConditonEntryCaption(AtomicBoolean change) {
        for (int row = 0; row < this.getModel().getEntryRowCount("conditionentryentity"); ++row) {
            String conditonJson;
            DynamicObject quoteBill = (DynamicObject)this.getModel().getValue("quotebill", row);
            if (quoteBill == null || !StringUtils.isNotEmpty((CharSequence)(conditonJson = (String)this.getModel().getValue("qs_precondition_tag", row)))) continue;
            FilterBuilder filterBuilder = PriceHelper.convertFullStringToQFilter(conditonJson, (String)quoteBill.getPkValue());
            filterBuilder.buildFilter();
            this.getModel().setValue("qs_preconditiondesc", (Object)filterBuilder.getFilterStringDesc(), row);
            change.set(true);
        }
    }

    private void loadSchemeEntryCaption(AtomicBoolean change) {
        for (int row = 0; row < this.getModel().getEntryRowCount("entryentity"); ++row) {
            String conditonJson;
            DynamicObject scheme = (DynamicObject)this.getModel().getValue("quotescheme", row);
            if (scheme == null) continue;
            DynamicObject sourcebill = scheme.getDynamicObject("pricesourceentity");
            DynamicObject quotebill = scheme.getDynamicObject("quoteentity");
            if (sourcebill != null) {
                String sourceConditonJson;
                MainEntityType sourceType = MetadataServiceHelper.getDataEntityType((String)((String)sourcebill.getPkValue()));
                String terminateSign = (String)this.getModel().getValue("terminationsign", row);
                if (StringUtils.isNotEmpty((CharSequence)terminateSign)) {
                    String quoteSignName = this.getCaption(terminateSign, sourceType);
                    this.getModel().setValue("terminationsigndesc", (Object)quoteSignName, row);
                    change.set(true);
                }
                if (StringUtils.isNotEmpty((CharSequence)(sourceConditonJson = (String)this.getModel().getValue("pricesourceprecon_tag", row)))) {
                    FilterBuilder filterBuilder = PriceHelper.convertFullStringToQFilter(sourceConditonJson, (String)sourcebill.getPkValue());
                    filterBuilder.buildFilter();
                    this.getModel().setValue("pricesourceprecondesc", (Object)filterBuilder.getFilterStringDesc(), row);
                    change.set(true);
                }
            }
            if (quotebill == null || !StringUtils.isNotEmpty((CharSequence)(conditonJson = (String)this.getModel().getValue("preconditionjson_tag", row)))) continue;
            FilterBuilder filterBuilder = PriceHelper.convertFullStringToQFilter(conditonJson, (String)quotebill.getPkValue());
            filterBuilder.buildFilter();
            this.getModel().setValue("qu_preconditiondesc", (Object)filterBuilder.getFilterStringDesc(), row);
            change.set(true);
        }
    }

    private String getCaption(String terminateSign, MainEntityType entityType) {
        String[] fieldCaption_sub;
        int index;
        String tempFieldId;
        IDataEntityProperty findProperty;
        String[] terminateSign_sub = terminateSign.split("\\.");
        if (terminateSign_sub.length > 1 && (findProperty = entityType.findProperty(tempFieldId = terminateSign_sub[0])) instanceof EntryProp) {
            index = terminateSign.indexOf(46, 0);
            terminateSign = terminateSign.substring(index + 1);
        }
        String quoteSignName = EntityParseHelper.buildPropFullCaption((EntityType)entityType, (String)terminateSign);
        if ("msbd_pricetax_expenses".equals(entityType.getName()) && (fieldCaption_sub = quoteSignName.split("\\.")).length >= 2) {
            index = quoteSignName.indexOf(46, 0);
            quoteSignName = quoteSignName.substring(index + 1);
        }
        return quoteSignName;
    }
}

