/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.pricemodel.opplugin;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.OpBizRuleSetServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.mpscmm.msbd.pricemodel.common.enums.PriceServiceEnum;
import kd.mpscmm.msbd.pricemodel.opplugin.PriceServiceRegisterStatusValidator;

public class PriceServiceRegisterRemoveOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("service");
        e.getFieldKeys().add("enable");
        e.getFieldKeys().add("controlpoint");
        e.getFieldKeys().add("bizentity");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new PriceServiceRegisterStatusValidator());
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        DynamicObject[] datas = e.getDataEntities();
        if (datas != null) {
            for (DynamicObject data : datas) {
                String service = data.getString("service");
                DynamicObject bizEntityObj = data.getDynamicObject("bizentity");
                QFilter serviceFilter = new QFilter("service", "=", (Object)service);
                QFilter bizEntityFilter = new QFilter("bizentity", "=", bizEntityObj.getPkValue());
                QFilter enableFilter = new QFilter("enable", "=", (Object)Boolean.TRUE);
                if (QueryServiceHelper.exists((String)this.billEntityType.getName(), (QFilter[])new QFilter[]{serviceFilter, bizEntityFilter, enableFilter}) || !StringUtils.isNotEmpty((String)service) || bizEntityObj == null) continue;
                String serviceSign = PriceServiceEnum.getServiceSign(service);
                String entityNumber = bizEntityObj.getString("id");
                OpBizRuleSetServiceHelper.deleteOpBizRuleSet((String)entityNumber, (String)serviceSign);
            }
        }
    }
}

