/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.pricemodel.opplugin.advanceprice;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.mpscmm.msbd.pricemodel.business.helper.advanceprice.AdvancedPricingHelper;

public class PriceProcessSaveValidator
extends AbstractValidator {
    public void validate() {
        for (ExtendedDataEntity data : this.dataEntities) {
            DynamicObject priceProcess = data.getDataEntity();
            DynamicObject quoteEntity = priceProcess.getDynamicObject("quoteentity");
            String number = quoteEntity.getString("number");
            MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)number);
            Map allFieldList = entityType.getAllFields();
            DynamicObjectCollection factorList = priceProcess.getDynamicObjectCollection("factor");
            for (int i = 0; i < factorList.size(); ++i) {
                DynamicObject rowFactor = (DynamicObject)factorList.get(i);
                BigDecimal price = rowFactor.getBigDecimal("price");
                if (price != null) continue;
                rowFactor.set("price", (Object)BigDecimal.ZERO);
            }
            DynamicObjectCollection formulaRow = priceProcess.getDynamicObjectCollection("calformula");
            for (int i = 0; i < formulaRow.size(); ++i) {
                DynamicObject row = (DynamicObject)formulaRow.get(i);
                String quoteSign = row.getString("quotesign");
                if (StringUtils.isBlank((CharSequence)quoteSign)) continue;
                quoteSign = AdvancedPricingHelper.subEntryField(quoteSign, entityType);
                IDataEntityProperty property = (IDataEntityProperty)allFieldList.get(quoteSign);
                BigDecimal fieldPropertyMin = AdvancedPricingHelper.getFieldPropertyMin(property);
                BigDecimal fieldPropertyMax = AdvancedPricingHelper.getFieldPropertyMax(property);
                BigDecimal priceResult = row.getBigDecimal("priceresult");
                if (priceResult == null) {
                    row.set("priceresult", (Object)BigDecimal.ZERO);
                    continue;
                }
                boolean checkRange = AdvancedPricingHelper.checkRange(fieldPropertyMin, fieldPropertyMax, priceResult);
                priceResult = priceResult.setScale(10, RoundingMode.HALF_UP);
                if (checkRange) continue;
                String range = AdvancedPricingHelper.getRange(fieldPropertyMin, fieldPropertyMax);
                String tipMsg = String.format(ResManager.loadKDString((String)"\u8fd4\u56de\u6570\u636e\u5931\u8d25\uff0c\u201c\u8ba1\u7b97\u516c\u5f0f\u201d\u7b2c%1$s\u884c\uff0c\u5b57\u6bb5\u201c\u7ed3\u679c\u201d\u7684\u503c%2$s\u8d85\u51fa\u9650\u5b9a\u8303\u56f4%3$s\u3002", (String)"PriceProcessSaveValidator_0", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]), i + 1, priceResult, range);
                this.addErrorMessage(data, tipMsg);
            }
        }
    }
}

