/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.pricemodel.opplugin.quote;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Field;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mpscmm.msbd.pricemodel.business.helper.advanceprice.AdvancedPricingHelper;
import kd.mpscmm.msbd.pricemodel.business.helper.quote.QuoteOtherHelper;
import kd.mpscmm.msbd.pricemodel.common.enums.OperatorEnum;

public class QuoteSchemeSubmitValidator
extends AbstractValidator {
    private static final Log logger = LogFactory.getLog(QuoteSchemeSubmitValidator.class);

    public void validate() {
        for (ExtendedDataEntity data : this.dataEntities) {
            DynamicObject bill = data.getDataEntity();
            this.addMessage(data, bill);
        }
    }

    private void addMessage(ExtendedDataEntity data, DynamicObject bill) {
        if (bill.getDynamicObject("pricesourceentity") == null) {
            return;
        }
        if (bill.getDynamicObject("quoteentity") == null) {
            return;
        }
        this.conditionTypeCheck(data, bill);
        this.resultTypeCheck(data, bill);
        this.fieldBigDecimalCheck(data, bill);
    }

    private void fieldBigDecimalCheck(ExtendedDataEntity data, DynamicObject bill) {
        DynamicObjectCollection entries = bill.getDynamicObjectCollection("entryresult");
        if (entries != null && entries.size() > 0) {
            String sourceEntity = QuoteOtherHelper.getPriceSourceEntity(bill);
            if (StringUtils.isEmpty((CharSequence)sourceEntity)) {
                return;
            }
            MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)sourceEntity);
            int row = 0;
            for (DynamicObject entry : entries) {
                String sourceSign;
                ++row;
                boolean schemeGroupPrice = entry.getBoolean("schemegroupprice");
                if (!schemeGroupPrice || !StringUtils.isNotEmpty((CharSequence)(sourceSign = entry.getString("sourcesignr")))) continue;
                String msg = ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6570\u503c\u7c7b\u578b\u7684\u201c\u4ef7\u683c\u6765\u6e90\u5b57\u6bb5\u201d\u914d\u7f6e\u4e3a\u201d\u4f5c\u4e3a\u65b9\u6848\u7ec4\u4ef7\u683c\u201c\u3002", (String)"QuoteSchemeSubmitValidator_3", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]);
                if (QuoteOtherHelper.isDimensionMode(bill)) {
                    msg = ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6570\u503c\u7c7b\u578b\u7684\u201c\u6765\u6e90\u5b9e\u4f53\u5b57\u6bb5\u201d\u914d\u7f6e\u4e3a\u201c\u4f5c\u4e3a\u65b9\u6848\u7ec4\u4ef7\u683c\u201d\u3002", (String)"QuoteSchemeSubmitValidator_5", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]);
                }
                if (StringUtils.isEmpty((CharSequence)(sourceSign = AdvancedPricingHelper.subEntryField(sourceSign, dataEntityType)))) {
                    this.addMessage(data, msg, ErrorLevel.Error);
                    continue;
                }
                Map allFields = dataEntityType.getAllFields();
                IDataEntityProperty iDataEntityProperty = (IDataEntityProperty)allFields.get(sourceSign);
                if (iDataEntityProperty == null) {
                    this.addMessage(data, msg, ErrorLevel.Error);
                    continue;
                }
                Class type = iDataEntityProperty.getPropertyType();
                if (type != null && BigDecimal.class.isAssignableFrom(type)) continue;
                this.addMessage(data, msg, ErrorLevel.Error);
            }
        }
    }

    private void conditionTypeCheck(ExtendedDataEntity data, DynamicObject bill) {
        if (!QuoteOtherHelper.isDimensionMode(bill)) {
            String sourceEntity = bill.getDynamicObject("pricesourceentity").getString("number");
            String quoteEntity = bill.getDynamicObject("quoteentity").getString("number");
            ArrayList<String> sourceCondition = new ArrayList<String>(16);
            ArrayList<String> quoteCondition = new ArrayList<String>(16);
            DynamicObjectCollection entries = bill.getDynamicObjectCollection("entryentity");
            if (entries != null && entries.size() > 0) {
                for (DynamicObject entry : entries) {
                    String sourceSign = entry.getString("sourcesign");
                    String quoteSign = entry.getString("quotesign");
                    String matchFlag = entry.getString("matchflag");
                    if (!StringUtils.isNotEmpty((CharSequence)sourceSign) || !StringUtils.isNotEmpty((CharSequence)quoteSign) || OperatorEnum.CONFIGURED.getValue().equals(matchFlag)) continue;
                    sourceCondition.add(sourceSign);
                    quoteCondition.add(quoteSign);
                }
                try {
                    if (sourceCondition.size() > 0) {
                        DataSet sourceDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)sourceEntity, (String)String.join((CharSequence)",", sourceCondition), (QFilter[])new QFilter[]{QFilter.of((String)"1!=1", (Object[])new Object[0])}, (String)"id");
                        DataSet quoteDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)quoteEntity, (String)String.join((CharSequence)",", quoteCondition), (QFilter[])new QFilter[]{QFilter.of((String)"1!=1", (Object[])new Object[0])}, (String)"id");
                        Field[] sourceFields = sourceDataSet.getRowMeta().getFields();
                        Field[] quoteFields = quoteDataSet.getRowMeta().getFields();
                        for (int s = 0; s < sourceFields.length; ++s) {
                            Field sourceField = sourceFields[s];
                            Field quoteField = quoteFields[s];
                            if (sourceField.getDataType().equals((Object)quoteField.getDataType())) continue;
                            this.addMessage(data, ResManager.loadKDString((String)"\u53d6\u4ef7\u6761\u4ef6\u6620\u5c04\u5206\u5f55\u5b58\u5728\u201c\u4ef7\u683c\u6765\u6e90\u5b57\u6bb5\u201d\u548c\u201c\u53d6\u4ef7\u5355\u636e\u5b57\u6bb5\u201d\u7c7b\u578b\u4e0d\u5339\u914d\u3002", (String)"QuoteSchemeSubmitValidator_1", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]), ErrorLevel.Error);
                            return;
                        }
                    }
                }
                catch (Exception e) {
                    logger.info("dynamicform exists");
                }
            }
        }
    }

    private void resultTypeCheck(ExtendedDataEntity data, DynamicObject bill) {
        if (!QuoteOtherHelper.isDimensionMode(bill)) {
            String sourceEntity = bill.getDynamicObject("pricesourceentity").getString("number");
            String quoteEntity = bill.getDynamicObject("quoteentity").getString("number");
            ArrayList<String> sourceResult = new ArrayList<String>(16);
            ArrayList<String> quoteResult = new ArrayList<String>(16);
            DynamicObjectCollection entries = bill.getDynamicObjectCollection("entryresult");
            if (entries != null && entries.size() > 0) {
                for (DynamicObject entry : entries) {
                    String sourceSignr = entry.getString("sourcesignr");
                    String quoteSignr = entry.getString("quotesignr");
                    if (!StringUtils.isNotEmpty((CharSequence)sourceSignr) || !StringUtils.isNotEmpty((CharSequence)quoteSignr)) continue;
                    sourceResult.add(sourceSignr);
                    quoteResult.add(quoteSignr);
                }
                try {
                    if (sourceResult.size() > 0) {
                        DataSet sourceDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)sourceEntity, (String)String.join((CharSequence)",", sourceResult), (QFilter[])new QFilter[]{QFilter.of((String)"1!=1", (Object[])new Object[0])}, (String)"id");
                        DataSet quoteDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)quoteEntity, (String)String.join((CharSequence)",", quoteResult), (QFilter[])new QFilter[]{QFilter.of((String)"1!=1", (Object[])new Object[0])}, (String)"id");
                        Field[] sourceFields = sourceDataSet.getRowMeta().getFields();
                        Field[] quoteFields = quoteDataSet.getRowMeta().getFields();
                        for (int s = 0; s < sourceFields.length; ++s) {
                            Field sourceField = sourceFields[s];
                            Field quoteField = quoteFields[s];
                            if (sourceField.getDataType().equals((Object)quoteField.getDataType())) continue;
                            this.addMessage(data, ResManager.loadKDString((String)"\u53d6\u4ef7\u7ed3\u679c\u6620\u5c04\u5206\u5f55\u5b58\u5728\u201c\u4ef7\u683c\u6765\u6e90\u5b57\u6bb5\u201d\u548c\u201c\u53d6\u4ef7\u5355\u636e\u5b57\u6bb5\u201d\u7c7b\u578b\u4e0d\u5339\u914d\u3002", (String)"QuoteSchemeSubmitValidator_2", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]), ErrorLevel.Error);
                            return;
                        }
                    }
                }
                catch (Exception e) {
                    logger.info("dynamicform exists");
                }
            }
        }
    }
}

