/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.serviceflow.business.clearploy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mpscmm.msbd.serviceflow.business.clearploy.AbstractUnifyLogClearPloy;
import kd.mpscmm.msbd.serviceflow.business.service.UnifyLogClearPloyContext;
import kd.mpscmm.msbd.serviceflow.common.info.TransformLogInfo;
import kd.mpscmm.msbd.serviceflow.common.info.TransformMsInfo;

public class UnifyLogNumClearPloy
extends AbstractUnifyLogClearPloy {
    public UnifyLogNumClearPloy(UnifyLogClearPloyContext unifyLogClearContext) {
        super(unifyLogClearContext);
    }

    @Override
    public void exeClearPloy(List<TransformLogInfo> transformLogInfoList) {
        UnifyLogClearPloyContext unifyLogClearContext = this.getUnifyLogClearContext();
        String logEntity = unifyLogClearContext.getLogEntity();
        String appNumber = unifyLogClearContext.getAppNumber();
        List<String> logLevelList = unifyLogClearContext.getLogCleanLevel();
        Long appMaxRecordNum = unifyLogClearContext.getAppMaxRecordNum();
        String datePartField = unifyLogClearContext.getDatePartField();
        Collection<TransformMsInfo> transformInfoList = unifyLogClearContext.getTransformInfoList();
        QFilter filter = QFilter.of((String)"1=1", (Object[])new Object[0]);
        if ("msbd_tracklog".equals(logEntity)) {
            QFilter appFilter = new QFilter("appid", "=", (Object)appNumber);
            QFilter levelFilter = new QFilter("level", "in", logLevelList);
            filter.and(appFilter).and(levelFilter);
        }
        int size = ORM.create().count(this.getClass().getName(), logEntity, filter.toArray());
        ArrayList<Object> deletePkIDList = new ArrayList<Object>(16);
        if ((long)size > appMaxRecordNum) {
            int deleteSize = size - appMaxRecordNum.intValue();
            if (transformInfoList == null || transformInfoList.size() <= 0) {
                try (DataSet ids = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)logEntity, (String)"id", (QFilter[])filter.toArray(), (String)datePartField.concat(" asc"), (int)deleteSize);){
                    ids.forEach(value -> deletePkIDList.add(value.getLong("id")));
                }
            }
            for (TransformMsInfo transformInfo : transformInfoList) {
                String msKey = transformInfo.getMsKey();
                List transformLogInfo = transformLogInfoList.stream().filter(v -> msKey.equals(v.getMsKey())).collect(Collectors.toList());
                if (transformLogInfo == null || transformLogInfo.size() <= 0) continue;
                TransformLogInfo logInfo = (TransformLogInfo)transformLogInfo.get(0);
                Long msRecordNum = logInfo.getMsRecordNum();
                Long msMaxRecordNum = transformInfo.getMsMaxRecordNum();
                int d_value = msRecordNum.intValue() - msMaxRecordNum.intValue();
                if (msRecordNum > msMaxRecordNum) {
                    filter.and("classname", "=", (Object)msKey);
                    try (DataSet ids = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)logEntity, (String)"id", (QFilter[])filter.toArray(), (String)datePartField.concat(" asc"), (int)d_value);){
                        ids.forEach(value -> deletePkIDList.add(value.getLong("id")));
                    }
                }
                Integer cleanNum = logInfo.getCleanNum();
                if (d_value > 0) {
                    cleanNum = cleanNum + d_value;
                    List<String> cleanDetailList = logInfo.getCleanDetailList();
                    cleanDetailList.add(String.format(ResManager.loadKDString((String)"\u6570\u91cf\u6e05\u7406\u89c4\u5219,\u672c\u6b21\u6e05\u7406\u6570\u636e\uff08%d \u6761\uff09", (String)"UnifyLogNumClearPloy_2", (String)"mpscmm-msbd-serviceflow", (Object[])new Object[0]), d_value));
                }
                logInfo.setCleanNum(cleanNum);
            }
        }
        this.deleteLogPkId(deletePkIDList);
    }
}

