/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.serviceflow.business.clearploy;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mpscmm.msbd.serviceflow.business.clearploy.AbstractUnifyLogClearPloy;
import kd.mpscmm.msbd.serviceflow.business.service.UnifyLogClearPloyContext;
import kd.mpscmm.msbd.serviceflow.common.info.TransformLogInfo;
import kd.mpscmm.msbd.serviceflow.common.info.TransformMsInfo;

public class UnifyLogTimeClearPloy
extends AbstractUnifyLogClearPloy {
    public UnifyLogTimeClearPloy(UnifyLogClearPloyContext unifyLogClearContext) {
        super(unifyLogClearContext);
    }

    @Override
    public void exeClearPloy(List<TransformLogInfo> transformLogInfoList) {
        UnifyLogClearPloyContext unifyLogClearContext = this.getUnifyLogClearContext();
        String logEntity = unifyLogClearContext.getLogEntity();
        String appNumber = unifyLogClearContext.getAppNumber();
        List<String> logLevelList = unifyLogClearContext.getLogCleanLevel();
        String datePartField = unifyLogClearContext.getDatePartField();
        Collection<TransformMsInfo> transformInfoList = unifyLogClearContext.getTransformInfoList();
        String maxTime = unifyLogClearContext.getMaxTime();
        QFilter filter = QFilter.of((String)"1=1", (Object[])new Object[0]);
        if ("msbd_tracklog".equals(logEntity)) {
            QFilter appFilter = new QFilter("appid", "=", (Object)appNumber);
            QFilter levelFilter = new QFilter("level", "in", logLevelList);
            filter.and(appFilter).and(levelFilter);
        }
        LocalDate localDate = LocalDate.now();
        LocalDate limitDate = localDate.minusDays(Long.parseLong(maxTime));
        QFilter timeLimitFilter = new QFilter(datePartField, "<", (Object)limitDate);
        ArrayList<Object> deletePkIDList = new ArrayList<Object>(16);
        if (transformInfoList == null || transformInfoList.size() <= 0) {
            try (DataSet ids = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)logEntity, (String)"id", (QFilter[])new QFilter[]{filter, timeLimitFilter}, (String)datePartField.concat(" asc"));){
                ids.forEach(value -> deletePkIDList.add(value.getLong("id")));
            }
        }
        for (TransformMsInfo transformInfo : transformInfoList) {
            String msKey = transformInfo.getMsKey();
            String msMaxTime = transformInfo.getMsMaxTime();
            timeLimitFilter.and(datePartField, "<", (Object)localDate.minusDays(Long.parseLong(msMaxTime)));
            QFilter msKeyFilter = new QFilter("classname", "=", (Object)msKey);
            List transformLogInfo = transformLogInfoList.stream().filter(v -> msKey.equals(v.getMsKey())).collect(Collectors.toList());
            if (transformLogInfo == null || transformLogInfo.size() <= 0) continue;
            TransformLogInfo logInfo = (TransformLogInfo)transformLogInfo.get(0);
            int d_value = 0;
            DataSet ids = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)logEntity, (String)"id", (QFilter[])new QFilter[]{filter, timeLimitFilter, msKeyFilter}, (String)datePartField.concat(" asc"));
            Throwable throwable = null;
            try {
                for (Row value2 : ids) {
                    deletePkIDList.add(value2.getLong("id"));
                    ++d_value;
                }
                Integer cleanNum = logInfo.getCleanNum();
                if (d_value > 0) {
                    cleanNum = cleanNum + d_value;
                    List<String> cleanDetailList = logInfo.getCleanDetailList();
                    cleanDetailList.add(String.format(ResManager.loadKDString((String)"\u65f6\u95f4\u6e05\u7406\u89c4\u5219,\u672c\u6b21\u6e05\u7406\u6570\u636e\uff08%d \u6761\uff09", (String)"UnifyLogTimeClearPloy_2", (String)"mpscmm-msbd-serviceflow", (Object[])new Object[0]), d_value));
                }
                logInfo.setCleanNum(cleanNum);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (ids == null) continue;
                if (throwable != null) {
                    try {
                        ids.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                ids.close();
            }
        }
        this.deleteLogPkId(deletePkIDList);
    }
}

