/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.serviceflow.business.log;

import java.util.Arrays;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.mpscmm.msbd.serviceflow.business.log.LogService;
import kd.mpscmm.msbd.serviceflow.common.logwrite.TrackLogInfo;

public abstract class AbstractLogService
implements LogService {
    private static final Log log = LogFactory.getLog(AbstractLogService.class);
    public Class<?> classValue = null;
    public String appId = "";
    public String logWriteEntity = "";
    public static final String START = "start";
    public static final String MID = "mid";
    public static final String END = "end";
    public static final String INFO = "info";
    public static final String WARN = "warn";
    public static final String ERROR = "error";

    public AbstractLogService(Class<?> classValue, String appId, String logWriteEntity) {
        this.classValue = classValue;
        this.appId = appId;
        this.logWriteEntity = logWriteEntity;
    }

    public void saveTrackLog(TrackLogInfo trackLogInfo) {
        try {
            ThreadPools.executeOnce((String)"msbd_tracklog", () -> {
                Throwable throwable;
                TXHandle tx;
                block17: {
                    block18: {
                        block19: {
                            tx = TX.requiresNew((String)AbstractLogService.class.getName());
                            throwable = null;
                            String level = trackLogInfo.getLevel();
                            if (this.checkEnableLogging(this.appId, this.classValue.getName(), level)) break block17;
                            if (tx == null) break block18;
                            if (throwable == null) break block19;
                            try {
                                tx.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            break block18;
                        }
                        tx.close();
                    }
                    return;
                }
                try {
                    try {
                        DynamicObject trackLogDyn = trackLogInfo.serialTrackLogInfo();
                        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{trackLogDyn});
                    }
                    catch (Exception e) {
                        tx.markRollback();
                        log.error("msbd_tracklog seria and save failer:{}", (Object)Arrays.toString(e.getStackTrace()));
                    }
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
                catch (Throwable throwable4) {
                    throw throwable4;
                }
                finally {
                    if (tx != null) {
                        if (throwable != null) {
                            try {
                                tx.close();
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                        } else {
                            tx.close();
                        }
                    }
                }
            });
        }
        catch (Exception e) {
            log.error("msbd_tracklog seria and save failer", (Throwable)e);
        }
    }

    private boolean checkEnableLogging(String appNumber, String msKey, String level) {
        QFilter filter = new QFilter("appnumber", "=", (Object)appNumber);
        filter.and("entry.mskey", "=", (Object)msKey);
        filter.and("entry.logwritelevel", "match", (Object)level);
        Map logManageData = BusinessDataServiceHelper.loadFromCache((String)"msbd_logmanage", (String)"id", (QFilter[])filter.toArray());
        boolean flag = false;
        if (logManageData != null && logManageData.size() > 0) {
            flag = true;
        }
        return flag;
    }
}

