/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.serviceflow.business.service;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.mpscmm.msbd.serviceflow.business.clearploy.AbstractUnifyLogClearPloy;
import kd.mpscmm.msbd.serviceflow.business.service.UnifyLogClearPloyContext;
import kd.mpscmm.msbd.serviceflow.business.service.UnifyLogController;
import kd.mpscmm.msbd.serviceflow.common.info.PloyResultInfo;
import kd.mpscmm.msbd.serviceflow.common.info.TransformLogInfo;
import kd.mpscmm.msbd.serviceflow.common.info.TransformMsInfo;
import kd.mpscmm.msbd.serviceflow.common.info.UnifyLogClearLogInfo;
import org.apache.commons.collections4.multimap.ArrayListValuedHashMap;

public class UnifyLogClearService
extends AbstractTask {
    private static final Log log = LogFactory.getLog(UnifyLogClearService.class);
    private static final DateTimeFormatter formatter = DateTimeFormatter.ofPattern(TimeServiceHelper.getDateTimeFormatString());

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        log.info("MSBD--\u300b\u7edf\u4e00\u6e05\u7406\u65e5\u5fd7\u5f00\u59cb\u65f6\u95f4:{}", (Object)formatter.format(LocalDateTime.now()));
        log.info("MSBD--\u300b\u6e05\u7406\u53c2\u6570\u5982\u4e0b:{}", map);
        long startTimeM = System.currentTimeMillis();
        Date startTime = TimeServiceHelper.now();
        try (TraceSpan traceSpan = Tracer.create((String)"UnifyLogClearService", (String)"exeLogCleanPloy");){
            PloyResultInfo ployResultInfo;
            String primaryKeyValueStr;
            List primaryKeyValueList;
            Object primaryKeyValue;
            QFilter filter = QFilter.of((String)"1=1", (Object[])new Object[0]);
            if (map != null && map.size() > 0 && (primaryKeyValue = map.get("primaryKeyValueStr")) instanceof String && (primaryKeyValueList = SerializationUtils.fromJsonStringToList((String)(primaryKeyValueStr = (String)primaryKeyValue), Long.class)) != null && primaryKeyValueList.size() > 0) {
                filter.and("id", "in", (Object)primaryKeyValueList);
            }
            if ((ployResultInfo = this.exeLogCleanPloy(filter)) != null) {
                BigDecimal cost = BigDecimal.valueOf(System.currentTimeMillis() - startTimeM).divide(BigDecimal.valueOf(1000L), 3, RoundingMode.HALF_UP);
                UnifyLogClearLogInfo.save(ployResultInfo.getAllTransformLogInfoList(), startTime, cost, ployResultInfo.getCollCleanStrategy());
            }
        }
        log.info("MSBD--\u300b\u7edf\u4e00\u6e05\u7406\u65e5\u5fd7\u7ed3\u675f\u65f6\u95f4:{}", (Object)formatter.format(LocalDateTime.now()));
    }

    private PloyResultInfo exeLogCleanPloy(QFilter filter) {
        HashSet<String> appIdSet = new HashSet<String>(16);
        ArrayListValuedHashMap msValue = new ArrayListValuedHashMap(16);
        try (DataSet rows = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"msbd_logmanage", (String)"id,app,entry.mskey mskey,entry.msmaxrecordnum msmaxrecordnum,entry.msmaxtime msmaxtime", (QFilter[])filter.toArray(), null);){
            for (Row row : rows) {
                Long id = row.getLong("id");
                appIdSet.add(row.getString("app"));
                String msKey = row.getString("mskey");
                if (StringUtils.isBlank((CharSequence)msKey) || id == 0L) continue;
                TransformMsInfo transformInfo = new TransformMsInfo(msKey, row.getLong("msmaxrecordnum"), row.getString("msmaxtime"));
                msValue.put((Object)id, (Object)transformInfo);
            }
        }
        Map<String, String> appIdAppNumber = UnifyLogController.getAppIdAppNumber(appIdSet);
        ArrayList<TransformLogInfo> allTransformLogInfoList = new ArrayList<TransformLogInfo>(16);
        ArrayList<String> collCleanStrategy = new ArrayList<String>(16);
        try (DataSet rows = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"msbd_logmanage", (String)"id,name,logentity, appmaxrecordnum, logcleanlevel, app, maxtime, datepartfield,cleanfilterstr_tag", (QFilter[])filter.toArray(), null);){
            if (rows.isEmpty()) {
                Iterator iterator = null;
                return iterator;
            }
            for (Row row : rows) {
                Long id = row.getLong("id");
                String logEntity = row.getString("logentity");
                Long appMaxRecordNum = row.getLong("appmaxrecordnum");
                String appId = row.getString("app");
                String appNumber = appIdAppNumber.get(appId);
                String maxTime = row.getString("maxtime");
                String logCleanLevel = row.getString("logcleanlevel");
                List<String> logCleanLevelList = Arrays.asList(logCleanLevel.split(","));
                String datePartField = row.getString("datepartfield");
                String cleanFilterStr = row.getString("cleanfilterstr_tag");
                Collection transformInfoList = msValue.get((Object)id);
                QFilter appFilter = new QFilter("appid", "=", (Object)appNumber);
                List<TransformLogInfo> transformLogInfoList = this.getLogEntityTransformInfo(logEntity, appFilter);
                UnifyLogClearPloyContext unifyLogClearPloyContext = UnifyLogClearPloyContext.create(appNumber, logEntity, datePartField, logCleanLevelList, maxTime, appMaxRecordNum, transformInfoList);
                unifyLogClearPloyContext.setCleanFilterStr(cleanFilterStr);
                List<AbstractUnifyLogClearPloy> logClearPloyList = AbstractUnifyLogClearPloy.createLogClearPloy(unifyLogClearPloyContext);
                logClearPloyList.stream().forEach(ploy -> ploy.exeClearPloy(transformLogInfoList));
                transformLogInfoList.stream().forEach(info -> info.setLogManage(id));
                allTransformLogInfoList.addAll(transformLogInfoList);
                collCleanStrategy.add(row.getString("name"));
            }
        }
        appIdSet.clear();
        appIdSet = null;
        msValue.clear();
        msValue = null;
        appIdAppNumber.clear();
        appIdAppNumber = null;
        return PloyResultInfo.create(allTransformLogInfoList, collCleanStrategy);
    }

    private List<TransformLogInfo> getLogEntityTransformInfo(String logEntity, QFilter appFilter) {
        ArrayList<TransformLogInfo> transformLogInfoList = new ArrayList<TransformLogInfo>(16);
        if ("msbd_tracklog".equals(logEntity)) {
            try (DataSet msRows = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)logEntity, (String)"id,classname", (QFilter[])new QFilter[]{appFilter}, null);){
                DataSet serviceImpl = msRows.groupBy(new String[]{"classname"}).count("id").finish();
                for (Row msRow : serviceImpl) {
                    transformLogInfoList.add(new TransformLogInfo(msRow.getString("classname"), msRow.getLong("id"), 0, new ArrayList<String>(16)));
                }
            }
        }
        return transformLogInfoList;
    }
}

