/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.serviceflow.formplugin;

import java.util.EventObject;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.metadata.treebuilder.FormTreeBuilder;
import kd.bos.metadata.treebuilder.PropTreeBuildOption;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.util.StringUtils;

public class UnifyLogManagePlugin
extends AbstractFormPlugin {
    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"datepartfield", "cleanfilter"});
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        DynamicObject app;
        FormOperate operate = (FormOperate)e.getSource();
        if ("save".equals(operate.getOperateKey()) && (app = (DynamicObject)this.getModel().getValue("app")) != null) {
            String appNumber = app.getString("number");
            this.getModel().setValue("appnumber", (Object)appNumber);
        }
    }

    public void click(EventObject evt) {
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        DynamicObject entityNumber = (DynamicObject)model.getValue("logentity");
        if (Objects.isNull(entityNumber)) {
            view.showMessage(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u65e5\u5fd7\u5b9e\u4f53\u3002", (String)"UnifyLogManagePlugin_0", (String)"mpscmm-msbd-serviceflow", (Object[])new Object[0]));
            return;
        }
        String number = entityNumber.getString("number");
        if ("datepartfield".equals(key)) {
            MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)number);
            PropTreeBuildOption option = new PropTreeBuildOption();
            option.setMatchedProperty((IDataEntityProperty)new DateTimeProp());
            option.setOnlyPhysicsField(false);
            TreeNode treeNode = FormTreeBuilder.buildDynamicPropertyTree((MainEntityType)entityType, (PropTreeBuildOption)option);
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("msbd_fieldselect");
            String nodesJson = SerializationUtils.toJsonString((Object)treeNode);
            showParameter.getCustomParams().put("treenodes", nodesJson);
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "date_select_field"));
            showParameter.setCaption(ResManager.loadKDString((String)"\u65e5\u5fd7\u5b9e\u4f53\u5b57\u6bb5", (String)"UnifyLogManagePlugin_1", (String)"mpscmm-msbd-serviceflow", (Object[])new Object[0]));
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            this.getView().showForm(showParameter);
        } else if ("cleanfilter".equals(key)) {
            Object filterExpress = this.getModel().getValue("cleanfilterstr_tag");
            this.showCommonFilterView(filterExpress, number, "clean_filter_symbol");
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        switch (key) {
            case "cleanfilter": {
                String value = (String)newValue;
                if (value != null && !"".equals(value)) break;
                this.getModel().setValue("cleanfilterstr_tag", null);
                break;
            }
        }
    }

    private void showCommonFilterView(Object filterExpress, String filterEntity, String commonfiltersymbol) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("msbd_commonfilter");
        showParameter.getCustomParams().put("formula", filterExpress);
        showParameter.getCustomParams().put("entitynumber", filterEntity);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, commonfiltersymbol));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCaption(ResManager.loadKDString((String)"\u65e5\u5fd7\u6e05\u7406\u6761\u4ef6", (String)"UnifyLogManagePlugin_2", (String)"mpscmm-msbd-serviceflow", (Object[])new Object[0]));
        this.getView().showForm(showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String conditionJson;
        IDataModel model = this.getModel();
        String actionId = closedCallBackEvent.getActionId();
        Object retData = closedCallBackEvent.getReturnData();
        if (retData == null) {
            return;
        }
        if ("date_select_field".equals(actionId)) {
            model.setValue("datepartfield", retData);
        } else if ("clean_filter_symbol".equals(actionId) && StringUtils.isNotEmpty((String)(conditionJson = (String)closedCallBackEvent.getReturnData()))) {
            CRCondition condition = (CRCondition)SerializationUtils.fromJsonString((String)conditionJson, CRCondition.class);
            String exprTran = condition.getExprDesc();
            this.getModel().setValue("cleanfilterstr_tag", (Object)conditionJson);
            this.getModel().setValue("cleanfilter", (Object)exprTran);
        }
    }
}

