/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.basedata.formplugin.allowCtrl;

import java.util.EventObject;
import java.util.List;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.mpscmm.msbd.basedata.business.helper.allowCtrl.AllowCtrlOpHelper;
import kd.mpscmm.msbd.business.helper.OperatorGroupHelper;
import kd.mpscmm.msbd.business.helper.OrgHelper;
import kd.mpscmm.msbd.common.enums.OperatorGrpTypeEnum;

public class AllowCtrlTplPlugin
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    private static final String IS_STOP_PROPERTYCHANGE = "isStopPropertyChange";

    public void registerListener(EventObject e) {
        BasedataEdit custgroup;
        BasedataEdit cust;
        BasedataEdit materialgroup;
        BasedataEdit material;
        BasedataEdit deptEdit;
        BasedataEdit operatorEdit;
        super.registerListener(e);
        BasedataEdit operatorGroupEdit = (BasedataEdit)this.getView().getControl("operatorgroup");
        if (operatorGroupEdit != null) {
            operatorGroupEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((operatorEdit = (BasedataEdit)this.getView().getControl("operator")) != null) {
            operatorEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((deptEdit = (BasedataEdit)this.getView().getControl("dept")) != null) {
            deptEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((material = (BasedataEdit)this.getView().getControl("material")) != null) {
            material.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((materialgroup = (BasedataEdit)this.getView().getControl("materialgroup")) != null) {
            materialgroup.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((cust = (BasedataEdit)this.getView().getControl("customer")) != null) {
            cust.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((custgroup = (BasedataEdit)this.getView().getControl("customergroup")) != null) {
            custgroup.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key = e.getProperty().getName();
        IDataModel bill = this.getModel();
        DynamicObject org = (DynamicObject)bill.getValue("org");
        String name = this.getModel().getDataEntity().getDataEntityType().getName();
        if (org == null) {
            if (AllowCtrlOpHelper.checkIsContains(name)) {
                this.getView().showMessage(String.format(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9500\u552e\u7ec4\u7ec7\u3002", (String)"OperMaterCtrlPlugin_0", (String)"mpscmm-msbd-basedata", (Object[])new Object[0]), new Object[0]));
                e.setCancel(true);
            } else {
                this.getView().showMessage(String.format(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u91c7\u8d2d\u7ec4\u7ec7\u3002", (String)"OperMaterCtrlPlugin_1", (String)"mpscmm-msbd-basedata", (Object[])new Object[0]), new Object[0]));
                e.setCancel(true);
            }
            return;
        }
        String OperatorGrpType = AllowCtrlOpHelper.checkIsContains(name) ? OperatorGrpTypeEnum.SALEGRP.getValue() : OperatorGrpTypeEnum.PURCHASEGRP.getValue();
        Long orgId = (Long)org.getPkValue();
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        switch (key) {
            case "operator": {
                QFilter qFilter = new QFilter("invalid", "=", (Object)Boolean.FALSE);
                List operatorGroups = OperatorGroupHelper.getAllOperatorGroupByOrg((Long)orgId, (String)OperatorGrpType);
                if (operatorGroups != null && operatorGroups.size() > 0) {
                    qFilter.and(new QFilter("operatorgrpid", "in", (Object)operatorGroups));
                    showParameter.getListFilterParameter().getQFilters().add(qFilter);
                    break;
                }
                showParameter.getListFilterParameter().getQFilters().add(QFilter.of((String)"1!=1", (Object[])new Object[0]));
                break;
            }
            case "operatorgroup": {
                showParameter.getListFilterParameter().setFilter(new QFilter("operatorgrouptype", "=", (Object)OperatorGrpType));
                break;
            }
            case "dept": {
                List deptIDs = OrgHelper.getAllToOrg((String)"15", (String)"01", (Long)orgId, (boolean)true);
                deptIDs.add(orgId);
                QFilter iDfilter = new QFilter("id", "in", (Object)deptIDs);
                showParameter.getListFilterParameter().getQFilters().add(iDfilter);
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if (IS_STOP_PROPERTYCHANGE.equals(this.getPageCache().get(IS_STOP_PROPERTYCHANGE))) {
            return;
        }
        ChangeData[] changeSet = e.getChangeSet();
        String propName = e.getProperty().getName();
        String name = this.getModel().getDataEntity().getDataEntityType().getName();
        String isChange = null;
        switch (propName) {
            case "controldimension": {
                for (int i = 0; i < changeSet.length; ++i) {
                    this.getPageCache().put("controldimension_old", (String)changeSet[i].getOldValue());
                    isChange = AllowCtrlOpHelper.checkIsContains(name) ? ResManager.loadKDString((String)"\u63a7\u5236\u7ef4\u5ea6\u5207\u6362\uff0c\u5c06\u6e05\u9664\u53ef\u9500\u660e\u7ec6\u4fe1\u606f\uff0c\u662f\u5426\u786e\u8ba4\u5207\u6362\uff1f", (String)"OperMaterContrPlugin_0", (String)"mpscmm-msbd-basedata", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u63a7\u5236\u7ef4\u5ea6\u5207\u6362\uff0c\u5c06\u6e05\u9664\u53ef\u91c7\u660e\u7ec6\u4fe1\u606f\uff0c\u662f\u5426\u786e\u8ba4\u5207\u6362\uff1f", (String)"OperMaterContrPlugin_1", (String)"mpscmm-msbd-basedata", (Object[])new Object[0]);
                    ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("controldimension", (IFormPlugin)this);
                    this.getView().showConfirm(String.format(isChange, new Object[0]), MessageBoxOptions.OKCancel, ConfirmTypes.Default, confirmCallBacks);
                }
                break;
            }
            case "operator": {
                for (int i = 0; i < changeSet.length; ++i) {
                    DynamicObject operator = (DynamicObject)changeSet[i].getNewValue();
                    if (operator != null) {
                        this.getModel().setValue("operatorgroup", operator.get("operatorgrpid"), changeSet[i].getRowIndex());
                        continue;
                    }
                    this.getModel().setValue("operatorgroup", null);
                }
                break;
            }
            case "material": {
                for (int i = 0; i < changeSet.length; ++i) {
                    DynamicObject material = (DynamicObject)changeSet[i].getNewValue();
                    int rowIndex = changeSet[i].getRowIndex();
                    if (material != null && material.getDynamicObject("masterid") != null) {
                        DynamicObject masterid = material.getDynamicObject("masterid");
                        this.getModel().setValue("materialmasterid", masterid.getPkValue(), rowIndex);
                        continue;
                    }
                    this.getModel().setValue("materialmasterid", null, rowIndex);
                }
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        String callBackId = e.getCallBackId();
        MessageBoxResult result = e.getResult();
        switch (callBackId) {
            case "controldimension": {
                if (result.equals((Object)MessageBoxResult.Yes)) {
                    this.getModel().deleteEntryData("entryentity");
                    this.getModel().createNewEntryRow("entryentity");
                    break;
                }
                this.getPageCache().put(IS_STOP_PROPERTYCHANGE, IS_STOP_PROPERTYCHANGE);
                this.getModel().setValue("controldimension", (Object)this.getPageCache().get("controldimension_old"));
                this.getPageCache().remove(IS_STOP_PROPERTYCHANGE);
                break;
            }
        }
    }
}

