/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.basedata.opplugin.allowCtrl.validator;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.mpscmm.msbd.basedata.business.helper.allowCtrl.AllowCtrlOpHelper;
import kd.mpscmm.msbd.common.utils.CommonUtils;

public class AllowCtrlDuplicateValidator
extends AbstractValidator {
    public Set<String> preparePropertys() {
        HashSet<String> preparePropertys = super.preparePropertys();
        if (CommonUtils.isNull((Object)preparePropertys)) {
            preparePropertys = new HashSet<String>();
        }
        preparePropertys.add("controldimension");
        preparePropertys.add("operator");
        preparePropertys.add("operatorgroup");
        preparePropertys.add("dept");
        preparePropertys.add("customer");
        preparePropertys.add("customergroup");
        preparePropertys.add("material");
        preparePropertys.add("materialgroup");
        return preparePropertys;
    }

    public void validate() {
        if (this.dataEntities.length > 1) {
            return;
        }
        for (ExtendedDataEntity extend : this.dataEntities) {
            DynamicObject entity = extend.getDataEntity();
            String dataEntityTypeName = entity.getDataEntityType().getName();
            DynamicObjectCollection entrys = entity.getDynamicObjectCollection("entryentity");
            if (entrys.size() == 0) {
                if (AllowCtrlOpHelper.checkIsContains(dataEntityTypeName)) {
                    this.addMessage(extend, String.format(ResManager.loadKDString((String)"\u201c\u53ef\u9500\u660e\u7ec6\u201d\u5355\u636e\u4f53\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DuplicateValidator_0", (String)"mpscmm-msbd-basedata", (Object[])new Object[0]), new Object[0]));
                    continue;
                }
                this.addMessage(extend, String.format(ResManager.loadKDString((String)"\u201c\u53ef\u91c7\u660e\u7ec6\u201d\u5355\u636e\u4f53\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DuplicateValidator_1", (String)"mpscmm-msbd-basedata", (Object[])new Object[0]), new Object[0]));
                continue;
            }
            HashSet<String> localentrySet = new HashSet<String>(entrys.size());
            Set<String> sysDupliEntrys = AllowCtrlOpHelper.getSysDupliEntrys(entity, ((Object)((Object)this)).getClass().getName(), dataEntityTypeName);
            HashSet<String> dupliErrorMsgs = new HashSet<String>(8);
            for (DynamicObject entry : entrys) {
                StringBuilder entryBuild = new StringBuilder();
                String[] keyName = new String[10];
                Map<String, String> DuplicatesMap = AllowCtrlOpHelper.toConvertMesTipMap(entry, entryBuild, keyName, dataEntityTypeName);
                boolean isInnerDuplicate = AllowCtrlOpHelper.checkLocalDupliEntrys(localentrySet, entryBuild);
                boolean isSysDuplicate = AllowCtrlOpHelper.checkSysDupliEntrys(sysDupliEntrys, entryBuild);
                if (DuplicatesMap.size() < 2) continue;
                if (isInnerDuplicate) {
                    dupliErrorMsgs.add(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u5f55\u5165\u7684\u201c%1$s\u201d\u3010%2$s\u3011\u201c%3$s\u201d\u3010%4$s\u3011\u5b58\u5728\u91cd\u590d\u9879\uff0c\u8bf7\u68c0\u67e5\u5f55\u5165\u7684\u6570\u636e\u3002", (String)"DuplicateValidator_2", (String)"mpscmm-msbd-basedata", (Object[])new Object[0]), keyName[0], DuplicatesMap.get(keyName[0]), keyName[1], DuplicatesMap.get(keyName[1])));
                }
                if (!isSysDuplicate) continue;
                if (AllowCtrlOpHelper.checkIsContains(entity.getDataEntityType().getName())) {
                    dupliErrorMsgs.add(String.format(ResManager.loadKDString((String)"\u7cfb\u7edf\u4e2d\u5df2\u5b58\u5728\u201c%1$s\u201d\u3010%2$s\u3011\u201c%3$s\u201d\u3010%4$s\u3011\u7684\u53ef\u9500\u63a7\u5236\u8bb0\u5f55\uff0c\u8bf7\u68c0\u67e5\u5f55\u5165\u7684\u6570\u636e\u3002", (String)"DuplicateValidator_3", (String)"mpscmm-msbd-basedata", (Object[])new Object[0]), keyName[0], DuplicatesMap.get(keyName[0]), keyName[1], DuplicatesMap.get(keyName[1])));
                    continue;
                }
                dupliErrorMsgs.add(String.format(ResManager.loadKDString((String)"\u7cfb\u7edf\u4e2d\u5df2\u5b58\u5728\u201c%1$s\u201d\u3010%2$s\u3011\u201c%3$s\u201d\u3010%4$s\u3011\u7684\u53ef\u91c7\u63a7\u5236\u8bb0\u5f55\uff0c\u8bf7\u68c0\u67e5\u5f55\u5165\u7684\u6570\u636e\u3002", (String)"DuplicateValidator_4", (String)"mpscmm-msbd-basedata", (Object[])new Object[0]), keyName[0], DuplicatesMap.get(keyName[0]), keyName[1], DuplicatesMap.get(keyName[1])));
            }
            for (String errorMsg : dupliErrorMsgs) {
                this.addMessage(extend, errorMsg);
            }
        }
    }
}

