/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.quotamodel.business.algorithm;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.mpscmm.msbd.quotamodel.business.algorithm.AbstractQuotaStrategy;
import kd.mpscmm.msbd.quotamodel.business.helper.QuotaAlgorithmHelper;
import kd.mpscmm.msbd.quotamodel.common.pojo.QuotaRecordDetailInfo;

public class HighestQuotaStrategy
extends AbstractQuotaStrategy {
    private static final Log log = LogFactory.getLog(HighestQuotaStrategy.class);

    @Override
    public QuotaRecordDetailInfo algorithm(QuotaRecordDetailInfo calRecordDetailInfo, Boolean isResultAdjust, DataSet sourcelistDS) {
        BigDecimal baseRemainQty = calRecordDetailInfo.getUnprocessBaseQty();
        Long baseUnitID = calRecordDetailInfo.getBaseUnitID();
        DynamicObject baseUnit = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_measureunits", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)baseUnitID)});
        BigDecimal sumbasequotaQty = BigDecimal.ZERO;
        Map<String, String> quotaTgtFieldMap = calRecordDetailInfo.getQuotaTgtFieldMap();
        Map<Integer, List<Map<String, Object>>> quotaQryRsltMap = calRecordDetailInfo.getQuotaQueryResultInfos();
        HashMap<Integer, List<Map<String, Object>>> quotaCalResultInfos = new HashMap<Integer, List<Map<String, Object>>>(16);
        block0: for (int m = 1; m < 999; ++m) {
            List<Map<String, Object>> quotaDefLst = quotaQryRsltMap.get(m);
            if (quotaDefLst == null) continue;
            ArrayList<Map<String, Object>> quotaCalResultLst = new ArrayList<Map<String, Object>>(16);
            BigDecimal maxRate = BigDecimal.ZERO;
            for (int i = 0; i < quotaDefLst.size(); ++i) {
                BigDecimal quotarate = (BigDecimal)quotaDefLst.get(i).get("quotarate");
                if (quotarate.compareTo(maxRate) <= 0) continue;
                maxRate = quotarate;
            }
            for (int j = 0; j < quotaDefLst.size(); ++j) {
                if (((BigDecimal)quotaDefLst.get(j).get("quotarate")).compareTo(maxRate) != 0) continue;
                Map<String, Object> quotaCalResultMap = quotaDefLst.get(j);
                quotaCalResultMap.put("quotaedBaseQty", baseRemainQty);
                BigDecimal srcAdjustBaseQty = new BigDecimal(0);
                BigDecimal maxBaseQty = new BigDecimal(0);
                BigDecimal minBaseQty = new BigDecimal(0);
                BigDecimal packageBatchQty = new BigDecimal(0);
                if (isResultAdjust.booleanValue()) {
                    Long supplierId = (Long)quotaCalResultMap.get("supplier");
                    Long orgId = (Long)quotaCalResultMap.get(quotaTgtFieldMap.get("org"));
                    Long materialId = (Long)quotaCalResultMap.get("material");
                    Map<String, BigDecimal> sourceListRst = QuotaAlgorithmHelper.getQuotaedQtyBySourceList(supplierId, orgId, materialId, baseRemainQty, calRecordDetailInfo.getQuotaDate(), materialId, sourcelistDS);
                    srcAdjustBaseQty = sourceListRst.get("srcAdjustBaseQty");
                    maxBaseQty = sourceListRst.get("maxBaseQty");
                    minBaseQty = sourceListRst.get("minBaseQty");
                    packageBatchQty = sourceListRst.get("packageBaseQty");
                } else {
                    srcAdjustBaseQty = baseRemainQty;
                }
                StringBuilder qtyStr = new StringBuilder();
                qtyStr.append(quotaDefLst.get(j).get("supplier"));
                qtyStr.append(" : ");
                qtyStr.append(baseRemainQty);
                qtyStr.append(" : ");
                qtyStr.append(srcAdjustBaseQty);
                qtyStr.append(" \uff1b ");
                log.info("Quota,HighestQuotaStrategyResult\uff0crsltKey : quotaedBaseQty : srcAdjustBaseQty = {} ", (Object)qtyStr.toString());
                quotaCalResultMap.put("srcAdjustBaseQty", srcAdjustBaseQty);
                quotaCalResultMap.put("maxBaseQty", maxBaseQty);
                quotaCalResultMap.put("minBaseQty", minBaseQty);
                quotaCalResultMap.put("packageBaseQty", packageBatchQty);
                quotaCalResultLst.add(quotaCalResultMap);
                quotaCalResultInfos.put(m, quotaCalResultLst);
                break block0;
            }
            break;
        }
        calRecordDetailInfo.setQuotaCalculateResultInfos(quotaCalResultInfos);
        return calRecordDetailInfo;
    }
}

