/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.quotamodel.business.helper;

import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.mpscmm.msbd.quotamodel.business.service.QuotaService;
import kd.mpscmm.msbd.quotamodel.common.pojo.QuotaCalInParam;
import kd.mpscmm.msbd.quotamodel.common.pojo.QuotaRecordDetailInfo;
import kd.mpscmm.msbd.quotamodel.common.pojo.QuotaRecordInfo;

public class QuotaCalHelper {
    private static final Log log = LogFactory.getLog(QuotaCalHelper.class);
    public static final DateTimeFormatter FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");

    public static Map<String, Object> getQuota(Map<String, Object> queryMap) {
        QuotaCalInParam queryInfo = new QuotaCalInParam();
        queryInfo.setQuotaSchemeID((Long)queryMap.get("quotaSchemeID"));
        Map data = (Map)queryMap.get("dataInfos");
        queryInfo.setDataInfos(data);
        QuotaRecordInfo quotaRecord = QuotaService.checkParam(queryInfo, "query");
        if (quotaRecord.getSuccess().booleanValue()) {
            quotaRecord = QuotaService.quotaQuery(queryInfo);
        }
        HashMap<String, Object> queryResult = new HashMap<String, Object>(16);
        queryResult.put("success", quotaRecord.getSuccess());
        queryResult.put("detail", quotaRecord.getDetail());
        ArrayList RecordDetailsLst = new ArrayList(quotaRecord.getQuotaRecordDetails().size());
        if (quotaRecord.getQuotaRecordDetails() != null) {
            for (QuotaRecordDetailInfo detailInfo : quotaRecord.getQuotaRecordDetails()) {
                HashMap<String, Object> detailMap = new HashMap<String, Object>(16);
                detailMap.put("dataKey", detailInfo.getDataKey());
                detailMap.put("quotaSource", detailInfo.getQuotaSource());
                detailMap.put("quotaMappingID", detailInfo.getQuotaMappingID());
                detailMap.put("matchKey", detailInfo.getMatchKey());
                detailMap.put("quotaCalRuleID", detailInfo.getQuotaCalRuleID());
                detailMap.put("algorithmID", detailInfo.getAlgorithmID());
                detailMap.put("quotaQueryResultInfos", detailInfo.getQuotaQueryResultInfos());
                detailMap.put("dataSuccess", detailInfo.getDataSuccess());
                detailMap.put("recordDetail", detailInfo.getRecordDetail());
                RecordDetailsLst.add(detailMap);
            }
        }
        queryResult.put("quotaRecordDetails", RecordDetailsLst);
        return queryResult;
    }

    public static Map<String, Object> getQuotaResult(Map<String, Object> calMap) {
        QuotaCalInParam queryInfo = new QuotaCalInParam();
        queryInfo.setQuotaSchemeID((Long)calMap.get("quotaSchemeID"));
        Map data = (Map)calMap.get("dataInfos");
        queryInfo.setDataInfos(data);
        QuotaRecordInfo quotaCalRecord = QuotaService.checkParam(queryInfo, "cal");
        if (quotaCalRecord.getSuccess().booleanValue()) {
            quotaCalRecord = QuotaService.quotaCal(queryInfo);
        }
        HashMap<String, Object> quotaResult = new HashMap<String, Object>(16);
        quotaResult.put("success", quotaCalRecord.getSuccess());
        quotaResult.put("detail", quotaCalRecord.getDetail());
        ArrayList RecordDetailsLst = new ArrayList(16);
        if (quotaCalRecord.getQuotaRecordDetails() != null) {
            for (QuotaRecordDetailInfo detailInfo : quotaCalRecord.getQuotaRecordDetails()) {
                HashMap<String, Object> detailMap = new HashMap<String, Object>(16);
                detailMap.put("dataKey", detailInfo.getDataKey());
                detailMap.put("quotaSource", detailInfo.getQuotaSource());
                detailMap.put("quotaMappingID", detailInfo.getQuotaMappingID());
                detailMap.put("matchKey", detailInfo.getMatchKey());
                detailMap.put("quotaCalRuleID", detailInfo.getQuotaCalRuleID());
                detailMap.put("algorithmID", detailInfo.getAlgorithmID());
                detailMap.put("quotaCalculateResultInfos", detailInfo.getQuotaCalculateResultInfos());
                detailMap.put("dataSuccess", detailInfo.getDataSuccess());
                detailMap.put("recordDetail", detailInfo.getRecordDetail());
                RecordDetailsLst.add(detailMap);
            }
        }
        quotaResult.put("quotaRecordDetails", RecordDetailsLst);
        return quotaResult;
    }
}

