/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.quotamodel.business.helper;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.tree.TreeNode;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.util.StringUtils;
import kd.mpscmm.msbd.quotamodel.common.pojo.TreeNodeParams;

public class QuotaMetaHelper {
    public static TreeNode buildTree(String entityNumber, TreeNodeParams params) {
        if (StringUtils.isNotEmpty((String)entityNumber) && params != null) {
            MainEntityType meta = MetadataServiceHelper.getDataEntityType((String)entityNumber);
            Map allFields = meta.getAllFields();
            HashMap<String, TreeNode> nodeMap = new HashMap<String, TreeNode>();
            TreeNode root = new TreeNode(null, QuotaMetaHelper.getRootId(), meta.getDisplayName().getLocaleValue());
            root.setIsOpened(true);
            nodeMap.put(root.getId(), root);
            for (IDataEntityProperty pro : allFields.values()) {
                IDataEntityType parent = pro.getParent();
                if (parent instanceof MainEntityType) {
                    root.addChild(QuotaMetaHelper.buildNode4Property(root, pro, params));
                    continue;
                }
                if (!(parent instanceof EntryType) || !(parent.getParent() instanceof MainEntityType)) continue;
                TreeNode entryNode = QuotaMetaHelper.getEntryNode(nodeMap, parent);
                if (!nodeMap.containsKey(entryNode.getId())) {
                    root.addChild(entryNode);
                    nodeMap.put(entryNode.getId(), entryNode);
                }
                entryNode.addChild(QuotaMetaHelper.buildNode4Property(entryNode, pro, params));
            }
            return root;
        }
        return null;
    }

    private static TreeNode getEntryNode(Map<String, TreeNode> nodeMap, IDataEntityType entryPro) {
        String entryNodeId = entryPro.getName();
        TreeNode entryNode = nodeMap.get(entryNodeId);
        if (entryNode == null) {
            entryNode = QuotaMetaHelper.getTreeNode(QuotaMetaHelper.getRootId(), entryNodeId, entryPro.getDisplayName().toString());
            entryNode.setIsOpened(true);
        }
        return entryNode;
    }

    private static TreeNode buildNode4Property(TreeNode parentNode, IDataEntityProperty pro, TreeNodeParams params) {
        if (!QuotaMetaHelper.filterPro(pro, params)) {
            return null;
        }
        return QuotaMetaHelper.buildProTreeNode(parentNode, pro);
    }

    private static TreeNode getTreeNode(String parentId, String id, String text) {
        return new TreeNode(parentId, id, text);
    }

    private static TreeNode buildProTreeNode(TreeNode parentNode, IDataEntityProperty pro) {
        String parentId = parentNode.getId();
        if ("0".equals(parentId)) {
            return QuotaMetaHelper.getTreeNode(parentId, pro.getName(), pro.getDisplayName().toString());
        }
        return QuotaMetaHelper.getTreeNode(parentId, parentId + "." + pro.getName(), pro.getDisplayName().toString());
    }

    private static boolean filterPro(IDataEntityProperty pro, TreeNodeParams params) {
        Set<String> includeNodes;
        boolean flag = true;
        IDataEntityType parent = pro.getParent();
        String name = pro.getName();
        if (parent instanceof EntryType) {
            name = parent.getName() + "." + name;
        }
        if ((includeNodes = params.getIncludeNodes()) != null && includeNodes.size() > 0) {
            flag = includeNodes.contains(name);
        }
        Set<String> excludeNodes = params.getExcludeNodes();
        if (flag && excludeNodes != null && excludeNodes.size() > 0) {
            flag = !excludeNodes.contains(name);
        }
        return flag;
    }

    private static String getRootId() {
        return "0";
    }
}

