/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.quotamodel.business.helper;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.mpscmm.msbd.business.helper.FieldMapHelper;
import kd.mpscmm.msbd.common.enums.EnableStatusEnum;
import kd.mpscmm.msbd.common.enums.StatusEnum;
import kd.mpscmm.msbd.quotamodel.common.pojo.QuotaSchemeConfigInfo;

public class QuotaSchemeHelper {
    public static FilterBuilder convertStringToQFilter(String runcondition, String srcType) {
        if (StringUtils.isNotEmpty((String)runcondition)) {
            FilterCondition condition = (FilterCondition)SerializationUtils.fromJsonString((String)runcondition, FilterCondition.class);
            condition.createMetaData();
            FilterBuilder fb = new FilterBuilder(EntityMetadataCache.getDataEntityType((String)srcType), condition);
            fb.buildFilter();
            return fb;
        }
        return null;
    }

    public static DynamicObject queryScheme(Long quotaSchemeId) {
        QFilter idFltr = new QFilter("id", "=", (Object)quotaSchemeId);
        QFilter enableFltr = new QFilter("enable", "=", (Object)EnableStatusEnum.ENABLE.getValue());
        QFilter auditFltr = new QFilter("status", "=", (Object)StatusEnum.AUDIT.getValue());
        DynamicObject quotaSchemeDO = BusinessDataServiceHelper.loadSingleFromCache((String)"msbd_quotascheme", (QFilter[])new QFilter[]{idFltr.and(enableFltr).and(auditFltr)});
        return quotaSchemeDO;
    }

    public static Set<String> queryMatchKey(Long schemeId) {
        DynamicObjectCollection quotaSchemeEntrys;
        HashSet<String> matchKeys = new HashSet<String>();
        DynamicObject quotaSchemeDO = QuotaSchemeHelper.queryScheme(schemeId);
        if (quotaSchemeDO != null && (quotaSchemeEntrys = quotaSchemeDO.getDynamicObjectCollection("calsettingentity")) != null) {
            for (int i = 0; i < quotaSchemeEntrys.size(); ++i) {
                String conditionJson = ((DynamicObject)quotaSchemeEntrys.get(i)).getString("matchconditionjson");
                if (!StringUtils.isNotEmpty((String)conditionJson)) continue;
                JSONArray conditions = JSON.parseArray((String)conditionJson);
                for (Object condition : conditions) {
                    matchKeys.add((String)condition);
                }
            }
        }
        return matchKeys;
    }

    public static List<QuotaSchemeConfigInfo> querySchemeEntry(Long quotaSchemeId) {
        QFilter idFltr = new QFilter("id", "=", (Object)quotaSchemeId);
        QFilter enableFltr = new QFilter("enable", "=", (Object)EnableStatusEnum.ENABLE.getValue());
        QFilter auditFltr = new QFilter("status", "=", (Object)StatusEnum.AUDIT.getValue());
        DataSet DSSchemeEntrys = QueryServiceHelper.queryDataSet((String)QuotaSchemeHelper.class.getName(), (String)"msbd_quotascheme", (String)"calsettingentity.quotasource, calsettingentity.quotamapping,calsettingentity.quotacategory, calsettingentity.quotarangejson_tag, calsettingentity.matchconditionjson, calsettingentity.quotacalrule, calsettingentity.quotacalresultjson, calsettingentity.priority", (QFilter[])new QFilter[]{idFltr.and(enableFltr).and(auditFltr)}, (String)"calsettingentity.priority");
        DSSchemeEntrys = DSSchemeEntrys.orderBy(new String[]{"calsettingentity.priority"});
        ArrayList<QuotaSchemeConfigInfo> schemeCfgInfo = new ArrayList<QuotaSchemeConfigInfo>();
        for (Row row : DSSchemeEntrys) {
            QuotaSchemeConfigInfo info = new QuotaSchemeConfigInfo();
            info.setQuotaSchemeID(quotaSchemeId);
            info.setQuotaSource(row.getString("calsettingentity.quotasource"));
            info.setQuotaMappingID(row.getLong("calsettingentity.quotamapping"));
            info.setQuotaCategoryID(row.getLong("calsettingentity.quotacategory"));
            Map tempTgtColMap = FieldMapHelper.getFieldMapById((Long)Long.valueOf(row.getString("calsettingentity.quotamapping")), (String)"target");
            info.setQuotaTgtFieldMap(tempTgtColMap);
            Map tempSrcColMap = FieldMapHelper.getFieldMapById((Long)Long.valueOf(row.getString("calsettingentity.quotamapping")), (String)"source");
            info.setQuotaSrcFieldMap(tempSrcColMap);
            info.setSrcRange(row.getString("calsettingentity.quotarangejson_tag"));
            info.setQuotaMatchKey(QuotaSchemeHelper.getKeySet(row.getString("calsettingentity.matchconditionjson")));
            info.setQuotaCalRuleID(row.getLong("calsettingentity.quotacalrule"));
            info.setQuotaResultKey(QuotaSchemeHelper.getKeySet(row.getString("calsettingentity.quotacalresultjson")));
            info.setPriority(row.getInteger("calsettingentity.priority"));
            schemeCfgInfo.add(info);
        }
        DSSchemeEntrys.close();
        return schemeCfgInfo;
    }

    public static Set<String> getKeySet(String keyJson) {
        JSONArray JsonStr = JSON.parseArray((String)keyJson);
        HashSet<String> keySet = new HashSet<String>();
        for (Object str : JsonStr) {
            keySet.add((String)str);
        }
        return keySet;
    }
}

