/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.quotamodel.business.service;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.mpscmm.msbd.business.helper.FieldMapHelper;
import kd.mpscmm.msbd.common.enums.EnableStatusEnum;
import kd.mpscmm.msbd.common.enums.StatusEnum;
import kd.mpscmm.msbd.common.utils.CommonUtils;
import kd.mpscmm.msbd.quotamodel.business.algorithm.AbstractQuotaStrategy;
import kd.mpscmm.msbd.quotamodel.business.algorithm.QuotaStrategyExcutor;
import kd.mpscmm.msbd.quotamodel.business.helper.QuotaSchemeHelper;
import kd.mpscmm.msbd.quotamodel.common.pojo.QuotaCalInParam;
import kd.mpscmm.msbd.quotamodel.common.pojo.QuotaRecordDetailInfo;
import kd.mpscmm.msbd.quotamodel.common.pojo.QuotaRecordInfo;
import kd.mpscmm.msbd.quotamodel.common.pojo.QuotaSchemeConfigInfo;
import org.apache.commons.lang3.StringUtils;

public class QuotaService {
    private static final Log log = LogFactory.getLog(QuotaService.class);

    public static QuotaRecordInfo checkParam(QuotaCalInParam queryInfo, String checkType) {
        QuotaRecordInfo quotaCheckRecord = new QuotaRecordInfo();
        if (queryInfo != null && queryInfo.getDataInfos() != null && queryInfo.getDataInfos().size() >= 500000) {
            quotaCheckRecord.setSuccess(false);
            quotaCheckRecord.setDetail(ResManager.loadKDString((String)"\u5165\u53c2\u6570\u636e\u91cf\u8d85\u8fc750w\uff0c\u8bf7\u5206\u6279\u67e5\u8be2/\u8ba1\u7b97\u914d\u989d\u3002", (String)"QuotaService_19", (String)"mpscmm-msbd-quotamodel", (Object[])new Object[0]));
            return quotaCheckRecord;
        }
        if (queryInfo instanceof QuotaCalInParam) {
            if (queryInfo.getQuotaSchemeID() == null) {
                quotaCheckRecord.setSuccess(false);
                quotaCheckRecord.setDetail(ResManager.loadKDString((String)"\u53c2\u6570\u201c\u914d\u989d\u5e94\u7528\u65b9\u6848ID\u201d\u4e3a\u5fc5\u586b\u9879\uff0c\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"QuotaService_0", (String)"mpscmm-msbd-quotamodel", (Object[])new Object[0]));
                return quotaCheckRecord;
            }
            DynamicObject schemeDO = QuotaSchemeHelper.queryScheme(queryInfo.getQuotaSchemeID());
            if (schemeDO == null) {
                quotaCheckRecord.setSuccess(false);
                quotaCheckRecord.setDetail(String.format(ResManager.loadKDString((String)"\u4f20\u5165\u53c2\u6570\u4e2d\u914d\u989d\u5e94\u7528\u65b9\u6848\u201c%s\u201d\u672a\u67e5\u627e\u6216\u4e0d\u53ef\u7528\u3002", (String)"QuotaService_1", (String)"mpscmm-msbd-quotamodel", (Object[])new Object[0]), queryInfo.getQuotaSchemeID().toString()));
                return quotaCheckRecord;
            }
            DynamicObjectCollection querySchemeEntryColl = schemeDO.getDynamicObjectCollection("calsettingentity");
            if (querySchemeEntryColl.size() == 0) {
                quotaCheckRecord.setSuccess(false);
                quotaCheckRecord.setDetail(String.format(ResManager.loadKDString((String)"\u4f20\u5165\u53c2\u6570\u4e2d\u914d\u989d\u5e94\u7528\u65b9\u6848\u201c%s\u201d\u4e2d\u6ca1\u6709\u914d\u989d\u8ba1\u7b97\u8bbe\u7f6e\u3002", (String)"QuotaService_2", (String)"mpscmm-msbd-quotamodel", (Object[])new Object[0]), queryInfo.getQuotaSchemeID().toString()));
                return quotaCheckRecord;
            }
            for (int i = 0; i < querySchemeEntryColl.size(); ++i) {
                String quotasource = ((DynamicObject)querySchemeEntryColl.get(i)).getString("quotasource");
                DynamicObject quotamapping = ((DynamicObject)querySchemeEntryColl.get(i)).getDynamicObject("quotamapping");
                String matchKey = ((DynamicObject)querySchemeEntryColl.get(i)).getString("matchcondition");
                DynamicObject quotaCalRule = ((DynamicObject)querySchemeEntryColl.get(i)).getDynamicObject("quotacalrule");
                String resultKey = ((DynamicObject)querySchemeEntryColl.get(i)).getString("quotacalresult");
                int priority = ((DynamicObject)querySchemeEntryColl.get(i)).getInt("priority");
                StringBuilder errorsb = new StringBuilder();
                if (quotasource == null || quotasource.equals("")) {
                    errorsb.append(ResManager.loadKDString((String)"\u914d\u989d\u6765\u6e90\u4e3a\u7a7a\u3002", (String)"QuotaService_9", (String)"mpscmm-msbd-quotamodel", (Object[])new Object[0]));
                }
                if (quotamapping == null) {
                    errorsb.append(ResManager.loadKDString((String)"\u914d\u989d\u6765\u6e90\u6620\u5c04\u4e3a\u7a7a\u3002", (String)"QuotaService_10", (String)"mpscmm-msbd-quotamodel", (Object[])new Object[0]));
                } else {
                    DynamicObject fieldMapDO = FieldMapHelper.getFieldMapObjById((Long)((Long)quotamapping.getPkValue()));
                    if (fieldMapDO == null) {
                        errorsb.append(ResManager.loadKDString((String)"\u914d\u989d\u6765\u6e90\u6620\u5c04\u672a\u627e\u5230\u6216\u672a\u542f\u7528\u3002", (String)"QuotaService_11", (String)"mpscmm-msbd-quotamodel", (Object[])new Object[0]));
                    }
                }
                if (matchKey == null || matchKey.equals("")) {
                    errorsb.append(ResManager.loadKDString((String)"\u914d\u989d\u5339\u914d\u6761\u4ef6\u4e3a\u7a7a\u3002", (String)"QuotaService_12", (String)"mpscmm-msbd-quotamodel", (Object[])new Object[0]));
                }
                if (quotaCalRule == null) {
                    errorsb.append(ResManager.loadKDString((String)"\u914d\u989d\u8ba1\u7b97\u89c4\u5219\u4e3a\u7a7a\u3002", (String)"QuotaService_13", (String)"mpscmm-msbd-quotamodel", (Object[])new Object[0]));
                } else {
                    QFilter idFltr = new QFilter("id", "=", quotaCalRule.getPkValue());
                    QFilter enableFltr = new QFilter("enable", "=", (Object)EnableStatusEnum.ENABLE.getValue());
                    QFilter auditFltr = new QFilter("status", "=", (Object)StatusEnum.AUDIT.getValue());
                    DynamicObject calRuleDO = BusinessDataServiceHelper.loadSingleFromCache((String)"msbd_quotacalrule", (QFilter[])new QFilter[]{idFltr.and(enableFltr).and(auditFltr)});
                    if (calRuleDO == null) {
                        errorsb.append(ResManager.loadKDString((String)"\u914d\u989d\u8ba1\u7b97\u89c4\u5219\u672a\u627e\u5230\u6216\u672a\u542f\u7528\u3002", (String)"QuotaService_14", (String)"mpscmm-msbd-quotamodel", (Object[])new Object[0]));
                    } else if (checkType.equals("cal")) {
                        DynamicObject algorithm = calRuleDO.getDynamicObject("algorithm");
                        if (algorithm == null) {
                            errorsb.append(ResManager.loadKDString((String)"\u914d\u989d\u8ba1\u7b97\u89c4\u5219\u4e2d\u914d\u989d\u7b97\u6cd5\u4e3a\u7a7a\u3002", (String)"QuotaService_15", (String)"mpscmm-msbd-quotamodel", (Object[])new Object[0]));
                        } else {
                            QFilter algorithmidFltr = new QFilter("id", "=", algorithm.getPkValue());
                            DynamicObject algorithmDO = BusinessDataServiceHelper.loadSingleFromCache((String)"msbd_quotaalgorithm", (QFilter[])new QFilter[]{algorithmidFltr.and(enableFltr).and(auditFltr)});
                            if (algorithmDO == null) {
                                errorsb.append(ResManager.loadKDString((String)"\u914d\u989d\u8ba1\u7b97\u89c4\u5219\u4e2d\u914d\u989d\u7b97\u6cd5\u672a\u627e\u5230\u6216\u672a\u542f\u7528\u3002", (String)"QuotaService_16", (String)"mpscmm-msbd-quotamodel", (Object[])new Object[0]));
                            }
                        }
                    }
                }
                if (resultKey == null) {
                    errorsb.append(ResManager.loadKDString((String)"\u8f93\u51fa\u7ed3\u679c\u4e3a\u7a7a\u3002", (String)"QuotaService_17", (String)"mpscmm-msbd-quotamodel", (Object[])new Object[0]));
                }
                if (priority == 0) {
                    errorsb.append(ResManager.loadKDString((String)"\u4f18\u5148\u7ea7\u4e3a\u7a7a\u3002", (String)"QuotaService_18", (String)"mpscmm-msbd-quotamodel", (Object[])new Object[0]));
                }
                if (errorsb == null || errorsb.toString().equals("")) continue;
                quotaCheckRecord.setSuccess(false);
                quotaCheckRecord.setDetail(String.format(ResManager.loadKDString((String)"\u4f20\u5165\u53c2\u6570\u4e2d\u914d\u989d\u5e94\u7528\u65b9\u6848\u201c%1$s\u201d\uff0c\u7b2c\u201c%2$s\u201d\u884c\u4e2d\u201c%3$s\u201d\u3002", (String)"QuotaService_3", (String)"mpscmm-msbd-quotamodel", (Object[])new Object[0]), schemeDO.getString("number"), String.valueOf(i + 1), errorsb.toString()));
                return quotaCheckRecord;
            }
            quotaCheckRecord.setSuccess(true);
            return quotaCheckRecord;
        }
        return quotaCheckRecord;
    }

    public static QuotaRecordInfo quotaQuery(QuotaCalInParam queryInfo) {
        QuotaRecordInfo quotaRecord = new QuotaRecordInfo();
        quotaRecord.setExecuteBeginTime(LocalDateTime.now());
        log.info("Quota,queryStartTime\uff1a{}", (Object)LocalDateTime.now());
        long queryStartTime = System.currentTimeMillis();
        Map<String, Map<String, Object>> data = queryInfo.getDataInfos();
        if (data.size() <= 100) {
            log.info("Quota,QuotaService.quotaQuery()\u5165\u53c2:{}", (Object)queryInfo);
        }
        quotaRecord.setQuotaSchemeID(queryInfo.getQuotaSchemeID());
        DynamicObject schemeDO = QuotaSchemeHelper.queryScheme(queryInfo.getQuotaSchemeID());
        if (schemeDO == null) {
            quotaRecord.setSuccess(false);
            quotaRecord.setDetail(ResManager.loadKDString((String)"\u65b9\u6848\u201c%s\u201d\u672a\u67e5\u627e\u5230\u914d\u989d\u65b9\u6848\uff0c\u6216\u914d\u989d\u65b9\u6848\u4e0d\u53ef\u7528\u3002", (String)"QuotaService_4", (String)"mpscmm-msbd-quotamodel", (Object[])new Object[]{queryInfo.getQuotaSchemeID().toString()}));
            log.info(quotaRecord.getDetail());
        } else {
            List<QuotaRecordDetailInfo> recordDetails = QuotaService.quotaQueryExecutor(queryInfo);
            quotaRecord.setQuotaRecordDetails(recordDetails);
            quotaRecord.setSuccess(true);
            if (recordDetails.size() <= 100) {
                log.info("Quota,QuotaService.quotaQuery()\u51fa\u53c2:{}", (Object)quotaRecord);
            }
        }
        DynamicObject currentUserDO = BusinessDataServiceHelper.loadSingleFromCache((Object)UserServiceHelper.getCurrentUserId(), (String)"bos_user");
        if (currentUserDO != null) {
            quotaRecord.setExecutorID((Long)currentUserDO.getPkValue());
        }
        quotaRecord.setExecuteEndTime(LocalDateTime.now());
        log.info("Quota,queryEndTime\uff1a{}", (Object)LocalDateTime.now());
        long queryEndTime = System.currentTimeMillis();
        log.info("Quota,query use time\uff1a{} ms", (Object)(queryEndTime - queryStartTime));
        return quotaRecord;
    }

    private static List<QuotaRecordDetailInfo> quotaQueryExecutor(QuotaCalInParam queryInfo) {
        ArrayList<QuotaRecordDetailInfo> recordDetailInfoList = new ArrayList<QuotaRecordDetailInfo>(16);
        List<QuotaSchemeConfigInfo> schemeCfgInfos = QuotaSchemeHelper.querySchemeEntry(queryInfo.getQuotaSchemeID());
        HashMap<String, Map<String, Object>> unQuotaRawData = new HashMap<String, Map<String, Object>>(16);
        HashMap quotaedRawData = new HashMap(16);
        Map<String, Map<String, Object>> reQuotaedRawData = queryInfo.getDataInfos();
        for (QuotaSchemeConfigInfo cfgInfo : schemeCfgInfos) {
            for (Map.Entry<String, Map<String, Object>> rawData : reQuotaedRawData.entrySet()) {
                unQuotaRawData.put(rawData.getKey(), rawData.getValue());
            }
            Set<String> matchKey = cfgInfo.getQuotaMatchKey();
            String grpField = QuotaService.getGrgField(matchKey);
            if (grpField == null || grpField.equals("")) {
                for (Map.Entry data : unQuotaRawData.entrySet()) {
                    boolean match = true;
                    for (String mkey : matchKey) {
                        if (mkey.equalsIgnoreCase("validdate") || mkey.equalsIgnoreCase("invaliddate") || null != queryInfo.getDataInfos().get(data.getKey()).get(mkey)) continue;
                        match = false;
                    }
                    if (!match) continue;
                    HashMap dataMap = new HashMap(1);
                    dataMap.put(data.getKey(), data.getValue());
                    ArrayList dataMapLst = new ArrayList(1);
                    dataMapLst.add(dataMap);
                    ArrayList<List<Map<String, Map<String, Object>>>> rawQuota = new ArrayList<List<Map<String, Map<String, Object>>>>(1);
                    rawQuota.add(dataMapLst);
                    List<QuotaRecordDetailInfo> queryQuotaData = QuotaService.queryQuotaData(cfgInfo, grpField, null, rawQuota, "query");
                    if (queryQuotaData == null) continue;
                    recordDetailInfoList.addAll(queryQuotaData);
                }
            } else {
                String quotaGrpFld = cfgInfo.getQuotaTgtFieldMap().get("grpField");
                Map<String, Map<String, Object>> unGrpRawData = queryInfo.getDataInfos();
                for (Map.Entry data : unQuotaRawData.entrySet()) {
                    boolean match = true;
                    for (String mkey : matchKey) {
                        if (mkey.equalsIgnoreCase("validdate") || mkey.equalsIgnoreCase("invaliddate") || null != queryInfo.getDataInfos().get(data.getKey()).get(mkey)) continue;
                        match = false;
                    }
                    if (!match) continue;
                    unGrpRawData.put((String)data.getKey(), (Map<String, Object>)data.getValue());
                }
                if (unGrpRawData == null || unGrpRawData.size() == 0) continue;
                List<Object> rawDataGrp = new ArrayList(16);
                rawDataGrp = QuotaService.rawDataProcessGroup(unGrpRawData, grpField);
                HashSet<Long> fldIds = new HashSet<Long>(16);
                ArrayList<List<Map<String, Map<String, Object>>>> reprocessForPrelimQuota = new ArrayList<List<Map<String, Map<String, Object>>>>(16);
                int batchSizeNum = 1000;
                if (grpField.equals("org")) {
                    batchSizeNum = 1;
                }
                for (int i = 0; i < rawDataGrp.size(); ++i) {
                    List fldLst = (List)rawDataGrp.get(i);
                    block7: for (Map.Entry rowdata : ((Map)fldLst.get(0)).entrySet()) {
                        Map rowEntry = (Map)rowdata.getValue();
                        for (Map.Entry data : rowEntry.entrySet()) {
                            if (!grpField.equals(data.getKey())) continue;
                            fldIds.add((Long)data.getValue());
                            reprocessForPrelimQuota.add((List<Map<String, Map<String, Object>>>)rawDataGrp.get(i));
                            continue block7;
                        }
                    }
                    if (fldIds.size() != batchSizeNum) continue;
                    recordDetailInfoList.addAll(QuotaService.queryQuotaData(cfgInfo, quotaGrpFld, fldIds, reprocessForPrelimQuota, "query"));
                    fldIds.clear();
                    reprocessForPrelimQuota.clear();
                }
                if (fldIds.size() > 0) {
                    recordDetailInfoList.addAll(QuotaService.queryQuotaData(cfgInfo, quotaGrpFld, fldIds, reprocessForPrelimQuota, "query"));
                }
            }
            reQuotaedRawData.clear();
            for (QuotaRecordDetailInfo detailInfo : recordDetailInfoList) {
                if (detailInfo.getQuotaQueryResultInfos() == null || detailInfo.getQuotaQueryResultInfos().size() == 0) {
                    reQuotaedRawData.put(detailInfo.getDataKey(), (Map<String, Object>)unQuotaRawData.get(detailInfo.getDataKey()));
                    continue;
                }
                quotaedRawData.put(detailInfo.getDataKey(), unQuotaRawData.get(detailInfo.getDataKey()));
            }
            for (Map.Entry undata : unQuotaRawData.entrySet()) {
                if (quotaedRawData.containsKey(undata.getKey())) continue;
                reQuotaedRawData.put((String)undata.getKey(), (Map<String, Object>)undata.getValue());
            }
            unQuotaRawData.clear();
        }
        for (String undataKey : queryInfo.getDataInfos().keySet()) {
            if (quotaedRawData.containsKey(undataKey)) continue;
            QuotaRecordDetailInfo unQuotaedDetailInfo = new QuotaRecordDetailInfo();
            unQuotaedDetailInfo.setDataKey(undataKey);
            unQuotaedDetailInfo.setRecordDetail(ResManager.loadKDString((String)"\u914d\u989d\u6765\u6e90\u4e2d\u672a\u67e5\u8be2\u5230\u914d\u989d\u4fe1\u606f\u3002", (String)"QuotaService_5", (String)"mpscmm-msbd-quotamodel", (Object[])new Object[0]));
            recordDetailInfoList.add(unQuotaedDetailInfo);
            log.info("Quota\uff0cdataKey\uff1a{} : \u914d\u989d\u6765\u6e90\u4e2d\u672a\u67e5\u8be2\u5230\u914d\u989d\u4fe1\u606f", (Object)undataKey);
        }
        return recordDetailInfoList;
    }

    /*
     * WARNING - void declaration
     */
    public static QuotaRecordInfo quotaCal(QuotaCalInParam queryInfo) {
        DynamicObject currentUserDO;
        QuotaRecordInfo quotaCalRecord = new QuotaRecordInfo();
        ArrayList<QuotaRecordDetailInfo> calDetailInfoList = new ArrayList<QuotaRecordDetailInfo>(16);
        ArrayList<QuotaRecordDetailInfo> qryDetailInfoList = new ArrayList<QuotaRecordDetailInfo>(16);
        quotaCalRecord.setExecuteBeginTime(LocalDateTime.now());
        log.info("Quota,calStartTime\uff1a{}", (Object)LocalDateTime.now());
        long calStartTime = System.currentTimeMillis();
        Map<String, Map<String, Object>> infos = queryInfo.getDataInfos();
        if (infos.size() <= 100) {
            log.info("Quota, QuotaService.quotaCal()\u5165\u53c2:{}", (Object)queryInfo);
        }
        quotaCalRecord.setQuotaSchemeID(queryInfo.getQuotaSchemeID());
        DynamicObject schemeDO = QuotaSchemeHelper.queryScheme(queryInfo.getQuotaSchemeID());
        if (schemeDO == null) {
            quotaCalRecord.setSuccess(false);
            quotaCalRecord.setDetail(ResManager.loadKDString((String)"\u65b9\u6848\u201c%s\u201d\u672a\u627e\u5230\u914d\u989d\u65b9\u6848\uff0c\u6216\u914d\u989d\u65b9\u6848\u4e0d\u53ef\u7528\u3002", (String)"QuotaService_6", (String)"mpscmm-msbd-quotamodel", (Object[])new Object[]{queryInfo.getQuotaSchemeID().toString()}));
            log.info("Quota," + quotaCalRecord.getDetail());
        } else {
            List<QuotaSchemeConfigInfo> schemeCfgInfos = QuotaSchemeHelper.querySchemeEntry(queryInfo.getQuotaSchemeID());
            LinkedHashMap<String, Map<String, Object>> unQuotaRawData = new LinkedHashMap<String, Map<String, Object>>(16);
            LinkedHashMap quotaedRawData = new LinkedHashMap(16);
            Map<String, Map<String, Object>> reQuotaedRawData = queryInfo.getDataInfos();
            for (QuotaSchemeConfigInfo cfgInfo : schemeCfgInfos) {
                HashMap<String, BigDecimal> rsltQtyMap;
                Map<String, BigDecimal> currQuotaedMap;
                Map<String, Map<String, BigDecimal>> currBatchQuotaQty;
                QuotaRecordDetailInfo calDetailInfo;
                Map dataValue;
                Object dataKey;
                String currBatchMatchKey;
                Map<Integer, List<Map<String, Object>>> quotaDefMap;
                String grpField;
                if (reQuotaedRawData == null || reQuotaedRawData.size() == 0) break;
                for (Map.Entry<String, Map<String, Object>> rawData : reQuotaedRawData.entrySet()) {
                    unQuotaRawData.put(rawData.getKey(), rawData.getValue());
                }
                Set<String> matchKey = cfgInfo.getQuotaMatchKey();
                Long quotaCalRuleID = cfgInfo.getQuotaCalRuleID();
                if (matchKey == null || quotaCalRuleID == null) continue;
                QFilter ruleIdFltr = new QFilter("id", "=", (Object)quotaCalRuleID);
                DynamicObject quotaCalRuleDO = BusinessDataServiceHelper.loadSingleFromCache((String)"msbd_quotacalrule", (String)"id,number,enable,status,resultadjust,algorithm", (QFilter[])new QFilter[]{ruleIdFltr});
                DynamicObject algorithmDO = null;
                if (quotaCalRuleDO != null && quotaCalRuleDO.get("enable").toString().equals("1") && quotaCalRuleDO.get("status").toString().equals("C")) {
                    QFilter algorithmIdFltr = new QFilter("id", "=", quotaCalRuleDO.getDynamicObject("algorithm").getPkValue());
                    algorithmDO = BusinessDataServiceHelper.loadSingleFromCache((String)"msbd_quotaalgorithm", (String)"id,number,enable,status,plugin", (QFilter[])new QFilter[]{algorithmIdFltr});
                }
                String classname = "";
                if (algorithmDO != null) {
                    classname = algorithmDO.getString("plugin");
                }
                Boolean isResultAdjust = false;
                if (quotaCalRuleDO != null) {
                    isResultAdjust = quotaCalRuleDO.getBoolean("resultadjust");
                }
                if ((grpField = QuotaService.getGrgField(matchKey)) == null || grpField.equals("")) {
                    for (Map.Entry data : unQuotaRawData.entrySet()) {
                        boolean match = true;
                        for (String mkey : matchKey) {
                            if (mkey.equalsIgnoreCase("validdate") || mkey.equalsIgnoreCase("invaliddate") || null != queryInfo.getDataInfos().get(data.getKey()).get(mkey)) continue;
                            match = false;
                        }
                        if (!match) continue;
                        HashMap dataMap = new HashMap(1);
                        dataMap.put(data.getKey(), data.getValue());
                        ArrayList dataMapLst = new ArrayList(1);
                        dataMapLst.add(dataMap);
                        ArrayList<List<Map<String, Map<String, Object>>>> rawQuota = new ArrayList<List<Map<String, Map<String, Object>>>>(1);
                        rawQuota.add(dataMapLst);
                        List<QuotaRecordDetailInfo> queryQuotaData = QuotaService.queryQuotaData(cfgInfo, grpField, null, rawQuota, "cal");
                        if (queryQuotaData == null || queryQuotaData.size() == 0) continue;
                        qryDetailInfoList.addAll(queryQuotaData);
                        for (QuotaRecordDetailInfo quotaRecordDetailInfo : qryDetailInfoList) {
                            quotaDefMap = quotaRecordDetailInfo.getQuotaQueryResultInfos();
                            if (quotaDefMap == null || quotaDefMap.size() == 0) continue;
                            currBatchMatchKey = QuotaService.getCurrBatchMatchKey(quotaDefMap, matchKey);
                            dataKey = quotaRecordDetailInfo.getDataKey();
                            dataValue = (Map)unQuotaRawData.get(dataKey);
                            calDetailInfo = QuotaService.calDetailInfoInit(cfgInfo, quotaRecordDetailInfo, dataValue);
                            if (calDetailInfo == null) continue;
                            currBatchQuotaQty = quotaCalRecord.getCurrBatchQuotaQty();
                            if (currBatchQuotaQty != null && currBatchMatchKey != null && !currBatchMatchKey.equals("")) {
                                calDetailInfo.setCurrentBatchQuotaQty(currBatchQuotaQty.get(currBatchMatchKey));
                            }
                            log.info("Quota,calByRow,dataKey\uff1a{}\uff1balgorithm\uff1a{}\uff1bisResultAdjust\uff1a{}", new Object[]{quotaRecordDetailInfo.getDataKey(), classname, isResultAdjust});
                            if ((calDetailInfo = QuotaService.calculateQuota(calDetailInfo, classname, isResultAdjust, null)).getQuotaCalculateResultInfos() == null) continue;
                            currQuotaedMap = calDetailInfo.getCurrentBatchQuotaQty();
                            if (currQuotaedMap != null && currBatchMatchKey != null && !currBatchMatchKey.equals("")) {
                                for (Map.Entry<String, BigDecimal> quotaQty : currQuotaedMap.entrySet()) {
                                    if (quotaCalRecord.getCurrBatchQuotaQty() != null && quotaCalRecord.getCurrBatchQuotaQty().get(currBatchMatchKey) != null) {
                                        quotaCalRecord.getCurrBatchQuotaQty().get(currBatchMatchKey).put(quotaQty.getKey(), quotaQty.getValue());
                                        continue;
                                    }
                                    if (quotaCalRecord.getCurrBatchQuotaQty() != null && quotaCalRecord.getCurrBatchQuotaQty().get(currBatchMatchKey) == null) {
                                        rsltQtyMap = new HashMap(16);
                                        rsltQtyMap.put(quotaQty.getKey(), quotaQty.getValue());
                                        quotaCalRecord.getCurrBatchQuotaQty().put(currBatchMatchKey, rsltQtyMap);
                                        continue;
                                    }
                                    if (quotaCalRecord.getCurrBatchQuotaQty() != null) continue;
                                    rsltQtyMap = new HashMap<String, BigDecimal>(16);
                                    rsltQtyMap.put(quotaQty.getKey(), quotaQty.getValue());
                                    HashMap<String, Map<String, BigDecimal>> hashMap = new HashMap<String, Map<String, BigDecimal>>(16);
                                    hashMap.put(currBatchMatchKey, rsltQtyMap);
                                    quotaCalRecord.setCurrBatchQuotaQty(hashMap);
                                }
                            }
                            calDetailInfoList.add(calDetailInfo);
                        }
                        qryDetailInfoList.clear();
                    }
                } else {
                    List<Map<String, Map<String, Object>>> fldLst;
                    String quotaGrpFld;
                    String string = quotaGrpFld = cfgInfo.getQuotaTgtFieldMap() != null ? cfgInfo.getQuotaTgtFieldMap().get(grpField) : "";
                    if (quotaGrpFld == null || quotaGrpFld.equals("")) {
                        log.info("Quota\uff0c\u5173\u952e\u5206\u7ec4\u5b57\u6bb5\u672a\u505a\u6620\u5c04\uff01");
                        continue;
                    }
                    LinkedHashMap<String, Map<String, Object>> unGrpRawData = new LinkedHashMap<String, Map<String, Object>>(16);
                    for (Map.Entry data : unQuotaRawData.entrySet()) {
                        boolean match = true;
                        for (String mkey : matchKey) {
                            if (mkey.equalsIgnoreCase("validdate") || mkey.equalsIgnoreCase("invaliddate") || null != queryInfo.getDataInfos().get(data.getKey()).get(mkey)) continue;
                            match = false;
                        }
                        if (!match) continue;
                        unGrpRawData.put((String)data.getKey(), (Map<String, Object>)data.getValue());
                    }
                    if (unGrpRawData == null || unGrpRawData.size() == 0) continue;
                    List<List<Map<String, Map<String, Object>>>> rawDataGrp = QuotaService.rawDataProcessGroup(unGrpRawData, grpField);
                    HashSet<Long> fldIds = new HashSet<Long>(16);
                    ArrayList<List<Map<String, Map<String, Object>>>> reprocessForPrelimQuota = new ArrayList<List<Map<String, Map<String, Object>>>>(16);
                    int batchSizeNum = 1000;
                    if (grpField.equals("org")) {
                        batchSizeNum = 1;
                    }
                    for (int i = 0; i < rawDataGrp.size() && (fldLst = rawDataGrp.get(i)).size() != 0; ++i) {
                        void var30_43;
                        Object rowdata2;
                        block9: for (Object rowdata2 : fldLst.get(0).entrySet()) {
                            Map<String, Object> rowEntry = rowdata2.getValue();
                            for (Map.Entry<String, Object> data : rowEntry.entrySet()) {
                                if (!grpField.equals(data.getKey())) continue;
                                fldIds.add((Long)data.getValue());
                                reprocessForPrelimQuota.add(rawDataGrp.get(i));
                                continue block9;
                            }
                        }
                        if (fldIds.size() != batchSizeNum) continue;
                        log.info("Quota,calByBatch\uff0cgrpFld\uff1a{},fldIDs\uff1a{}", (Object)quotaGrpFld, fldIds);
                        qryDetailInfoList.clear();
                        qryDetailInfoList.addAll(QuotaService.queryQuotaData(cfgInfo, quotaGrpFld, fldIds, reprocessForPrelimQuota, "cal"));
                        Object var30_41 = null;
                        if (isResultAdjust.booleanValue()) {
                            DataSet dataSet = QuotaService.querySourceListPrelim(grpField, fldIds);
                        }
                        rowdata2 = qryDetailInfoList.iterator();
                        while (rowdata2.hasNext()) {
                            QuotaRecordDetailInfo qryDetailInfo2 = (QuotaRecordDetailInfo)rowdata2.next();
                            Map<Integer, List<Map<String, Object>>> quotaDefMap2 = qryDetailInfo2.getQuotaQueryResultInfos();
                            if (quotaDefMap2 == null || quotaDefMap2.size() == 0) continue;
                            String currBatchMatchKey2 = QuotaService.getCurrBatchMatchKey(quotaDefMap2, matchKey);
                            String dataKey2 = qryDetailInfo2.getDataKey();
                            Map dataValue2 = (Map)unQuotaRawData.get(dataKey2);
                            QuotaRecordDetailInfo calDetailInfo2 = QuotaService.calDetailInfoInit(cfgInfo, qryDetailInfo2, dataValue2);
                            if (calDetailInfo2 == null) continue;
                            Map<String, Map<String, BigDecimal>> currBatchQuotaQty2 = quotaCalRecord.getCurrBatchQuotaQty();
                            if (currBatchQuotaQty2 != null && currBatchMatchKey2 != null && !currBatchMatchKey2.equals("")) {
                                calDetailInfo2.setCurrentBatchQuotaQty(currBatchQuotaQty2.get(currBatchMatchKey2));
                            }
                            log.info("Quota,calByBatch,dataKey\uff1a{}\uff1balgorithm\uff1a{}\uff1bisResultAdjust\uff1a{}", new Object[]{dataKey2, classname, isResultAdjust});
                            if ((calDetailInfo2 = QuotaService.calculateQuota(calDetailInfo2, classname, isResultAdjust, (DataSet)var30_43)).getQuotaCalculateResultInfos() == null) continue;
                            Map<String, BigDecimal> currQuotaedMap2 = calDetailInfo2.getCurrentBatchQuotaQty();
                            if (currQuotaedMap2 != null && currBatchMatchKey2 != null && !currBatchMatchKey2.equals("")) {
                                for (Map.Entry entry : currQuotaedMap2.entrySet()) {
                                    if (quotaCalRecord.getCurrBatchQuotaQty() != null && quotaCalRecord.getCurrBatchQuotaQty().get(currBatchMatchKey2) != null) {
                                        quotaCalRecord.getCurrBatchQuotaQty().get(currBatchMatchKey2).put((String)entry.getKey(), (BigDecimal)entry.getValue());
                                        continue;
                                    }
                                    if (quotaCalRecord.getCurrBatchQuotaQty() != null && quotaCalRecord.getCurrBatchQuotaQty().get(currBatchMatchKey2) == null) {
                                        HashMap rsltQtyMap2 = new HashMap(16);
                                        rsltQtyMap2.put(entry.getKey(), entry.getValue());
                                        quotaCalRecord.getCurrBatchQuotaQty().put(currBatchMatchKey2, rsltQtyMap2);
                                        continue;
                                    }
                                    if (quotaCalRecord.getCurrBatchQuotaQty() != null) continue;
                                    HashMap rsltQtyMap2 = new HashMap(16);
                                    rsltQtyMap2.put(entry.getKey(), entry.getValue());
                                    HashMap<String, Map<String, BigDecimal>> rsltMap2 = new HashMap<String, Map<String, BigDecimal>>(16);
                                    rsltMap2.put(currBatchMatchKey2, rsltQtyMap2);
                                    quotaCalRecord.setCurrBatchQuotaQty(rsltMap2);
                                }
                            }
                            calDetailInfoList.add(calDetailInfo2);
                        }
                        qryDetailInfoList.clear();
                        fldIds.clear();
                        reprocessForPrelimQuota.clear();
                        if (var30_43 == null) continue;
                        var30_43.close();
                    }
                    if (fldIds.size() > 0) {
                        log.info("Quota,calByRemain\uff0cgrpFld\uff1a{},fldIDs\uff1a{}", (Object)quotaGrpFld, fldIds);
                        qryDetailInfoList.addAll(QuotaService.queryQuotaData(cfgInfo, quotaGrpFld, fldIds, reprocessForPrelimQuota, "cal"));
                        DataSet srcListPrelim = null;
                        if (isResultAdjust.booleanValue()) {
                            srcListPrelim = QuotaService.querySourceListPrelim(grpField, fldIds);
                        }
                        for (QuotaRecordDetailInfo quotaRecordDetailInfo : qryDetailInfoList) {
                            quotaDefMap = quotaRecordDetailInfo.getQuotaQueryResultInfos();
                            if (quotaDefMap == null || quotaDefMap.size() == 0) continue;
                            currBatchMatchKey = QuotaService.getCurrBatchMatchKey(quotaDefMap, matchKey);
                            dataKey = quotaRecordDetailInfo.getDataKey();
                            dataValue = (Map)unQuotaRawData.get(dataKey);
                            calDetailInfo = QuotaService.calDetailInfoInit(cfgInfo, quotaRecordDetailInfo, dataValue);
                            if (calDetailInfo == null) continue;
                            currBatchQuotaQty = quotaCalRecord.getCurrBatchQuotaQty();
                            if (currBatchQuotaQty != null && currBatchMatchKey != null && !currBatchMatchKey.equals("")) {
                                calDetailInfo.setCurrentBatchQuotaQty(currBatchQuotaQty.get(currBatchMatchKey));
                            }
                            log.info("Quota,calByRemain,dataKey\uff1a{}\uff1balgorithm\uff1a{}\uff1bisResultAdjust\uff1a{}", new Object[]{dataKey, classname, isResultAdjust});
                            if ((calDetailInfo = QuotaService.calculateQuota(calDetailInfo, classname, isResultAdjust, srcListPrelim)).getQuotaCalculateResultInfos() == null) continue;
                            currQuotaedMap = calDetailInfo.getCurrentBatchQuotaQty();
                            if (currQuotaedMap != null && currBatchMatchKey != null && !currBatchMatchKey.equals("")) {
                                for (Map.Entry<String, BigDecimal> quotaQty : currQuotaedMap.entrySet()) {
                                    if (quotaCalRecord.getCurrBatchQuotaQty() != null && quotaCalRecord.getCurrBatchQuotaQty().get(currBatchMatchKey) != null) {
                                        quotaCalRecord.getCurrBatchQuotaQty().get(currBatchMatchKey).put(quotaQty.getKey(), quotaQty.getValue());
                                        continue;
                                    }
                                    if (quotaCalRecord.getCurrBatchQuotaQty() != null && quotaCalRecord.getCurrBatchQuotaQty().get(currBatchMatchKey) == null) {
                                        rsltQtyMap = new HashMap(16);
                                        rsltQtyMap.put(quotaQty.getKey(), quotaQty.getValue());
                                        quotaCalRecord.getCurrBatchQuotaQty().put(currBatchMatchKey, rsltQtyMap);
                                        continue;
                                    }
                                    if (quotaCalRecord.getCurrBatchQuotaQty() != null) continue;
                                    rsltQtyMap = new HashMap<String, BigDecimal>(16);
                                    rsltQtyMap.put(quotaQty.getKey(), quotaQty.getValue());
                                    HashMap<String, Map<String, BigDecimal>> hashMap = new HashMap<String, Map<String, BigDecimal>>(16);
                                    hashMap.put(currBatchMatchKey, rsltQtyMap);
                                    quotaCalRecord.setCurrBatchQuotaQty(hashMap);
                                }
                            }
                            calDetailInfoList.add(calDetailInfo);
                        }
                        qryDetailInfoList.clear();
                        fldIds.clear();
                        reprocessForPrelimQuota.clear();
                        if (srcListPrelim != null) {
                            srcListPrelim.close();
                        }
                    }
                }
                reQuotaedRawData.clear();
                for (QuotaRecordDetailInfo detailInfo : calDetailInfoList) {
                    if (detailInfo.getQuotaCalculateResultInfos() == null || detailInfo.getQuotaCalculateResultInfos().size() == 0) {
                        reQuotaedRawData.put(detailInfo.getDataKey(), (Map<String, Object>)unQuotaRawData.get(detailInfo.getDataKey()));
                        continue;
                    }
                    quotaedRawData.put(detailInfo.getDataKey(), unQuotaRawData.get(detailInfo.getDataKey()));
                }
                for (Map.Entry undata : unQuotaRawData.entrySet()) {
                    if (quotaedRawData.containsKey(undata.getKey())) continue;
                    reQuotaedRawData.put((String)undata.getKey(), (Map<String, Object>)undata.getValue());
                }
                unQuotaRawData.clear();
            }
            for (String undataKey : queryInfo.getDataInfos().keySet()) {
                if (quotaedRawData.containsKey(undataKey)) continue;
                QuotaRecordDetailInfo unQuotaedDetailInfo = new QuotaRecordDetailInfo();
                unQuotaedDetailInfo.setDataKey(undataKey);
                unQuotaedDetailInfo.setDataSuccess(false);
                unQuotaedDetailInfo.setRecordDetail(ResManager.loadKDString((String)"\u914d\u989d\u6761\u4ef6\u4e0d\u7b26\u5408\u6216\u8005\u914d\u989d\u6765\u6e90\u4e2d\u672a\u67e5\u8be2\u5230\u914d\u989d\u4fe1\u606f\u3002", (String)"QuotaService_7", (String)"mpscmm-msbd-quotamodel", (Object[])new Object[0]));
                calDetailInfoList.add(unQuotaedDetailInfo);
                log.info("Quota,dataKey{}\uff1a\u914d\u989d\u6761\u4ef6\u4e0d\u7b26\u5408\u6216\u8005\u914d\u989d\u6765\u6e90\u4e2d\u672a\u67e5\u8be2\u5230\u914d\u989d\u4fe1\u606f", (Object)undataKey);
            }
            quotaCalRecord.setQuotaRecordDetails(calDetailInfoList);
            if (quotaedRawData.size() == 0) {
                quotaCalRecord.setSuccess(false);
            } else {
                quotaCalRecord.setSuccess(true);
            }
        }
        if (quotaCalRecord.getQuotaRecordDetails().size() <= 100) {
            log.info("Quota,QuotaService.quotaCal()\u51fa\u53c2:{}", (Object)quotaCalRecord);
        }
        if ((currentUserDO = BusinessDataServiceHelper.loadSingleFromCache((Object)UserServiceHelper.getCurrentUserId(), (String)"bos_user")) != null) {
            quotaCalRecord.setExecutorID((Long)currentUserDO.getPkValue());
        }
        quotaCalRecord.setExecuteEndTime(LocalDateTime.now());
        log.info("Quota,calEndTime\uff1a{} ", (Object)LocalDateTime.now());
        long calEndTime = System.currentTimeMillis();
        log.info("Quota,cal use time\uff1a{} ms ", (Object)(calEndTime - calStartTime));
        return quotaCalRecord;
    }

    private static QuotaRecordDetailInfo calDetailInfoInit(QuotaSchemeConfigInfo cfgInfo, QuotaRecordDetailInfo qryDetailInfo, Map<String, Object> dataValue) {
        if (cfgInfo == null || qryDetailInfo == null || dataValue == null) {
            return null;
        }
        QuotaRecordDetailInfo calDetailInfo = new QuotaRecordDetailInfo();
        calDetailInfo.setQuotaSource(cfgInfo.getQuotaSource());
        calDetailInfo.setQuotaMappingID(cfgInfo.getQuotaMappingID());
        calDetailInfo.setMatchKey(cfgInfo.getQuotaMatchKey());
        calDetailInfo.setQuotaResultKey(cfgInfo.getQuotaResultKey());
        calDetailInfo.setQuotaCalRuleID(cfgInfo.getQuotaCalRuleID());
        calDetailInfo.setQuotaTgtFieldMap(cfgInfo.getQuotaTgtFieldMap());
        calDetailInfo.setQuotaQueryResultInfos(qryDetailInfo.getQuotaQueryResultInfos());
        String dataKey = qryDetailInfo.getDataKey();
        calDetailInfo.setDataKey(dataKey);
        calDetailInfo.setUnprocessBaseQty((BigDecimal)dataValue.get("baseQty"));
        Long baseUnitID = (Long)dataValue.get("baseUnit");
        if (CommonUtils.isNull((Object)baseUnitID)) {
            DynamicObject materialObj = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_material", (String)"id,baseunit", (QFilter[])new QFilter[]{new QFilter("id", "=", dataValue.get("material"))});
            if (CommonUtils.isNull((Object)materialObj)) {
                return null;
            }
            calDetailInfo.setBaseUnitID((Long)materialObj.getDynamicObject("baseunit").getPkValue());
        } else {
            calDetailInfo.setBaseUnitID((Long)dataValue.get("baseUnit"));
        }
        Date bizdate = new Date();
        if (dataValue.get("validdate") != null) {
            try {
                SimpleDateFormat simpleFormate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                bizdate = simpleFormate.parse((String)dataValue.get("validdate"));
            }
            catch (ParseException e) {
                log.error(e.toString());
            }
        }
        calDetailInfo.setQuotaDate(bizdate);
        calDetailInfo.setMatchValues(dataValue);
        Map supplierBaseQty = (Map)dataValue.get("supplierBaseQty");
        calDetailInfo.setSupplierBaseQty(supplierBaseQty);
        return calDetailInfo;
    }

    private static QuotaRecordDetailInfo calculateQuota(QuotaRecordDetailInfo calDetailInfo, String classname, Boolean isResultAdjust, DataSet srcListPrelim) {
        QuotaStrategyExcutor quotaStrategyExcutor = new QuotaStrategyExcutor();
        quotaStrategyExcutor.setCalRecordDetailInfo(calDetailInfo);
        quotaStrategyExcutor.setIsResultAdjust(isResultAdjust);
        quotaStrategyExcutor.setSourcelistDS(srcListPrelim);
        Object quotaStrategyClass = null;
        try {
            if (classname != null && !classname.equals("")) {
                quotaStrategyClass = TypesContainer.createInstance((String)classname);
                if (quotaStrategyClass instanceof AbstractQuotaStrategy) {
                    quotaStrategyExcutor.setQuotaStrategy((AbstractQuotaStrategy)quotaStrategyClass);
                    calDetailInfo = quotaStrategyExcutor.executeAlgorithm();
                    calDetailInfo.setDataSuccess(true);
                } else {
                    calDetailInfo.setDataSuccess(false);
                    calDetailInfo.setRecordDetail(ResManager.loadKDString((String)"\u672a\u627e\u5230\u7b97\u6cd5\u63d2\u4ef6\u3002", (String)"QuotaService_8", (String)"mpscmm-msbd-quotamodel", (Object[])new Object[0]));
                    log.info("Quota,QuotaCalRuleID\uff1a{} algorithmPlugin not find", (Object)calDetailInfo.getQuotaCalRuleID());
                }
            } else {
                calDetailInfo.setDataSuccess(false);
                calDetailInfo.setRecordDetail(ResManager.loadKDString((String)"\u672a\u627e\u5230\u7b97\u6cd5\u63d2\u4ef6\u3002", (String)"QuotaService_8", (String)"mpscmm-msbd-quotamodel", (Object[])new Object[0]));
                log.info("Quota,QuotaCalRuleID\uff1a{} algorithmPlugin not find", (Object)calDetailInfo.getQuotaCalRuleID());
            }
        }
        catch (Exception ee) {
            log.error("Quota,QuotaService.calculateQuota() \u7684 \u5f85\u914d\u989d\u6570\u636e\uff1a{} \u914d\u989d\u6765\u6e90\uff1a{} \u914d\u989d\u6620\u5c04ID\uff1a{} \u914d\u989d\u5339\u914d\u6761\u4ef6key\uff1a{} \u914d\u989d\u7ed3\u679ckey\uff1a{} \u914d\u989d\u8ba1\u7b97\u89c4\u5219\uff1a{} \u62a5\u9519\uff1a", new Object[]{calDetailInfo.getDataKey(), calDetailInfo.getQuotaSource(), calDetailInfo.getQuotaMappingID(), calDetailInfo.getMatchKey(), calDetailInfo.getQuotaResultKey(), calDetailInfo.getQuotaCalRuleID(), ee});
        }
        return calDetailInfo;
    }

    private static DataSet querySourceListPrelim(String grpField, Set<Long> fldIds) {
        ArrayList selectlistFields = new ArrayList();
        Collections.addAll(selectlistFields, "id", "entryentity.id", "org", "supplier", "enable", "status", "entryentity.material", "entryentity.material.masterid.id", "entryentity.purchaseunit", "entryentity.expirydate");
        Collections.addAll(selectlistFields, "entryentity.maxbillqty", "entryentity.minbillqty", "entryentity.packingbaseqty", "entryentity.effectdate");
        Collections.addAll(selectlistFields, "entryentity.maxbillbaseqty", "entryentity.minbillbaseqty", "entryentity.frozenstatus");
        String selectFields = selectlistFields.stream().collect(Collectors.joining(","));
        QFilter qfLst = QFilter.of((String)"1=1", (Object[])new Object[0]);
        if (grpField != null && !grpField.equals("") && fldIds.size() > 0) {
            if (grpField.equals("material")) {
                grpField = "entryentity.material.masterid.id";
            }
            qfLst.and(new QFilter(grpField, "in", fldIds));
        }
        return QueryServiceHelper.queryDataSet((String)"sourceListQuery", (String)"pm_sourcelist", (String)selectFields, (QFilter[])new QFilter[]{qfLst}, null);
    }

    private static String getGrgField(Set<String> matchKey) {
        String grpFld = "";
        if (matchKey != null) {
            if (matchKey.contains("material")) {
                grpFld = "material";
            } else if (matchKey.contains("org")) {
                grpFld = "org";
            }
        }
        return grpFld;
    }

    private static List<List<Map<String, Map<String, Object>>>> rawDataProcessGroup(Map<String, Map<String, Object>> rawData, String grpFld) {
        if (rawData == null || rawData.size() == 0 || grpFld == null || grpFld.equals("")) {
            return null;
        }
        ArrayList<List<Map<String, Map<String, Object>>>> rawDataGrp = new ArrayList<List<Map<String, Map<String, Object>>>>(16);
        Set grpFldSet = rawData.values().stream().filter(row -> row.containsKey(grpFld)).map(row -> row.get(grpFld)).collect(Collectors.toSet());
        for (Object fld : grpFldSet) {
            ArrayList grpFldList = new ArrayList(16);
            for (Map.Entry<String, Map<String, Object>> raw : rawData.entrySet()) {
                Map<String, Object> rawEntry = raw.getValue();
                for (Map.Entry<String, Object> entry : rawEntry.entrySet()) {
                    if (!grpFld.equals(entry.getKey()) || !fld.equals(entry.getValue())) continue;
                    LinkedHashMap<String, Map<String, Object>> rawMap = new LinkedHashMap<String, Map<String, Object>>(16);
                    rawMap.put(raw.getKey(), raw.getValue());
                    grpFldList.add(rawMap);
                }
            }
            rawDataGrp.add(grpFldList);
        }
        return rawDataGrp;
    }

    private static List<QuotaRecordDetailInfo> queryQuotaData(QuotaSchemeConfigInfo cfgInfo, String grpField, Set<Long> fldIds, List<List<Map<String, Map<String, Object>>>> reprocessForPrelimQuota, String processType) {
        List<Object> QuotaRecordDetailInfoLst = new ArrayList(16);
        if (grpField != null && !grpField.equals("") && fldIds.size() > 0) {
            DataSet prelimQuotaData = QuotaService.queryQuotaDataPrelim(cfgInfo, grpField, fldIds);
            QuotaRecordDetailInfoLst = QuotaService.filterQuotaPrelimData(cfgInfo, reprocessForPrelimQuota, prelimQuotaData, processType);
            prelimQuotaData.close();
        } else {
            QuotaRecordDetailInfoLst = QuotaService.filterQuotaPrelimData(cfgInfo, reprocessForPrelimQuota, null, processType);
        }
        return QuotaRecordDetailInfoLst;
    }

    private static DataSet queryQuotaDataPrelim(QuotaSchemeConfigInfo cfgInfo, String grpField, Set<Long> fldIds) {
        FilterBuilder fb;
        String srcEntity = cfgInfo.getQuotaSource();
        Map<String, String> tgtFldMap = cfgInfo.getQuotaTgtFieldMap();
        Long quotaCategoryID = cfgInfo.getQuotaCategoryID();
        String selectCols = StringUtils.join(tgtFldMap.values(), (char)',');
        if (selectCols != null && !selectCols.equals("")) {
            selectCols = selectCols + ",id,entryentity.id";
        }
        QFilter qfLst = QFilter.of((String)"1=1", (Object[])new Object[0]);
        if (!CommonUtils.isNull((Object)tgtFldMap.get("quotacategory")) && !CommonUtils.isNull((Object)quotaCategoryID) && quotaCategoryID != 0L) {
            qfLst.and(new QFilter(tgtFldMap.get("quotacategory"), "=", (Object)quotaCategoryID));
        }
        if ((fb = QuotaSchemeHelper.convertStringToQFilter(cfgInfo.getSrcRange(), srcEntity)) != null) {
            qfLst.and(fb.getQFilter());
        }
        if (grpField != null && !grpField.equals("") && fldIds.size() > 0) {
            qfLst.and(new QFilter(grpField, "in", fldIds));
        }
        log.info("Quota,queryQuotaDataPrelim\uff0centity\uff1a{}\uff1bselectors\uff1a{}\uff1bcondition\uff1a{}", new Object[]{srcEntity, selectCols, qfLst});
        return QueryServiceHelper.queryDataSet((String)"quotaQuery", (String)srcEntity, (String)selectCols, (QFilter[])new QFilter[]{qfLst}, (String)tgtFldMap.get("priority"));
    }

    private static List<QuotaRecordDetailInfo> filterQuotaPrelimData(QuotaSchemeConfigInfo cfgInfo, List<List<Map<String, Map<String, Object>>>> reprocessForPrelimQuota, DataSet prelimQuotaData, String processType) {
        ArrayList<QuotaRecordDetailInfo> QuotaRecordDetailInfoLst = new ArrayList<QuotaRecordDetailInfo>(16);
        String srcEntity = cfgInfo.getQuotaSource();
        Map<String, String> tgtFldMap = cfgInfo.getQuotaTgtFieldMap();
        Long quotaCategoryID = cfgInfo.getQuotaCategoryID();
        String selectCols = StringUtils.join(tgtFldMap.values(), (char)',');
        if (selectCols != null && !selectCols.equals("")) {
            selectCols = selectCols + ",id,entryentity.id";
        }
        Set<String> matchKeys = cfgInfo.getQuotaMatchKey();
        FilterBuilder fb = QuotaSchemeHelper.convertStringToQFilter(cfgInfo.getSrcRange(), srcEntity);
        for (int i = 0; i < reprocessForPrelimQuota.size(); ++i) {
            List<Map<String, Map<String, Object>>> mapLst = reprocessForPrelimQuota.get(i);
            for (int j = 0; j < mapLst.size(); ++j) {
                Map<String, Map<String, Object>> rowdatas = mapLst.get(j);
                for (Map.Entry<String, Map<String, Object>> rowdata : rowdatas.entrySet()) {
                    Row idrow;
                    DataSet quotaIDDS;
                    Map<String, Object> quotaRawData = rowdata.getValue();
                    QFilter qfLst = QFilter.of((String)"1=1", (Object[])new Object[0]);
                    if (!CommonUtils.isNull((Object)tgtFldMap.get("quotacategory")) && !CommonUtils.isNull((Object)quotaCategoryID) && quotaCategoryID != 0L) {
                        qfLst.and(new QFilter(tgtFldMap.get("quotacategory"), "=", (Object)quotaCategoryID));
                    }
                    for (String mKey : matchKeys) {
                        if (mKey.equalsIgnoreCase("validdate") || mKey.equalsIgnoreCase("invaliddate")) continue;
                        QFilter qf = new QFilter(tgtFldMap.get(mKey), "=", quotaRawData.get(mKey));
                        qfLst.and(qf);
                    }
                    QFilter effectDateQF = null;
                    QFilter expiryDateQF = null;
                    Date dateCont = new Date();
                    if (quotaRawData.get("validdate") != null) {
                        try {
                            SimpleDateFormat simpleFormate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                            dateCont = simpleFormate.parse((String)quotaRawData.get("validdate"));
                        }
                        catch (ParseException e) {
                            log.error(e.toString());
                        }
                    }
                    effectDateQF = new QFilter(tgtFldMap.get("validdate"), "<=", (Object)dateCont);
                    expiryDateQF = new QFilter(tgtFldMap.get("invaliddate"), ">=", (Object)dateCont);
                    DataSet quotaDOs = null;
                    if (prelimQuotaData == null) {
                        if (fb != null) {
                            qfLst.and(fb.getQFilter());
                        }
                        if (!"query".equals(processType) || matchKeys.contains("validdate")) {
                            if (effectDateQF != null) {
                                qfLst.and(effectDateQF);
                            } else if (expiryDateQF != null) {
                                qfLst.and(expiryDateQF);
                            }
                        }
                        log.info("Quota,quotaDataPrelim is null\uff0cquery Quota again,entity\uff1a{}\uff1bselectors\uff1a{}\uff1bconditions\uff1a{}", new Object[]{srcEntity, selectCols, qfLst});
                        quotaDOs = QueryServiceHelper.queryDataSet((String)"quotaQuery", (String)srcEntity, (String)selectCols, (QFilter[])new QFilter[]{qfLst}, (String)tgtFldMap.get("priority"));
                    } else {
                        log.info("Quota\uff0cquotaDataPrelim by filter\uff1a{}", (Object)qfLst);
                        quotaDOs = prelimQuotaData.copy().filter(qfLst.toString());
                        if (effectDateQF != null && expiryDateQF != null && (!"query".equals(processType) || matchKeys.contains("validdate"))) {
                            HashMap<String, Date> dateMap = new HashMap<String, Date>(1);
                            dateMap.put("var", dateCont);
                            quotaDOs = quotaDOs.filter(tgtFldMap.get("validdate") + "<=var", dateMap);
                            quotaDOs = quotaDOs.filter(tgtFldMap.get("invaliddate") + ">=var", dateMap);
                        }
                    }
                    Long quotaId = 0L;
                    if (quotaDOs == null || (quotaIDDS = quotaDOs.copy()) == null) continue;
                    quotaIDDS = quotaIDDS.select("id").orderBy(new String[]{"id desc"});
                    Iterator iterator = quotaIDDS.iterator();
                    while (iterator.hasNext() && ((quotaId = (idrow = (Row)iterator.next()).getLong("id")) == null || quotaId == 0L)) {
                    }
                    HashMap<String, Long> dateIdMap = new HashMap<String, Long>(1);
                    dateIdMap.put("idvar", quotaId);
                    DataSet quotaDefDOs = quotaDOs.filter("id=idvar", dateIdMap);
                    String[] orderbyStrs = new String[]{"entryentity.id"};
                    DataSet quotaDefOrdered = quotaDefDOs.orderBy(orderbyStrs);
                    QuotaRecordDetailInfo recordDetailInfo = new QuotaRecordDetailInfo();
                    recordDetailInfo.setDataKey(rowdata.getKey());
                    recordDetailInfo.setQuotaSource(cfgInfo.getQuotaSource());
                    recordDetailInfo.setQuotaMappingID(cfgInfo.getQuotaMappingID());
                    recordDetailInfo.setMatchKey(cfgInfo.getQuotaMatchKey());
                    HashMap<Integer, List<Map<String, Object>>> Defmap = new HashMap<Integer, List<Map<String, Object>>>(16);
                    for (Row row : quotaDefOrdered) {
                        Integer rank = row.getInteger(tgtFldMap.get("priority"));
                        HashMap<String, Object> quotaInfo = new HashMap<String, Object>(16);
                        for (Map.Entry<String, String> tgt : tgtFldMap.entrySet()) {
                            if (tgt.getKey().equalsIgnoreCase("validdate") || tgt.getKey().equalsIgnoreCase("invaliddate")) {
                                quotaInfo.put(tgt.getKey(), row.getDate(tgt.getValue()));
                                continue;
                            }
                            quotaInfo.put(tgt.getKey(), row.get(tgt.getValue()));
                        }
                        quotaInfo.put("quotaId", row.get("id"));
                        if (Defmap.get(rank) == null) {
                            ArrayList<HashMap<String, Object>> DefList = new ArrayList<HashMap<String, Object>>(16);
                            DefList.add(quotaInfo);
                            Defmap.put(rank, DefList);
                            continue;
                        }
                        ((List)Defmap.get(rank)).add(quotaInfo);
                    }
                    quotaIDDS.close();
                    quotaDOs.close();
                    quotaDefDOs.close();
                    quotaDefOrdered.close();
                    recordDetailInfo.setQuotaQueryResultInfos(Defmap);
                    recordDetailInfo.setQuotaCalRuleID(cfgInfo.getQuotaCalRuleID());
                    recordDetailInfo.setDataSuccess(true);
                    QuotaRecordDetailInfoLst.add(recordDetailInfo);
                }
            }
        }
        return QuotaRecordDetailInfoLst;
    }

    private static String getCurrBatchMatchKey(Map<Integer, List<Map<String, Object>>> quotaDefMap, Set<String> matchKey) {
        List<Object> quotaDefLst = new ArrayList(16);
        String currBatchMatchKey = "";
        for (int m = 1; m < 999 && (quotaDefLst = quotaDefMap.get(m)) == null; ++m) {
        }
        if (quotaDefLst != null) {
            StringBuilder currBatchMatchKeysb = new StringBuilder();
            for (String mkey : matchKey) {
                if (mkey.equalsIgnoreCase("validdate") || mkey.equalsIgnoreCase("invaliddate")) continue;
                if ("".equals(currBatchMatchKeysb.toString())) {
                    currBatchMatchKeysb.append(((Map)quotaDefLst.get(0)).get(mkey));
                    continue;
                }
                currBatchMatchKeysb.append("$$").append(((Map)quotaDefLst.get(0)).get(mkey));
            }
            currBatchMatchKey = currBatchMatchKeysb.toString();
        }
        return currBatchMatchKey;
    }
}

