/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.quotamodel.formplugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.servicehelper.MetadataServiceHelper;

public class DataRangePlugin
extends AbstractBillPlugIn
implements ClickListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        Button btnok = (Button)this.getView().getControl("btnok");
        btnok.addClickListener((ClickListener)this);
        Button btncancel = (Button)this.getView().getControl("btncancel");
        btncancel.addClickListener((ClickListener)this);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String entity = (String)formShowParameter.getCustomParam("entity");
        if (kd.bos.util.StringUtils.isNotEmpty((String)entity)) {
            FilterGrid filterGridAp = (FilterGrid)this.getView().getControl("filtergridap");
            filterGridAp.setEntityNumber(entity);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String filterJson = (String)formShowParameter.getCustomParam("filterJson");
        FilterCondition filterCondition = null;
        if (!kd.bos.util.StringUtils.isBlank((String)filterJson)) {
            filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)filterJson, FilterCondition.class);
        }
        if (filterCondition != null) {
            FilterGrid filterGrid = (FilterGrid)this.getView().getControl("filtergridap");
            filterGrid.SetValue(filterCondition);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if ("btnok".equalsIgnoreCase(key)) {
            HashMap<String, String> map = new HashMap<String, String>();
            String filterJsonString = this.getFilterJsonString();
            map.put("filterJson", filterJsonString);
            if (kd.bos.util.StringUtils.isNotEmpty((String)filterJsonString)) {
                map.put("filterDesc", this.getFilterExpr());
            }
            this.getView().returnDataToParent(map);
            this.getView().close();
        }
        if ("btncancel".equalsIgnoreCase(key)) {
            this.getView().close();
        }
    }

    private String getFilterExpr() {
        String tranExpr = "";
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String entityNumber = (String)formShowParameter.getCustomParam("entity");
        MainEntityType mainType = MetadataServiceHelper.getDataEntityType((String)entityNumber);
        FilterCondition filterCondition = this.getFilter();
        if (filterCondition != null && filterCondition.getFilterRow().size() > 0) {
            FilterBuilder filterBuilder = new FilterBuilder(mainType, filterCondition);
            String[] scripts = filterBuilder.buildFilterScript();
            ArrayList<String> descs = new ArrayList<String>();
            if (StringUtils.isNotBlank((CharSequence)scripts[1])) {
                descs.add(scripts[1]);
            }
            String joinStr = " " + ResManager.loadKDString((String)"\u4e14", (String)"DataRangePlugin_0", (String)"mpscmm-msbd-quotamodel", (Object[])new Object[0]) + " ";
            tranExpr = StringUtils.join((Object[])descs.toArray(), (String)joinStr);
        }
        return tranExpr;
    }

    private FilterCondition getFilter() {
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl("filtergridap");
        FilterGrid.FilterGridState filterGridState = filterGrid.getFilterGridState();
        FilterCondition condition = filterGridState.getFilterCondition();
        return condition;
    }

    private String getFilterJsonString() {
        FilterCondition filterCondition = this.getFilter();
        String filter = null;
        if (filterCondition != null) {
            filter = SerializationUtils.toJsonString((Object)filterCondition);
        }
        return filter;
    }
}

