/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.partitiontask;

import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.mpscmm.msbd.partitiontask.bean.PartitionTaskInfo;
import kd.mpscmm.msbd.partitiontask.exception.PartitionTaskErrorCode;

public class PartitionTaskBuilder {
    private PartitionTaskInfo task = new PartitionTaskInfo();

    public PartitionTaskBuilder setSchemeNumber(String schemeNumber) {
        DynamicObject schemeInfo = BusinessDataServiceHelper.loadSingleFromCache((String)"msbd_tasklogscheme", (String)"id", (QFilter[])new QFilter("number", "=", (Object)schemeNumber).toArray());
        if (schemeInfo == null) {
            throw new KDBizException(PartitionTaskErrorCode.getTaskNumberError(), new Object[]{schemeNumber});
        }
        this.task.setSchemeId(schemeInfo.getLong("id"));
        return this;
    }

    public PartitionTaskBuilder setSchemeId(Long schemeId) {
        this.task.setSchemeId(schemeId);
        return this;
    }

    public PartitionTaskBuilder setAppId(String appId) {
        this.task.setAppId(appId);
        return this;
    }

    public PartitionTaskBuilder setParam(Map<String, Object> param) {
        this.task.setCustomerParam(param);
        return this;
    }

    public PartitionTaskBuilder setMutexKey(String mutexKey) {
        if (mutexKey.length() > 255) {
            throw new KDBizException(PartitionTaskErrorCode.getMutexKeyOverSizeError(), new Object[0]);
        }
        this.task.setMutexKey(mutexKey);
        return this;
    }

    public PartitionTaskInfo build() {
        if (this.task.getSchemeId() == null) {
            throw new IllegalArgumentException("schemeId can not be null!");
        }
        return this.task;
    }
}

