/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.partitiontask.task;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.dlock.DLock;
import kd.bos.exception.KDBizException;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.JobDispatcher;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.executor.JobClient;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.util.StringUtils;
import kd.mpscmm.msbd.partitiontask.exception.PartitionTaskErrorCode;

public class PartitionTaskHelper {
    private static final Log logger = LogFactory.getLog(PartitionTaskHelper.class);
    static final String PARTIIONTASK = "partiiontask";
    static final String CACHEKEY = "running";

    public static void retryTask(List<Long> retryTasks, String execAppId) {
        if (retryTasks == null || retryTasks.isEmpty()) {
            return;
        }
        DynamicObjectCollection taskObjs = QueryServiceHelper.query((String)"msbd_tasklog", (String)"id,name", (QFilter[])new QFilter("id", "in", retryTasks).and("taskstatus", "in", (Object)new String[]{"D", "G"}).toArray(), (String)"id");
        for (DynamicObject taskObj : taskObjs) {
            PartitionTaskHelper.dispatchSubJob(taskObj.getString("name"), taskObj.getLong("id"), execAppId);
        }
    }

    static DistributeSessionlessCache getPartitionCache() {
        return CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache(PARTIIONTASK);
    }

    public static void initRunningCount(String mainTaskId, int count) {
        DistributeSessionlessCache cache = PartitionTaskHelper.getPartitionCache();
        cache.put(mainTaskId, (Object)(count + ""));
    }

    static void subTaskRunningCountPlus(String mainTaskId) {
        try (DLock dLock = DLock.create((String)mainTaskId, (String)ResManager.loadKDString((String)"\u5206\u6279\u6846\u67b6\u4efb\u52a1\u9501%s", (String)"mainTaskLock", (String)"mpscmm-msbd-partitiontask", (Object[])new Object[]{mainTaskId}));){
            dLock.lock();
            DistributeSessionlessCache partitionCache = PartitionTaskHelper.getPartitionCache();
            String countStr = (String)partitionCache.get(mainTaskId);
            if (!StringUtils.isEmpty((String)countStr)) {
                partitionCache.put(mainTaskId, (Object)(Integer.parseInt(countStr) + 1 + ""));
            }
        }
    }

    static void subTaskRunningCountMinus(String mainTaskId) {
        try (DLock dLock = DLock.create((String)mainTaskId, (String)ResManager.loadKDString((String)"\u5206\u6279\u6846\u67b6\u4efb\u52a1\u9501%s", (String)"mainTaskLock", (String)"mpscmm-msbd-partitiontask", (Object[])new Object[]{mainTaskId}));){
            dLock.lock();
            DistributeSessionlessCache partitionCache = PartitionTaskHelper.getPartitionCache();
            String countStr = (String)partitionCache.get(mainTaskId);
            if (!StringUtils.isEmpty((String)countStr)) {
                partitionCache.put(mainTaskId, (Object)(Integer.parseInt(countStr) - 1 + ""));
            }
        }
    }

    static void subTaskRunningCountClear(String mainTaskId) {
        DistributeSessionlessCache partitionCache = PartitionTaskHelper.getPartitionCache();
        if (partitionCache.contains(mainTaskId)) {
            partitionCache.remove(mainTaskId);
        }
    }

    static void dispatchSubJob(String jobName, Long subTaskId, String execAppId) {
        PartitionTaskHelper.setScheduleTask(subTaskId);
        if (StringUtils.isEmpty((String)execAppId)) {
            execAppId = "im";
        }
        JobInfo job = new JobInfo();
        job.setName(jobName);
        job.setJobType(JobType.BIZ);
        HashMap<String, Long> params = new HashMap<String, Long>();
        params.put("taskid", subTaskId);
        job.setParams(params);
        job.setAppId(execAppId);
        job.setRunByLang(Lang.get());
        job.setTaskClassname("kd.mpscmm.msbd.partitiontask.task.SubTask");
        job.setRunByUserId(RequestContext.get().getCurrUserId());
        JobClient.dispatch((JobInfo)job);
        int durSec = 200;
        try {
            Thread.sleep(durSec);
        }
        catch (InterruptedException e) {
            logger.error((Throwable)e);
        }
    }

    public static void deleteJob(String taskId) {
        DynamicObject jobInfo = QueryServiceHelper.queryOne((String)"sch_task", (String)"job", (QFilter[])new QFilter("id", "=", (Object)taskId).toArray());
        JobDispatcher service = (JobDispatcher)ServiceFactory.getService(JobDispatcher.class);
        service.deleteJob(jobInfo.getString("job"));
    }

    public static void deleteJobs(List<String> taskIdList) {
        DynamicObjectCollection jobs = QueryServiceHelper.query((String)"sch_task", (String)"job", (QFilter[])new QFilter("id", "in", taskIdList).toArray());
        JobDispatcher service = (JobDispatcher)ServiceFactory.getService(JobDispatcher.class);
        for (DynamicObject job : jobs) {
            service.deleteJob(job.getString("job"));
        }
    }

    public static void closeTask(List<Long> closeTasks) {
        if (closeTasks == null || closeTasks.isEmpty()) {
            return;
        }
        SqlBuilder updateSqlBuilder = new SqlBuilder();
        updateSqlBuilder.append("update t_msbd_tasklog set ftaskstatus = ? where ", new Object[]{"E"}).appendIn("fid", closeTasks.toArray()).append(" and ftaskstatus = ? ", new Object[]{"D"});
        DB.execute((DBRoute)DBRoute.of((String)"scm"), (SqlBuilder)updateSqlBuilder);
    }

    static void setErrTask(Long taskLogId, String errMsg) {
        ArrayList<String> taskIdList = new ArrayList<String>();
        taskIdList.add(taskLogId.toString());
        PartitionTaskHelper.setBatchErrTask(taskIdList, errMsg);
    }

    static void setBatchErrTask(List<String> taskLogId, String errMsg) {
        String idStr = String.join((CharSequence)",", taskLogId);
        StringBuilder sql = new StringBuilder();
        if (errMsg != null) {
            sql.append("update t_msbd_tasklog set ftaskstatus = ?,flog = ?,flog_tag = ?,fendtime=? where fid in (").append(idStr).append(")");
            String errMsg_abstract = errMsg;
            if (errMsg.length() > 255) {
                errMsg_abstract = errMsg.substring(0, 255);
            }
            DB.execute((DBRoute)DBRoute.of((String)"scm"), (String)sql.toString(), (Object[])new Object[]{"D", errMsg_abstract, errMsg, TimeServiceHelper.now()});
        } else {
            sql.append("update t_msbd_tasklog set ftaskstatus = ? ,fendtime=? where fid in (").append(idStr).append(")");
            DB.execute((DBRoute)DBRoute.of((String)"scm"), (String)sql.toString(), (Object[])new Object[]{"D", TimeServiceHelper.now()});
        }
    }

    static void setRunTask(Long taskLogId, String taskId) {
        DB.execute((DBRoute)DBRoute.of((String)"scm"), (String)"update t_msbd_tasklog set ftaskstatus = ?,ftimes = ftimes+1,fdispatchtaskid = ?,fstarttime = ? where fid = ?", (Object[])new Object[]{"B", taskId, TimeServiceHelper.now(), taskLogId});
    }

    static void setScheduleTask(Long taskLogId) {
        DB.execute((DBRoute)DBRoute.of((String)"scm"), (String)"update t_msbd_tasklog set ftaskstatus = ? where fid = ?", (Object[])new Object[]{"F", taskLogId});
    }

    static void setWaitRetryTask(Long taskLogId) {
        DB.execute((DBRoute)DBRoute.of((String)"scm"), (String)"update t_msbd_tasklog set ftaskstatus = ? where fid = ?", (Object[])new Object[]{"G", taskLogId});
    }

    static void setSuccessTask(Long taskLogId) {
        DB.execute((DBRoute)DBRoute.of((String)"scm"), (String)"update t_msbd_tasklog set ftaskstatus = ?,fendtime = ? where fid = ?", (Object[])new Object[]{"A", TimeServiceHelper.now(), taskLogId});
    }

    static void checkAndAddMutex(String mutexKey, Long mainTaskId) {
        if (!StringUtils.isEmpty((String)mutexKey)) {
            StringBuilder sql = new StringBuilder();
            sql.append("select 1 from t_msbd_partitiontaskmutex where fmutexkey = ?");
            DataSet dataSet = DB.queryDataSet((String)"partitiontaskmutex", (DBRoute)DBRoute.of((String)"scm"), (String)sql.toString(), (Object[])new String[]{mutexKey});
            if (dataSet.hasNext()) {
                throw new KDBizException(PartitionTaskErrorCode.getTaskMutexError(), new Object[0]);
            }
            sql.setLength(0);
            sql.append("insert into t_msbd_partitiontaskmutex(fmutexkey,fmaintaskid)values(?,?)");
            try {
                DB.execute((DBRoute)DBRoute.of((String)"scm"), (String)sql.toString(), (Object[])new Object[]{mutexKey, mainTaskId});
            }
            catch (Exception e) {
                throw new KDBizException(PartitionTaskErrorCode.getTaskMutexError(), new Object[0]);
            }
        }
    }

    static void releaseMutex(String mutexKey, Long taskId) {
        if (!StringUtils.isEmpty((String)mutexKey)) {
            DB.execute((DBRoute)DBRoute.of((String)"scm"), (String)"delete from t_msbd_partitiontaskmutex where fmutexkey = ? and fmaintaskid = ?", (Object[])new Object[]{mutexKey, taskId});
        }
    }

    static boolean isTaskRunning(String mainTaskId) {
        int runningSubTakCount;
        boolean running = false;
        DistributeSessionlessCache partitionCache = PartitionTaskHelper.getPartitionCache();
        if (partitionCache.contains(mainTaskId) && (runningSubTakCount = Integer.parseInt((String)partitionCache.get(mainTaskId))) > 0) {
            running = true;
        }
        return running;
    }

    static boolean isTaskListRunning(List<String> mainTaskIdList) {
        boolean running = false;
        for (String mainTaskId : mainTaskIdList) {
            if (!PartitionTaskHelper.isTaskRunning(mainTaskId)) continue;
            running = true;
            break;
        }
        return running;
    }

    static boolean isTaskListFail(List<String> mainTaskIdList) {
        if (mainTaskIdList == null || mainTaskIdList.isEmpty()) {
            return false;
        }
        boolean fail = false;
        String idStr = String.join((CharSequence)",", mainTaskIdList);
        StringBuilder sql = new StringBuilder();
        sql.append("select 1 from t_msbd_tasklog where fmaintasklogid in(").append(idStr).append(") and ftaskstatus = 'D'");
        DataSet rows = DB.queryDataSet((String)"kd.mpscmm.msbd.partitiontask.task.PartitionTaskHelper", (DBRoute)DBRoute.of((String)"scm"), (String)sql.toString());
        if (rows.hasNext()) {
            fail = true;
        }
        return fail;
    }

    static Map<String, Object> buildSchemeParams(DynamicObject taskScheme) {
        HashMap<String, Object> mainTaskParams = new HashMap<String, Object>();
        String timestamp = String.valueOf(TimeServiceHelper.now().getTime());
        mainTaskParams.put("schemeid", taskScheme.get("id"));
        mainTaskParams.put("number", taskScheme.getString("number").concat(timestamp));
        mainTaskParams.put("name", taskScheme.getString("name").concat(timestamp));
        mainTaskParams.put("mainTaskClass", taskScheme.getString("taskexec"));
        mainTaskParams.put("subTaskClass", taskScheme.getString("subtaskexec"));
        mainTaskParams.put("retrywhenfail", taskScheme.getBoolean("retrywhenfail"));
        mainTaskParams.put("retrytime", taskScheme.getInt("retrytime"));
        mainTaskParams.put("maxparallel", taskScheme.getInt("maxparallel"));
        mainTaskParams.put("runbyorder", taskScheme.getBoolean("runbyorder"));
        DynamicObjectCollection entry = taskScheme.getDynamicObjectCollection("entryentity");
        HashMap<String, String> schemeParams = new HashMap<String, String>(16);
        for (DynamicObject row : entry) {
            schemeParams.put(row.getString("key"), row.getString("param"));
        }
        mainTaskParams.put("schemeParams", schemeParams);
        return mainTaskParams;
    }

    public static Map<String, Object> buildSchemeParams(Long taskLogSchemeId) {
        DynamicObject taskScheme = BusinessDataServiceHelper.loadSingleFromCache((Object)taskLogSchemeId, (String)"msbd_tasklogscheme");
        return PartitionTaskHelper.buildSchemeParams(taskScheme);
    }

    public static void markStop(String taskId) {
        PartitionTaskHelper.getPartitionCache().put(taskId + CACHEKEY, (Object)"false");
    }

    static Boolean isContinueRunning(String taskId) {
        String result = (String)PartitionTaskHelper.getPartitionCache().get(taskId + CACHEKEY);
        return Boolean.parseBoolean(result);
    }

    static void initRunningFalg(String taskId) {
        PartitionTaskHelper.getPartitionCache().put(taskId + CACHEKEY, (Object)"true");
    }

    static void clearRunningFalg(String taskId) {
        PartitionTaskHelper.getPartitionCache().remove(taskId + CACHEKEY);
    }

    static void atskRetryTimesMinus(Long taskLogId) {
        DB.execute((DBRoute)DBRoute.of((String)"scm"), (String)"update t_msbd_tasklog set fretrytimeremain = fretrytimeremain-1 where fid = ?", (Object[])new Object[]{taskLogId});
    }
}

