/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.algox.business.function.input;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.Input;
import kd.bos.algo.Row;
import kd.bos.algo.input.DataSetInput;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class InspectCustomizedInput {
    private String inspectEntity;
    private QFilter[] unitQFilter;
    private String partitionSqlField;

    public InspectCustomizedInput(String inspectEntity, QFilter[] unitQFilter, String partitionSqlField) {
        this.inspectEntity = inspectEntity;
        this.unitQFilter = unitQFilter;
        this.partitionSqlField = partitionSqlField;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Input[] createBizDataInput(String queryFields) {
        ArrayList<Object> inputList = new ArrayList<Object>(16);
        if (this.partitionSqlField != null && !"".equals(this.partitionSqlField)) {
            IDataEntityType inspectEntityType = ORM.create().getDataEntityType(this.inspectEntity);
            IDataEntityProperty partitionSqlFieldProperty = (IDataEntityProperty)inspectEntityType.getProperties().get((Object)this.partitionSqlField);
            if (partitionSqlFieldProperty instanceof DateTimeProp) {
                Date maxBizDate = null;
                Date minBizDate = null;
                try (DataSet bizDate_ = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)this.inspectEntity, (String)(this.partitionSqlField + " maxSqlField," + this.partitionSqlField + " minSqlField"), (QFilter[])this.unitQFilter, (String)"id desc");){
                    GroupbyDataSet groupbyDate = bizDate_.groupBy();
                    DataSet _bizDate_ = groupbyDate.max("maxSqlField").min("minSqlField").finish();
                    Row row2 = _bizDate_.next();
                    maxBizDate = row2.getDate("maxSqlField");
                    minBizDate = row2.getDate("minSqlField");
                }
                LocalDate _maxBizDate = LocalDateTime.ofInstant(maxBizDate.toInstant(), ZoneId.systemDefault()).toLocalDate();
                LocalDate _minBizDate = LocalDateTime.ofInstant(minBizDate.toInstant(), ZoneId.systemDefault()).toLocalDate();
                long d_value = _maxBizDate.toEpochDay() - _minBizDate.toEpochDay();
                if (d_value < 16L) {
                    int i = 0;
                    while ((long)i < d_value) {
                        QFilter endQFilter;
                        LocalDate startDate = _minBizDate.plusDays(i);
                        LocalDate endDate = _minBizDate.plusDays(i + 1);
                        QFilter startQFilter = new QFilter(this.partitionSqlField, ">=", (Object)startDate);
                        if ((long)i == d_value - 1L) {
                            endQFilter = new QFilter(this.partitionSqlField, "<=", (Object)endDate);
                            startQFilter.and(endQFilter);
                        } else {
                            endQFilter = new QFilter(this.partitionSqlField, "<", (Object)endDate);
                            startQFilter.and(endQFilter);
                        }
                        inputList.add(this.getDataSetInput(this.getCombineQFilter(startQFilter), queryFields));
                        ++i;
                    }
                    return inputList.toArray(new Input[0]);
                } else {
                    int remainder = (int)(d_value % 16L);
                    int number = (int)(d_value / 16L);
                    for (int i = 0; i < 16; ++i) {
                        QFilter endQFilter;
                        LocalDate startDate = _minBizDate.plusDays(number * i);
                        LocalDate endDate = _minBizDate.plusDays(number * (i + 1));
                        QFilter startQFilter = new QFilter(this.partitionSqlField, ">=", (Object)startDate);
                        if (i == 15 && remainder <= 0) {
                            endQFilter = new QFilter(this.partitionSqlField, "<=", (Object)endDate);
                            startQFilter.and(endQFilter);
                        } else {
                            endQFilter = new QFilter(this.partitionSqlField, "<", (Object)endDate);
                            startQFilter.and(endQFilter);
                        }
                        inputList.add(this.getDataSetInput(this.getCombineQFilter(startQFilter), queryFields));
                    }
                    if (remainder <= 0) return inputList.toArray(new Input[0]);
                    LocalDate startDateTime = _minBizDate.plusDays(number * 16);
                    QFilter startQFilter = new QFilter(this.partitionSqlField, ">=", (Object)startDateTime);
                    QFilter endQFilter = new QFilter(this.partitionSqlField, "<=", (Object)_maxBizDate);
                    startQFilter.and(endQFilter);
                    inputList.add(this.getDataSetInput(this.getCombineQFilter(startQFilter), queryFields));
                }
                return inputList.toArray(new Input[0]);
            }
            try (DataSet bizOrg_ = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)this.inspectEntity, (String)this.partitionSqlField, (QFilter[])this.unitQFilter, (String)"id desc");){
                DataSet bizOrg = bizOrg_.groupBy(new String[]{this.partitionSqlField}).finish();
                DataSet copy = bizOrg.copy();
                int bizOrgCount = bizOrg.count(this.partitionSqlField, true);
                if (bizOrgCount < 16) {
                    try (DataSet _bizOrg_ = copy;){
                        for (Row row3 : _bizOrg_) {
                            QFilter qFilter = new QFilter(this.partitionSqlField, "=", row3.get(this.partitionSqlField));
                            inputList.add(this.getDataSetInput(this.getCombineQFilter(qFilter), queryFields));
                        }
                        return inputList.toArray(new Input[0]);
                    }
                }
                int remainder = bizOrgCount % 16;
                int number = bizOrgCount / 16;
                ArrayList allBizOrg = new ArrayList(16);
                bizOrg.forEach(row -> allBizOrg.add(row.getLong(this.partitionSqlField)));
                for (int i = 0; i < 16; ++i) {
                    List partBizOrg = allBizOrg.subList(number * i, number * (i + 1));
                    QFilter qFilter = new QFilter(this.partitionSqlField, "in", partBizOrg);
                    inputList.add(this.getDataSetInput(this.getCombineQFilter(qFilter), queryFields));
                }
                if (remainder <= 0) return inputList.toArray(new Input[0]);
                List lastBizOrg = allBizOrg.subList(number * 16, allBizOrg.size());
                for (Long singleBizOrg : lastBizOrg) {
                    QFilter qFilter = new QFilter(this.partitionSqlField, "=", (Object)singleBizOrg);
                    inputList.add(this.getDataSetInput(this.getCombineQFilter(qFilter), queryFields));
                }
                return inputList.toArray(new Input[0]);
            }
        }
        DataSet bizIdColl = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)this.inspectEntity, (String)queryFields, (QFilter[])this.unitQFilter, (String)"id desc");
        inputList.add(new DataSetInput(bizIdColl));
        return inputList.toArray(new Input[0]);
    }

    private Input getDataSetInput(QFilter[] combineQFilter, String queryFields) {
        DataSet _bizOrg_ = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)this.inspectEntity, (String)queryFields, (QFilter[])combineQFilter, (String)"id desc");
        return new DataSetInput(_bizOrg_);
    }

    private QFilter[] getCombineQFilter(QFilter currQFilter) {
        QFilter[] qFilters = Arrays.copyOf(this.unitQFilter, this.unitQFilter.length + 1);
        qFilters[this.unitQFilter.length] = currQFilter;
        return qFilters;
    }

    private InspectCustomizedInput() {
    }
}

