/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.algox.business.function.reduce;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mpscmm.msbd.datamanage.business.AbstractDmfPlugin;
import kd.mpscmm.msbd.datamanage.common.pojo.FixLogInfo;

public class FixLogGroupReduceFunction
extends GroupReduceFunction {
    private AbstractDmfPlugin pluginService;
    private String inspectEntity;
    private String billEntrySymbol;
    private String queryFieldKeys;
    private Long logId;

    public FixLogGroupReduceFunction(AbstractDmfPlugin pluginService, String inspectEntity, String billEntrySymbol, String queryFieldKeys, Long logId) {
        this.pluginService = pluginService;
        this.inspectEntity = inspectEntity;
        this.queryFieldKeys = queryFieldKeys;
        this.logId = logId;
        this.billEntrySymbol = billEntrySymbol;
    }

    public void reduce(Iterable<RowX> iterable, Collector collector) {
        HashSet<Long> idSet = new HashSet<Long>(16);
        int count = 0;
        for (RowX row : iterable) {
            idSet.add(row.getLong(0));
            if (++count < 1000) continue;
            this.calculateExtLogic(idSet, collector);
            idSet.clear();
            count = 0;
        }
        if (idSet.size() > 0) {
            this.calculateExtLogic(idSet, collector);
            idSet.clear();
        }
    }

    private void calculateExtLogic(Set<Long> idSet, Collector collector) {
        QFilter[] filterIdArray = new QFilter(this.billEntrySymbol.concat(".id"), "in", idSet).toArray();
        DataSet partitionDataset = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)this.inspectEntity, (String)this.queryFieldKeys, (QFilter[])filterIdArray, null);
        List fixLogInfos = this.pluginService.fixDataSet(partitionDataset);
        long[] detailPkIdList = DBServiceHelper.genLongIds((String)"t_msbd_fixdatalog_e", (int)fixLogInfos.size());
        for (int i = 0; i < fixLogInfos.size(); ++i) {
            FixLogInfo fixLogInfo = (FixLogInfo)fixLogInfos.get(i);
            Object[] entry = new Object[]{this.logId, detailPkIdList[i], i + 1, this.pluginService.getClass().getName(), fixLogInfo.getBillno(), fixLogInfo.getBillid(), fixLogInfo.getBillentryseq(), fixLogInfo.getBillentryid(), fixLogInfo.getFixfieldmark(), fixLogInfo.getFixfieldname(), fixLogInfo.getFixbeforevalue(), fixLogInfo.getFixaftervalue()};
            collector.collect(new RowX(entry));
        }
    }

    public RowMeta getResultRowMeta() {
        Field fid = new Field("fid", (DataType)DataType.LongType);
        Field fentryid = new Field("fentryid", (DataType)DataType.LongType);
        Field fseq = new Field("fseq", (DataType)DataType.IntegerType);
        Field ffixpluginurl = new Field("ffixpluginurl", (DataType)DataType.StringType);
        Field fbillno = new Field("fbillno", (DataType)DataType.StringType);
        Field fbillid = new Field("fbillid", (DataType)DataType.LongType);
        Field fbillseq = new Field("fbillentryseq", (DataType)DataType.IntegerType);
        Field fbillentryid = new Field("fbillentryid", (DataType)DataType.LongType);
        Field ffixfieldmark = new Field("ffixfieldmark", (DataType)DataType.StringType);
        Field ffixfieldname = new Field("ffixfieldname", (DataType)DataType.StringType);
        Field ffixbeforevalue = new Field("ffixbeforevalue", (DataType)DataType.StringType);
        Field ffixaftervalue = new Field("ffixaftervalue", (DataType)DataType.StringType);
        RowMeta rowMeta = new RowMeta(new Field[]{fid, fentryid, fseq, ffixpluginurl, fbillno, fbillid, fbillseq, fbillentryid, ffixfieldmark, ffixfieldname, ffixbeforevalue, ffixaftervalue});
        return rowMeta;
    }
}

