/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.algox.business.function.reduce;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperateInfo;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.KDBizException;
import kd.bos.metadata.entity.validation.ConditionValidation;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.mpscmm.msbd.algox.common.helper.ConditionAnalysisHelper;
import kd.mpscmm.msbd.algox.common.helper.InsExecuteHelper;
import kd.mpscmm.msbd.algox.common.util.ReflectUtils;

public class IuValidCalculateFunction
extends GroupReduceFunction {
    private String inspectEntity;
    private Long entryId;
    private DynamicObject inspectUnit;
    private long factBatchMaxNum;
    private int errorNum = 0;

    public IuValidCalculateFunction(String inspectEntity, Long entryId, DynamicObject inspectUnit, long factBatchMaxNum) {
        this.inspectEntity = inspectEntity;
        this.entryId = entryId;
        this.inspectUnit = inspectUnit;
        this.factBatchMaxNum = factBatchMaxNum;
    }

    public void reduce(Iterable<RowX> iterable, Collector collector) {
        HashSet<Long> idSet = new HashSet<Long>(16);
        int count = 0;
        for (RowX rowx : iterable) {
            Long id = (Long)rowx.get(0);
            idSet.add(id);
            if ((long)(++count) < this.factBatchMaxNum) continue;
            this.calculateExtLogic(idSet, collector);
            idSet.clear();
            count = 0;
        }
        if (idSet.size() > 0) {
            this.calculateExtLogic(idSet, collector);
            idSet.clear();
        }
    }

    private void calculateExtLogic(Set<Long> idSet, Collector collector) {
        this.getMulTermination();
        if (this.errorNum >= 10000) {
            return;
        }
        DynamicObject[] bizData = BusinessDataServiceHelper.load((Object[])idSet.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)this.inspectEntity));
        List<OperateErrorInfo> operateErrorInfoList = this.executeDmfUnit(this.inspectEntity, this.inspectUnit, bizData);
        this.errorNum += operateErrorInfoList.size();
        if (operateErrorInfoList.size() > 10000) {
            operateErrorInfoList = operateErrorInfoList.subList(0, 10000);
        }
        operateErrorInfoList.stream().sorted(Comparator.comparing(OperateInfo::getTitle));
        int subEntrySize = operateErrorInfoList.size();
        int indexSeq = 1;
        long[] detailPkIdList = DBServiceHelper.genLongIds((String)"t_msbd_inspectlogentry_e", (int)subEntrySize);
        for (int i = 0; i < subEntrySize; ++i) {
            OperateErrorInfo result = operateErrorInfoList.get(i);
            Object[] subEntry = new Object[8];
            subEntry[0] = detailPkIdList[i];
            subEntry[1] = this.entryId;
            subEntry[2] = indexSeq;
            subEntry[3] = result.getPkValue();
            Object[] reflectFieldsValue = ReflectUtils.reflectFieldsValue(result, "entryId");
            subEntry[4] = reflectFieldsValue[0] instanceof Long ? reflectFieldsValue[0] : Long.valueOf(0L);
            subEntry[5] = result.getEntityKey();
            String msg = "";
            msg = result.getMessage().length() > 512 ? result.getMessage().substring(0, 480) : result.getMessage();
            subEntry[6] = msg;
            String title = result.getTitle();
            if (title == null) {
                title = "";
            }
            subEntry[7] = title;
            collector.collect(new RowX(subEntry));
            ++indexSeq;
        }
    }

    public RowMeta getResultRowMeta() {
        Field fdetailid = new Field("fdetailid", (DataType)DataType.LongType);
        Field fentryid = new Field("fentryid", (DataType)DataType.LongType);
        Field fseq = new Field("fseq", (DataType)DataType.IntegerType);
        Field fobjid = new Field("fobjid", (DataType)DataType.LongType);
        Field fobjentryid = new Field("fobjentryid", (DataType)DataType.LongType);
        Field fobjtypeid = new Field("fobjtypeid", (DataType)DataType.StringType);
        Field fobjdes = new Field("fobjdes", (DataType)DataType.StringType);
        Field fbizuniquesympol = new Field("fbizuniquesympol", (DataType)DataType.StringType);
        RowMeta rowMeta = new RowMeta(new Field[]{fdetailid, fentryid, fseq, fobjid, fobjentryid, fobjtypeid, fobjdes, fbizuniquesympol});
        return rowMeta;
    }

    private List<OperateErrorInfo> executeDmfUnit(String inspectEntity, DynamicObject dmfUnit, DynamicObject[] bills) {
        DynamicObjectCollection validEntityRows = dmfUnit.getDynamicObjectCollection("validentity");
        List<Object> operateErrorInfoList = new ArrayList<OperateErrorInfo>(16);
        String fieldKey = "billno";
        boolean isFieldKeyFlag = this.judgeExistsField(inspectEntity, fieldKey);
        String billNo = "";
        for (DynamicObject bill : bills) {
            if (isFieldKeyFlag) {
                billNo = bill.getString(fieldKey);
            }
            for (DynamicObject conditionRow : validEntityRows) {
                boolean trueThrow;
                boolean validEnable = conditionRow.getBoolean("validenable");
                if (!validEnable) continue;
                String expressionEntity = (String)conditionRow.get("validjson_tag");
                ConditionValidation conditionValidation = InsExecuteHelper.getConditionValidation(expressionEntity);
                String expression = conditionValidation.getExpression();
                String entityKey = conditionValidation.getEntityKey();
                CRCondition condition = new CRCondition();
                condition.setExpression(expression);
                condition.buildFullFormula(MetadataServiceHelper.getDataEntityType((String)inspectEntity));
                boolean exeResultFlag = ConditionAnalysisHelper.doExeCondition(inspectEntity, bill, condition, entityKey);
                if (exeResultFlag != (trueThrow = conditionValidation.isTrueThrow())) continue;
                OperateErrorInfo operateerrorinfo = new OperateErrorInfo("DmfUnitService.excuteDmfUnitValidExpression", ErrorLevel.Error, bill.getPkValue(), bill.getPkValue());
                operateerrorinfo.setTitle(billNo);
                operateerrorinfo.setEntityKey(inspectEntity);
                String msg = "";
                msg = isFieldKeyFlag ? String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7\uff1a%1$s,\u5b58\u5728\u5982\u4e0b\u95ee\u9898\uff1a%2$s", (String)"IuValidCalculateFunction_0", (String)"mpscmm-msbd-algox", (Object[])new Object[0]), billNo, conditionValidation.getMessage().getLocaleValue()) : String.format(ResManager.loadKDString((String)"\u5b58\u5728\u5982\u4e0b\u95ee\u9898\uff1a%s", (String)"IuValidCalculateFunction_1", (String)"mpscmm-msbd-algox", (Object[])new Object[0]), conditionValidation.getMessage().getLocaleValue());
                operateerrorinfo.setMessage(msg);
                operateErrorInfoList.add(operateerrorinfo);
            }
            if (operateErrorInfoList.size() <= 10000) continue;
            operateErrorInfoList = operateErrorInfoList.subList(0, 10000);
            break;
        }
        bills = null;
        return operateErrorInfoList;
    }

    private boolean judgeExistsField(String inspectEntity, String fieldKey) {
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)inspectEntity);
        Set entries = dataEntityType.getAllEntities().entrySet();
        boolean flag = false;
        for (Map.Entry entry : entries) {
            IDataEntityProperty varLeft;
            EntityType value;
            if (((String)entry.getKey()).contains("_lk") || !((value = (EntityType)entry.getValue()) instanceof BillEntityType) || (varLeft = value.findProperty(fieldKey)) == null) continue;
            flag = true;
            break;
        }
        return flag;
    }

    private void getMulTermination() {
        Long inspectUnitId = (Long)this.inspectUnit.getPkValue();
        boolean mulTermination = InsExecuteHelper.getMulTermination(inspectUnitId);
        if (mulTermination) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8be5\u5de1\u68c0\u6a21\u578b\u5df2\u7ecf\u88ab\u7ec8\u6b62\uff0c\u7ec8\u6b62\u671f\u95f4\u5185\uff0c\u4e0d\u5141\u8bb8\u518d\u6b21\u88ab\u6267\u884c\u3002", (String)"IuValidCalculateFunction_2", (String)"mpscmm-msbd-algox", (Object[])new Object[0]));
        }
    }
}

