/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.algox.business.logicsexecutor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Input;
import kd.bos.algo.Output;
import kd.bos.algo.input.DataSetInput;
import kd.bos.algo.output.DbOutput;
import kd.bos.algox.AlgoX;
import kd.bos.algox.AlgoXCallBack;
import kd.bos.algox.DataSetX;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.JobSession;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.mpscmm.msbd.algox.business.function.callback.FixLogCallBack;
import kd.mpscmm.msbd.algox.business.function.reduce.FixLogGroupReduceFunction;
import kd.mpscmm.msbd.algox.common.helper.InsExecuteHelper;
import kd.mpscmm.msbd.algox.common.util.DateUtils;
import kd.mpscmm.msbd.datamanage.business.AbstractDmfPlugin;
import kd.mpscmm.msbd.datamanage.common.pojo.ExeDmfUnitInfo;
import kd.mpscmm.msbd.datamanage.common.pojo.FixLogInfo;
import kd.mpscmm.msbd.datamanage.common.pojo.FixedDTO;
import kd.mpscmm.msbd.datamanage.common.pojo.InspectOptionInfo;

public class IuFixPluginExecutor {
    private static final Log logger = LogFactory.getLog(IuFixPluginExecutor.class);

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void executeFixMethod(DynamicObject inspectUnit, FixedDTO fixedDTO) {
        block22: {
            block20: {
                block21: {
                    inspectEntity = (String)inspectUnit.getDynamicObject("entity").getPkValue();
                    extPluginEntryList = inspectUnit.getDynamicObjectCollection("pluginentry");
                    tx = TX.required();
                    var6_6 = null;
                    try {
                        logId = this.saveFixLog(inspectEntity);
lbl7:
                        // 3 sources

                        for (DynamicObject row : extPluginEntryList) {
                            pluginEnable = row.getBoolean("pluginenable");
                            if (!pluginEnable || StringUtils.isBlank((CharSequence)(pluginClassUrl = row.getString("pluginclassurl"))) || !((pluginClassObj = TypesContainer.createInstance((String)pluginClassUrl)) instanceof AbstractDmfPlugin)) continue;
                            pluginService = (AbstractDmfPlugin)pluginClassObj;
                            simpleClassName = pluginService.getClass().getName();
                            if (!simpleClassName.contains("kd.mpscmm.msbd.datamanage.inspect")) {
                                IuFixPluginExecutor.logger.error("\u76ee\u524d\u4e0d\u652f\u6301\u6269\u5c55\u7684\u63d2\u4ef6\uff0c\u6267\u884c\u6570\u636e\u4fee\u590d\u7684\u65b9\u5f0f\u3002");
                                if (tx == null) return;
                                if (var6_6 == null) break block20;
                                break block21;
                            }
                            ** GOTO lbl-1000
                        }
                        ** GOTO lbl68
                    }
                    catch (Exception e) {
                        tx.markRollback();
                        mainMsg = e.toString();
                        stackTrace = Arrays.toString(e.getStackTrace());
                        expMsg = ResManager.loadKDString((String)"\u4fee\u590d\u8fc7\u7a0b\u4e2d\u51fa\u73b0\u5f02\u5e38\uff1a", (String)"IuFixPluginExecutor_0", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]).concat(mainMsg.concat(stackTrace));
                        IuFixPluginExecutor.logger.error("\u4fee\u590d\u8fc7\u7a0b\u4e2d\u51fa\u73b0\u5f02\u5e38\uff1a{}", (Object)mainMsg.concat(stackTrace));
                        this.saveExpFixLog(inspectEntity, expMsg);
                        break block22;
                    }
                    catch (Throwable var7_10) {
                        try {
                            var6_6 = var7_10;
                            throw var7_10;
                        }
                        catch (Throwable var21_25) {
                            if (tx == null) throw var21_25;
                            if (var6_6 == null) {
                                tx.close();
                                throw var21_25;
                            }
                            try {
                                tx.close();
                                throw var21_25;
                            }
                            catch (Throwable var22_26) {
                                var6_6.addSuppressed(var22_26);
                                throw var21_25;
                            }
                        }
                    }
                }
                try {
                    tx.close();
                    return;
                }
                catch (Throwable var16_19) {
                    var6_6.addSuppressed(var16_19);
                    return;
                }
            }
            tx.close();
            return;
lbl-1000:
            // 1 sources

            {
                option = InspectOptionInfo.getInstance();
                pluginService.setInspectOptionInfo(option);
                pluginService.setExeDmfUnitInfo(new ExeDmfUnitInfo(null, (Long)inspectUnit.getPkValue(), null, null, inspectEntity));
                preparePropertysEventArgs = new PreparePropertysEventArgs();
                fieldKeys = new ArrayList<E>(16);
                preparePropertysEventArgs.setFieldKeys(fieldKeys);
                pluginService.onPreparePropertys(preparePropertysEventArgs);
                queryFieldKeys = String.join((CharSequence)",", fieldKeys);
                IuFixPluginExecutor.logger.info("\u5de1\u68c0\u4fee\u590d\u4e8e\u65f6\u95f4\uff1a{}\u5f00\u59cb", (Object)DateUtils.getCurrentDateStr());
                this.executeFixLogicDs(pluginService, inspectEntity, queryFieldKeys, fixedDTO.getEntryIdSet(), logId);
                simpleName = pluginService.getClass().getSimpleName();
                if ("BaseUnitInspectPlugin".equals(simpleName) || "SumQtyInspectPlugin".equals(simpleName) || "SalOrderConfirmAmountPlugin".equals(simpleName)) {
                    this.executeFixLogicDyn(pluginService, inspectEntity, queryFieldKeys, fixedDTO.getIdSet(), logId);
                }
                this.executeFixLogicMainDs(pluginService, inspectEntity, queryFieldKeys, fixedDTO.getIdSet(), logId);
                ** GOTO lbl7
lbl68:
                // 1 sources

                this.updateLogEntry(fixedDTO.getLogEntryId(), String.valueOf(logId));
                IuFixPluginExecutor.logger.info("\u5de1\u68c0\u4fee\u590d\u4e8e\u65f6\u95f4\uff1a{}\u7ed3\u675f", (Object)DateUtils.getCurrentDateStr());
            }
        }
        if (tx != null) {
            if (var6_6 != null) {
                try {
                    tx.close();
                }
                catch (Throwable var7_9) {
                    var6_6.addSuppressed(var7_9);
                }
            } else {
                tx.close();
            }
        }
        IuFixPluginExecutor.logger.info("\u672c\u6b21\u6570\u636e\u4fee\u590d\u6267\u884c\u6210\u529f\u3002");
    }

    private void updateLogEntry(Object entryPkValue, String resultStr) {
        String updateSql = "update t_msbd_inspectlogentry  set  ffixeddatadetail_tag=?,fisfixed=? where  fentryid =?";
        Object[] parameter = new Object[]{resultStr, 1, entryPkValue};
        DB.execute((DBRoute)DBRoute.of((String)"scm"), (String)updateSql, (Object[])parameter);
    }

    private long saveExpFixLog(String inspectEntity, String expMsg) {
        try (TXHandle tx = TX.required();){
            try {
                String sql = "insert into t_msbd_fixdatalog(fid,foptime,fopuserid,ftraceid,fentityid,fopreason) values(?,?,?,?,?,?)";
                long[] pkId = DBServiceHelper.genLongIds((String)"t_msbd_fixdatalog", (int)1);
                long id = pkId[0];
                Object[] values = new Object[6];
                values[0] = id;
                values[1] = TimeServiceHelper.now();
                values[2] = RequestContext.get().getCurrUserId();
                values[3] = RequestContext.get().getTraceId();
                values[4] = inspectEntity;
                if (expMsg.length() >= 1000) {
                    expMsg = expMsg.substring(0, 999);
                }
                values[5] = expMsg;
                DB.execute((DBRoute)DBRoute.of((String)"scm"), (String)sql, (Object[])values);
            }
            catch (Exception e) {
                tx.markRollback();
                logger.error("\u6301\u4e45\u5316\u65e5\u5fd7\u51fa\u73b0\u4e86\u5f02\u5e38:{}", (Object)Arrays.toString(e.getStackTrace()));
            }
        }
        return 0L;
    }

    private long saveFixLog(String inspectEntity) {
        String sql = "insert into t_msbd_fixdatalog(fid,foptime,fopuserid,ftraceid,fentityid) values(?,?,?,?,?)";
        long[] pkId = DBServiceHelper.genLongIds((String)"t_msbd_fixdatalog", (int)1);
        long id = pkId[0];
        Object[] values = new Object[]{id, TimeServiceHelper.now(), RequestContext.get().getCurrUserId(), RequestContext.get().getTraceId(), inspectEntity};
        DB.execute((DBRoute)DBRoute.of((String)"scm"), (String)sql, (Object[])values);
        return id;
    }

    private void executeFixLogicMainDs(AbstractDmfPlugin pluginService, String inspectEntity, String queryFieldKeys, Set<Object> expIdSet, long logId) {
        long factBatchMaxNum;
        if (expIdSet == null || expIdSet.size() <= 0) {
            return;
        }
        int count = expIdSet.size();
        if ((long)count > (factBatchMaxNum = 1000L)) {
            List expIdList = expIdSet.stream().collect(Collectors.toList());
            List partitionList = InsExecuteHelper.partition(expIdList, (int)factBatchMaxNum);
            for (List batchBillId : partitionList) {
                DataSet bizDataArray = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)inspectEntity, (String)queryFieldKeys, (QFilter[])new QFilter("id", "in", batchBillId).toArray(), null);
                List fixLogInfos = pluginService.fixMainDataSet(bizDataArray);
                if (bizDataArray != null) {
                    bizDataArray.close();
                }
                if (fixLogInfos.size() <= 0) continue;
                this.saveFixLogEntry(logId, fixLogInfos, pluginService.getClass().getName());
            }
        } else {
            DataSet bizDataArray = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)inspectEntity, (String)queryFieldKeys, (QFilter[])new QFilter("id", "in", expIdSet).toArray(), null);
            List fixLogInfos = pluginService.fixMainDataSet(bizDataArray);
            if (bizDataArray != null) {
                bizDataArray.close();
            }
            if (fixLogInfos.size() > 0) {
                this.saveFixLogEntry(logId, fixLogInfos, pluginService.getClass().getName());
            }
        }
        pluginService = null;
    }

    private void executeFixLogicDs(AbstractDmfPlugin pluginService, String inspectEntity, String queryFieldKeys, Set<Object> expEntryIdSet, long logId) {
        String billEntrySympol = pluginService.getInspectOptionInfo().getBillEntrySympol();
        if (expEntryIdSet == null || expEntryIdSet.size() <= 0) {
            return;
        }
        int count = expEntryIdSet.size();
        long factBatchMaxNum = 1000L;
        if (billEntrySympol == null || "".equals(billEntrySympol)) {
            return;
        }
        if ((long)count > factBatchMaxNum) {
            if (count > 40000) {
                this.fixAlgoXEntryMethod(pluginService, inspectEntity, queryFieldKeys, expEntryIdSet, logId);
            } else {
                List expEntryIdList = expEntryIdSet.stream().collect(Collectors.toList());
                List partitionList = InsExecuteHelper.partition(expEntryIdList, (int)factBatchMaxNum);
                for (List batchBillId : partitionList) {
                    String entryKey = billEntrySympol + ".id";
                    DataSet bizDataArray = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)inspectEntity, (String)queryFieldKeys, (QFilter[])new QFilter(entryKey, "in", batchBillId).toArray(), null);
                    List fixLogInfos = pluginService.fixDataSet(bizDataArray);
                    if (bizDataArray != null) {
                        bizDataArray.close();
                    }
                    if (fixLogInfos.size() <= 0) continue;
                    this.saveFixLogEntry(logId, fixLogInfos, pluginService.getClass().getName());
                }
            }
        } else {
            String entryKey = billEntrySympol + ".id";
            DataSet bizDataArray = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)inspectEntity, (String)queryFieldKeys, (QFilter[])new QFilter(entryKey, "in", expEntryIdSet).toArray(), null);
            List fixLogInfos = pluginService.fixDataSet(bizDataArray);
            if (bizDataArray != null) {
                bizDataArray.close();
            }
            if (fixLogInfos.size() > 0) {
                this.saveFixLogEntry(logId, fixLogInfos, pluginService.getClass().getName());
            }
        }
        pluginService = null;
    }

    public void fixAlgoXEntryMethod(AbstractDmfPlugin pluginService, String inspectEntity, String queryFieldKeys, Set<Object> expEntryIdSet, long logId) {
        try (TXHandle tx = TX.requiresNew((String)this.getClass().getName());){
            String billEntrySymbol = pluginService.getInspectOptionInfo().getBillEntrySympol();
            if (billEntrySymbol == null || "".equals(billEntrySymbol)) {
                return;
            }
            try {
                JobSession jobSession = AlgoX.createSession((String)this.getClass().getName());
                Input[] fixIdInput = this.getFixIdInput(inspectEntity, billEntrySymbol, expEntryIdSet);
                DataSetX dataSetx = jobSession.fromInput(fixIdInput);
                dataSetx = dataSetx.groupBy(new String[0]).reduceGroup((GroupReduceFunction)new FixLogGroupReduceFunction(pluginService, inspectEntity, billEntrySymbol, queryFieldKeys, logId));
                String insertSql = "insert into t_msbd_fixdatalog_e(fid,fentryid,fseq ,ffixpluginurl,fbillno,fbillid,fbillentryseq,fbillentryid,ffixfieldmark,ffixfieldname,ffixbeforevalue,ffixaftervalue) values(?,?,?,?,?,?,?,?,?,?,?,?)";
                DbOutput output = new DbOutput("scm", insertSql, dataSetx.getRowMeta());
                dataSetx.output((Output)output);
                logger.info("commitTimeOut : 30 runningTimeOut : 28 " + (Object)((Object)TimeUnit.MINUTES));
                jobSession.asyncCommit(30, 28, TimeUnit.MINUTES, (AlgoXCallBack)new FixLogCallBack());
            }
            catch (Exception e) {
                tx.markRollback();
                String mainMsg = e.toString();
                String stackTrace = Arrays.toString(e.getStackTrace());
                throw new KDBizException("AlgoX execute Exception\uff1a".concat(mainMsg.concat(stackTrace)));
            }
        }
    }

    private Input[] getFixIdInput(String inspectEntity, String billEntrySymbol, Set<Object> expEntryIdSet) {
        String entryKey = billEntrySymbol.concat(".id");
        DataSet bizDataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)inspectEntity, (String)entryKey.concat(" id"), (QFilter[])new QFilter(entryKey, "in", expEntryIdSet).toArray(), null);
        DataSetInput input = new DataSetInput(bizDataSet);
        Input[] inputs = new Input[]{input};
        return inputs;
    }

    private void saveFixLogEntry(Long id, List<FixLogInfo> fixLogInfos, String pluginName) {
        String insertSql = "insert into t_msbd_fixdatalog_e(fid,fentryid,fseq ,ffixpluginurl,fbillno,fbillid,fbillentryseq,fbillentryid,ffixfieldmark,ffixfieldname,ffixbeforevalue,ffixaftervalue) values(?,?,?,?,?,?,?,?,?,?,?,?)";
        int fixLogInfoSize = fixLogInfos.size();
        ArrayList<Object[]> paramter = new ArrayList<Object[]>(fixLogInfoSize);
        long[] detailPkIdList = DBServiceHelper.genLongIds((String)"t_msbd_fixdatalog_e", (int)fixLogInfoSize);
        for (int i = 0; i < fixLogInfoSize; ++i) {
            FixLogInfo fixLogInfo = fixLogInfos.get(i);
            Object[] obj = new Object[12];
            obj[0] = id;
            obj[1] = detailPkIdList[i];
            obj[2] = i + 1;
            obj[3] = pluginName;
            obj[4] = fixLogInfo.getBillno();
            Long billid = fixLogInfo.getBillid();
            if (billid == null) {
                billid = 0L;
            }
            obj[5] = billid;
            Integer billentryseq = fixLogInfo.getBillentryseq();
            if (billentryseq == null) {
                billentryseq = 0;
            }
            obj[6] = billentryseq;
            Long billentryid = fixLogInfo.getBillentryid();
            if (billentryid == null) {
                billentryid = 0L;
            }
            obj[7] = billentryid;
            obj[8] = fixLogInfo.getFixfieldmark();
            obj[9] = fixLogInfo.getFixfieldname();
            obj[10] = fixLogInfo.getFixbeforevalue();
            obj[11] = fixLogInfo.getFixaftervalue();
            paramter.add(obj);
        }
        if (paramter.size() > 0) {
            DB.executeBatch((DBRoute)DBRoute.of((String)"scm"), (String)insertSql, paramter);
            fixLogInfos.clear();
            fixLogInfos = null;
        }
    }

    private void executeFixLogicDyn(AbstractDmfPlugin pluginService, String inspectEntity, String queryFieldKeys, Set<Object> expIdSet, long logId) {
        long factBatchMaxNum;
        if (expIdSet == null || expIdSet.size() <= 0) {
            return;
        }
        int count = expIdSet.size();
        if ((long)count > (factBatchMaxNum = 1000L)) {
            List expIdList = expIdSet.stream().collect(Collectors.toList());
            List partitionList = InsExecuteHelper.partition(expIdList, (int)factBatchMaxNum);
            for (List batchBillId : partitionList) {
                DynamicObject[] bizDataArray = this.queryBizDataArray(inspectEntity, queryFieldKeys, new QFilter("id", "in", batchBillId).toArray());
                List fixLogInfos = pluginService.fixDynamicObject(bizDataArray);
                if (fixLogInfos.size() <= 0) continue;
                this.saveFixLogEntry(logId, fixLogInfos, pluginService.getClass().getName());
            }
        } else {
            DynamicObject[] bizDataArray = this.queryBizDataArray(inspectEntity, queryFieldKeys, new QFilter("id", "in", expIdSet).toArray());
            List fixLogInfos = pluginService.fixDynamicObject(bizDataArray);
            if (fixLogInfos.size() > 0) {
                this.saveFixLogEntry(logId, fixLogInfos, pluginService.getClass().getName());
            }
        }
    }

    private DynamicObject[] queryBizDataArray(String inspectEntity, String queryFieldKeys, QFilter[] qFilter) {
        return BusinessDataServiceHelper.load((String)inspectEntity, (String)queryFieldKeys, (QFilter[])qFilter);
    }

    private IuFixPluginExecutor() {
    }

    public static IuFixPluginExecutor getInstance() {
        return new IuFixPluginExecutor();
    }
}

