/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.algox.business.logicsexecutor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import kd.bos.algo.Output;
import kd.bos.algo.output.DbOutput;
import kd.bos.algox.AlgoX;
import kd.bos.algox.AlgoXCallBack;
import kd.bos.algox.DataSetX;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.JobSession;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.entity.validation.ConditionValidation;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.ShardingUtil;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mpscmm.msbd.algox.business.function.callback.InspectSuccessCallBack;
import kd.mpscmm.msbd.algox.business.function.input.InsValidInput;
import kd.mpscmm.msbd.algox.business.function.reduce.IuValidCalculateFunction;
import kd.mpscmm.msbd.algox.business.logicsexecutor.AbstractInspectUnitExecutor;
import kd.mpscmm.msbd.algox.common.helper.ConditionAnalysisHelper;
import kd.mpscmm.msbd.algox.common.helper.InsExecuteHelper;
import kd.mpscmm.msbd.algox.common.info.InspectExtExecutorInfo;
import kd.mpscmm.msbd.algox.common.info.InspectLogToolsInfo;
import kd.mpscmm.msbd.algox.common.util.InspectUnitContext;

public class IuValidExecutor
extends AbstractInspectUnitExecutor {
    private static final Log logger = LogFactory.getLog(IuValidExecutor.class);

    public IuValidExecutor(InspectUnitContext inspectUnitContext) {
        super(inspectUnitContext);
    }

    @Override
    public InspectExtExecutorInfo executeUnitLogic(DynamicObject inspectUnit, List<QFilter> inspectUnitQFilter) {
        String inspectEntity = (String)inspectUnit.getDynamicObject("entity").getPkValue();
        List<QFilter> enablePlanQFilter = this.getEnablePlanQFilter(inspectEntity);
        if (enablePlanQFilter != null) {
            inspectUnitQFilter.addAll(enablePlanQFilter);
        }
        QFilter[] qFilter = inspectUnitQFilter.toArray(new QFilter[0]);
        int count = ORM.create().count(this.getClass().getName(), inspectEntity, qFilter);
        if (count > 100000) {
            String expMsg = ResManager.loadKDString((String)"\u672c\u6b21\u5de1\u68c0\u6570\u636e\u91cf\u8d85\u8fc710\u4e07\uff0c\u5efa\u8bae\u5199\u63d2\u4ef6\u5b8c\u6210\uff0c\u6216\u8005\u8c03\u6574\u8fc7\u6ee4\u6761\u4ef6\u5c06\u5de1\u68c0\u6570\u636e\u91cf\u964d\u4f4e\u3002", (String)"IuValidExecutor_0", (String)"mpscmm-msbd-algox", (Object[])new Object[0]);
            throw new KDBizException(expMsg);
        }
        long maxInspectNum = this.inspectUnitContext.getMaxInspectNum();
        if ((long)count > maxInspectNum && maxInspectNum != 0L) {
            String expMsg = String.format(ResManager.loadKDString((String)"\u5f85\u5de1\u68c0\u6570\u91cf\uff08%1$d\uff09\u8d85\u8fc7\u5de1\u68c0\u4efb\u52a1\u4e0a\u5b9a\u4e49\u7684\u6700\u5927\u5de1\u68c0\u6570\u91cf\uff08%2$d\uff09\u3002", (String)"IuValidExecutor_1", (String)"mpscmm-msbd-algox", (Object[])new Object[0]), count, maxInspectNum);
            throw new KDBizException(expMsg);
        }
        long batchMaxNum = this.inspectUnitContext.getBatchMaxNum();
        ShardingUtil.BroadcastVO broadcast = this.inspectUnitContext.getBroadcast();
        long factBatchMaxNum = batchMaxNum == 0L ? 2000L : batchMaxNum;
        int isAlgoX = 0;
        isAlgoX = broadcast != null ? this.executeBroadCastUnitLogic(inspectUnit, broadcast, inspectEntity, qFilter, count, factBatchMaxNum) : this.executeSingleUnitLogic(inspectUnit, inspectEntity, qFilter, count, factBatchMaxNum);
        InspectExtExecutorInfo inspectExtExecutorInfo = InspectExtExecutorInfo.assertInsResult(count, count);
        inspectExtExecutorInfo.setIsAlgoX(isAlgoX);
        return inspectExtExecutorInfo;
    }

    private int executeBroadCastUnitLogic(DynamicObject inspectUnit, ShardingUtil.BroadcastVO broadcast, String inspectEntity, QFilter[] qFilter, int totalNum, long factBatchMaxNum) {
        Long inspectUnitId = (Long)inspectUnit.getPkValue();
        int index = broadcast.getIndex();
        int total = broadcast.getTotal();
        List objectList = QueryServiceHelper.queryPrimaryKeys((String)inspectEntity, (QFilter[])qFilter, null, (int)totalNum);
        ArrayList<Object> entityDataIdList = new ArrayList<Object>(16);
        for (int i = 0; i < objectList.size(); ++i) {
            if (i % total != index) continue;
            entityDataIdList.add(objectList.get(i));
        }
        logger.info("\u5e7f\u64ad\u4e8b\u52a1\u5904\u7406MyTaskBroadcast,\u5206\u7247\u53c2\u6570: \u603b\u6570\uff1a{} \u5f53\u524d\u6267\u884c\u5668\u5e8f\u53f7\uff1a {}\u3002\u5904\u7406\u4e86{}\u6761\u6570\u636e\u4e2d\u7684\uff1a{}", new Object[]{total, index, entityDataIdList.size(), StringUtils.join((Object[])entityDataIdList.toArray(), (String)",")});
        int isAlgoX = 0;
        if ((long)entityDataIdList.size() > factBatchMaxNum) {
            isAlgoX = this.batchExeData(inspectEntity, inspectUnit, entityDataIdList, factBatchMaxNum);
        } else {
            DynamicObject[] bizDataArray = BusinessDataServiceHelper.load((Object[])entityDataIdList.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)inspectEntity));
            List<OperateErrorInfo> operateErrorInfoList = this.executeDmfUnit(inspectEntity, inspectUnit, bizDataArray);
            if (operateErrorInfoList.size() > 0) {
                Long entryId = this.inspectUnitContext.getLogEntryIdInspectId().get(inspectUnitId);
                Integer logSubEntrySeq = InsExecuteHelper.getLogSubEntrySeq(this.getClass().getName(), entryId);
                InspectLogToolsInfo.syncSaveExpEntry(operateErrorInfoList, entryId, logSubEntrySeq);
            }
        }
        return isAlgoX;
    }

    private int executeSingleUnitLogic(DynamicObject inspectUnit, String inspectEntity, QFilter[] qFilter, int totalNum, long factBatchMaxNum) {
        Long inspectUnitId = (Long)inspectUnit.getPkValue();
        int isAlgoX = 0;
        if ((long)totalNum > factBatchMaxNum) {
            List objectList = QueryServiceHelper.queryPrimaryKeys((String)inspectEntity, (QFilter[])qFilter, null, (int)totalNum);
            isAlgoX = this.batchExeData(inspectEntity, inspectUnit, objectList, factBatchMaxNum);
        } else {
            DynamicObject[] bizDataArray = this.analysisDmfDataRange(inspectEntity, qFilter, totalNum);
            List<OperateErrorInfo> operateErrorInfoList = this.executeDmfUnit(inspectEntity, inspectUnit, bizDataArray);
            if (operateErrorInfoList.size() > 0) {
                Long entryId = this.inspectUnitContext.getLogEntryIdInspectId().get(inspectUnitId);
                Integer logSubEntrySeq = InsExecuteHelper.getLogSubEntrySeq(this.getClass().getName(), entryId);
                InspectLogToolsInfo.syncSaveExpEntry(operateErrorInfoList, entryId, logSubEntrySeq + 1);
            }
        }
        return isAlgoX;
    }

    private int batchExeData(String inspectEntity, DynamicObject inspectUnit, List<Object> objectList, long factBatchMaxNum) {
        Long inspectUnitId = (Long)inspectUnit.getPkValue();
        int totalNum = objectList.size();
        int isAlgoX = 0;
        if (totalNum > 20000) {
            isAlgoX = 1;
            JobSession jobSession = AlgoX.createSession((String)this.getClass().getName());
            InsValidInput inspectCustomizedInput = new InsValidInput(objectList);
            DataSetX inputDataSetX = jobSession.fromInput(inspectCustomizedInput.createBizDataInput());
            Long entryId = this.inspectUnitContext.getLogEntryIdInspectId().get(inspectUnitId);
            inputDataSetX = inputDataSetX.groupBy(new String[0]).reduceGroup((GroupReduceFunction)new IuValidCalculateFunction(inspectEntity, entryId, inspectUnit, factBatchMaxNum));
            String insertSql = "insert into t_msbd_inspectlogentry_e(fdetailid,fentryid,fseq,fobjid,fobjentryid,fobjtypeid,fobjdes,fbizuniquesympol) values(?,?,?,?,?,?,?,?)";
            DbOutput outPut = new DbOutput("scm", insertSql, inputDataSetX.getRowMeta());
            inputDataSetX.output((Output)outPut);
            long timeOut = this.inspectUnitContext.getTimeOut();
            int commitTimeOut = Integer.parseInt(String.valueOf(timeOut)) - 5;
            int runningTimeOut = commitTimeOut - 5;
            logger.info("commitTimeOut : " + commitTimeOut + " runningTimeOut : " + runningTimeOut + " " + (Object)((Object)TimeUnit.SECONDS) + " " + InspectSuccessCallBack.class.getName() + " entryId " + entryId);
            jobSession.asyncCommit(commitTimeOut, runningTimeOut, TimeUnit.SECONDS, (AlgoXCallBack)new InspectSuccessCallBack(entryId));
        } else {
            List<List<Object>> partitionList = InsExecuteHelper.partition(objectList, (int)factBatchMaxNum);
            Iterator<List<Object>> iterator = partitionList.iterator();
            int remainder = partitionList.size() % 10;
            int number = partitionList.size() / 10;
            if (remainder != 0) {
                ++number;
            }
            int i = 1;
            int n = 1;
            int totalEntryExpNum = 0;
            Long entryId = this.inspectUnitContext.getLogEntryIdInspectId().get(inspectUnitId);
            Integer logSubEntrySeq = InsExecuteHelper.getLogSubEntrySeq(this.getClass().getName(), entryId);
            while (iterator.hasNext()) {
                List<Object> batchBillNo = iterator.next();
                boolean mulTermination = InsExecuteHelper.getMulTermination((Long)inspectUnit.getPkValue());
                if (mulTermination) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u8be5\u5de1\u68c0\u6a21\u578b\u5df2\u7ecf\u88ab\u7ec8\u6b62\uff0c\u7ec8\u6b62\u671f\u95f4\u5185\uff0c\u4e0d\u5141\u8bb8\u518d\u6b21\u88ab\u6267\u884c\u3002", (String)"IuValidExecutor_2", (String)"mpscmm-msbd-algox", (Object[])new Object[0]));
                }
                DynamicObject[] batchObject = this.queryDynamicObject(batchBillNo, inspectEntity);
                List<OperateErrorInfo> operateErrorInfoList = this.executeDmfUnit(inspectEntity, inspectUnit, batchObject);
                if (operateErrorInfoList.size() >= 10000) {
                    operateErrorInfoList = operateErrorInfoList.subList(0, 10000);
                }
                InspectLogToolsInfo.syncSaveExpEntry(operateErrorInfoList, entryId, logSubEntrySeq + 1);
                logSubEntrySeq = logSubEntrySeq + operateErrorInfoList.size() + 1;
                if ((totalEntryExpNum += operateErrorInfoList.size()) >= 10000) break;
                if (n == i * number) {
                    this.executeSql("update t_msbd_inspectlogentry set fruningprocess =? where fentryid=?", new Object[]{InsExecuteHelper.getValidProcessValue(i), entryId});
                    ++i;
                }
                ++n;
                this.waitTime(500L);
                iterator.remove();
            }
        }
        return isAlgoX;
    }

    private List<OperateErrorInfo> executeDmfUnit(String inspectEntity, DynamicObject dmfUnit, DynamicObject[] bills) {
        DynamicObjectCollection validEntityRows = dmfUnit.getDynamicObjectCollection("validentity");
        List<Object> operateErrorInfoList = new ArrayList<OperateErrorInfo>(16);
        String fieldKey = "billno";
        boolean isFieldKeyFlag = this.judgeExistsField(inspectEntity, fieldKey);
        String billNo = "";
        for (DynamicObject bill : bills) {
            if (isFieldKeyFlag) {
                billNo = bill.getString(fieldKey);
            }
            for (DynamicObject conditionRow : validEntityRows) {
                boolean trueThrow;
                boolean validEnable = conditionRow.getBoolean("validenable");
                if (!validEnable) continue;
                String expressionEntity = (String)conditionRow.get("validjson_tag");
                ConditionValidation conditionValidation = InsExecuteHelper.getConditionValidation(expressionEntity);
                String expression = conditionValidation.getExpression();
                String entityKey = conditionValidation.getEntityKey();
                CRCondition condition = new CRCondition();
                condition.setExpression(expression);
                condition.buildFullFormula(MetadataServiceHelper.getDataEntityType((String)inspectEntity));
                boolean exeResultFlag = ConditionAnalysisHelper.doExeCondition(inspectEntity, bill, condition, entityKey);
                if (exeResultFlag != (trueThrow = conditionValidation.isTrueThrow())) continue;
                OperateErrorInfo operateerrorinfo = new OperateErrorInfo("DmfUnitService.excuteDmfUnitValidExpression", ErrorLevel.Error, bill.getPkValue(), bill.getPkValue());
                operateerrorinfo.setTitle(billNo);
                operateerrorinfo.setEntityKey(inspectEntity);
                String msg = "";
                msg = isFieldKeyFlag ? String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7\uff1a%1$s,\u5b58\u5728\u5982\u4e0b\u95ee\u9898\uff1a%2$s", (String)"IuValidExecutor_3", (String)"mpscmm-msbd-algox", (Object[])new Object[0]), billNo, conditionValidation.getMessage().getLocaleValue()) : String.format(ResManager.loadKDString((String)"\u5b58\u5728\u5982\u4e0b\u95ee\u9898\uff1a%s", (String)"IuValidExecutor_4", (String)"mpscmm-msbd-algox", (Object[])new Object[0]), conditionValidation.getMessage().getLocaleValue());
                operateerrorinfo.setMessage(msg);
                operateErrorInfoList.add(operateerrorinfo);
            }
            if (operateErrorInfoList.size() <= 10000) continue;
            operateErrorInfoList = operateErrorInfoList.subList(0, 10000);
            break;
        }
        bills = null;
        return operateErrorInfoList;
    }

    private List<QFilter> getEnablePlanQFilter(String inspectEntity) {
        List<QFilter> inspectPlanQFilter = this.inspectUnitContext.getInspectPlanQFilter();
        List<QFilter> qFilterList = inspectPlanQFilter.stream().collect(Collectors.toList());
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)inspectEntity);
        Set entries = dataEntityType.getAllEntities().entrySet();
        Iterator qFilterIterator = qFilterList.iterator();
        while (qFilterIterator.hasNext()) {
            boolean flag = false;
            QFilter qFilter = (QFilter)qFilterIterator.next();
            if (qFilter == null) continue;
            String property = qFilter.getProperty();
            for (Map.Entry entry : entries) {
                IDataEntityProperty varLeft;
                EntityType value = (EntityType)entry.getValue();
                if (((String)entry.getKey()).contains("_lk") || (varLeft = value.findProperty(property)) == null) continue;
                flag = true;
                break;
            }
            if (flag) continue;
            qFilterIterator.remove();
        }
        return qFilterList;
    }

    private boolean judgeExistsField(String inspectEntity, String fieldKey) {
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)inspectEntity);
        Set entries = dataEntityType.getAllEntities().entrySet();
        boolean flag = false;
        for (Map.Entry entry : entries) {
            IDataEntityProperty varLeft;
            EntityType value;
            if (((String)entry.getKey()).contains("_lk") || !((value = (EntityType)entry.getValue()) instanceof BillEntityType) || (varLeft = value.findProperty(fieldKey)) == null) continue;
            flag = true;
            break;
        }
        return flag;
    }

    private List<OperateErrorInfo> getOperateErrorInfoList(String inspectEntity, String expMsg) {
        ArrayList<OperateErrorInfo> collectData = new ArrayList<OperateErrorInfo>(16);
        OperateErrorInfo operateErrorInfo = new OperateErrorInfo(this.getClass().getName(), ErrorLevel.Error, (Object)0L, (Object)0L);
        operateErrorInfo.setMessage(expMsg);
        operateErrorInfo.setTitle("error");
        operateErrorInfo.setEntityKey(inspectEntity);
        Collections.addAll(collectData, operateErrorInfo);
        return collectData;
    }

    private void executeSql(String sqlTemp, Object[] params) {
        DB.execute((DBRoute)DBRoute.of((String)"scm"), (String)sqlTemp, (Object[])params);
    }
}

