/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.algox.business.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Callable;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.message.api.MessageChannels;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.ShardingUtil;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.url.UrlService;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import kd.mpscmm.msbd.algox.business.service.IInspectPlanService;
import kd.mpscmm.msbd.algox.business.service.InspectUnitService;
import kd.mpscmm.msbd.algox.common.info.InspectLogToolsInfo;
import kd.mpscmm.msbd.algox.common.info.InspectUnitResultInfo;
import kd.mpscmm.msbd.algox.common.util.InspectUnitContext;

public abstract class AbstractInspectPlanService
implements IInspectPlanService {
    private static final Log logger = LogFactory.getLog(AbstractInspectPlanService.class);

    @Override
    public abstract List<InspectUnitResultInfo> executeInspectUnits(DynamicObject[] var1, List<QFilter> var2, long var3, long var5, ShardingUtil.BroadcastVO var7);

    @Override
    public boolean batchSendSchemeResultMsg(Long userId, String msg, Long dmfLogId) {
        try {
            ArrayList<Long> userIDS = new ArrayList<Long>(16);
            userIDS.add(userId);
            MessageInfo msgInfo = new MessageInfo();
            msgInfo.setNotifyType(MessageChannels.MC.getNumber());
            msgInfo.setUserIds(userIDS);
            MainEntityType dmfAuditScheme = MetadataServiceHelper.getDataEntityType((String)"msbd_inspectplan");
            LocaleString disPlayName = dmfAuditScheme.getDisplayName();
            msgInfo.setEntityNumber(dmfAuditScheme.getName());
            msgInfo.setTitle(disPlayName.getLocaleValue());
            msgInfo.setMessageType("alarm");
            String clientUrl = UrlService.getDomainContextUrl();
            String url = String.format("%s/index.html?formId=%s&pkId=%d&type=base", clientUrl, "msbd_inspectlog", dmfLogId);
            msgInfo.setContentUrl(url);
            msgInfo.setContent(String.format(ResManager.loadKDString((String)"%1$s\u8bf7\u70b9\u51fb\uff1a%2$s", (String)"AbstractInspectPlanService_0", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]), msg, url));
            MessageCenterServiceHelper.sendMessage((MessageInfo)msgInfo);
        }
        catch (Exception e) {
            logger.error("\u53d1\u9001\u6d88\u606f\u51fa\u73b0\u4e86\u5f02\u5e38:{}", (Object)Arrays.toString(e.getStackTrace()));
            return false;
        }
        return true;
    }

    public void initLogToolsEntry(InspectLogToolsInfo inspectLogToolsInfo, InspectUnitContext inspectUnitContext) {
        DynamicObjectCollection inspectLogToolsInfoEntry = inspectLogToolsInfo.getResult().getDynamicObjectCollection("entryentity");
        HashMap<Long, Long> toolsInfo = new HashMap<Long, Long>(16);
        for (DynamicObject resultEntry : inspectLogToolsInfoEntry) {
            long inspectUnitId = resultEntry.getLong("inspectunit");
            toolsInfo.put(inspectUnitId, (Long)resultEntry.getPkValue());
        }
        inspectUnitContext.setLogEntryIdInspectId(toolsInfo);
    }

    static class InspectUnitCallable
    implements Callable<InspectUnitResultInfo> {
        private InspectUnitService inspectUnitService;
        private DynamicObject inspectUnit;

        public InspectUnitCallable(InspectUnitService inspectUnitService, DynamicObject inspectUnit) {
            this.inspectUnit = inspectUnit;
            this.inspectUnitService = inspectUnitService;
        }

        @Override
        public InspectUnitResultInfo call() throws Exception {
            return this.inspectUnitService.executeDmfUnit(this.inspectUnit);
        }
    }
}

