/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.algox.common.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DcBinder;
import kd.bos.dataentity.serialization.DcJsonSerializer;
import kd.bos.dataentity.serialization.ListDcxmlBinder;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.instance.Instance;
import kd.bos.metadata.entity.validation.ConditionValidation;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mpscmm.msbd.common.utils.AppCacheUtils;

public class InsExecuteHelper {
    public static long getEntityTbaleRecordNum(String tableName, List<QFilter> qFilterList) {
        String sql = String.format("select count(1) from %s where ", tableName);
        long count = (Long)DB.query((DBRoute)DBRoute.of((String)"SCM"), (String)sql, resultSet -> {
            resultSet.next();
            return resultSet.getLong(1);
        });
        return count;
    }

    public static Integer getLogSubEntrySeq(String algoKey, Long entryId) {
        String seqSql = "select fseq from t_msbd_inspectlogentry_e  where fentryid=?";
        try (DataSet dataSet = DB.queryDataSet((String)algoKey, (DBRoute)DBRoute.of((String)"SCM"), (String)seqSql, (Object[])new Object[]{entryId});){
            Integer n = dataSet.count("fseq", false);
            return n;
        }
    }

    public static String getValidProcessValue(int percent) {
        String value = "V";
        if (percent == 1) {
            value = "M";
        }
        if (percent == 2) {
            value = "N";
        }
        if (percent == 3) {
            value = "O";
        }
        if (percent == 4) {
            value = "P";
        }
        if (percent == 5) {
            value = "Q";
        }
        if (percent == 6) {
            value = "R";
        }
        if (percent == 7) {
            value = "S";
        }
        if (percent == 8) {
            value = "T";
        }
        if (percent == 9) {
            value = "U";
        }
        if (percent == 10) {
            value = "V";
        }
        return value;
    }

    public static String getPluginProcessValue(int percent) {
        String value = "K";
        if (percent == 1) {
            value = "B";
        }
        if (percent == 2) {
            value = "C";
        }
        if (percent == 3) {
            value = "D";
        }
        if (percent == 4) {
            value = "E";
        }
        if (percent == 5) {
            value = "F";
        }
        if (percent == 6) {
            value = "G";
        }
        if (percent == 7) {
            value = "H";
        }
        if (percent == 8) {
            value = "I";
        }
        if (percent == 9) {
            value = "J";
        }
        if (percent == 10) {
            value = "K";
        }
        return value;
    }

    public static ConditionValidation getConditionValidation(String expressionEntity) {
        ArrayList<IDataEntityType> dTypes = new ArrayList<IDataEntityType>(16);
        dTypes.add(DataEntityType.getDataEntityType(ConditionValidation.class));
        ListDcxmlBinder binder = new ListDcxmlBinder(false, dTypes);
        Map parameter = (Map)SerializationUtils.fromJsonString((String)expressionEntity, Map.class);
        return (ConditionValidation)new DcJsonSerializer((DcBinder)binder).deserializeFromMap(parameter, null);
    }

    public static boolean getRunningInspectPlan(Long inspectPlanId) {
        QFilter qFilter = new QFilter("inspectplan", "=", (Object)inspectPlanId);
        QFilter runningPlanQFilter = new QFilter("exestatus", "=", (Object)"A");
        runningPlanQFilter.or(new QFilter("entryentity.runingstatus", "in", Arrays.asList("A", "B")));
        boolean inspectLog = QueryServiceHelper.exists((String)"msbd_inspectlog", (QFilter[])qFilter.and(runningPlanQFilter).toArray());
        return inspectLog;
    }

    public static boolean getMulTermination(Long unitId) {
        boolean flag = false;
        String instanceId = Instance.getInstanceId();
        String mulCloseKey = instanceId.concat("_mulclose_").concat("msbd");
        String mulCloseValue = (String)AppCacheUtils.get((String)mulCloseKey, String.class);
        if (mulCloseValue == null) {
            return flag;
        }
        List mulCloseValueList = SerializationUtils.fromJsonStringToList((String)mulCloseValue, Long.class);
        return mulCloseValueList.contains(unitId);
    }

    public static Long getOrgId(String orgNumber) {
        QFilter qFilter = new QFilter("number", "=", (Object)orgNumber);
        List orgIdList = QueryServiceHelper.queryPrimaryKeys((String)"bos_org", (QFilter[])qFilter.toArray(), null, (int)1);
        Long orgId = 0L;
        if (orgIdList != null && orgIdList.size() > 0) {
            orgId = (Long)orgIdList.get(0);
        }
        return orgId;
    }

    public static QFilter[] getQFilter(FilterCondition filterCondition, String entityNumber) {
        FilterBuilder fb = new FilterBuilder(EntityMetadataCache.getDataEntityType((String)entityNumber), filterCondition);
        fb.buildFilter();
        return fb.getQFilters().toArray(new QFilter[0]);
    }

    public static List<QFilter> getQFilterList(String filterJSON, String entityNumber) {
        FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)filterJSON, FilterCondition.class);
        FilterBuilder fb = new FilterBuilder(EntityMetadataCache.getDataEntityType((String)entityNumber), filterCondition);
        fb.buildFilter();
        QFilter qFilter = fb.getQFilter();
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(16);
        qFilterList.add(qFilter);
        return qFilterList;
    }

    public static <T> List<List<T>> partition(List<T> originalList, int batchSize) {
        ArrayList<List<T>> result = new ArrayList<List<T>>(16);
        if (originalList == null) {
            return result;
        }
        int remainder = originalList.size() % batchSize;
        int number = originalList.size() / batchSize;
        for (int i = 0; i < number; ++i) {
            List<T> value = originalList.subList(i * batchSize, (i + 1) * batchSize);
            result.add(value);
        }
        if (remainder > 0) {
            result.add(originalList.subList(number * batchSize, originalList.size()));
        }
        return result;
    }

    public static List<String> getEntityId(List<Object> inspectUnitIdList) {
        DynamicObjectCollection inspectUnitCollection = InsExecuteHelper.getInspectUnit(inspectUnitIdList);
        List<String> inspectEntityIdList = inspectUnitCollection.stream().map(inspectUnit -> inspectUnit.getString("entity.id")).collect(Collectors.toList());
        return inspectEntityIdList;
    }

    public static DynamicObjectCollection getInspectUnit(List<?> inspectUnitIdList) {
        DynamicObjectCollection inspectUnitCollection = QueryServiceHelper.query((String)"msbd_inspectunit", (String)"id,entity.id", (QFilter[])new QFilter("id", "in", inspectUnitIdList).toArray());
        return inspectUnitCollection;
    }

    public static String getSuccessTips(int totalBillNum, int totalBillEntryNum, int expBillNum, int expBillEntryNum) {
        return String.format(ResManager.loadKDString((String)"\u672c\u6b21\u5171\u5de1\u68c0\u4e86%1$s\u5355\uff0c\u5408\u8ba1%2$s\u6761\uff0c\u5176\u4e2d\u5f02\u5e38\u6570\u636e%3$s\u5355\uff0c\u5408\u8ba1%4$s\u6761\u3002", (String)"InsExecuteHelper_1", (String)"mpscmm-msbd-algox", (Object[])new Object[0]), totalBillNum, totalBillEntryNum, expBillNum, expBillEntryNum);
    }

    public static String getErrorTips(int totalBillNum, int totalBillEntryNum, int expBillNum, int expBillEntryNum) {
        return String.format(ResManager.loadKDString((String)"\u672c\u6b21\u5171\u5de1\u68c0\u4e86%1$s\u5355\uff0c\u5408\u8ba1%2$s\u6761\uff0c\u5176\u4e2d\u5f02\u5e38\u6570\u636e%3$s\u5355\uff0c\u5408\u8ba1%4$s\u6761\u3002", (String)"InsExecuteHelper_1", (String)"mpscmm-msbd-algox", (Object[])new Object[0]), totalBillNum, totalBillEntryNum, expBillNum, expBillEntryNum);
    }

    private InsExecuteHelper() {
    }
}

