/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.algox.common.info;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperateInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mpscmm.msbd.algox.common.helper.InsExecuteHelper;
import kd.mpscmm.msbd.algox.common.util.ReflectUtils;

public class InspectLogToolsInfo {
    protected static final Log logger = LogFactory.getLog(InspectLogToolsInfo.class);
    private DynamicObject result = BusinessDataServiceHelper.newDynamicObject((String)"msbd_inspectlog");

    public InspectLogToolsInfo(Long planId, Long jobId, List<Object> inspectUnitIdList, Object bizAppId, Long orgId) {
        long[] pkId = DBServiceHelper.genLongIds((String)"t_msbd_inspectlog", (int)1);
        this.result.set("id", (Object)pkId[0]);
        this.result.set("inspectplan", (Object)planId);
        this.result.set("inspectjob", (Object)jobId);
        this.result.set("exeuser", (Object)RequestContext.get().getCurrUserId());
        this.result.set("exetime", (Object)new Date(System.currentTimeMillis()));
        this.result.set("exestatus", (Object)"A");
        this.result.set("bizappid", bizAppId);
        this.result.set("org", (Object)orgId);
        DynamicObjectCollection rows = this.result.getDynamicObjectCollection("entryentity");
        int index = 1;
        for (Object inspectUnitId : inspectUnitIdList) {
            DynamicObject row = rows.addNew();
            row.set("seq", (Object)index);
            row.set("inspectunit", inspectUnitId);
            row.set("runingstatus", (Object)"A");
            ++index;
        }
        this.saveInspectLog();
    }

    public DynamicObject getResult() {
        return this.result;
    }

    public void beginRun(Long inspectUnitId) {
        this.result.getDynamicObjectCollection("entryentity").forEach(row -> {
            if (inspectUnitId.equals(row.getLong("inspectunit"))) {
                row.set("runingstatus", (Object)"B");
                row.set("runingprocess", (Object)"X");
            }
        });
        this.saveInspectLog();
    }

    public void collectExtExcpMsg(Long inspectUnitId, String excpstacktrace, boolean isLastItem) {
        for (DynamicObject resultEntry : this.result.getDynamicObjectCollection("entryentity")) {
            if (!inspectUnitId.equals(resultEntry.getLong("inspectunit"))) continue;
            resultEntry.set("entrystatus", (Object)"B");
            resultEntry.set("runingstatus", (Object)"C");
            resultEntry.set("runingprocess", (Object)"W");
            resultEntry.set("description", (Object)ResManager.loadKDString((String)"\u5de1\u68c0\u6a21\u578b\u5b58\u5728\u5f02\u5e38\u4fe1\u606f\uff0c\u8bf7\u6ce8\u610f\u67e5\u770b\u8be6\u60c5\u4fe1\u606f\u3002", (String)"InspectLogToolsInfo_1", (String)"mpscmm-msbd-algox", (Object[])new Object[0]));
            resultEntry.set("excpstacktrace_tag", (Object)excpstacktrace);
        }
        if (isLastItem) {
            this.result.set("exestatus", (Object)"B");
            this.result.set("endtime", (Object)new Date());
        }
        this.saveInspectLog();
    }

    public void endRun(Long inspectUnitId, int totalBillNum, int totalBillEntryNum, boolean isLastInspectUnit, int isAlgoX) {
        for (DynamicObject resultEntry : this.result.getDynamicObjectCollection("entryentity")) {
            if (!inspectUnitId.equals(resultEntry.getLong("inspectunit"))) continue;
            Long entryId = (Long)resultEntry.getPkValue();
            String seqSql = "select fobjid,fobjentryid from t_msbd_inspectlogentry_e  where fentryid=?";
            int expBillNum = 0;
            int expBillEntryNum = 0;
            try (DataSet sqlDataSet = this.queryDataSet(seqSql, new Object[]{entryId});){
                DataSet transform = sqlDataSet.groupBy(new String[]{"fobjid"}).count("fobjentryid").finish();
                DataSet lastResult = transform.groupBy().count("fobjid").sum("fobjentryid").finish();
                for (Row row : lastResult) {
                    expBillNum = row.getInteger("fobjid");
                    expBillEntryNum = row.getInteger("fobjentryid");
                }
            }
            if (isAlgoX == 1) {
                resultEntry.set("runingstatus", (Object)"B");
                resultEntry.set("runingprocess", (Object)"X");
            } else {
                resultEntry.set("runingstatus", (Object)"C");
                resultEntry.set("runingprocess", (Object)"W");
                resultEntry.set("description", (Object)InsExecuteHelper.getSuccessTips(totalBillNum, totalBillEntryNum, expBillNum, expBillEntryNum));
            }
            HashMap<String, Number> inspectDetail = new HashMap<String, Number>(16);
            inspectDetail.put("inspect_unit_totalnum", totalBillNum);
            inspectDetail.put("inspect_unit_totalentrynum", totalBillEntryNum);
            if (expBillNum <= 0) {
                inspectDetail.put("inspect_unit_expnum", 0L);
                inspectDetail.put("inspect_unit_expnum", 0L);
                resultEntry.set("inspectdetail", (Object)SerializationUtils.toJsonString(inspectDetail));
                if (isAlgoX == 1) continue;
                resultEntry.set("entrystatus", (Object)"D");
                continue;
            }
            inspectDetail.put("inspect_unit_expnum", Long.valueOf(expBillNum));
            inspectDetail.put("inspect_unit_expnum", expBillEntryNum);
            resultEntry.set("inspectdetail", (Object)SerializationUtils.toJsonString(inspectDetail));
            resultEntry.set("entrystatus", (Object)"C");
        }
        if (isLastInspectUnit) {
            if (isAlgoX == 1) {
                this.result.set("exestatus", (Object)"A");
            } else {
                this.result.set("exestatus", (Object)"B");
                this.result.set("endtime", (Object)new Date());
            }
        }
        this.saveInspectLog();
    }

    /*
     * WARNING - void declaration
     */
    public static void syncSaveExpEntry(List<OperateErrorInfo> errorDataList, Object entryId, int indexSeq) {
        errorDataList.stream().sorted(Comparator.comparing(OperateInfo::getTitle));
        int subEntrySize = errorDataList.size();
        ArrayList<Object[]> subEntryValues = new ArrayList<Object[]>(subEntrySize);
        long[] detailPkIdList = DBServiceHelper.genLongIds((String)"t_msbd_inspectlogentry_e", (int)subEntrySize);
        for (int i = 0; i < subEntrySize; ++i) {
            void var10_11;
            OperateErrorInfo result = errorDataList.get(i);
            Object[] subEntry = new Object[8];
            subEntry[0] = indexSeq;
            subEntry[1] = detailPkIdList[i];
            subEntry[2] = entryId;
            subEntry[3] = result.getPkValue();
            Object[] reflectFieldsValue = ReflectUtils.reflectFieldsValue(result, "entryId");
            subEntry[4] = reflectFieldsValue[0] instanceof Long ? reflectFieldsValue[0] : Long.valueOf(0L);
            subEntry[5] = result.getEntityKey();
            String string = "";
            if (result.getMessage().length() > 512) {
                String string2 = result.getMessage().substring(0, 480);
            } else {
                String string3 = result.getMessage();
            }
            subEntry[6] = var10_11;
            String title = result.getTitle();
            if (title == null) {
                title = "";
            }
            subEntry[7] = title;
            subEntryValues.add(subEntry);
            ++indexSeq;
        }
        DBRoute currentDBRoute = DBRoute.of((String)"scm");
        String insertSubEntrySql = "insert into t_msbd_inspectlogentry_e(fseq,fdetailid,fentryid,fobjid,fobjentryid,fobjtypeid,fobjdes,fbizuniquesympol) values(?,?,?,?,?,?,?,?)";
        if (subEntrySize > 5000) {
            List partitionList = InsExecuteHelper.partition(subEntryValues, 5000);
            for (List<Object[]> list : partitionList) {
                InspectLogToolsInfo.saveSqlEntry(currentDBRoute, insertSubEntrySql, list);
            }
        } else {
            InspectLogToolsInfo.saveSqlEntry(currentDBRoute, insertSubEntrySql, subEntryValues);
        }
    }

    private static void saveSqlEntry(DBRoute currentDBRoute, String insertSubEntrySql, List<Object[]> partition) {
        try (TXHandle tx = TX.requiresNew((String)InspectLogToolsInfo.class.getName());){
            try {
                DB.executeBatch((DBRoute)currentDBRoute, (String)insertSubEntrySql, partition);
            }
            catch (Exception e) {
                tx.markRollback();
                logger.error("\u6301\u4e45\u5316\u65e5\u5fd7\u51fa\u73b0\u4e86\u5f02\u5e38:{}", (Object)Arrays.toString(e.getStackTrace()));
            }
        }
    }

    private void saveInspectLog() {
        try (TXHandle tx = TX.requiresNew((String)InspectLogToolsInfo.class.getName());){
            try {
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{this.result});
            }
            catch (Exception e) {
                tx.markRollback();
                logger.error("\u6301\u4e45\u5316\u65e5\u5fd7\u51fa\u73b0\u4e86\u5f02\u5e38:{}", (Object)Arrays.toString(e.getStackTrace()));
            }
        }
    }

    private DataSet queryDataSet(String sqlTemp, Object[] params) {
        return DB.queryDataSet((String)this.getClass().getName(), (DBRoute)DBRoute.of((String)"SCM"), (String)sqlTemp, (Object[])params);
    }
}

