/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.mastermodel.formplugin.queryscheme;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DcBinder;
import kd.bos.dataentity.serialization.DcJsonSerializer;
import kd.bos.dataentity.serialization.DynamicObjectSerializationBinder;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.dlock.DLock;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.Plugin;
import kd.bos.entity.property.FieldProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.container.Container;
import kd.bos.form.container.FormRoot;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.field.DateRangeEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.mpscmm.msbd.mastermodel.formplugin.queryscheme.ISchemeSavePlugin;
import kd.mpscmm.msbd.mastermodel.formplugin.queryscheme.PluginFactory;
import kd.mpscmm.msbd.mastermodel.formplugin.queryscheme.SchemeSavePlugin;

public class SchemeSaveHolder
implements ISchemeSavePlugin {
    private static final String SCHEME_ENTITY = "msmod_query_scheme";
    private final String formId;
    private IFormView view;
    private boolean isAddScheme = false;
    private Set<String> removeEntities = new HashSet<String>(16);

    public SchemeSaveHolder(IFormView view) {
        this.view = view;
        DynamicObject dataEntityDyc = this.view.getModel().getDataEntity(true);
        this.formId = dataEntityDyc.getDataEntityType().getExtendName();
    }

    public void initSchemesList() {
        DynamicObjectCollection schemeDycs = this.getSaveSchemeListDataExt(this.view);
        if (schemeDycs == null || schemeDycs.isEmpty()) {
            return;
        }
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField("schemeid_entry", new Object[0]);
        vs.addField("schemename_entry", new Object[0]);
        vs.addField("isdefaultscheme_entry", new Object[0]);
        for (DynamicObject item : schemeDycs) {
            Long schemeId = item.getLong("id");
            String schemeName = item.getString("name");
            String isdefaultScheme = item.getString("isdefault");
            vs.addRow(new Object[]{schemeId, schemeName, isdefaultScheme});
        }
        this.view.getModel().beginInit();
        this.view.getModel().deleteEntryData("scheme_entry");
        int rowCount = vs.getCount();
        if (rowCount != 0) {
            ((AbstractFormDataModel)this.view.getModel()).batchCreateNewEntryRow("scheme_entry", vs);
        }
        this.view.getModel().endInit();
        this.view.updateView("scheme_entry");
    }

    public void setDefaultScheme() {
        String isInit = this.view.getPageCache().get("isinit");
        int entryRowCount = this.view.getModel().getEntryRowCount("scheme_entry");
        if (isInit != null || entryRowCount < 1) {
            return;
        }
        EntryGrid entryGrid = (EntryGrid)this.view.getControl("scheme_entry");
        Boolean isDefault = (Boolean)this.view.getModel().getValue("isdefaultscheme_entry", 0);
        if (isDefault.booleanValue()) {
            entryGrid.selectRows(0);
        }
        this.view.getPageCache().put("isinit", "");
        DynamicObject formDataEntityDyc = this.view.getModel().getDataEntity(true);
        String schemeStr = this.toJson(formDataEntityDyc);
        this.view.getPageCache().put("initschemestr", schemeStr);
    }

    public DynamicObject saveScheme() {
        int index;
        DynamicObjectCollection formSchemeDycs;
        Object entrySchemeName;
        DynamicObject formDataEntityDyc = this.view.getModel().getDataEntity(true);
        int currentRow = this.view.getModel().getEntryCurrentRowIndex("scheme_entry");
        Object selSchemeId = this.view.getModel().getValue("schemeid_entry", currentRow);
        Boolean isDefault = (Boolean)this.view.getModel().getValue("isdefaultscheme_entry", currentRow);
        boolean isNew = selSchemeId == null || selSchemeId.equals(0L) || this.view.getPageCache().get("isAddSchemeCacheKey") != null;
        String setSchemeName = formDataEntityDyc.getString("schemename");
        if (!setSchemeName.equals(entrySchemeName = this.view.getModel().getValue("schemename_entry", currentRow))) {
            isNew = true;
        }
        DynamicObject schemeDyc = this.buildSchemeDyc(selSchemeId, isNew);
        this.saveSchemeDynaDealExt(this.view, schemeDyc);
        String lockKey = this.formId + schemeDyc.getString("name");
        try (DLock lock = DLock.create((String)lockKey, (String)"mscommon-writeoff-QuerySchemeHolder");){
            lock.lock();
            this.checkHasSameNameScheme(schemeDyc);
            this.invokeSaveScheme(new DynamicObject[]{schemeDyc});
        }
        if (!isNew) {
            this.view.getModel().deleteEntryRow("scheme_entry", currentRow);
        }
        if ((formSchemeDycs = formDataEntityDyc.getDynamicObjectCollection("scheme_entry")).isEmpty()) {
            index = this.view.getModel().createNewEntryRow("scheme_entry");
        } else {
            index = 0;
            this.view.getModel().insertEntryRow("scheme_entry", index);
        }
        if (!isNew) {
            this.view.getModel().setValue("isdefaultscheme_entry", (Object)isDefault, index);
        }
        this.view.getModel().setValue("schemename_entry", schemeDyc.get("name"), index);
        this.view.getModel().setValue("schemeid_entry", schemeDyc.getPkValue(), index);
        EntryGrid entryGrid = (EntryGrid)this.view.getControl("scheme_entry");
        entryGrid.selectRows(index);
        this.view.getPageCache().remove("isAddSchemeCacheKey");
        this.view.getModel().setDataChanged(false);
        return schemeDyc;
    }

    @Override
    public boolean checkDataChangedExt() {
        List plugins = this.view.getFormShowParameter().getFormConfig().getPlugins();
        for (Plugin plugin : plugins) {
            boolean checkDataChangedExt;
            Object pagePlugin;
            String className = plugin.getClassName();
            if (!plugin.isEnabled() || SchemeSavePlugin.class.getName().equals(className) || !((pagePlugin = PluginFactory.newStrategy(className)) instanceof ISchemeSavePlugin) || (checkDataChangedExt = ((ISchemeSavePlugin)pagePlugin).checkDataChangedExt())) continue;
            return false;
        }
        return true;
    }

    @Override
    public void saveSchemeDynaDealExt(IFormView view, DynamicObject schemeDyna) {
        List plugins = view.getFormShowParameter().getFormConfig().getPlugins();
        for (Plugin plugin : plugins) {
            Object pagePlugin;
            String className = plugin.getClassName();
            if (!plugin.isEnabled() || SchemeSavePlugin.class.getName().equals(className) || !((pagePlugin = PluginFactory.newStrategy(className)) instanceof ISchemeSavePlugin)) continue;
            ((ISchemeSavePlugin)pagePlugin).saveSchemeDynaDealExt(view, schemeDyna);
        }
    }

    @Override
    public QFilter checkSchemeNameQfilter(IFormView view) {
        List plugins = view.getFormShowParameter().getFormConfig().getPlugins();
        QFilter qFilter = new QFilter("1", "=", (Object)1);
        for (Plugin plugin : plugins) {
            QFilter qFilterExt;
            Object pagePlugin;
            String className = plugin.getClassName();
            if (!plugin.isEnabled() || this.getClass().getName().equals(className) || !((pagePlugin = PluginFactory.newStrategy(className)) instanceof ISchemeSavePlugin) || (qFilterExt = ((ISchemeSavePlugin)pagePlugin).checkSchemeNameQfilter(view)) == null) continue;
            qFilter.and(qFilterExt);
        }
        return qFilter;
    }

    @Override
    public void afterSelScheme() {
        List plugins = this.view.getFormShowParameter().getFormConfig().getPlugins();
        for (Plugin plugin : plugins) {
            Object pagePlugin;
            String className = plugin.getClassName();
            if (!plugin.isEnabled() || this.getClass().getName().equals(className) || !((pagePlugin = PluginFactory.newStrategy(className)) instanceof ISchemeSavePlugin)) continue;
            ((ISchemeSavePlugin)pagePlugin).afterSelScheme();
        }
    }

    @Override
    public void selectSchemeDealExt(DynamicObject dbFormDataDyc, IFormView iFormView) {
        List plugins = this.view.getFormShowParameter().getFormConfig().getPlugins();
        for (Plugin plugin : plugins) {
            Object pagePlugin;
            String className = plugin.getClassName();
            if (!plugin.isEnabled() || SchemeSavePlugin.class.getName().equals(className) || !((pagePlugin = PluginFactory.newStrategy(className)) instanceof ISchemeSavePlugin)) continue;
            ((ISchemeSavePlugin)pagePlugin).selectSchemeDealExt(dbFormDataDyc, this.view);
        }
    }

    @Override
    public void beforeSaveSchemeExt(IFormView iFormView) {
        List plugins = this.view.getFormShowParameter().getFormConfig().getPlugins();
        for (Plugin plugin : plugins) {
            Object pagePlugin;
            String className = plugin.getClassName();
            if (!plugin.isEnabled() || SchemeSavePlugin.class.getName().equals(className) || !((pagePlugin = PluginFactory.newStrategy(className)) instanceof ISchemeSavePlugin)) continue;
            ((ISchemeSavePlugin)pagePlugin).beforeSaveSchemeExt(this.view);
        }
    }

    @Override
    public DynamicObjectCollection getSaveSchemeListDataExt(IFormView iFormView) {
        List plugins = this.view.getFormShowParameter().getFormConfig().getPlugins();
        for (Plugin plugin : plugins) {
            Object pagePlugin;
            String className = plugin.getClassName();
            if (!plugin.isEnabled() || SchemeSavePlugin.class.getName().equals(className) || !((pagePlugin = PluginFactory.newStrategy(className)) instanceof ISchemeSavePlugin)) continue;
            return ((ISchemeSavePlugin)pagePlugin).getSaveSchemeListDataExt(iFormView);
        }
        return this.getSchemeDycsByUser();
    }

    private void checkHasSameNameScheme(DynamicObject schemeDyc) {
        String name = schemeDyc.getString("name");
        if (StringUtils.isEmpty((CharSequence)name)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4fdd\u5b58\u65b9\u6848\u5931\u8d25\uff0c\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"SchemeSaveHolder_0", (String)"mpscmm-msbd-mastermodel", (Object[])new Object[0]));
        }
        QFilter formIdFilter = new QFilter("formid", "=", (Object)this.formId);
        formIdFilter.and("name", "=", (Object)name);
        formIdFilter.and("id", "!=", schemeDyc.getPkValue());
        formIdFilter.and("creator", "=", (Object)UserServiceHelper.getCurrentUserId());
        QFilter qFilter = this.checkSchemeNameQfilter(this.view);
        formIdFilter.and(qFilter);
        boolean isHasSameNameScheme = QueryServiceHelper.exists((String)SCHEME_ENTITY, (QFilter[])formIdFilter.toArray());
        if (isHasSameNameScheme) {
            String msg = ResManager.loadKDString((String)"\u4fdd\u5b58\u65b9\u6848\u5931\u8d25\uff0c%s: \u201c\u540d\u79f0\u201d \u91cd\u590d\u3002", (String)"SchemeSaveHolder_2", (String)"mpscmm-msbd-mastermodel", (Object[])new Object[0]);
            msg = String.format(msg, schemeDyc.getString("name"));
            throw new KDBizException(msg);
        }
    }

    private void invokeSaveScheme(DynamicObject[] schemeDycs) {
        OperateOption option = OperateOption.create();
        option.setVariableValue("ishasright", "true");
        OperationResult result = OperationServiceHelper.executeOperate((String)"save", (String)SCHEME_ENTITY, (DynamicObject[])schemeDycs, (OperateOption)option);
        List errors = result.getAllErrorOrValidateInfo();
        if (!result.isSuccess()) {
            StringBuilder msg = new StringBuilder();
            msg.append(ResManager.loadKDString((String)"\u4fdd\u5b58\u65b9\u6848\u5931\u8d25\uff0c", (String)"SchemeSaveHolder_3", (String)"mpscmm-msbd-mastermodel", (Object[])new Object[0]));
            for (IOperateInfo error : errors) {
                OperateInfo operror = (OperateInfo)error;
                msg.append(operror.getMessage()).append('\n');
            }
            if (errors.isEmpty()) {
                msg.append(result.getMessage()).append('\n');
            }
            throw new KDBizException(msg.toString());
        }
    }

    private DynamicObject buildSchemeDyc(Object selSchemeId, boolean isNew) {
        DynamicObject[] schemeDycs;
        int currentRow = this.view.getModel().getEntryCurrentRowIndex("scheme_entry");
        Boolean isDefault = (Boolean)this.view.getModel().getValue("isdefaultscheme_entry", currentRow);
        DynamicObject formDataEntityDyc = this.view.getModel().getDataEntity(true);
        String name = formDataEntityDyc.getString("schemename");
        DynamicObject schemeDyc = isNew ? this.createSchemeDyc(name) : ((schemeDycs = BusinessDataServiceHelper.load((Object[])new Object[]{selSchemeId}, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)SCHEME_ENTITY))).length > 0 ? schemeDycs[0] : this.createSchemeDyc(name));
        String schemeStr = this.toJson(formDataEntityDyc);
        schemeDyc.set("name", (Object)name);
        schemeDyc.set("formid", (Object)this.formId);
        schemeDyc.set("org", (Object)RequestContext.get().getOrgId());
        schemeDyc.set("modifier", (Object)RequestContext.get().getCurrUserId());
        if (schemeDyc.getDataEntityState().getFromDatabase()) {
            schemeDyc.set("modifytime", (Object)new Date());
        }
        schemeDyc.set("schemestr_tag", (Object)schemeStr);
        if (!isNew) {
            schemeDyc.set("isdefault", (Object)isDefault);
        }
        return schemeDyc;
    }

    public void deleteScheme() {
        int[] selectRows = ((EntryGrid)this.view.getControl("scheme_entry")).getSelectRows();
        if (selectRows.length < 1) {
            return;
        }
        int currentRow = selectRows[0];
        Long schemeId = (Long)this.view.getModel().getValue("schemeid_entry", currentRow);
        this.view.getModel().deleteEntryRow("scheme_entry", currentRow);
        DeleteServiceHelper.delete((String)SCHEME_ENTITY, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)schemeId)});
        DynamicObjectCollection entryEntity = this.view.getModel().getEntryEntity("scheme_entry");
        if (entryEntity == null || entryEntity.isEmpty()) {
            this.resetScheme();
        } else {
            EntryGrid entryGrid = (EntryGrid)this.view.getControl("scheme_entry");
            entryGrid.selectRows(0);
        }
    }

    public void addScheme() {
        this.isAddScheme = true;
        EntryGrid entryGrid = (EntryGrid)this.view.getControl("scheme_entry");
        entryGrid.selectRows(-1);
        this.resetScheme();
        this.view.getPageCache().put("isAddSchemeCacheKey", "");
    }

    public void resetScheme() {
        this.isAddScheme = true;
        String filterSchemeStr = this.view.getPageCache().get("initschemestr");
        DynamicObject dbFormDataDyc = this.toDynamicObject(filterSchemeStr);
        this.setDbValueFomValue(dbFormDataDyc);
        this.view.setVisible(Boolean.FALSE, new String[]{"deletescheme"});
        this.view.setVisible(Boolean.FALSE, new String[]{"setdefault"});
        this.view.setVisible(Boolean.FALSE, new String[]{"canceldefault"});
        this.view.updateView("filtersplit");
    }

    public void defaultScheme() {
        int currentRow = this.view.getModel().getEntryCurrentRowIndex("scheme_entry");
        Object selSchemeId = this.view.getModel().getValue("schemeid_entry", currentRow);
        this.setOtherSchemeNotDefault(selSchemeId);
        this.view.getModel().setValue("isdefaultscheme_entry", (Object)Boolean.TRUE, currentRow);
        this.view.updateView("isdefaultscheme_entry", currentRow);
        this.setButtonView(Boolean.TRUE);
        this.view.getModel().setDataChanged(false);
    }

    public void cancelScheme() {
        int currentRow = this.view.getModel().getEntryCurrentRowIndex("scheme_entry");
        Object selSchemeId = this.view.getModel().getValue("schemeid_entry", currentRow);
        DynamicObject currentScheme = BusinessDataServiceHelper.loadSingle((Object)selSchemeId, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)SCHEME_ENTITY));
        currentScheme.set("isdefault", (Object)Boolean.FALSE);
        SaveServiceHelper.update((DynamicObject)currentScheme);
        this.view.getModel().setValue("isdefaultscheme_entry", (Object)Boolean.FALSE, currentRow);
        this.view.updateView("isdefaultscheme_entry", currentRow);
        this.setButtonView(Boolean.FALSE);
        this.view.getModel().setDataChanged(false);
    }

    private void updateViews(String ... fields) {
        for (String field : fields) {
            this.view.updateView(field);
        }
    }

    private DynamicObject createSchemeDyc(String name) {
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)SCHEME_ENTITY);
        DynamicObject schemeDyc = new DynamicObject((DynamicObjectType)dataEntityType);
        Date now = new Date();
        schemeDyc.set("number", (Object)name);
        schemeDyc.set("creator", (Object)RequestContext.get().getCurrUserId());
        schemeDyc.set("createtime", (Object)now);
        schemeDyc.set("modifytime", (Object)now);
        schemeDyc.set("status", (Object)"C");
        schemeDyc.set("enable", (Object)"1");
        schemeDyc.set("id", (Object)DB.genLongId((String)dataEntityType.getAlias()));
        return schemeDyc;
    }

    private void setOtherSchemeNotDefault(Object selSchemeId) {
        DynamicObject[] otherSchemeDycs;
        int entryRowCount = this.view.getModel().getEntryRowCount("scheme_entry");
        HashSet<Object> schemeIds = new HashSet<Object>(entryRowCount);
        schemeIds.add(selSchemeId);
        for (int i = 0; i < entryRowCount; ++i) {
            Object schemeId = this.view.getModel().getValue("schemeid_entry", i);
            if (!((Boolean)this.view.getModel().getValue("isdefaultscheme_entry", i)).booleanValue() || schemeId.equals(selSchemeId)) continue;
            schemeIds.add(schemeId);
            this.view.getModel().setValue("isdefaultscheme_entry", (Object)Boolean.FALSE, i);
            this.view.updateView("isdefaultscheme_entry", i);
        }
        for (DynamicObject ohterSchemeDyc : otherSchemeDycs = BusinessDataServiceHelper.load((Object[])schemeIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)SCHEME_ENTITY))) {
            if (ohterSchemeDyc.getPkValue().equals(selSchemeId)) {
                ohterSchemeDyc.set("isdefault", (Object)Boolean.TRUE);
                continue;
            }
            ohterSchemeDyc.set("isdefault", (Object)Boolean.FALSE);
        }
        SaveServiceHelper.update((DynamicObject[])otherSchemeDycs);
    }

    private DynamicObject getScheme(Long schemeId) {
        DynamicObject schemeDyc = null;
        QFilter idf = new QFilter("id", "=", (Object)schemeId);
        DynamicObjectCollection schemeDycs = QueryServiceHelper.query((String)this.getClass().getName(), (String)SCHEME_ENTITY, (String)"id,name,isdefault,schemestr_tag", (QFilter[])idf.toArray(), null);
        if (schemeDycs.size() > 0) {
            schemeDyc = (DynamicObject)schemeDycs.get(0);
        }
        return schemeDyc;
    }

    private DynamicObjectCollection getSchemeDycsByUser() {
        QFilter formIdf = new QFilter("formid", "=", (Object)this.formId);
        QFilter curUserf = new QFilter("creator", "=", (Object)RequestContext.get().getCurrUserId());
        ArrayList<QFilter> filters = new ArrayList<QFilter>(16);
        filters.add(formIdf);
        filters.add(curUserf);
        DynamicObjectCollection schemeDycs = QueryServiceHelper.query((String)this.getClass().getName(), (String)SCHEME_ENTITY, (String)"id,name,isdefault,schemestr", (QFilter[])filters.toArray(new QFilter[0]), (String)"isdefault desc,modifytime desc");
        return schemeDycs;
    }

    public void setScheme(int row) {
        Long schemeId = (Long)this.view.getModel().getValue("schemeid_entry", row);
        this.setScheme(schemeId);
        this.view.getModel().setDataChanged(false);
    }

    public void setScheme(Long schemeId) {
        if (schemeId == null || schemeId.equals(0L)) {
            return;
        }
        DynamicObject schemeDyc = this.getScheme(schemeId);
        if (schemeDyc == null) {
            return;
        }
        String filterSchemeStr = schemeDyc.getString("schemestr_tag");
        DynamicObject dbFormDataDyc = this.toDynamicObject(filterSchemeStr);
        this.setDbValueFomValue(dbFormDataDyc);
        this.selectSchemeDealExt(dbFormDataDyc, this.view);
        this.view.updateView("filtersplit");
        this.view.getModel().setValue("schemename", schemeDyc.get("name"));
        Boolean isDefault = (Boolean)schemeDyc.get("isdefault");
        this.setButtonView(isDefault);
        this.view.getPageCache().remove("isAddSchemeCacheKey");
    }

    private void setButtonView(Boolean isDefault) {
        this.view.setVisible(Boolean.TRUE, new String[]{"deletescheme"});
        this.view.setVisible(Boolean.valueOf(isDefault == false), new String[]{"setdefault"});
        this.view.setVisible(isDefault, new String[]{"canceldefault"});
        this.updateViews("setdefault", "canceldefault");
    }

    private void setDbValueFomValue(DynamicObject dbFormDataDyc) {
        MainEntityType newFormDataEntityType = this.view.getModel().getDataEntityType();
        FormRoot rootControl = (FormRoot)this.view.getRootControl();
        this.setDbValueFomValue((Container)rootControl, dbFormDataDyc, (DynamicObjectType)newFormDataEntityType, 0);
        this.view.getModel().beginInit();
        Map allEntities = newFormDataEntityType.getAllEntities();
        this.removeEntities.add(this.formId);
        this.removeEntities.add("scheme_entry");
        for (Map.Entry item : allEntities.entrySet()) {
            if (this.removeEntities.contains(item.getKey())) continue;
            DynamicObjectCollection dbEntryDycs = dbFormDataDyc.getDynamicObjectCollection((String)item.getKey());
            this.view.getModel().deleteEntryData((String)item.getKey());
            if (dbEntryDycs.isEmpty()) continue;
            this.view.getModel().batchCreateNewEntryRow((String)item.getKey(), dbEntryDycs.size());
            for (int i = 0; i < dbEntryDycs.size(); ++i) {
                this.setDbValueFomValue((Container)this.view.getControl((String)item.getKey()), (DynamicObject)dbEntryDycs.get(i), (DynamicObjectType)item.getValue(), i);
            }
        }
        this.view.getModel().endInit();
    }

    private void setDbValueFomValue(Container container, DynamicObject dbFormDataDyc, DynamicObjectType newFormDataEntityType, int index) {
        HashSet<String> keySet = new HashSet<String>(16);
        this.initFilterFieldKeySet(keySet, container);
        DataEntityPropertyCollection dbProps = dbFormDataDyc.getDynamicObjectType().getProperties();
        for (IDataEntityProperty formProps : newFormDataEntityType.getProperties()) {
            if (!keySet.contains(formProps.getName()) || !dbProps.containsKey((Object)formProps.getName())) continue;
            Object val = dbFormDataDyc.get(formProps.getName());
            if (this.isAddScheme && formProps instanceof FieldProp) {
                val = ((FieldProp)formProps).getDefValue();
            }
            this.view.getModel().setValue(formProps.getName(), val, index);
        }
    }

    private String toJson(DynamicObject filterObj) {
        DynamicObjectSerializationBinder binder = new DynamicObjectSerializationBinder(filterObj.getDynamicObjectType());
        DcJsonSerializer jser = new DcJsonSerializer((DcBinder)binder);
        jser.setIsLocaleValueFull(true);
        binder.setOnlyDbProperty(false);
        String filterStr = jser.serializeToString((Object)filterObj, null);
        HashMap<String, String> param = new HashMap<String, String>(16);
        param.put("custfilters", filterStr);
        return SerializationUtils.toJsonString(param);
    }

    private DynamicObject toDynamicObject(String schemeJson) {
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)this.formId);
        if (StringUtils.isEmpty((CharSequence)schemeJson)) {
            return new DynamicObject((DynamicObjectType)type);
        }
        Map filterMap = (Map)SerializationUtils.fromJsonString((String)schemeJson, HashMap.class);
        String custfilters = (String)filterMap.get("custfilters");
        DynamicObjectSerializationBinder binder = new DynamicObjectSerializationBinder((DynamicObjectType)type);
        DcJsonSerializer jser = new DcJsonSerializer((DcBinder)binder);
        DynamicObject fromDataDyc = (DynamicObject)jser.deserializeFromString(custfilters, null);
        BusinessDataReader.loadRefence((Object[])new DynamicObject[]{fromDataDyc}, (IDataEntityType)type);
        return fromDataDyc;
    }

    private void initFilterFieldKeySet(Set<String> keySet, Container container) {
        for (Control control : container.getItems()) {
            if (control instanceof DateRangeEdit) {
                DateRangeEdit rangeEdit = (DateRangeEdit)control;
                keySet.add(rangeEdit.getStartDateFieldKey());
                keySet.add(rangeEdit.getEndDateFieldKey());
                continue;
            }
            if (control instanceof FieldEdit) {
                keySet.add(control.getKey());
                continue;
            }
            if (!(control instanceof Container)) continue;
            this.initFilterFieldKeySet(keySet, (Container)control);
        }
    }
}

