/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.changemodel.business.helper;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.metadata.ICollectionProperty;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.clr.DataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DcBinder;
import kd.bos.dataentity.serialization.DcJsonSerializer;
import kd.bos.dataentity.serialization.ListDcxmlBinder;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.TreeEntryType;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.LargeTextProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.EntryEntity;
import kd.bos.metadata.entity.commonfield.DateRangeField;
import kd.bos.metadata.entity.validation.ConditionValidation;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.mpscmm.msbd.business.helper.BillTypeHelper;
import kd.mpscmm.msbd.changemodel.common.consts.ChangeTypeEnum;
import kd.mpscmm.msbd.changemodel.common.enums.BillChangeTypeEnum;
import kd.mpscmm.msbd.changemodel.common.enums.BizCancelStatusEnum;
import kd.mpscmm.msbd.changemodel.common.enums.BizChangeStatusEnum;
import kd.mpscmm.msbd.changemodel.common.enums.BizValidStatusEnum;
import kd.mpscmm.msbd.common.enums.EnableStatusEnum;
import kd.mpscmm.msbd.common.enums.StatusEnum;
import kd.mpscmm.msbd.common.utils.CommonUtils;

public class ChangeModelHelper {
    private static final Log LOGGER = LogFactory.getLog(ChangeModelHelper.class);

    public static DynamicObject getChangeModel4SrcBill(String srcBillEntiyId) {
        QFilter qf1 = new QFilter("srcbill", "=", (Object)srcBillEntiyId);
        QFilter qf2 = new QFilter("enable", "=", (Object)EnableStatusEnum.ENABLE.getValue());
        QFilter qf3 = new QFilter("changetype", "=", (Object)BillChangeTypeEnum.CHANGE.getValue());
        Map map = BusinessDataServiceHelper.loadFromCache((String)"plat_changemodel", (QFilter[])new QFilter[]{qf1, qf2, qf3});
        if (!CommonUtils.isNull((Object)map)) {
            ArrayList list = new ArrayList(map.values());
            DynamicObject changeModel = (DynamicObject)list.get(0);
            return changeModel;
        }
        return null;
    }

    public static DynamicObject getChangeModel4XBill(String xBillEntiyId) {
        QFilter qf1 = new QFilter("xbill", "=", (Object)xBillEntiyId);
        QFilter qf2 = new QFilter("enable", "=", (Object)EnableStatusEnum.ENABLE.getValue());
        QFilter qf3 = new QFilter("changetype", "=", (Object)BillChangeTypeEnum.CHANGE.getValue());
        Map map = BusinessDataServiceHelper.loadFromCache((String)"plat_changemodel", (QFilter[])new QFilter[]{qf1, qf2, qf3});
        if (!CommonUtils.isNull((Object)map)) {
            ArrayList list = new ArrayList(map.values());
            DynamicObject changeModel = (DynamicObject)list.get(0);
            return changeModel;
        }
        return null;
    }

    public static DynamicObject getChangeModel4BatchXBill(String batchXBillEntiyId) {
        QFilter qf1 = new QFilter("batchxbill", "=", (Object)batchXBillEntiyId);
        QFilter qf2 = new QFilter("enable", "=", (Object)EnableStatusEnum.ENABLE.getValue());
        QFilter qf3 = new QFilter("changetype", "=", (Object)BillChangeTypeEnum.BATCHANGE.getValue());
        Map map = BusinessDataServiceHelper.loadFromCache((String)"plat_changemodel", (QFilter[])new QFilter[]{qf1, qf2, qf3});
        if (!CommonUtils.isNull((Object)map)) {
            ArrayList list = new ArrayList(map.values());
            DynamicObject changeModel = (DynamicObject)list.get(0);
            return changeModel;
        }
        return null;
    }

    public static DynamicObject getChangeModel4BatchSrcBill(String srcBillEntiyId) {
        QFilter qf1 = new QFilter("srcbill", "=", (Object)srcBillEntiyId);
        QFilter qf2 = new QFilter("enable", "=", (Object)EnableStatusEnum.ENABLE.getValue());
        QFilter qf3 = new QFilter("changetype", "=", (Object)BillChangeTypeEnum.BATCHANGE.getValue());
        Map map = BusinessDataServiceHelper.loadFromCache((String)"plat_changemodel", (QFilter[])new QFilter[]{qf1, qf2, qf3});
        if (!CommonUtils.isNull((Object)map)) {
            ArrayList list = new ArrayList(map.values());
            DynamicObject changeModel = (DynamicObject)list.get(0);
            return changeModel;
        }
        return null;
    }

    public static DynamicObject getChangeModel4Revise(String entityId) {
        QFilter qf1 = new QFilter("srcbill", "=", (Object)entityId);
        QFilter qf2 = new QFilter("enable", "=", (Object)EnableStatusEnum.ENABLE.getValue());
        QFilter qf3 = new QFilter("changetype", "=", (Object)BillChangeTypeEnum.REVISE.getValue());
        Map map = BusinessDataServiceHelper.loadFromCache((String)"plat_changemodel", (QFilter[])new QFilter[]{qf1, qf2, qf3});
        if (!CommonUtils.isNull((Object)map)) {
            ArrayList list = new ArrayList(map.values());
            DynamicObject changeModel = (DynamicObject)list.get(0);
            return changeModel;
        }
        return null;
    }

    public static DynamicObject getChangeModel(String entityId) {
        QFilter qf1 = new QFilter("srcbill", "=", (Object)entityId);
        QFilter qf2 = new QFilter("enable", "=", (Object)EnableStatusEnum.ENABLE.getValue());
        Map map = BusinessDataServiceHelper.loadFromCache((String)"plat_changemodel", (QFilter[])new QFilter[]{qf1, qf2});
        if (!CommonUtils.isNull((Object)map)) {
            ArrayList list = new ArrayList(map.values());
            DynamicObject changeModel = (DynamicObject)list.get(0);
            return changeModel;
        }
        return null;
    }

    public static String getXlogEntityId(DynamicObject changeModel) {
        String xLogEntity = "plat_xbilllog";
        if (changeModel != null && changeModel.getDynamicObject("xbilllog") != null) {
            xLogEntity = (String)changeModel.getDynamicObject("xbilllog").getPkValue();
        }
        return xLogEntity;
    }

    public static String getXlogEntityId(String entityId) {
        DynamicObject changeModel = ChangeModelHelper.getChangeModel(entityId);
        String xLogEntity = "plat_xbilllog";
        if (changeModel != null && changeModel.getDynamicObject("xbilllog") != null) {
            xLogEntity = (String)changeModel.getDynamicObject("xbilllog").getPkValue();
        }
        return xLogEntity;
    }

    public static String getXlogEntityId4XBill(String entityId) {
        DynamicObject changeModel = ChangeModelHelper.getChangeModel4XBill(entityId);
        String xLogEntity = "plat_xbilllog";
        if (changeModel != null && changeModel.getDynamicObject("xbilllog") != null) {
            xLogEntity = (String)changeModel.getDynamicObject("xbilllog").getPkValue();
        }
        return xLogEntity;
    }

    public static DynamicObject generateXBilll(String srcBillEntiy, long srcBillId) {
        long beginquerycmtime = System.currentTimeMillis();
        LOGGER.info("BizChangePerformance----generateXBilll:1.QueryChangeModel Begin: " + new Date(beginquerycmtime));
        DynamicObject changeModel = ChangeModelHelper.getChangeModel4SrcBill(srcBillEntiy);
        if (changeModel == null) {
            return null;
        }
        Map<String, Map<String, String>> entryAndOp = ChangeModelHelper.getXBillEntryAndOp(changeModel);
        long endquerycmtime = System.currentTimeMillis();
        LOGGER.info("BizChangePerformance----generateXBilll:1.QueryChangeModelAndSrcEntryInfo Finish: " + new Date(endquerycmtime));
        LOGGER.info("BizChangePerformance----generateXBilll:1.QueryChangeModel UseTime: " + (endquerycmtime - beginquerycmtime) + " ms");
        LOGGER.info("BizChangePerformance----generateXBilll:2.QuerySrcBillLoadSingle Begin: " + new Date(endquerycmtime));
        DynamicObject srcBill = BusinessDataServiceHelper.loadSingle((Object)srcBillId, (String)srcBillEntiy);
        if (CommonUtils.isNull((Object)srcBill)) {
            return null;
        }
        ChangeModelHelper.excutePluginMethod(changeModel, "beforeSrcBillChange", srcBill);
        long endqsrctime = System.currentTimeMillis();
        LOGGER.info("BizChangePerformance----generateXBilll:2.QuerySrcBillLoadSingle Finish: " + new Date(endqsrctime));
        LOGGER.info("BizChangePerformance----generateXBilll:2.QuerySrcBillLoadSingle UseTime: " + (endqsrctime - endquerycmtime) + " ms");
        String xbilldtstr = "";
        if (changeModel.getDynamicObject("xbill") == null || changeModel.getDynamicObject("xbill").getPkValue() == null) {
            return null;
        }
        xbilldtstr = (String)changeModel.getDynamicObject("xbill").getPkValue();
        MainEntityType xBillDt = MetadataServiceHelper.getDataEntityType((String)xbilldtstr);
        List<EntityType> xBillentryEntitys = ChangeModelHelper.getChildEntities((IDataEntityType)xBillDt);
        IDataEntityType srcBillET = srcBill.getDataEntityType();
        List<EntityType> srcBillentryEntitys = ChangeModelHelper.getChildEntities(srcBillET);
        DynamicObject xBill = new DynamicObject((DynamicObjectType)xBillDt);
        DynamicObjectCollection mapplingEntitys = changeModel.getDynamicObjectCollection("mappingentity");
        long begingenXbillTime = System.currentTimeMillis();
        LOGGER.info("BizChangePerformance----generateXBill:3.xbillSetValueByMapEntry Begin: " + new Date(begingenXbillTime));
        HashSet<String> notRegistedEntryInfoSet = new HashSet<String>();
        LocaleString headTitle = ResManager.getLocaleString((String)"\u5355\u636e\u5934", (String)"ChangeModelHelper_0", (String)"mpscmm-msbd-changemodel");
        DataEntityPropertyCollection headProps = xBill.getDynamicObjectType().getProperties();
        for (DynamicObject mapplingEntity : mapplingEntitys) {
            try {
                DynamicObject xBillEntry;
                DynamicObjectCollection srcBillEntrys;
                DynamicObjectCollection xBillEntrys;
                DataEntityPropertyCollection entryProps;
                IDataEntityProperty targetProp;
                String targetFieldName = mapplingEntity.getString("targetfieldname");
                String sourceFieldName = mapplingEntity.getString("sourcefieldname");
                if (CommonUtils.isNull((Object)sourceFieldName)) continue;
                String[] targetItems = targetFieldName.split("\\.");
                String[] sourceItems = sourceFieldName.split("\\.");
                if (headTitle != null && headTitle.containsValue((Object)targetItems[0])) {
                    xBill.set(mapplingEntity.getString("targetfield"), srcBill.get(mapplingEntity.getString("sourcefield")));
                    IDataEntityProperty prop = (IDataEntityProperty)headProps.get((Object)mapplingEntity.getString("targetfield"));
                    if (prop instanceof LargeTextProp) {
                        xBill.set(mapplingEntity.getString("targetfield") + "_tag", srcBill.get(mapplingEntity.getString("sourcefield") + "_tag"));
                    }
                    if (!(prop instanceof MulBasedataProp)) continue;
                    DynamicObjectCollection rows = (DynamicObjectCollection)srcBill.get(mapplingEntity.getString("sourcefield"));
                    DynamicObjectCollection xRows = ChangeModelHelper.copyNewMulBaseData(rows);
                    xBill.set(mapplingEntity.getString("targetfield"), (Object)xRows);
                    continue;
                }
                if ((targetItems.length != 3 || sourceItems.length != 3) && (targetItems.length != 2 || sourceItems.length != 2) || headTitle != null && headTitle.containsValue((Object)targetItems[0])) continue;
                EntityType xBillEntryType = ChangeModelHelper.getChildEntitiesByAlias(xBillentryEntitys, targetItems[0]);
                EntityType srcBillEntryType = ChangeModelHelper.getChildEntitiesByAlias(srcBillentryEntitys, sourceItems[0]);
                if (xBillEntryType == null || srcBillEntryType == null || targetItems.length == 3 && sourceItems.length == 3 && (xBillEntryType.getClass() != EntryType.class && xBillEntryType.getClass() != SubEntryType.class || !((targetProp = (IDataEntityProperty)(entryProps = xBillEntryType.getProperties()).get((Object)mapplingEntity.getString("targetfield"))) instanceof DateProp) && !(targetProp instanceof DateTimeProp))) continue;
                String entryTypeName = xBillEntryType.getName();
                if (entryAndOp.get(entryTypeName) == null) {
                    notRegistedEntryInfoSet.add(entryTypeName);
                    continue;
                }
                String entrychangetype = entryAndOp.get(xBillEntryType.getName()).get("changetype");
                String entrysrcid = entryAndOp.get(xBillEntryType.getName()).get("srcid");
                if (xBillEntryType.getClass() == EntryType.class) {
                    xBillEntrys = xBill.getDynamicObjectCollection(xBillEntryType.getName());
                    srcBillEntrys = srcBill.getDynamicObjectCollection(srcBillEntryType.getName());
                    if (entryAndOp.get(xBillEntryType.getName()) == null) continue;
                    if (srcBillEntrys.size() > 0 && xBillEntrys.size() == 0) {
                        for (int i = 0; i < srcBillEntrys.size(); ++i) {
                            DynamicObject xBillEntry2 = xBillEntrys.addNew();
                            try {
                                xBillEntry2.set("seq", ((DynamicObject)srcBillEntrys.get(i)).get("seq"));
                                xBillEntry2.set(entrysrcid, ((DynamicObject)srcBillEntrys.get(i)).getPkValue());
                                xBillEntry2.set(entrychangetype, (Object)ChangeTypeEnum.UPDATE.getValue());
                                continue;
                            }
                            catch (KDException e) {
                                LOGGER.warn((Throwable)e);
                            }
                        }
                    }
                    DataEntityPropertyCollection entryProps2 = xBillEntryType.getProperties();
                    for (int i = 0; i < srcBillEntrys.size(); ++i) {
                        DynamicObject srcBillEntry = (DynamicObject)srcBillEntrys.get(i);
                        DynamicObject xBillEntry3 = (DynamicObject)xBillEntrys.get(i);
                        try {
                            if (mapplingEntity.getString("targetfield").equals(entrychangetype) || mapplingEntity.getString("targetfield").equals(entrysrcid)) continue;
                            xBillEntry3.set(mapplingEntity.getString("targetfield"), srcBillEntry.get(mapplingEntity.getString("sourcefield")));
                            IDataEntityProperty prop = (IDataEntityProperty)entryProps2.get((Object)mapplingEntity.getString("targetfield"));
                            if (prop instanceof LargeTextProp) {
                                xBillEntry3.set(mapplingEntity.getString("targetfield") + "_tag", srcBillEntry.get(mapplingEntity.getString("sourcefield") + "_tag"));
                            }
                            if (!(prop instanceof MulBasedataProp)) continue;
                            DynamicObjectCollection rows = (DynamicObjectCollection)srcBillEntry.get(mapplingEntity.getString("sourcefield"));
                            DynamicObjectCollection xRows = ChangeModelHelper.copyNewMulBaseData(rows);
                            xBillEntry3.set(mapplingEntity.getString("targetfield"), (Object)xRows);
                            continue;
                        }
                        catch (Exception e) {
                            LOGGER.warn((Throwable)e);
                        }
                    }
                    continue;
                }
                if (xBillEntryType.getClass() == TreeEntryType.class) {
                    xBillEntrys = xBill.getDynamicObjectCollection(xBillEntryType.getName());
                    srcBillEntrys = srcBill.getDynamicObjectCollection(srcBillEntryType.getName());
                    if (entryAndOp.get(xBillEntryType.getName()) == null) continue;
                    if (srcBillEntrys.size() > 0 && xBillEntrys.size() == 0) {
                        HashMap<Object, Object> srcIdAndPid = new HashMap<Object, Object>();
                        HashMap<Object, Long> srcIdAndXbillId = new HashMap<Object, Long>();
                        long[] entryIds = Arrays.stream(DB.genGlobalLongIds((int)srcBillEntrys.size())).sorted().toArray();
                        for (int i = 0; i < srcBillEntrys.size(); ++i) {
                            DynamicObject xBillEntry4 = xBillEntrys.addNew();
                            try {
                                srcIdAndPid.put(((DynamicObject)srcBillEntrys.get(i)).getPkValue(), ((DynamicObject)srcBillEntrys.get(i)).get("pid"));
                                long entryId = entryIds[((DynamicObject)srcBillEntrys.get(i)).getInt("seq") - 1];
                                xBillEntry4.set("id", (Object)entryId);
                                xBillEntry4.set(entrysrcid, ((DynamicObject)srcBillEntrys.get(i)).getPkValue());
                                xBillEntry4.set(entrychangetype, (Object)ChangeTypeEnum.UPDATE.getValue());
                                srcIdAndXbillId.put(((DynamicObject)srcBillEntrys.get(i)).getPkValue(), entryId);
                                continue;
                            }
                            catch (KDException e) {
                                LOGGER.warn((Throwable)e);
                            }
                        }
                        for (DynamicObject xBillEntry4 : xBillEntrys) {
                            try {
                                xBillEntry4.set("pid", srcIdAndXbillId.get(srcIdAndPid.getOrDefault(xBillEntry4.get(entrysrcid), 0)));
                                xBillEntry4.set("seq", srcBillEntrys.stream().filter(v -> v.getString("id").equals(xBillEntry4.getString(entrysrcid))).findFirst().map(v -> v.get("seq")).orElse(null));
                            }
                            catch (KDException e) {
                                LOGGER.warn((Throwable)e);
                            }
                        }
                    }
                    for (int i = 0; i < srcBillEntrys.size(); ++i) {
                        DynamicObject srcBillEntry = (DynamicObject)srcBillEntrys.get(i);
                        xBillEntry = (DynamicObject)xBillEntrys.get(i);
                        try {
                            if (mapplingEntity.getString("targetfield").equals(entrychangetype) || mapplingEntity.getString("targetfield").equals(entrysrcid)) continue;
                            xBillEntry.set(mapplingEntity.getString("targetfield"), srcBillEntry.get(mapplingEntity.getString("sourcefield")));
                            continue;
                        }
                        catch (Exception e) {
                            LOGGER.warn((Throwable)e);
                        }
                    }
                    continue;
                }
                if (xBillEntryType.getClass() != SubEntryType.class) continue;
                xBillEntrys = xBill.getDynamicObjectCollection(((EntryType)srcBillEntryType.getParent()).getName());
                srcBillEntrys = srcBill.getDynamicObjectCollection(((EntryType)srcBillEntryType.getParent()).getName());
                for (int i = 0; i < srcBillEntrys.size(); ++i) {
                    DynamicObject srcBillEntry = (DynamicObject)srcBillEntrys.get(i);
                    xBillEntry = (DynamicObject)xBillEntrys.get(i);
                    DynamicObjectCollection subSrcBillEntrys = srcBillEntry.getDynamicObjectCollection(srcBillEntryType.getName());
                    DynamicObjectCollection subXBillEntrys = xBillEntry.getDynamicObjectCollection(xBillEntryType.getName());
                    if (subSrcBillEntrys.size() > 0 && subXBillEntrys.size() == 0) {
                        for (int j = 0; j < subSrcBillEntrys.size(); ++j) {
                            DynamicObject subXBillEntry = subXBillEntrys.addNew();
                            try {
                                subXBillEntry.set("seq", ((DynamicObject)subSrcBillEntrys.get(j)).get("seq"));
                                subXBillEntry.set(entrysrcid, ((DynamicObject)subSrcBillEntrys.get(j)).getPkValue());
                                subXBillEntry.set(entrychangetype, (Object)ChangeTypeEnum.UPDATE.getValue());
                                continue;
                            }
                            catch (Exception e) {
                                LOGGER.warn((Throwable)e);
                            }
                        }
                    }
                    DataEntityPropertyCollection subEntryProps = subSrcBillEntrys.getDynamicObjectType().getProperties();
                    for (int j = 0; j < subSrcBillEntrys.size(); ++j) {
                        DynamicObject subSrcBillEntry = (DynamicObject)subSrcBillEntrys.get(j);
                        DynamicObject subXBillEntry = (DynamicObject)subXBillEntrys.get(j);
                        try {
                            if (mapplingEntity.getString("targetfield").equals(entrychangetype) || mapplingEntity.getString("targetfield").equals(entrysrcid)) continue;
                            subXBillEntry.set(mapplingEntity.getString("targetfield"), subSrcBillEntry.get(mapplingEntity.getString("sourcefield")));
                            IDataEntityProperty prop = (IDataEntityProperty)subEntryProps.get((Object)mapplingEntity.getString("targetfield"));
                            if (prop instanceof LargeTextProp) {
                                subXBillEntry.set(mapplingEntity.getString("targetfield") + "_tag", subSrcBillEntry.get(mapplingEntity.getString("sourcefield") + "_tag"));
                            }
                            if (!(prop instanceof MulBasedataProp)) continue;
                            DynamicObjectCollection rows = (DynamicObjectCollection)subSrcBillEntry.get(mapplingEntity.getString("sourcefield"));
                            DynamicObjectCollection xRows = ChangeModelHelper.copyNewMulBaseData(rows);
                            subXBillEntry.set(mapplingEntity.getString("targetfield"), (Object)xRows);
                            continue;
                        }
                        catch (Exception e) {
                            LOGGER.warn((Throwable)e);
                        }
                    }
                }
            }
            catch (Exception ee) {
                LOGGER.warn((Throwable)ee);
            }
        }
        long endgenXbillTime = System.currentTimeMillis();
        LOGGER.info("BizChangePerformance----generateXBill:3.xbillSetValueByMapEntry, These Entrys are not registed: " + notRegistedEntryInfoSet);
        LOGGER.info("BizChangePerformance----generateXBill:3.xbillSetValueByMapEntry, Please check plugin!");
        LOGGER.info("BizChangePerformance----generateXBill:3.xbillSetValueByMapEntry Finish: " + new Date(endgenXbillTime));
        LOGGER.info("BizChangePerformance----generateXBill:3.xbillSetValueByMapEntry UseTime: " + (endgenXbillTime - begingenXbillTime) + " ms");
        long beginGenXbillOtherTime = System.currentTimeMillis();
        LOGGER.info("BizChangePerformance----generateXBill:4.xbillSetValueXPro Begin\uff1a " + new Date(beginGenXbillOtherTime));
        if (srcBill.containsProperty("billtype")) {
            DynamicObject srcBillTypeDO = srcBill.getDynamicObject("billtype");
            Long xBillTypeID = ChangeModelHelper.getXBillTypeIDFromChangeModel(changeModel, srcBillTypeDO != null ? (Long)srcBillTypeDO.getPkValue() : 0L);
            if (xBillTypeID <= 0L) {
                xBill.set("billtype", (Object)BillTypeHelper.getBillTypeByEntity((String)xBill.getDataEntityType().getName()));
            } else {
                xBill.set("billtype", (Object)xBillTypeID);
            }
        }
        if (changeModel.getBoolean("isnotupdateversion")) {
            xBill.set("changebillno", (Object)(srcBill.get("billno") + "_" + srcBill.get("version") + "_" + srcBill.get("subversion")));
        } else {
            xBill.set("changebillno", (Object)(srcBill.get("billno") + "_" + srcBill.get("version")));
        }
        xBill.set("billstatus", (Object)StatusEnum.SAVE.getValue());
        xBill.set("changebizdate", (Object)new Date(System.currentTimeMillis()));
        xBill.set("sourcebillid", srcBill.getPkValue());
        xBill.set("sourcebillentity", (Object)srcBill.getDataEntityType().getName());
        xBill.set("validstatus", (Object)BizValidStatusEnum.UNVALID.getValue());
        xBill.set("valider", null);
        xBill.set("validdate", null);
        if (xBill.getDynamicObjectType().getProperty("changecancelstatus") != null) {
            xBill.set("changecancelstatus", (Object)BizCancelStatusEnum.UNCANCEL.getValue());
        }
        xBill.set("changestatus", (Object)BizChangeStatusEnum.UNCHANGE.getValue());
        xBill.set("validstatus", (Object)BizValidStatusEnum.UNVALID.getValue());
        DynamicObject currentUserDO = BusinessDataServiceHelper.loadSingleFromCache((Object)UserServiceHelper.getCurrentUserId(), (String)"bos_user");
        xBill.set("creator", (Object)currentUserDO);
        xBill.set("createtime", (Object)new Date(System.currentTimeMillis()));
        xBill.set("modifier", (Object)currentUserDO);
        xBill.set("modifytime", (Object)new Date(System.currentTimeMillis()));
        xBill.set("lastupdateuser", (Object)currentUserDO);
        xBill.set("lastupdatetime", (Object)new Date(System.currentTimeMillis()));
        ChangeModelHelper.excutePluginMethod(changeModel, "afterSrcBillChange", srcBill);
        ChangeModelHelper.excutePluginMethod(changeModel, "afterSrcBillChange4X", xBill);
        long endGenXbillOtherTime = System.currentTimeMillis();
        LOGGER.info("BizChangePerformance----generateXBill:4.xbillSetValueByXPro Finish: " + new Date(endGenXbillOtherTime));
        LOGGER.info("BizChangePerformance----generateXBill:4.xbillSetValueByXPro UseTime: " + (endGenXbillOtherTime - beginGenXbillOtherTime) + " ms");
        return xBill;
    }

    public static DynamicObjectCollection copyNewMulBaseData(DynamicObjectCollection oldRows) {
        DynamicObjectCollection xRows = new DynamicObjectCollection();
        if (oldRows == null || oldRows.isEmpty() || !(oldRows instanceof MulBasedataDynamicObjectCollection)) {
            return xRows;
        }
        DynamicObjectType type = oldRows.getDynamicObjectType();
        for (DynamicObject row : oldRows) {
            DynamicObject value = row.getDynamicObject("fbasedataid");
            DynamicObject xRow = new DynamicObject(type);
            xRow.set("fbasedataid", (Object)value);
            xRows.add((Object)xRow);
        }
        return xRows;
    }

    public static DynamicObject[] generateXBilll(DynamicObject[] srcBills) {
        ArrayList<DynamicObject> xBills = new ArrayList<DynamicObject>();
        for (DynamicObject srcBill : srcBills) {
            DynamicObject xBill = ChangeModelHelper.generateXBilll(srcBill.getDataEntityType().getName(), (Long)srcBill.getPkValue());
            if (CommonUtils.isNull((Object)xBill)) continue;
            xBills.add(xBill);
        }
        if (xBills.size() == 0) {
            return null;
        }
        return xBills.toArray(new DynamicObject[xBills.size()]);
    }

    public static String[] getProperty4Entry(IDataEntityType dt, String entryName) {
        DynamicPropertyCollection dynPropColl = (DynamicPropertyCollection)dt.getProperties();
        Iterator it = dynPropColl.iterator();
        ArrayList<String> arPropName = new ArrayList<String>();
        while (it.hasNext()) {
            DataEntityPropertyCollection entry;
            IDataEntityProperty dataEntityProp = (IDataEntityProperty)it.next();
            if (dataEntityProp instanceof EntryProp && dataEntityProp.getName().equals(entryName)) {
                entry = ((EntryProp)dataEntityProp).getDynamicCollectionItemPropertyType().getProperties();
                for (IDataEntityProperty dataEntityPropEntry : entry) {
                    if (dataEntityPropEntry instanceof EntryProp) continue;
                    arPropName.add(dataEntityPropEntry.getName());
                }
                continue;
            }
            if (!(dataEntityProp instanceof EntryProp)) continue;
            entry = ((EntryProp)dataEntityProp).getDynamicCollectionItemPropertyType().getProperties();
            for (IDataEntityProperty dataEntityPropEntry : entry) {
                if (!(dataEntityPropEntry instanceof EntryProp) || !dataEntityPropEntry.getName().equals(entryName)) continue;
                DataEntityPropertyCollection subEntry = ((EntryProp)dataEntityPropEntry).getDynamicCollectionItemPropertyType().getProperties();
                for (IDataEntityProperty dataEntityPropSubEntry : subEntry) {
                    if (dataEntityPropSubEntry instanceof EntryProp) continue;
                    arPropName.add(dataEntityPropSubEntry.getName());
                }
            }
        }
        return arPropName.toArray(new String[0]);
    }

    public static String[] getCanLogProperty(IDataEntityType xbillDt) {
        DynamicObjectCollection mappingEntitys = ChangeModelHelper.getMappingColFromXBillDT(xbillDt);
        if (mappingEntitys == null || mappingEntitys.size() < 1) {
            return null;
        }
        ArrayList<String> arPropName = new ArrayList<String>();
        LocaleString headTitle = ResManager.getLocaleString((String)"\u5355\u636e\u5934", (String)"ChangeModelHelper_0", (String)"mpscmm-msbd-changemodel");
        for (DynamicObject mappingEntity : mappingEntitys) {
            String targetField = mappingEntity.getString("targetfield");
            String targetFieldname = mappingEntity.getString("targetfieldname");
            Boolean canLog = mappingEntity.getBoolean("canlog");
            String[] targetItems = targetFieldname.split("\\.");
            if (headTitle == null || !headTitle.containsValue((Object)targetItems[0]) || !canLog.booleanValue()) continue;
            arPropName.add(targetField);
        }
        return arPropName.toArray(new String[0]);
    }

    public static String[] getAllCanLogProperty(DynamicObject changeModel) {
        if (changeModel == null) {
            return null;
        }
        DynamicObjectCollection mappingEntitys = changeModel.getDynamicObjectCollection("mappingentity");
        if (mappingEntitys == null || mappingEntitys.size() < 1) {
            return null;
        }
        ArrayList<String> arPropName = new ArrayList<String>();
        for (DynamicObject mappingEntity : mappingEntitys) {
            String targetField = mappingEntity.getString("targetfield");
            Boolean canLog = mappingEntity.getBoolean("canlog");
            if (!canLog.booleanValue()) continue;
            arPropName.add(targetField);
        }
        return arPropName.toArray(new String[0]);
    }

    public static String[] getCanWritebackProperty(IDataEntityType xbillDt) {
        DynamicObjectCollection mappingEntitys = ChangeModelHelper.getMappingColFromXBillDT(xbillDt);
        if (mappingEntitys == null || mappingEntitys.size() < 1) {
            return null;
        }
        ArrayList<String> arPropName = new ArrayList<String>();
        LocaleString headTitle = ResManager.getLocaleString((String)"\u5355\u636e\u5934", (String)"ChangeModelHelper_0", (String)"mpscmm-msbd-changemodel");
        for (DynamicObject mappingEntity : mappingEntitys) {
            String targetField = mappingEntity.getString("targetfield");
            String targetFieldname = mappingEntity.getString("targetfieldname");
            Boolean canLog = mappingEntity.getBoolean("canwriteback");
            String[] targetItems = targetFieldname.split("\\.");
            if (headTitle == null || !headTitle.containsValue((Object)targetItems[0]) || !canLog.booleanValue()) continue;
            arPropName.add(targetField);
        }
        return arPropName.toArray(new String[0]);
    }

    public static String[] getEnableProperty(IDataEntityType xbillDt) {
        Map<String, List<String>> dateRangeItems = ChangeModelHelper.getAllDateRangeItemsMap(xbillDt.getName(), null);
        return ChangeModelHelper.getEnableProperty(xbillDt, dateRangeItems);
    }

    public static String[] getEnableProperty(IDataEntityType xbillDt, Map<String, List<String>> dateRangeItems) {
        DynamicObjectCollection mappingEntitys = ChangeModelHelper.getMappingColFromXBillDT(xbillDt);
        if (mappingEntitys == null || mappingEntitys.size() < 1) {
            return null;
        }
        ArrayList<String> arPropName = new ArrayList<String>();
        LocaleString headTitle = ResManager.getLocaleString((String)"\u5355\u636e\u5934", (String)"ChangeModelHelper_0", (String)"mpscmm-msbd-changemodel");
        for (DynamicObject mappingEntity : mappingEntitys) {
            String targetField = mappingEntity.getString("targetfield");
            String targetFieldname = mappingEntity.getString("targetfieldname");
            Boolean canEnable = mappingEntity.getBoolean("canenable");
            String[] targetItems = targetFieldname.split("\\.");
            if (headTitle == null || !headTitle.containsValue((Object)targetItems[0]) || !canEnable.booleanValue()) continue;
            arPropName.add(targetField);
        }
        if (dateRangeItems != null) {
            for (Map.Entry<String, List<String>> item : dateRangeItems.entrySet()) {
                String dateRange = item.getKey();
                if (item.getValue() == null || item.getValue().size() != 2) continue;
                String dateRangeStart = item.getValue().get(0);
                String dateRangeEnd = item.getValue().get(1);
                if (!arPropName.contains(dateRangeStart) && !arPropName.contains(dateRangeEnd)) continue;
                arPropName.add(dateRange);
            }
        }
        return arPropName.toArray(new String[0]);
    }

    public static String[] getUnEnableProperty(IDataEntityType xbillDt) {
        Map<String, List<String>> dateRangeItems = ChangeModelHelper.getAllDateRangeItemsMap(xbillDt.getName(), null);
        return ChangeModelHelper.getUnEnableProperty(xbillDt, dateRangeItems);
    }

    public static String[] getUnEnableProperty(IDataEntityType xbillDt, Map<String, List<String>> dateRangeItems) {
        DynamicObjectCollection mappingEntitys = ChangeModelHelper.getMappingColFromXBillDT(xbillDt);
        if (mappingEntitys == null || mappingEntitys.size() < 1) {
            return null;
        }
        ArrayList<String> arPropName = new ArrayList<String>();
        LocaleString headTitle = ResManager.getLocaleString((String)"\u5355\u636e\u5934", (String)"ChangeModelHelper_0", (String)"mpscmm-msbd-changemodel");
        for (DynamicObject mappingEntity : mappingEntitys) {
            String targetField = mappingEntity.getString("targetfield");
            String targetFieldname = mappingEntity.getString("targetfieldname");
            Boolean canEnable = mappingEntity.getBoolean("canenable");
            String[] targetItems = targetFieldname.split("\\.");
            if (headTitle == null || !headTitle.containsValue((Object)targetItems[0]) || canEnable.booleanValue()) continue;
            arPropName.add(targetField);
        }
        if (dateRangeItems != null) {
            for (Map.Entry<String, List<String>> item : dateRangeItems.entrySet()) {
                String dateRange = item.getKey();
                if (item.getValue() == null || item.getValue().size() != 2) continue;
                String dateRangeStart = item.getValue().get(0);
                String dateRangeEnd = item.getValue().get(1);
                if (!arPropName.contains(dateRangeStart) && !arPropName.contains(dateRangeEnd)) continue;
                arPropName.add(dateRange);
            }
        }
        return arPropName.toArray(new String[0]);
    }

    public static String[] getCanLogProperty(IDataEntityType xBillDt, String entryEntity) {
        DynamicObjectCollection mappingEntitys = ChangeModelHelper.getMappingColFromXBillDT(xBillDt);
        if (mappingEntitys == null || mappingEntitys.size() < 1) {
            return null;
        }
        ArrayList<String> arPropName = new ArrayList<String>();
        LocaleString headTitle = ResManager.getLocaleString((String)"\u5355\u636e\u5934", (String)"ChangeModelHelper_0", (String)"mpscmm-msbd-changemodel");
        for (DynamicObject mappingEntity : mappingEntitys) {
            DataEntityPropertyCollection entryProps;
            IDataEntityProperty targetProp;
            String targetField = mappingEntity.getString("targetfield");
            String targetFieldname = mappingEntity.getString("targetfieldname");
            Boolean canLog = mappingEntity.getBoolean("canlog");
            String[] targetItems = targetFieldname.split("\\.");
            List<EntityType> xBillentryEntitys = ChangeModelHelper.getChildEntities(xBillDt);
            EntityType xBillEntryType = ChangeModelHelper.getChildEntitiesByAlias(xBillentryEntitys, targetItems[0]);
            if (xBillEntryType == null || targetItems.length != 2 && targetItems.length != 3 || headTitle != null && headTitle.containsValue((Object)targetItems[0]) || !entryEntity.equalsIgnoreCase(xBillEntryType.getName()) || targetItems.length == 3 && (xBillEntryType.getClass() != EntryType.class && xBillEntryType.getClass() != SubEntryType.class || !((targetProp = (IDataEntityProperty)(entryProps = xBillEntryType.getProperties()).get((Object)mappingEntity.getString("targetfield"))) instanceof DateProp) && !(targetProp instanceof DateTimeProp)) || !canLog.booleanValue()) continue;
            arPropName.add(targetField);
        }
        return arPropName.toArray(new String[0]);
    }

    public static String[] getCanWritebackProperty(IDataEntityType xBillDt, String entryEntity) {
        DynamicObjectCollection mappingEntitys = ChangeModelHelper.getMappingColFromXBillDT(xBillDt);
        if (mappingEntitys == null || mappingEntitys.size() < 1) {
            return null;
        }
        ArrayList<String> arPropName = new ArrayList<String>();
        LocaleString headTitle = ResManager.getLocaleString((String)"\u5355\u636e\u5934", (String)"ChangeModelHelper_0", (String)"mpscmm-msbd-changemodel");
        for (DynamicObject mappingEntity : mappingEntitys) {
            DataEntityPropertyCollection entryProps;
            IDataEntityProperty targetProp;
            String targetField = mappingEntity.getString("targetfield");
            String targetFieldname = mappingEntity.getString("targetfieldname");
            Boolean canLog = mappingEntity.getBoolean("canwriteback");
            String[] targetItems = targetFieldname.split("\\.");
            List<EntityType> xBillentryEntitys = ChangeModelHelper.getChildEntities(xBillDt);
            EntityType xBillEntryType = ChangeModelHelper.getChildEntitiesByAlias(xBillentryEntitys, targetItems[0]);
            if (xBillEntryType == null || targetItems.length != 2 && targetItems.length != 3 || headTitle != null && headTitle.containsValue((Object)targetItems[0]) || !entryEntity.equalsIgnoreCase(xBillEntryType.getName()) || targetItems.length == 3 && (xBillEntryType.getClass() != EntryType.class && xBillEntryType.getClass() != SubEntryType.class || !((targetProp = (IDataEntityProperty)(entryProps = xBillEntryType.getProperties()).get((Object)mappingEntity.getString("targetfield"))) instanceof DateProp) && !(targetProp instanceof DateTimeProp)) || !canLog.booleanValue()) continue;
            arPropName.add(targetField);
        }
        return arPropName.toArray(new String[0]);
    }

    public static String[] getEnableProperty(IDataEntityType xBillDt, String entryEntity) {
        Map<String, List<String>> dateRangeItems = ChangeModelHelper.getAllDateRangeItemsMap(xBillDt.getName(), entryEntity);
        return ChangeModelHelper.getEnableProperty(xBillDt, entryEntity, dateRangeItems);
    }

    public static String[] getEnableProperty(IDataEntityType xBillDt, String entryEntity, Map<String, List<String>> dateRangeItems) {
        DynamicObjectCollection mappingEntitys = ChangeModelHelper.getMappingColFromXBillDT(xBillDt);
        if (mappingEntitys == null || mappingEntitys.size() < 1) {
            return null;
        }
        ArrayList<String> arPropName = new ArrayList<String>();
        LocaleString headTitle = ResManager.getLocaleString((String)"\u5355\u636e\u5934", (String)"ChangeModelHelper_0", (String)"mpscmm-msbd-changemodel");
        for (DynamicObject mappingEntity : mappingEntitys) {
            DataEntityPropertyCollection entryProps;
            IDataEntityProperty targetProp;
            String targetField = mappingEntity.getString("targetfield");
            String targetFieldname = mappingEntity.getString("targetfieldname");
            Boolean canEnable = mappingEntity.getBoolean("canenable");
            String[] targetItems = targetFieldname.split("\\.");
            List<EntityType> xBillentryEntitys = ChangeModelHelper.getChildEntities(xBillDt);
            EntityType xBillEntryType = ChangeModelHelper.getChildEntitiesByAlias(xBillentryEntitys, targetItems[0]);
            if (xBillEntryType == null || targetItems.length != 2 && targetItems.length != 3 || headTitle != null && headTitle.containsValue((Object)targetItems[0]) || !entryEntity.equalsIgnoreCase(xBillEntryType.getName()) || targetItems.length == 3 && (xBillEntryType.getClass() != EntryType.class && xBillEntryType.getClass() != SubEntryType.class || !((targetProp = (IDataEntityProperty)(entryProps = xBillEntryType.getProperties()).get((Object)mappingEntity.getString("targetfield"))) instanceof DateProp) && !(targetProp instanceof DateTimeProp)) || !canEnable.booleanValue()) continue;
            arPropName.add(targetField);
        }
        if (dateRangeItems != null) {
            for (Map.Entry<String, List<String>> item : dateRangeItems.entrySet()) {
                String dateRange = item.getKey();
                if (item.getValue() == null || item.getValue().size() != 2) continue;
                String dateRangeStart = item.getValue().get(0);
                String dateRangeEnd = item.getValue().get(1);
                if (!arPropName.contains(dateRangeStart) && !arPropName.contains(dateRangeEnd)) continue;
                arPropName.add(dateRange);
            }
        }
        return arPropName.toArray(new String[0]);
    }

    public static String[] getUnEnableProperty(IDataEntityType xBillDt, String entryEntity) {
        Map<String, List<String>> dateRangeItems = ChangeModelHelper.getAllDateRangeItemsMap(xBillDt.getName(), entryEntity);
        return ChangeModelHelper.getUnEnableProperty(xBillDt, entryEntity, dateRangeItems);
    }

    public static String[] getUnEnableProperty(IDataEntityType xBillDt, String entryEntity, Map<String, List<String>> dateRangeItems) {
        DynamicObjectCollection mappingEntitys = ChangeModelHelper.getMappingColFromXBillDT(xBillDt);
        if (mappingEntitys == null || mappingEntitys.size() < 1) {
            return null;
        }
        ArrayList<String> arPropName = new ArrayList<String>();
        LocaleString headTitle = ResManager.getLocaleString((String)"\u5355\u636e\u5934", (String)"ChangeModelHelper_0", (String)"mpscmm-msbd-changemodel");
        for (DynamicObject mappingEntity : mappingEntitys) {
            DataEntityPropertyCollection entryProps;
            IDataEntityProperty targetProp;
            String targetField = mappingEntity.getString("targetfield");
            String targetFieldname = mappingEntity.getString("targetfieldname");
            Boolean canEnable = mappingEntity.getBoolean("canenable");
            String[] targetItems = targetFieldname.split("\\.");
            List<EntityType> xBillentryEntitys = ChangeModelHelper.getChildEntities(xBillDt);
            EntityType xBillEntryType = ChangeModelHelper.getChildEntitiesByAlias(xBillentryEntitys, targetItems[0]);
            if (xBillEntryType == null || targetItems.length != 2 && targetItems.length != 3 || headTitle != null && headTitle.containsValue((Object)targetItems[0]) || !entryEntity.equalsIgnoreCase(xBillEntryType.getName()) || targetItems.length == 3 && (xBillEntryType.getClass() != EntryType.class && xBillEntryType.getClass() != SubEntryType.class || !((targetProp = (IDataEntityProperty)(entryProps = xBillEntryType.getProperties()).get((Object)mappingEntity.getString("targetfield"))) instanceof DateProp) && !(targetProp instanceof DateTimeProp)) || canEnable.booleanValue()) continue;
            arPropName.add(targetField);
        }
        if (dateRangeItems != null) {
            for (Map.Entry<String, List<String>> item : dateRangeItems.entrySet()) {
                String dateRange = item.getKey();
                if (item.getValue() == null || item.getValue().size() != 2) continue;
                String dateRangeStart = item.getValue().get(0);
                String dateRangeEnd = item.getValue().get(1);
                if (!arPropName.contains(dateRangeStart) && !arPropName.contains(dateRangeEnd)) continue;
                arPropName.add(dateRange);
            }
        }
        return arPropName.toArray(new String[0]);
    }

    public static List<EntityType> getChildEntities(IDataEntityType entityType) {
        ArrayList<EntityType> childEntities = new ArrayList<EntityType>();
        for (IDataEntityProperty property : entityType.getProperties()) {
            ICollectionProperty collProp;
            if (!(property instanceof ICollectionProperty) || !((collProp = (ICollectionProperty)property).getItemType() instanceof EntityType)) continue;
            EntityType childEntity = (EntityType)collProp.getItemType();
            childEntities.add(childEntity);
            childEntities.addAll(ChangeModelHelper.getChildEntities((IDataEntityType)childEntity));
        }
        return childEntities;
    }

    public static EntityType getChildEntitiesByAlias(List<EntityType> childEntities, String alias) {
        for (EntityType childEntity : childEntities) {
            LocaleString childEntityDisName = childEntity.getDisplayName();
            if (alias == null || childEntityDisName == null || !childEntityDisName.containsValue((Object)alias)) continue;
            return childEntity;
        }
        return null;
    }

    public static List<DateRangeField> getAllDateRangeItems(String formId, String entryEntity) {
        ArrayList<DateRangeField> dateRangeItems = new ArrayList<DateRangeField>(16);
        if (StringUtils.isBlank((CharSequence)formId)) {
            return dateRangeItems;
        }
        try {
            FormMetadata formMetadata = (FormMetadata)MetadataDao.readRuntimeMeta((String)MetadataDao.getIdByNumber((String)formId, (MetaCategory)MetaCategory.Form), (MetaCategory)MetaCategory.Form);
            String entityId = formMetadata.getEntityId();
            EntityMetadata entityMetadata = (EntityMetadata)MetadataDao.readRuntimeMeta((String)entityId, (MetaCategory)MetaCategory.Entity);
            if (entryEntity == null) {
                for (EntityItem item : entityMetadata.getItems()) {
                    if (!(item instanceof DateRangeField) || !StringUtils.isBlank((CharSequence)item.getParentId())) continue;
                    dateRangeItems.add((DateRangeField)item);
                }
            } else {
                for (EntityItem item : entityMetadata.getItems()) {
                    if (!(item instanceof EntryEntity) || !entryEntity.equals(item.getKey())) continue;
                    for (EntityItem entryItem : ((EntryEntity)item).getItems()) {
                        if (!(entryItem instanceof DateRangeField)) continue;
                        dateRangeItems.add((DateRangeField)entryItem);
                    }
                }
            }
        }
        catch (Exception e) {
            LOGGER.error((Throwable)e);
        }
        return dateRangeItems;
    }

    public static Map<String, List<String>> getAllDateRangeItemsMap(String formId, String entryEntity) {
        HashMap<String, List<String>> dateRangeItems = new HashMap<String, List<String>>(8);
        if (StringUtils.isBlank((CharSequence)formId)) {
            return dateRangeItems;
        }
        try {
            FormMetadata formMetadata = (FormMetadata)MetadataDao.readRuntimeMeta((String)MetadataDao.getIdByNumber((String)formId, (MetaCategory)MetaCategory.Form), (MetaCategory)MetaCategory.Form);
            String entityId = formMetadata.getEntityId();
            EntityMetadata entityMetadata = (EntityMetadata)MetadataDao.readRuntimeMeta((String)entityId, (MetaCategory)MetaCategory.Entity);
            if (entryEntity == null) {
                for (EntityItem item : entityMetadata.getItems()) {
                    if (!(item instanceof DateRangeField) || !StringUtils.isBlank((CharSequence)item.getParentId())) continue;
                    DateRangeField dateRangeField = (DateRangeField)item;
                    ArrayList<String> list = new ArrayList<String>();
                    list.add(dateRangeField.getStartDateFieldKey());
                    list.add(dateRangeField.getEndDateFieldKey());
                    dateRangeItems.put(dateRangeField.getKey(), list);
                }
            } else {
                for (EntityItem item : entityMetadata.getItems()) {
                    if (!(item instanceof EntryEntity) || !entryEntity.equals(item.getKey())) continue;
                    for (EntityItem entryItem : ((EntryEntity)item).getItems()) {
                        if (!(entryItem instanceof DateRangeField)) continue;
                        DateRangeField dateRangeField = (DateRangeField)entryItem;
                        ArrayList<String> list = new ArrayList<String>();
                        list.add(dateRangeField.getStartDateFieldKey());
                        list.add(dateRangeField.getEndDateFieldKey());
                        dateRangeItems.put(dateRangeField.getKey(), list);
                    }
                }
            }
        }
        catch (Exception e) {
            LOGGER.error((Throwable)e);
        }
        return dateRangeItems;
    }

    public static Map<String, List<String>> getAllDateRangeItems(String formId) {
        HashMap<String, List<String>> dateRangeItems = new HashMap<String, List<String>>(8);
        if (StringUtils.isBlank((CharSequence)formId)) {
            return dateRangeItems;
        }
        try {
            FormMetadata formMetadata = (FormMetadata)MetadataDao.readRuntimeMeta((String)MetadataDao.getIdByNumber((String)formId, (MetaCategory)MetaCategory.Form), (MetaCategory)MetaCategory.Form);
            String entityId = formMetadata.getEntityId();
            EntityMetadata entityMetadata = (EntityMetadata)MetadataDao.readRuntimeMeta((String)entityId, (MetaCategory)MetaCategory.Entity);
            for (EntityItem item : entityMetadata.getItems()) {
                if (item instanceof DateRangeField) {
                    if (!StringUtils.isBlank((CharSequence)item.getParentId())) continue;
                    DateRangeField dateRangeField = (DateRangeField)item;
                    ArrayList<String> list = new ArrayList<String>();
                    list.add(dateRangeField.getStartDateFieldKey());
                    list.add(dateRangeField.getEndDateFieldKey());
                    dateRangeItems.put(dateRangeField.getKey(), list);
                    continue;
                }
                if (!(item instanceof EntryEntity)) continue;
                for (EntityItem entryItem : ((EntryEntity)item).getItems()) {
                    if (!(entryItem instanceof DateRangeField)) continue;
                    DateRangeField dateRangeField = (DateRangeField)entryItem;
                    ArrayList<String> list = new ArrayList<String>();
                    list.add(dateRangeField.getStartDateFieldKey());
                    list.add(dateRangeField.getEndDateFieldKey());
                    dateRangeItems.put(dateRangeField.getKey(), list);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error((Throwable)e);
        }
        return dateRangeItems;
    }

    public static String[] getChangeService(DynamicObject changeModel) {
        if (CommonUtils.isNull((Object)changeModel)) {
            return null;
        }
        DynamicObjectCollection plugins = changeModel.getDynamicObjectCollection("pluginentity");
        if (CommonUtils.isNull((Object)plugins)) {
            return null;
        }
        ArrayList<String> res = new ArrayList<String>();
        for (DynamicObject plugin : plugins) {
            Boolean pluginenable = plugin.getBoolean("pluginenable");
            String classname = plugin.getString("classname");
            if (!pluginenable.booleanValue() || CommonUtils.isNull((Object)classname)) continue;
            res.add(classname);
        }
        if (res.size() != 0) {
            return res.toArray(new String[res.size()]);
        }
        return null;
    }

    public static String[] getAllWritebackProperty(IDataEntityType xbillDt) {
        String[] enablePropertys = ChangeModelHelper.getEnableProperty(xbillDt);
        String[] canwritebackPropertys = ChangeModelHelper.getCanWritebackProperty(xbillDt);
        ArrayList allwritebackPropertys = new ArrayList();
        if (enablePropertys != null && enablePropertys.length > 0) {
            Collections.addAll(allwritebackPropertys, enablePropertys);
        }
        if (canwritebackPropertys != null && canwritebackPropertys.length > 0) {
            Collections.addAll(allwritebackPropertys, canwritebackPropertys);
        }
        if (allwritebackPropertys != null && allwritebackPropertys.size() > 0) {
            return allwritebackPropertys.toArray(new String[0]);
        }
        return null;
    }

    public static String[] getAllWritebackProperty(IDataEntityType xBillDt, String entryEntity) {
        String[] enablePropertys = ChangeModelHelper.getEnableProperty(xBillDt, entryEntity);
        String[] canwritebackPropertys = ChangeModelHelper.getCanWritebackProperty(xBillDt, entryEntity);
        ArrayList allwritebackPropertys = new ArrayList();
        if (enablePropertys != null && enablePropertys.length > 0) {
            Collections.addAll(allwritebackPropertys, enablePropertys);
        }
        if (canwritebackPropertys != null && canwritebackPropertys.length > 0) {
            Collections.addAll(allwritebackPropertys, canwritebackPropertys);
        }
        if (allwritebackPropertys != null && allwritebackPropertys.size() > 0) {
            return allwritebackPropertys.toArray(new String[0]);
        }
        return null;
    }

    public static Map<String, Map<String, String>> getXBillEntryAndOp(DynamicObject changeModel) {
        Map<String, Map<String, String>> result = new HashMap<String, Map<String, String>>();
        if (changeModel == null) {
            return result;
        }
        String[] plugins = ChangeModelHelper.getChangeService(changeModel);
        if (plugins == null || plugins.length == 0) {
            result = ChangeModelHelper.getXBillEntryAndOpFromCustpama(changeModel);
            if (result == null || result.size() == 0) {
                result = new HashMap();
                HashMap<String, String> value = new HashMap<String, String>();
                value.put("entity", "billentry");
                value.put("entry_toolbar", "tbmainentry");
                value.put("btn_add", "addrow");
                value.put("btn_delete", "deleterow");
                value.put("btn_modify", "modifyrow");
                value.put("changetype", "billentrychangetype");
                value.put("srcid", "billentrysrcid");
                result.put((String)value.get("entity"), (Map<String, String>)value);
            }
            return result;
        }
        for (String plugin : plugins) {
            try {
                Class<?> c = Class.forName(plugin);
                Method m = c.getMethod("getXBillEntryAndOp", new Class[0]);
                Object r = m.invoke(c.newInstance(), new Object[0]);
                if (r == null || !(r instanceof Map)) continue;
                result.putAll((Map)r);
            }
            catch (Exception e) {
                String errMsg = ResManager.loadKDString((String)"\u53d8\u66f4\u65b9\u6848\u201c\u63d2\u4ef6\u201d\u914d\u7f6e\u4e0d\u6b63\u786e\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ChangeModelHelper_1", (String)"mpscmm-msbd-changemodel", (Object[])new Object[0]);
                throw new KDBizException(errMsg);
            }
        }
        return result;
    }

    public static Map<String, Map<String, String>> getAllXBillInfoMapping(DynamicObject changeModel) {
        if (changeModel == null) {
            return null;
        }
        Map<String, Map<String, String>> entryAndOp = ChangeModelHelper.getXBillEntryAndOp(changeModel);
        Map<String, Map<String, String>> entryAndOpCusparam = ChangeModelHelper.getXBillEntryAndOpFromCustpama(changeModel);
        Iterator<Map.Entry<String, Map<String, String>>> entryAndOpIt = entryAndOp.entrySet().iterator();
        if (entryAndOpCusparam != null) {
            while (entryAndOpIt.hasNext()) {
                Map.Entry<String, Map<String, String>> pluginMapRow = entryAndOpIt.next();
                if (pluginMapRow == null) continue;
                Map<String, String> pluginMap = pluginMapRow.getValue();
                Map<String, String> cusParamMap = entryAndOpCusparam.get(pluginMapRow.getKey());
                if (cusParamMap == null) continue;
                for (Map.Entry<String, String> cusParamRow : cusParamMap.entrySet()) {
                    if (cusParamRow == null || pluginMap.get(cusParamRow.getKey()) != null || cusParamRow.getValue() == null) continue;
                    pluginMap.put(cusParamRow.getKey(), cusParamRow.getValue());
                }
            }
        }
        return entryAndOp;
    }

    public static Map<String, Map<String, String>> getXBillEntryAndOpFromCustpama(DynamicObject changeModel) {
        String customparameter = changeModel.getString("customparameter_tag");
        if (customparameter == null || customparameter.isEmpty()) {
            return null;
        }
        String xbilldtstr = "";
        if (changeModel.getDynamicObject("xbill") != null && changeModel.getDynamicObject("xbill").getPkValue() != null) {
            xbilldtstr = (String)changeModel.getDynamicObject("xbill").getPkValue();
        }
        MainEntityType xBillDt = MetadataServiceHelper.getDataEntityType((String)xbilldtstr);
        List<EntityType> xBillentryEntitys = ChangeModelHelper.getChildEntities((IDataEntityType)xBillDt);
        List customparameters = new ArrayList(16);
        try {
            customparameters = (List)SerializationUtils.fromJsonString((String)customparameter, customparameters.getClass());
            HashMap<String, Map<String, String>> result = new HashMap<String, Map<String, String>>();
            for (Map map : customparameters) {
                for (EntityType xBillentryEntity : xBillentryEntitys) {
                    if (!xBillentryEntity.getName().equalsIgnoreCase((String)map.get("name"))) continue;
                    try {
                        Map propertymapping = (Map)SerializationUtils.fromJsonString((String)((String)map.get("val")), Map.class);
                        result.put((String)map.get("name"), propertymapping);
                    }
                    catch (Exception ee) {
                        String errMsg = ResManager.loadKDString((String)"\u53d8\u66f4\u65b9\u6848\u201c\u81ea\u5b9a\u4e49\u53c2\u6570\u201d\u914d\u7f6e\u4e0d\u6b63\u786e\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ChangeModelHelper_2", (String)"mpscmm-msbd-changemodel", (Object[])new Object[0]);
                        throw new KDBizException(errMsg);
                    }
                }
            }
            return result;
        }
        catch (Exception ee) {
            String errMsg = ResManager.loadKDString((String)"\u53d8\u66f4\u65b9\u6848\u201c\u81ea\u5b9a\u4e49\u53c2\u6570\u201d\u914d\u7f6e\u4e0d\u6b63\u786e\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ChangeModelHelper_2", (String)"mpscmm-msbd-changemodel", (Object[])new Object[0]);
            throw new KDBizException(errMsg);
        }
    }

    public static void excutePluginMethod(DynamicObject changeModel, String methodName, DynamicObject arg) {
        String[] plugins = ChangeModelHelper.getChangeService(changeModel);
        if (plugins == null || plugins.length == 0) {
            return;
        }
        for (String plugin : plugins) {
            try {
                Class<?> c = Class.forName(plugin);
                Method m = c.getMethod(methodName, DynamicObject.class);
                m.invoke(c.newInstance(), arg);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static Long getXBillTypeIDFromChangeModel(DynamicObject changeModelDO, Long srcBillTypeID) {
        Long targetXBillTypeID = 0L;
        if (changeModelDO == null || srcBillTypeID == null || srcBillTypeID <= 0L) {
            return targetXBillTypeID;
        }
        DynamicObjectCollection billTypeEntryCol = changeModelDO.getDynamicObjectCollection("billtypeentity");
        if (billTypeEntryCol != null && billTypeEntryCol.size() > 0) {
            for (DynamicObject billTypeEntryDO : billTypeEntryCol) {
                if (billTypeEntryDO.getDynamicObject("srcbilltype") == null) continue;
                Long entrySrcBillTypeID = (Long)billTypeEntryDO.getDynamicObject("srcbilltype").getPkValue();
                if (srcBillTypeID.longValue() != entrySrcBillTypeID.longValue() || billTypeEntryDO.getDynamicObject("xbilltype") == null) continue;
                targetXBillTypeID = (Long)billTypeEntryDO.getDynamicObject("xbilltype").getPkValue();
                break;
            }
        }
        return targetXBillTypeID;
    }

    public static FilterBuilder convertStringToQFilter(String runcondition, String srcType) {
        if (kd.bos.util.StringUtils.isNotEmpty((String)runcondition)) {
            FilterCondition condition = (FilterCondition)SerializationUtils.fromJsonString((String)runcondition, FilterCondition.class);
            condition.createMetaData();
            FilterBuilder fb = new FilterBuilder(EntityMetadataCache.getDataEntityType((String)srcType), condition);
            fb.buildFilter();
            return fb;
        }
        return null;
    }

    public static Map<Long, List<Object>> getAreaConditionArray(Long changeModel, String srcType) {
        DynamicObject changemodel = BusinessDataServiceHelper.loadSingleFromCache((Object)changeModel, (String)"plat_changemodel");
        String runcondition = "";
        String runconditionDesc = "";
        HashMap<Long, List<Object>> areaFilterMap = new HashMap<Long, List<Object>>();
        if (changemodel != null) {
            runcondition = changemodel.getString("areaconditionjson");
            runconditionDesc = (String)changemodel.getLocaleString("mul_areaconditiondesc").getItem(Lang.get().toString());
            FilterBuilder fb = ChangeModelHelper.convertStringToQFilter(runcondition, srcType);
            ArrayList<Object> filterlist = new ArrayList<Object>(2);
            if (fb != null) {
                filterlist.add(fb);
                filterlist.add(runconditionDesc);
                areaFilterMap.put(changeModel, filterlist);
            } else {
                areaFilterMap.put(changeModel, null);
            }
            return areaFilterMap;
        }
        return null;
    }

    public static ConditionValidation convertStringToValidate(String validconditionjson) {
        if (kd.bos.util.StringUtils.isNotEmpty((String)validconditionjson)) {
            ArrayList<IDataEntityType> dTypes = new ArrayList<IDataEntityType>();
            dTypes.add(DataEntityType.getDataEntityType(ConditionValidation.class));
            ListDcxmlBinder binder = new ListDcxmlBinder(false, dTypes);
            Map parameter = (Map)SerializationUtils.fromJsonString((String)validconditionjson, Map.class);
            DcJsonSerializer ds = new DcJsonSerializer((DcBinder)binder);
            ds.setIsLocaleValueFull(true);
            ConditionValidation validation = (ConditionValidation)ds.deserializeFromMap(parameter, null);
            if (validation.getDescription() == null && StringUtils.isNotBlank(parameter.get("Description")) && parameter.get("Description") instanceof String) {
                validation.setDescription(new LocaleString((String)parameter.get("Description")));
            }
            if (validation.getMessage() == null && StringUtils.isNotBlank(parameter.get("Message")) && parameter.get("Message") instanceof String) {
                validation.setMessage(new LocaleString((String)parameter.get("Message")));
            }
            return validation;
        }
        return null;
    }

    public static List<ConditionValidation> getValidConditionList(String xBillEntiyId) {
        DynamicObject changmodel = ChangeModelHelper.getChangeModel4XBill(xBillEntiyId);
        if (changmodel != null) {
            DynamicObjectCollection validcol = changmodel.getDynamicObjectCollection("validentity");
            ArrayList<ConditionValidation> vallist = new ArrayList<ConditionValidation>();
            for (DynamicObject valid : validcol) {
                ConditionValidation validation = ChangeModelHelper.convertStringToValidate(valid.getString("validconditionjson_tag"));
                if (validation == null || !validation.getEnabled()) continue;
                vallist.add(validation);
            }
            return vallist;
        }
        return null;
    }

    public static List<ConditionValidation> getValidConditionList(String xBillEntiyId, String opkey) {
        DynamicObject changmodel = ChangeModelHelper.getChangeModel4XBill(xBillEntiyId);
        if (changmodel != null) {
            DynamicObject changemodelDO = changmodel;
            String validoptype = changemodelDO.getString("validoptype");
            if (StringUtils.isNotEmpty((CharSequence)validoptype) && validoptype.contains(opkey)) {
                DynamicObjectCollection validcol = changemodelDO.getDynamicObjectCollection("validentity");
                ArrayList<ConditionValidation> vallist = new ArrayList<ConditionValidation>();
                for (DynamicObject valid : validcol) {
                    ConditionValidation validation = ChangeModelHelper.convertStringToValidate(valid.getString("validconditionjson_tag"));
                    if (validation == null || !validation.getEnabled()) continue;
                    vallist.add(validation);
                }
                return vallist;
            }
            return null;
        }
        return null;
    }

    private static DynamicObjectCollection getMappingColFromXBillDT(IDataEntityType xBillDt) {
        if (xBillDt == null) {
            return null;
        }
        DynamicObject changeModel = ChangeModelHelper.getChangeModel4XBill(xBillDt.getName());
        if (changeModel == null) {
            return null;
        }
        DynamicObjectCollection mappingEntitys = changeModel.getDynamicObjectCollection("mappingentity");
        return mappingEntitys;
    }
}

